/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.print;

import com.dassault.cecilia.core.cecilia.print.ListProcessorJava;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.LinkedHashMap;
import java.util.Map;

public class ListProcessorJavaInteractive
extends ListProcessorJava {
    private final Map<Integer, Integer> _mapPageToFirstLine = new LinkedHashMap<Integer, Integer>();

    public ListProcessorJavaInteractive(SrbInputStream inData) {
        super(inData);
        this._mapPageToFirstLine.put(0, 0);
    }

    public ListProcessorJavaInteractive(SrbInputStream inData, boolean rtf, String commandRtf, String fileNameRtf, boolean auto) {
        super(inData, rtf, commandRtf, fileNameRtf, auto);
        this._mapPageToFirstLine.put(0, 0);
    }

    @Override
    protected void endOfPage() {
        this._mapPageToFirstLine.put(this._pageCount + 1, this._currentLineIndex - 1);
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
        Integer currentLine = this._mapPageToFirstLine.get(pi);
        if (currentLine == null) {
            throw new PrinterException("Pas de ligne courante pour la page " + pi);
        }
        this.setCurrentPage(pi);
        this.setCurrentLine(currentLine);
        return super.print(g, pf, pi);
    }

    private final void setCurrentLine(int currentLine) {
        this._currentLineIndex = currentLine;
    }

    private final void setCurrentPage(int currentPage) {
        this._lastPage = currentPage;
    }
}

