/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.print;

import com.dassault.cecilia.core.cecilia.print.PrintableLine;
import com.dassault.cecilia.core.cecilia.print.PrintableWordGroup;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class PrintablePage
implements Printable,
Pageable {
    private static Logger _LOG = Logger.getLogger(PrintablePage.class.getPackage().getName());
    public static final int nbCarByLine = 96;
    protected Vector _lines = new Vector();
    protected int _currentLineIndex = 0;
    protected int _lastPage = -1;
    protected int _pageCount = 0;
    protected PageFormat _pageFormat = null;
    public static final int _smallFontSize = 8;
    public static final int _mediumFontSize = 10;
    public static final int _largeFontSize = 12;
    public static final double _inchFactor = 0.03527;
    public static final double _leftMarge = 42.52906152537567;
    private Font _pageNumberFont = new Font("Courier New", 0, 8);
    private Font _proprietyFont = new Font("Courier New", 0, 5);
    protected String[] _lastValues;
    protected PrintableLine _lastHeaderTabLine = null;
    protected Vector _tabHeaderLine = new Vector();
    protected PrintableLine _lastEmptyTabLine = null;
    protected PrintableLine _lastEndTabLine = null;
    protected int _compareColumnIndex = 0;
    protected int _tabColumnCount = 0;
    protected int _resetColumnIndex = 0;
    private BufferedImage _logo = null;
    private int _logoWidth = 0;
    private int _logoHeight = 0;
    protected String _date = "";
    protected Paper _paperMemo;
    boolean _firstTabLine = true;
    boolean _rtfSort = false;

    public PrintablePage() {
        String pathLogo = System.getProperty("cecilia.export.print.logo");
        if (pathLogo != null && pathLogo.length() > 0) {
            try {
                this._logo = ImageIO.read(new File(pathLogo));
            }
            catch (IOException e) {
                _LOG.info("Impossible de charger le logo d'impression : " + pathLogo);
                _LOG.log(Level.FINEST, "Exception lors de la lecture du logo d'impression", e);
            }
        }
        if (this._logo != null) {
            this._logoWidth = 150;
            this._logoHeight = this._logo.getHeight() * this._logoWidth / this._logo.getWidth();
        }
    }

    public String rpad(String valeur, int taille, char padChar) {
        String padString = new String("");
        String retour = new String(valeur);
        if (retour.length() < taille) {
            for (int i = 0; i < taille - retour.length(); ++i) {
                padString = padString + padChar;
            }
            retour = retour + padString;
        } else if (retour.length() > taille && taille >= 0) {
            retour = retour.substring(0, taille);
        }
        return retour;
    }

    public void setRtfSort(boolean set) {
        this._rtfSort = set;
    }

    public boolean isRtfSort() {
        return this._rtfSort;
    }

    public void processScribeFile() {
    }

    protected void initLastValues(int offset) {
        if (this._lastValues != null) {
            for (int i = offset; i < this._tabColumnCount; ++i) {
                this._lastValues[i] = "";
            }
        }
    }

    public void printLine(int yLine, PrintableLine currentLine, PageFormat pf, Graphics2D g2d) {
        int xLine = 0;
        if (currentLine.isTabLine()) {
            xLine = 43;
            xLine = 42 + (int)((pf.getImageableWidth() - (double)currentLine.getWidth()) / 2.0);
        } else {
            switch (currentLine.getAlignment()) {
                case 0: {
                    xLine = 43;
                    break;
                }
                case 1: {
                    xLine = 42 + (int)((pf.getImageableWidth() - (double)currentLine.getWidth()) / 2.0);
                    break;
                }
                case 2: {
                    xLine = (int)((pf.getImageableWidth() - 42.52906152537567 - (double)currentLine.getWidth()) / 2.0);
                }
            }
        }
        if (currentLine.isEmptyTabLine()) {
            g2d.setColor(Color.black);
            g2d.drawLine(xLine, yLine - currentLine.getHeight() / 2, xLine + currentLine.getWidth(), yLine - currentLine.getHeight() / 2);
            this._lastEmptyTabLine = currentLine;
        }
        if (currentLine.isEndTabLine()) {
            g2d.setColor(Color.black);
            g2d.drawLine(xLine, yLine, xLine + currentLine.getWidth(), yLine);
            this._lastEndTabLine = currentLine;
            this._lastEmptyTabLine = null;
            this._firstTabLine = true;
        }
        if (currentLine.isColumnHeaderTabLine()) {
            g2d.setColor(Color.black);
            g2d.drawLine(xLine, yLine - currentLine.getHeight(), xLine + currentLine.getWidth(), yLine - currentLine.getHeight());
        }
        if (currentLine.isHeaderTabLine()) {
            g2d.setColor(Color.black);
            g2d.drawLine(xLine, yLine - currentLine.getHeight(), xLine + currentLine.getWidth(), yLine - currentLine.getHeight());
            this._lastHeaderTabLine = currentLine;
            this._compareColumnIndex = currentLine.getCompareColumnIndex();
            this._resetColumnIndex = currentLine.getResetColumnIndex();
            this._tabColumnCount = currentLine.getTabColumnCount();
            this._lastValues = new String[this._tabColumnCount];
            this.initLastValues(0);
        }
        if (currentLine.isTabSeparatorLine()) {
            g2d.setColor(Color.black);
            g2d.drawLine(xLine, yLine, xLine + currentLine.getWidth(), yLine);
        }
        if (currentLine.isTabLine()) {
            g2d.setFont(currentLine.getFont());
            g2d.setColor(Color.black);
            g2d.drawLine(xLine, yLine, xLine, yLine - currentLine.getHeight());
        }
        int index = 0;
        Enumeration en = currentLine.getGroups();
        while (en.hasMoreElements()) {
            PrintableWordGroup group = (PrintableWordGroup)en.nextElement();
            if (group.getFontName() != null) {
                g2d.setFont(group.getFont(currentLine.getFontSize()));
            } else {
                g2d.setFont(currentLine.getFont(group));
            }
            g2d.setColor(group.getColor());
            if (!group.compareToPreview() || group.compareToPreview() && this._lastValues != null && !group.getString().equals(this._lastValues[index])) {
                AttributedString ats;
                if (this._lastValues != null) {
                    try {
                        this._lastValues[index] = group.getString();
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                }
                if (group.getImage() != null) {
                    int h;
                    int w;
                    ImageIcon imageIcon = group.getImage();
                    double width = this._pageFormat.getImageableWidth();
                    double imgWidth = imageIcon.getIconWidth();
                    double imgHeight = imageIcon.getIconHeight();
                    if (imgWidth > width) {
                        double ratio = width == 0.0 ? 1.0 : width / imgWidth;
                        double height = imgHeight * ratio;
                        w = (int)width;
                        h = (int)height;
                    } else {
                        w = (int)imgWidth;
                        h = imageIcon.getIconHeight();
                    }
                    Image image = imageIcon.getImage();
                    g2d.drawImage(image, xLine, Math.max(0, yLine - h), w, h, null);
                } else if (currentLine.isTabLine()) {
                    if (!currentLine.isHeaderTabLine() && !currentLine.isColumnHeaderTabLine()) {
                        Vector wordsOfGroups;
                        if (this._firstTabLine) {
                            this._lastEmptyTabLine = currentLine;
                            this._firstTabLine = false;
                        }
                        if ((wordsOfGroups = group.getWordsOfGroup()) != null) {
                            int xOffset = 1;
                            for (int i = 0; i < wordsOfGroups.size(); ++i) {
                                TextLayout t1;
                                FontRenderContext frc;
                                AttributedCharacterIterator iter;
                                AttributedString ats2;
                                PrintableWordGroup wog = (PrintableWordGroup)wordsOfGroups.elementAt(i);
                                g2d.setFont(currentLine.getFont(wog));
                                g2d.setColor(Color.black);
                                if (wog.isUnderline()) {
                                    ats2 = new AttributedString(wog.getString());
                                    ats2.addAttribute(TextAttribute.FONT, g2d.getFont());
                                    ats2.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
                                    iter = ats2.getIterator();
                                    frc = g2d.getFontRenderContext();
                                    t1 = new TextLayout(iter, frc);
                                    t1.draw(g2d, (float)xLine + (float)xOffset, (float)yLine - (float)(currentLine.getOffsetForText() / 2));
                                } else if (wog.isStrike()) {
                                    ats2 = new AttributedString(wog.getString());
                                    ats2.addAttribute(TextAttribute.FONT, g2d.getFont());
                                    ats2.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
                                    iter = ats2.getIterator();
                                    frc = g2d.getFontRenderContext();
                                    t1 = new TextLayout(iter, frc);
                                    t1.draw(g2d, (float)xLine + (float)xOffset, (float)yLine - (float)(currentLine.getOffsetForText() / 2));
                                } else {
                                    g2d.drawString(wog.getString(), xLine + xOffset, yLine - currentLine.getOffsetForText() / 2);
                                }
                                xOffset += currentLine.getWidth(wog);
                            }
                        } else {
                            g2d.drawString(group.getString(), xLine + 1, yLine - currentLine.getOffsetForText() / 2);
                        }
                    } else {
                        g2d.drawString(group.getString(), xLine + 1, yLine - currentLine.getOffsetForText() / 2);
                    }
                } else if (group.isUnderline()) {
                    ats = new AttributedString(group.getString());
                    ats.addAttribute(TextAttribute.FONT, g2d.getFont());
                    ats.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                    AttributedCharacterIterator iter = ats.getIterator();
                    FontRenderContext frc = g2d.getFontRenderContext();
                    TextLayout t1 = new TextLayout(iter, frc);
                    t1.draw(g2d, xLine, (float)yLine - (float)(currentLine.getOffsetForText() / 2));
                } else if (group.isStrike()) {
                    ats = new AttributedString(group.getString());
                    ats.addAttribute(TextAttribute.FONT, g2d.getFont());
                    ats.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
                    AttributedCharacterIterator iter = ats.getIterator();
                    FontRenderContext frc = g2d.getFontRenderContext();
                    TextLayout t1 = new TextLayout(iter, frc);
                    t1.draw(g2d, xLine, (float)yLine - (float)(currentLine.getOffsetForText() / 2));
                } else if (group.getFontName() != null && group.getFontName().equals("Symbol") && group.useGlyphs()) {
                    Font f = group.getFont(currentLine.getFontSize());
                    FontRenderContext frc = g2d.getFontRenderContext();
                    GlyphVector gv = f.createGlyphVector(frc, group.getGlyphs());
                    g2d.drawGlyphVector(gv, xLine, yLine - currentLine.getOffsetForText() / 2);
                } else {
                    g2d.drawString(group.getString(), xLine, yLine - currentLine.getOffsetForText() / 2);
                }
                if (index == this._resetColumnIndex) {
                    this.initLastValues(this._compareColumnIndex);
                }
            }
            xLine += currentLine.getWidth(group);
            if (currentLine.isTabLine()) {
                g2d.setFont(currentLine.getFont());
                g2d.setColor(Color.black);
                g2d.drawLine(xLine, yLine, xLine, yLine - currentLine.getHeight());
            }
            ++index;
        }
    }

    public void printPageNumber(int pi, PageFormat pf, Graphics2D g2d) {
        g2d.setFont(this._pageNumberFont);
        g2d.setColor(Color.black);
        String pageString = this._date.equals("") ? new String("page " + pi + "/" + this._pageCount) : new String(this._date + "  page " + pi + "/" + this._pageCount);
        int xLine = (int)(pf.getImageableX() + pf.getImageableWidth() - (double)g2d.getFontMetrics(this._pageNumberFont).stringWidth(pageString));
        int yLine = (int)(pf.getImageableY() + (double)g2d.getFontMetrics(this._pageNumberFont).getHeight() + 2.0);
        g2d.drawString(pageString, xLine, yLine);
    }

    /*
     * Unable to fully structure code
     */
    public void computePageCount(PageFormat pf) {
        this._pageFormat = pf;
        headerIsPrint = false;
        this._pageCount = 0;
        this._currentLineIndex = 0;
        while (this._currentLineIndex < this._lines.size()) {
            block10: {
                headerIsPrint = false;
                if (this._currentLineIndex >= this._lines.size()) break block10;
                ymax = 1 + (int)pf.getImageableHeight();
                yLine = 1;
                yLine = yLine + this._logoHeight + 20;
                do lbl-1000:
                // 5 sources

                {
                    block11: {
                        block12: {
                            block13: {
                                block14: {
                                    if ((currentLine = (PrintableLine)this._lines.elementAt(this._currentLineIndex)) == null) break block11;
                                    currentLine.setPageFormat(this._pageFormat);
                                    if (currentLine.isNewPageLine()) {
                                        ++this._currentLineIndex;
                                        break;
                                    }
                                    if (currentLine.isTabLine()) {
                                        if (currentLine.isHeaderTabLine()) {
                                            if (this._currentLineIndex + 1 >= this._lines.size()) break;
                                            nextLine = (PrintableLine)this._lines.elementAt(this._currentLineIndex + 1);
                                            if (yLine + currentLine.getLineCount() * currentLine.getHeight() + 2 * nextLine.getHeight() > ymax) break;
                                            headerIsPrint = true;
                                        } else if (!headerIsPrint) {
                                            if (yLine + 2 * currentLine.getHeight() + this._lastHeaderTabLine.getLineCount() * this._lastHeaderTabLine.getHeight() > ymax) break;
                                            en = this._lastHeaderTabLine.getLines();
                                            while (en.hasMoreElements()) {
                                                line = (PrintableLine)en.nextElement();
                                                yLine += line.getHeight();
                                            }
                                            headerIsPrint = true;
                                        }
                                    }
                                    if (!currentLine.isTabLine()) break block12;
                                    if (currentLine.isEndTabLine()) break block13;
                                    if (yLine + (currentLine.getHeight() + currentLine.getNominalHeight()) > ymax) break block14;
                                    yLine += currentLine.getHeight();
                                    ++this._currentLineIndex;
                                    if (currentLine.isHeaderTabLine()) {
                                        this._lastHeaderTabLine = currentLine;
                                        en = currentLine.getLines();
                                        while (en.hasMoreElements()) {
                                            subLine = (PrintableLine)en.nextElement();
                                            yLine += subLine.getHeight();
                                        }
                                    }
                                    if (this._currentLineIndex < this._lines.size()) ** GOTO lbl-1000
                                    break;
                                }
                                yLine += currentLine.getHeight();
                                this.endOfPage();
                                break;
                            }
                            if (yLine + currentLine.getHeight() > ymax) break;
                            yLine += currentLine.getHeight();
                            ++this._currentLineIndex;
                            if (this._currentLineIndex < this._lines.size()) ** GOTO lbl-1000
                            break;
                        }
                        if (yLine + currentLine.getHeight() > ymax) break;
                        yLine += currentLine.getHeight();
                        ++this._currentLineIndex;
                        if (this._currentLineIndex < this._lines.size()) ** GOTO lbl-1000
                        break;
                    }
                    ++this._currentLineIndex;
                } while (this._currentLineIndex < this._lines.size());
            }
            this.endOfPage();
            ++this._pageCount;
        }
        this._currentLineIndex = 0;
    }

    protected void endOfPage() {
    }

    @Override
    public int getNumberOfPages() {
        if (this._pageFormat == null) {
            throw new NullPointerException();
        }
        return this._pageCount;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        if (this._pageFormat == null) {
            throw new NullPointerException();
        }
        return this._pageFormat;
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        if (this._pageFormat == null) {
            throw new NullPointerException();
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
        block11: {
            block12: {
                headerIsPrint = false;
                g2d = (Graphics2D)g;
                this.initLastValues(0);
                if (this._currentLineIndex >= this._lines.size()) {
                    return 1;
                }
                if (this._lastPage != pi) break block11;
                if (this._currentLineIndex >= this._lines.size()) break block12;
                scaleFactor = 0.91;
                paper = pf.getPaper();
                g2d.scale(scaleFactor, scaleFactor);
                g2d.translate(paper.getImageableX(), paper.getImageableY());
                g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                x = new int[4];
                y = new int[4];
                x[0] = 1;
                x[1] = 1 + (int)pf.getImageableWidth();
                x[2] = 1 + (int)pf.getImageableWidth();
                x[3] = 1;
                y[0] = 1;
                y[1] = 1;
                y[2] = 1 + (int)pf.getImageableHeight();
                y[3] = 1 + (int)pf.getImageableHeight();
                ymax = 1 + (int)pf.getImageableHeight();
                yLine = 1;
                if (this._logo != null) {
                    g2d.drawImage(this._logo, 10, 10, this._logoWidth, this._logoHeight, null);
                }
                yLine = yLine + this._logoHeight + 25;
                this.printPageNumber(pi + 1, pf, g2d);
                do lbl-1000:
                // 5 sources

                {
                    block13: {
                        block14: {
                            block15: {
                                block16: {
                                    if ((currentLine = (PrintableLine)this._lines.elementAt(this._currentLineIndex)) == null) break block13;
                                    currentLine.setPageFormat(this._pageFormat);
                                    if (currentLine.isNewPageLine()) {
                                        ++this._currentLineIndex;
                                        break;
                                    }
                                    if (currentLine.isTabLine()) {
                                        if (currentLine.isHeaderTabLine()) {
                                            if (this._currentLineIndex + 1 >= this._lines.size()) break;
                                            nextLine = (PrintableLine)this._lines.elementAt(this._currentLineIndex + 1);
                                            if (yLine + currentLine.getLineCount() * currentLine.getHeight() + 2 * nextLine.getHeight() > ymax) break;
                                            headerIsPrint = true;
                                        } else if (!headerIsPrint) {
                                            if (yLine + 2 * currentLine.getHeight() + this._lastHeaderTabLine.getLineCount() * this._lastHeaderTabLine.getHeight() > ymax) break;
                                            this.printLine(yLine, this._lastHeaderTabLine, pf, g2d);
                                            en = this._lastHeaderTabLine.getLines();
                                            while (en.hasMoreElements()) {
                                                line = (PrintableLine)en.nextElement();
                                                this.printLine(yLine += line.getHeight(), line, pf, g2d);
                                            }
                                            headerIsPrint = true;
                                        }
                                    }
                                    if (!currentLine.isTabLine()) break block14;
                                    if (currentLine.isEndTabLine()) break block15;
                                    if (yLine + (currentLine.getHeight() + currentLine.getNominalHeight()) > ymax) break block16;
                                    this.printLine(yLine += currentLine.getHeight(), currentLine, pf, g2d);
                                    ++this._currentLineIndex;
                                    if (currentLine.isHeaderTabLine()) {
                                        en = currentLine.getLines();
                                        while (en.hasMoreElements()) {
                                            subLine = (PrintableLine)en.nextElement();
                                            this.printLine(yLine += subLine.getHeight(), subLine, pf, g2d);
                                        }
                                    }
                                    if (this._currentLineIndex < this._lines.size()) ** GOTO lbl-1000
                                    break;
                                }
                                this._lastEmptyTabLine.setEmptyTabLine(false);
                                this._lastEmptyTabLine.setEndTabLine(true);
                                this.printLine(yLine += this._lastEmptyTabLine.getHeight(), this._lastEmptyTabLine, pf, g2d);
                                this._lastEmptyTabLine.setEmptyTabLine(true);
                                this._lastEmptyTabLine.setEndTabLine(false);
                                break;
                            }
                            if (yLine + currentLine.getHeight() > ymax) break;
                            this.printLine(yLine += currentLine.getHeight(), currentLine, pf, g2d);
                            ++this._currentLineIndex;
                            if (this._currentLineIndex < this._lines.size()) ** GOTO lbl-1000
                            break;
                        }
                        if (yLine + currentLine.getHeight() > ymax) break;
                        this.printLine(yLine += currentLine.getHeight(), currentLine, pf, g2d);
                        ++this._currentLineIndex;
                        if (this._currentLineIndex < this._lines.size()) ** GOTO lbl-1000
                        break;
                    }
                    ++this._currentLineIndex;
                } while (this._currentLineIndex < this._lines.size());
                g2d.setColor(Color.black);
                g2d.rotate(1.57);
                g2d.rotate(1.57);
                g2d.rotate(1.57);
                g2d.setFont(this._proprietyFont);
                proprietyString = Locale.getDefault().getLanguage().equals(Locale.FRENCH.getLanguage()) != false ? System.getProperty("cecilia.export.print.propriete") + "                " : System.getProperty("cecilia.export.print.property") + "                ";
                g2d.drawString(proprietyString, (int)(-((pf.getImageableHeight() + (double)g2d.getFontMetrics(this._proprietyFont).stringWidth(proprietyString)) / 2.0)), 2 * g2d.getFontMetrics(this._proprietyFont).getHeight());
                break block11;
            }
            return 1;
        }
        this._lastPage = pi;
        return 0;
    }

    protected void printIconLine(int number, ImageIcon imag) {
        PrintableLine pl = new PrintableLine(this.rpad(" " + number, 5, ' '), 8);
        PrintableWordGroup wordGroup = pl.addGroup(this.rpad(" ", 30, ' '));
        wordGroup.setImage(imag);
        pl.setTabLine(true);
        this._lines.addElement(pl);
    }
}

