/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.stepper;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.stepper.ViewStep;
import com.dassault.cecilia.core.cecilia.stepper.ViewStepper;
import com.dassault.cecilia.core.cecilia.stepper.ViewTransition;
import com.dassault.cecilia.core.cecilia.stepper.ViewVariable;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.util.collection.TreeRank;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;

public class SimStepper
extends ViewStepper {
    private List<ViewTransition> _transs = new ArrayList<ViewTransition>();
    private List<ViewTransition> _viewTranss = Collections.unmodifiableList(this._transs);
    private List<ViewVariable> _states = new ArrayList<ViewVariable>();
    private List<ViewVariable> _viewStates = Collections.unmodifiableList(this._states);
    private TreeRank _flows = new TreeRank((Comparator)new Comparator<ViewVariable>(){

        @Override
        public int compare(ViewVariable o1, ViewVariable o2) {
            return o1.getId() - o2.getId();
        }
    });
    private List<ViewVariable> _viewFlows = Collections.unmodifiableList(this._flows);
    private List<ViewStep> _histo = new ArrayList<ViewStep>();
    private List<ViewStep> _viewHisto = Collections.unmodifiableList(this._histo);
    private int _nbrStep = 0;
    private ViewTransition _selectTr;
    private int _currentStep = 0;
    protected String _currentLoop = "";
    protected String _currentTime = "";

    public List<ViewTransition> getViewTranss() {
        return this._viewTranss;
    }

    @Override
    protected void addTransition(ViewTransition tr) {
        this._transs.add(tr);
        super.addTransition(tr);
    }

    public int getNbrTrans() {
        return this._transs.size();
    }

    public ViewTransition getTransAt(int idx) {
        return this._transs.get(idx);
    }

    public List<ViewVariable> getViewStates() {
        return this._viewStates;
    }

    @Override
    protected void addState(ViewVariable var) {
        this._states.add(var);
        super.addState(var);
    }

    public int getNbrState() {
        return this._states.size();
    }

    public ViewVariable getStateAt(int idx) {
        return this._states.get(idx);
    }

    public List<ViewVariable> getViewFlows() {
        return this._viewFlows;
    }

    @Override
    protected void addFlow(ViewVariable var) {
        this._flows.add((Object)var);
        super.addFlow(var);
    }

    public int getNbrFlow() {
        return this._flows.size();
    }

    public ViewVariable getFlowAt(int idx) {
        return (ViewVariable)this._flows.get(idx);
    }

    public List<ViewStep> getViewHisto() {
        return this._viewHisto;
    }

    public int getNbrStep() {
        return this._nbrStep;
    }

    protected void displayException(String mess) {
        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._parentComponent), mess);
    }

    protected void displayStepperException(StepperException exc) {
        String msg = exc.getMessage();
        if (msg == null || msg.length() == 0) {
            msg = exc.getClass().getName();
        }
        String title = ResMsgVoc.getString("VOC_ERROR") + " - " + exc.getClass().getSimpleName();
        JOptionCecilia.showMessageDialog(this._parentComponent, msg, title, 0);
    }

    @Override
    public void close() {
        if (this._connect != null) {
            this._transs.clear();
            this._states.clear();
            this._flows.clear();
            this._histo.clear();
        }
        super.close();
    }

    protected final boolean doGoInitialState() throws StepperException {
        if (!this._connect.goInitialState()) {
            return false;
        }
        this._histo.clear();
        this._nbrStep = 0;
        this.updateData(true, true);
        return true;
    }

    public boolean goInitialState() {
        try {
            if (!this.doGoInitialState()) {
                return false;
            }
        }
        catch (StepperException e) {
            this.displayStepperException(e);
            return false;
        }
        return true;
    }

    public void setSelectTransition(ViewTransition tr) {
        this._selectTr = tr;
    }

    public void triggerSelectTransition() {
        if (this._selectTr == null) {
            return;
        }
        try {
            if (this._connect.isValidTransition(this._selectTr.getId()) < 0.0) {
                return;
            }
            this.goForward(this._selectTr);
        }
        catch (StepperException e) {
            this.displayStepperException(e);
        }
    }

    protected final boolean doGoForward(ViewTransition tr) throws StepperException {
        if (tr == null) {
            if (this._histo.size() > this._nbrStep) {
                tr = this._histo.get((int)this._nbrStep)._trans;
            }
            if (tr == null) {
                ViewStep step = this._histo.get(this._nbrStep);
                if (step._stateVar != null && step._stateVal != null && step._stateVal.length() > 0) {
                    return this.doSetValueOfState(step._stateVar, step._stateVal);
                }
                return false;
            }
        }
        if (!this._connect.goForward(tr.getId())) {
            return false;
        }
        if (this._histo.size() > this._nbrStep) {
            ViewStep step = this._histo.get(this._nbrStep);
            if (step._trans != tr) {
                for (int i = this._histo.size() - 1; i >= this._nbrStep; --i) {
                    this._histo.remove(i);
                }
                this._histo.add(new ViewStep(tr));
            } else {
                step.setNextFlag(false);
            }
        } else {
            this._histo.add(new ViewStep(tr));
        }
        ++this._nbrStep;
        this.updateData(true, false);
        return true;
    }

    public boolean goForward(ViewTransition tr) {
        try {
            if (!this.doGoForward(tr)) {
                String mess = ResMsgCore.msgFormat("SIM_ERR_FORWARD", tr.getName());
                this.displayException(mess);
                return false;
            }
        }
        catch (StepperException e) {
            this.displayStepperException(e);
            return false;
        }
        return true;
    }

    protected final boolean doSetValueOfState(ViewVariable state, String value) throws StepperException {
        if (state.getName() != this._states.get(state.getId() - 1).getName()) {
            throw new IllegalArgumentException("Assert !");
        }
        if (!this._connect.setValueOfState(state.getId(), value)) {
            return false;
        }
        if (this._histo.size() > this._nbrStep) {
            ViewStep step = this._histo.get(this._nbrStep);
            if (step._stateVar != state || !step._stateVal.equals(value)) {
                for (int i = this._histo.size() - 1; i >= this._nbrStep; --i) {
                    this._histo.remove(i);
                }
                this._histo.add(new ViewStep(state, value));
            } else {
                step.setNextFlag(false);
            }
        } else {
            this._histo.add(new ViewStep(state, value));
        }
        ++this._nbrStep;
        this.updateData(true, false);
        return true;
    }

    public boolean setValueOfState(ViewVariable state, String value) {
        try {
            if (!this.doSetValueOfState(state, value)) {
                String mess = ResMsgCore.msgFormat("SIM_ERR_SETVALUE", state.getName(), value);
                this.displayException(mess);
                return false;
            }
        }
        catch (StepperException e) {
            String mess = ResMsgCore.msgFormat("SIM_ERR_SETVALUE", state.getName(), value);
            this.displayException(mess);
            return false;
        }
        return true;
    }

    protected final boolean doGoBackward(int nbrTrans) throws StepperException {
        this._connect.goBackward(nbrTrans);
        for (int i = 0; i < nbrTrans; ++i) {
            this._histo.get(this._nbrStep - i - 1).setNextFlag(true);
        }
        this._nbrStep -= nbrTrans;
        this.updateData(true, true);
        return true;
    }

    public boolean goBackward(int nbrTrans) {
        try {
            return this.doGoBackward(nbrTrans);
        }
        catch (StepperException e) {
            this.displayStepperException(e);
            return false;
        }
    }

    @Override
    protected void updateData(boolean notify, boolean razChange) throws StepperException {
        this._root.setPreviousChanged();
        this.updateValidTransitions();
        this.updateValueStates();
        this.updateValueFlows();
        if (!notify) {
            return;
        }
        this._root.refreshChanged(this, razChange);
        String cur = this.getCurrentTime();
        if (!cur.equals(this._currentTime)) {
            this._currentTime = cur;
            this.fireAltaOtherUpdate(1, this._currentTime);
        }
        if (!(cur = this.getCurrentLoop()).equals(this._currentLoop)) {
            this._currentLoop = cur;
            this.fireAltaOtherUpdate(2, this._currentLoop);
        }
        if (this._currentStep != this._nbrStep) {
            this._currentStep = this._nbrStep;
            this.fireAltaOtherUpdate(3, this._nbrStep);
        }
        this.fireAltaOtherUpdate(4, null);
    }

    protected boolean updateValidTransitions() throws StepperException {
        boolean change = false;
        for (int i = 0; i < this._transs.size(); ++i) {
            ViewTransition tr = this._transs.get(i);
            double valid = this._connect.isValidTransition(tr.getId());
            if (valid == tr.getValid()) continue;
            change = true;
            this.fireAltaTransitionUpdate(tr);
            tr.setValid(valid);
        }
        return change;
    }

    protected boolean updateValueStates() {
        boolean change = false;
        for (int i = 0; i < this._states.size(); ++i) {
            ViewVariable var = this._states.get(i);
            double val = this._connect.getValueOfState(var.getId());
            if (val == var.getDValue()) continue;
            change = true;
            var.setDValue(val);
            var.setSValue(this._connect.getValueStringOfState(var.getId()));
        }
        return change;
    }

    protected boolean updateValueFlows() {
        boolean change = false;
        for (ViewVariable var : this._flows) {
            double val = this._connect.getValueOfFlow(var.getId());
            if (val == var.getDValue()) continue;
            change = true;
            var.setDValue(val);
            var.setSValue(this._connect.getValueStringOfFlow(var.getId()));
        }
        return change;
    }

    public Map<String, String> getCurrentStates() {
        if (this._connect == null) {
            return null;
        }
        LinkedHashMap<String, String> inits = new LinkedHashMap<String, String>();
        int nbrState = this._connect.getNbrState();
        for (int i = 1; i <= nbrState; ++i) {
            String state = this._connect.getNameOfState(i);
            String value = this._connect.getValueStringOfState(i);
            inits.put(state, value);
        }
        return inits;
    }

    public ViewTransition getNextTransition() {
        if (this._connect == null) {
            return null;
        }
        int[] shedule = this._connect.getSheduler();
        if (shedule == null) {
            return null;
        }
        if (shedule.length == 0) {
            return null;
        }
        if (shedule[0] == 0) {
            return null;
        }
        return this._transs.get(shedule[1] - 1);
    }

    public int getNbrTransInSheduler() {
        if (this._connect == null) {
            return -1;
        }
        int[] shedule = this._connect.getSheduler();
        if (shedule == null) {
            return -1;
        }
        if (shedule.length == 0) {
            return -1;
        }
        return shedule[0];
    }

    public ViewTransition getTransAtInSheduler(int idx) {
        if (this._connect == null) {
            return null;
        }
        int[] shedule = this._connect.getSheduler();
        if (shedule == null) {
            return null;
        }
        if (shedule.length == 0) {
            return null;
        }
        return this.getTransAt(shedule[idx + 1] - 1);
    }

    public void saveAllState(Writer outStream) throws IOException {
        ViewVariable var;
        int i;
        outStream.append("States (nbr=").append(Integer.toString(this.getNbrState())).append(")\n");
        for (i = 0; i < this.getNbrState(); ++i) {
            var = this.getStateAt(i);
            outStream.append("St").append(Integer.toString(i + 1)).append("\t");
            outStream.append(var.getFinalName()).append("\t");
            outStream.append(var.getSValue()).append("\n");
        }
        outStream.append("\n");
        outStream.append("Flows (nbr=").append(Integer.toString(this.getNbrFlow())).append(")\n");
        for (i = 0; i < this.getNbrFlow(); ++i) {
            var = this.getFlowAt(i);
            outStream.append("Fl").append(Integer.toString(i + 1)).append("\t");
            outStream.append(var.getFinalName()).append("\t");
            outStream.append(var.getSValue()).append("\n");
        }
        outStream.append("\n");
        outStream.append("Transitions (nbr=").append(Integer.toString(this.getNbrTrans())).append(")\n");
        for (i = 0; i < this.getNbrTrans(); ++i) {
            ViewTransition tr = this.getTransAt(i);
            outStream.append("Tr").append(Integer.toString(i + 1)).append("\t");
            outStream.append(tr.getFinalName()).append("\t");
            outStream.append(Boolean.toString(tr.isValid())).append("\n");
        }
        outStream.append("\n");
    }
}

