/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.plugin;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.plugin.PlugPanel;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public abstract class AbstractPlugPanelInfo
extends JPanel
implements PlugPanel {
    JTextArea _ctrlTxt;
    File _inputFile = null;
    JLabel _ctrlFilePath;
    JButton _ctrlFileBut;
    JLabel _ctrlLbl = new JLabel(this.getLabel());
    protected static final int _LIMIT_DEFAULT = 30000;
    public static final String PROP_PLUG_INFOLIMIT = "cecilia.core.plugin.InfoLimit";

    public AbstractPlugPanelInfo() {
        super(new GridBagLayout());
        this.add((Component)this._ctrlLbl, new GridBagConstraints(0, 0, 1, 1, 100.0, 0.0, 11, 2, new Insets(2, 2, 2, 2), 0, 0));
        this._ctrlTxt = new JTextArea(20, 40);
        this._ctrlTxt.setFont(new Font("Monospaced", 0, 12));
        this.add((Component)new JScrollPane(this._ctrlTxt), new GridBagConstraints(0, 1, 1, 1, 100.0, 100.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this._ctrlFilePath = new JLabel("                        ");
        this._ctrlFileBut = new JButton("...");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this._ctrlFilePath, new GridBagConstraints(0, 0, 1, 1, 100.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        panel.add((Component)this._ctrlFileBut, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)panel, new GridBagConstraints(0, 2, 1, 1, 100.0, 0.0, 15, 2, new Insets(2, 2, 2, 2), 0, 0));
        this._ctrlFilePath.setVisible(false);
        this._ctrlFileBut.setVisible(false);
    }

    @Override
    public void trash() {
        if (this._inputFile != null && !this._inputFile.delete()) {
            this._inputFile.deleteOnExit();
        }
        this._ctrlTxt = null;
    }

    public void reset() {
        this._ctrlTxt.setText("");
    }

    protected int limit() {
        return Integer.getInteger(PROP_PLUG_INFOLIMIT, 30000);
    }

    public void append(String text) {
        this._ctrlTxt.append(text);
    }

    public boolean load(File input) throws IOException {
        return this.load(input, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(final File input, boolean deleteFileOnTrash) throws IOException {
        if (deleteFileOnTrash) {
            this._inputFile = input;
        }
        boolean result = true;
        FileInputStream in = null;
        try {
            String path = input.getPath();
            in = new FileInputStream(input);
            int limit = this.limit();
            int size = Math.min(in.available(), 5000);
            size = Math.min(size, limit) + 1;
            byte[] buf = new byte[size];
            int n = 1;
            int cumul = 0;
            while (n > 0 && cumul < limit) {
                n = in.read(buf);
                if (n <= 0) continue;
                this._ctrlTxt.append(new String(buf, 0, n));
                cumul += n;
            }
            if (cumul >= limit) {
                this._ctrlTxt.append("\n\nToo large file...");
                this._ctrlFilePath.setText(path);
                this._ctrlFilePath.setVisible(true);
                this._ctrlFileBut.setVisible(true);
                this._ctrlFileBut.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Desktop desktop = Desktop.getDesktop();
                        if (desktop.isSupported(Desktop.Action.OPEN)) {
                            try {
                                desktop.open(input);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                });
                result = false;
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        this._ctrlTxt.setCaretPosition(0);
        this._ctrlTxt.repaint();
        return result;
    }

    protected abstract String getLabel();

    @Override
    public Component getPanel() {
        return this;
    }

    @Override
    public String getInfo(String key) {
        if (key.equals("ppanel.title")) {
            return "Informations ...";
        }
        if (key.equals("ppanel.default.width")) {
            return "400";
        }
        if (key.equals("ppanel.default.height")) {
            return "300";
        }
        return null;
    }

    @Override
    public Icon getIcon(String key) {
        if (key.equals("ppanel.icon")) {
            return ResIcoCore.getImageIcon("MSG_INFO");
        }
        return null;
    }
}

