/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.plugin;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.plugin.AbstractPlugPanelInfo;
import com.dassault.cecilia.core.plugin.PlugTask;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.ResPlug;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.ban.BanInputStream;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.BanStoppedException;
import java.awt.Component;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JOptionPane;

public abstract class AbstractPlugTaskBan
implements PlugTask {
    long _uid;
    Plugable _launcher;
    BanInputStream _scriptStream;
    BanEntry _process;
    boolean _requestStop;
    Object _lockerProcess = new Object();
    protected TaskState _state;

    public AbstractPlugTaskBan(long uid, Plugable launcher, BanEntry entry, BanInputStream scriptStream) {
        this._uid = uid;
        this._launcher = launcher;
        this._process = entry;
        this._scriptStream = scriptStream;
        this._state = TaskState.WAIT;
    }

    @Override
    public boolean isPriority() {
        return false;
    }

    protected String getDefaultTitle() {
        return this.getInfo("ptask.desc");
    }

    protected abstract String getName();

    protected abstract String getDesc();

    @Override
    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return this.getName();
        }
        if (key.equals("ptask.desc")) {
            return this.getDesc();
        }
        if (this._process != null) {
            return this._process.getInfo(key);
        }
        if (key.equals("process.msg") || key.equals("process.msg.high")) {
            switch (this._state) {
                case WAIT: {
                    return ResPlug.getString("TASK_WAIT");
                }
                case INIT: {
                    return ResPlug.getString("TASK_INIT");
                }
                case WORK: {
                    return ResPlug.getString("TASK_WORK");
                }
                case MARK1: {
                    return "Mark1";
                }
                case MARK2: {
                    return "Mark2";
                }
                case FINISH: {
                    return ResPlug.getString("TASK_FINISH");
                }
            }
        }
        if (key.equals("process.p1000")) {
            switch (this._state) {
                case WAIT: {
                    return "-1";
                }
                case INIT: {
                    return "0";
                }
                default: {
                    return "100";
                }
                case FINISH: 
            }
            return "1000";
        }
        return null;
    }

    @Override
    public Icon getIcon(String key) {
        if (key.equals("ptask.icon")) {
            return ResIcoCore.getImageIcon("TASK_START");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this._state = TaskState.INIT;
        try {
            this._state = TaskState.WORK;
            this._process.execute(this._scriptStream);
            if (!this._requestStop) {
                this.displayResult();
            }
        }
        catch (BanStoppedException banStoppedException) {
        }
        catch (Exception e) {
            BanProcessException bpe;
            Throwable exc = e;
            if (e instanceof BanProcessException && (bpe = (BanProcessException)e).getException() != null) {
                exc = bpe.getException();
            }
            StringBuffer sb = new StringBuffer(512);
            sb.append("\n\n======================================\n");
            sb.append(exc.getClass().getSimpleName() + " : ");
            if (exc.getMessage() != null) {
                sb.append(exc.getMessage());
            }
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._launcher.getWindow()), sb.toString());
        }
        finally {
            this._state = TaskState.FINISH;
            Object object = this._lockerProcess;
            synchronized (object) {
                this._process = null;
            }
            this._launcher = null;
            System.gc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestResume() {
        Object object = this._lockerProcess;
        synchronized (object) {
            this._process.requestResume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestStop() {
        this._requestStop = true;
        Object object = this._lockerProcess;
        synchronized (object) {
            this._process.requestStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestSuspend(boolean high) {
        Object object = this._lockerProcess;
        synchronized (object) {
            this._process.requestSuspend();
        }
    }

    protected BanEntry getBanProcess() {
        return this._process;
    }

    protected Component getComponent() {
        return this._launcher.getWindow();
    }

    protected abstract void displayResult();

    protected void displayPanelResult() {
        try {
            AbstractPlugPanelInfo pPane = new AbstractPlugPanelInfo(){

                @Override
                protected String getLabel() {
                    return AbstractPlugTaskBan.this.getDefaultTitle();
                }

                @Override
                public String getInfo(String key) {
                    if (key.equals("ppanel.title")) {
                        return "Info - " + AbstractPlugTaskBan.this.getDefaultTitle();
                    }
                    if (key.equals("ppanel.default.width")) {
                        return "600";
                    }
                    if (key.equals("ppanel.default.height")) {
                        return "480";
                    }
                    return super.getInfo(key);
                }
            };
            this.addResultToPanel(pPane);
            this._launcher.addPanel(pPane, this._uid);
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._launcher.getWindow()), "Display result file : " + e1.getMessage(), this.getDefaultTitle(), 0);
        }
    }

    protected void addResultToPanel(AbstractPlugPanelInfo pane) throws IOException {
    }

    public static enum TaskState {
        WAIT,
        INIT,
        WORK,
        FINISH,
        MARK1,
        MARK2;

    }
}

