/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.plugin;

import com.dassault.cecilia.core.plugin.AbstractPluginModel;
import com.dassault.cecilia.core.plugin.DefaultIOParameters;
import com.dassault.cecilia.core.plugin.DlgChangeStepper;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.IOParameters;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PluginMStepper;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.core.plugin.PluginModel;
import com.dassault.cecilia.core.plugin.ResPlug;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.mbsa.Stepper;
import java.awt.Window;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public abstract class AbstractPluginWithStepper
extends AbstractPluginModel {
    protected static final String DEF_STEPPER = "com.dassault.cecilia.plugin.mbsa.translator.PluginStepperTranslator";

    @Override
    public boolean withParameters() {
        return true;
    }

    @Override
    public String getInfo(String key) {
        if (key.equals("plugin.parameterTag")) {
            return "params";
        }
        return super.getInfo(key);
    }

    @Override
    public Object getDefaultParameters(PluginManager plugable) {
        String key = plugable.getInfo("pluginmanager.stepper.default");
        if (key == null) {
            key = DEF_STEPPER;
        }
        return key;
    }

    protected boolean isStepperOptional() {
        return false;
    }

    @Override
    public Object changeParameters(PluginManager parent, Object parameters) {
        Window win = SwingUtilities.getWindowAncestor(parent.getWindow());
        if (win == null) {
            win = parent.getWindow();
        }
        DlgChangeStepper dlg = new DlgChangeStepper(win);
        dlg.setValidSelection(!this.isStepperOptional());
        dlg.refreshList(parent, "PluginStepper", null, (String)parameters, null);
        dlg.setVisible(true);
        if (dlg.getResult()) {
            return dlg.getSelKey();
        }
        return parameters;
    }

    @Override
    public IOParameters getIOParameters() {
        return DefaultIOParameters.getInstance();
    }

    protected Stepper createStepper(Plugable launcher, InfoStepper iStepper) {
        PluginMStepper plugStepper = this.verifyStepper(launcher, iStepper._stepperKey);
        if (plugStepper == null) {
            return null;
        }
        return plugStepper.createStepper(launcher, iStepper);
    }

    protected Stepper createStepper(Plugable launcher, Object params) {
        Stepper stepper = null;
        String stepperKey = DEF_STEPPER;
        if (params != null) {
            if (params instanceof PluginMStepper) {
                stepper = ((PluginMStepper)params).createStepper(launcher, null);
            } else if (params instanceof Stepper) {
                stepper = (Stepper)params;
            } else if (params instanceof String) {
                stepperKey = (String)params;
            } else {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(launcher.getWindow()), ResPlug.getString("PLG_SIMUL_PARAM_ERR"));
                return null;
            }
        }
        if (stepper == null) {
            PluginMStepper plugStepper = this.verifyStepper(launcher, stepperKey);
            if (plugStepper == null) {
                return null;
            }
            stepper = params instanceof InfoStepper ? plugStepper.createStepper(launcher, ((InfoStepper)params)._params) : plugStepper.createStepper(launcher, null);
        }
        return stepper;
    }

    private PluginMStepper verifyStepper(Plugable launcher, String stepperKey) {
        if (stepperKey.length() == 0) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(launcher.getWindow()), ResPlug.getString("PLG_SIMUL_PARAM_ERR"));
            return null;
        }
        PluginModel plug = launcher.getPlugin(stepperKey);
        if (plug == null) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(launcher.getWindow()), ResPlug.msgFormat("PLG_SIMUL_PARAM_UNKNOW", stepperKey));
            return null;
        }
        if (!(plug instanceof PluginMStepper)) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(launcher.getWindow()), ResPlug.msgFormat("PLG_SIMUL_PARAM_NOSTEP", stepperKey));
            return null;
        }
        return (PluginMStepper)plug;
    }

    public static class InfoStepper {
        String _stepperKey;
        Map<String, Object> _params;
        IModel _model;

        public InfoStepper(String stepperKey, IModel model, Map<String, Object> params) {
            this._stepperKey = stepperKey;
            this._model = model;
            this._params = params;
        }

        public IModel getModel() {
            return this._model;
        }

        public Map<String, Object> getParameters() {
            return this._params;
        }
    }
}

