/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.plugin;

import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.core.plugin.PluginModel;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.util.logging.LogUtility;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class PanelSelectTypedPlugin
extends JPanel {
    protected static final int LABEL_TITLE = 1;
    protected static final int LABEL_LIST = 2;
    protected static final int LABEL_KEY = 3;
    protected static final int LABEL_DESC = 4;
    protected static final int LABEL_PARAM = 5;
    protected static final int LABEL_ERROR_NOTYPE = 6;
    PluginManager _launcher;
    LstModel _modeTrlLst;
    JList _ctrlTrLst;
    JTextField _ctrlTrKey;
    JTextArea _ctrlTrInfo;
    JButton _ctrlTrParams;

    protected abstract String getLabel(int var1);

    public PanelSelectTypedPlugin() {
        super(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(this.getLabel(1)));
        this.add((Component)new JLabel(this.getLabel(2)), new GridBagConstraints(0, 0, 1, 1, 0.0, 100.0, 12, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)new JLabel(this.getLabel(3)), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)new JLabel(this.getLabel(4)), new GridBagConstraints(0, 2, 1, 1, 0.0, 100.0, 12, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._modeTrlLst = new LstModel();
        this._ctrlTrLst = new JList(this._modeTrlLst);
        this._ctrlTrKey = new JTextField(30);
        this._ctrlTrKey.setEditable(false);
        this._ctrlTrInfo = new JTextArea(5, 20);
        this._ctrlTrInfo.setEditable(false);
        this._ctrlTrInfo.setEnabled(false);
        this._ctrlTrInfo.setLineWrap(true);
        this._ctrlTrLst.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int idx = PanelSelectTypedPlugin.this._ctrlTrLst.getSelectedIndex();
                if (idx >= 0) {
                    PanelSelectTypedPlugin.this._ctrlTrInfo.setText(PanelSelectTypedPlugin.this._modeTrlLst.getDescAt(idx));
                    PanelSelectTypedPlugin.this._ctrlTrKey.setText(PanelSelectTypedPlugin.this._modeTrlLst.getKeyAt(idx));
                    PanelSelectTypedPlugin.this._ctrlTrParams.setEnabled(PanelSelectTypedPlugin.this._modeTrlLst.getPlugAt(idx).withParameters());
                } else {
                    PanelSelectTypedPlugin.this._ctrlTrInfo.setText("");
                    PanelSelectTypedPlugin.this._ctrlTrKey.setText("");
                    PanelSelectTypedPlugin.this._ctrlTrParams.setEnabled(false);
                }
                PanelSelectTypedPlugin.this._ctrlTrInfo.setCaretPosition(0);
            }
        });
        this.add((Component)new JScrollPane(this._ctrlTrLst), new GridBagConstraints(1, 0, 1, 1, 100.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this._ctrlTrKey, new GridBagConstraints(1, 1, 1, 1, 100.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)new JScrollPane(this._ctrlTrInfo), new GridBagConstraints(1, 2, 1, 1, 100.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this._ctrlTrParams = new JButton(this.getLabel(5));
        this.add((Component)this._ctrlTrParams, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._ctrlTrParams.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int idx = PanelSelectTypedPlugin.this._ctrlTrLst.getSelectedIndex();
                if (idx < 0) {
                    return;
                }
                PluginModel plug = PanelSelectTypedPlugin.this._modeTrlLst.getPlugAt(idx);
                if (!plug.withParameters()) {
                    LogUtility.logStackTrace((Logger)LogUtility.getLog(PanelSelectTypedPlugin.class), (Level)Level.INFO, (String)"Idx no correct : PluginModel without params");
                    return;
                }
                PanelSelectTypedPlugin.this._modeTrlLst.setParamAt(idx, plug.changeParameters(PanelSelectTypedPlugin.this._launcher, PanelSelectTypedPlugin.this._modeTrlLst.getParamAt(idx)));
            }
        });
        this._ctrlTrParams.setEnabled(false);
    }

    public boolean refreshList(PluginManager launcher, String type, String subtype, String currentKey, Object currentParam) {
        this._launcher = launcher;
        List plugins = launcher.getPlugins(type);
        this._modeTrlLst.clear();
        int idx = -1;
        Iterator i = plugins.iterator();
        int cpt = 0;
        while (i.hasNext()) {
            String stype;
            String key = (String)i.next();
            PluginModel plug = launcher.getPlugin(key);
            if (subtype != null && ((stype = plug.getInfo("sub-type")) == null || !stype.equals(subtype))) continue;
            String name = plug.getInfo("plugin.name");
            if (name == null) {
                name = type + " : " + key;
            }
            Object param = null;
            if (plug.withParameters()) {
                param = plug.getDefaultParameters(launcher);
            }
            if (key.equals(currentKey)) {
                idx = cpt;
                if (currentParam != null) {
                    param = currentParam;
                }
            }
            this._modeTrlLst.add(plug, name, key, param);
            ++cpt;
        }
        if (this._modeTrlLst.getSize() == 0) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), this.getLabel(6));
            return false;
        }
        this._ctrlTrLst.setSelectedIndex(idx);
        return true;
    }

    public String getSelKey() {
        return this._ctrlTrKey.getText();
    }

    public Object getSelParams() {
        int idx = this._ctrlTrLst.getSelectedIndex();
        return this._modeTrlLst.getParamAt(idx);
    }

    class LstModel
    extends AbstractListModel {
        ArrayList<PlugInfo> _lst = new ArrayList();

        LstModel() {
        }

        @Override
        public int getSize() {
            return this._lst.size();
        }

        @Override
        public Object getElementAt(int idx) {
            return this._lst.get((int)idx)._name;
        }

        public String getKeyAt(int idx) {
            return this._lst.get((int)idx)._key;
        }

        public String getDescAt(int idx) {
            return this._lst.get((int)idx)._desc;
        }

        public Object getParamAt(int idx) {
            return this._lst.get((int)idx)._params;
        }

        public void setParamAt(int idx, Object params) {
            this._lst.get((int)idx)._params = params;
        }

        public PluginModel getPlugAt(int idx) {
            return this._lst.get((int)idx)._plug;
        }

        public void add(PluginModel plug, String name, String key, Object params) {
            int idx = this.getSize();
            this._lst.add(new PlugInfo(plug, name, key, params));
            this.fireIntervalAdded(this, idx, idx);
        }

        public void clear() {
            int idx = this.getSize();
            if (idx == 0) {
                return;
            }
            this._lst.clear();
            this.fireIntervalRemoved(this, 0, idx - 1);
        }

        class PlugInfo {
            PluginModel _plug;
            String _name;
            String _key;
            String _desc;
            Object _params;

            public PlugInfo(PluginModel plug, String name, String key, Object params) {
                this._plug = plug;
                this._name = name;
                this._key = key;
                this._params = params;
                this._desc = plug.getInfo("plugin.description");
            }
        }
    }
}

