/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.pluginmanager;

import com.dassault.cecilia.core.pluginmanager.AttachableComponentDescriptor;
import com.dassault.cecilia.core.pluginmanager.ItemDescriptor;
import com.dassault.cecilia.core.pluginmanager.MenuDescriptor;
import com.dassault.cecilia.core.pluginmanager.SeparatorDescriptor;
import java.awt.Component;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Node;

public abstract class AbstractAttachableComponentDescriptor
implements AttachableComponentDescriptor {
    private static Map _classes = new HashMap();
    String _containerPath;
    String _containerType;
    int _position;
    String _type = null;

    public AbstractAttachableComponentDescriptor(String type) {
        this._type = type;
    }

    public AbstractAttachableComponentDescriptor(String containerType, String containerPath, int position) {
        this._containerType = containerType;
        this._containerPath = containerPath;
        this._position = position;
    }

    @Override
    public String getContainerPath() {
        return this._containerPath;
    }

    @Override
    public String getContainerType() {
        return this._containerType;
    }

    @Override
    public int getPosition() {
        return this._position;
    }

    @Override
    public void setPosition(int position) {
        this._position = position;
    }

    @Override
    public void setContainerPath(String containerPath) {
        this._containerPath = containerPath;
    }

    @Override
    public void setContainerType(String containerType) {
        this._containerType = containerType;
    }

    public void readNode(Node node) {
        this._type = node.getAttributes().getNamedItem("TYPE").getNodeValue();
        this._containerType = node.getAttributes().getNamedItem("CONTAINER_TYPE").getNodeValue();
        this._containerPath = node.getAttributes().getNamedItem("CONTAINER_PATH").getNodeValue();
        this._position = Integer.parseInt(node.getAttributes().getNamedItem("POSITION").getNodeValue());
    }

    @Override
    public void write(BufferedWriter writer) throws IOException {
        writer.write("      <ATTACHABLE_COMPONENT ");
        this.writeNodeAttributes(writer);
        writer.write("/>");
        writer.newLine();
    }

    public void writeNodeAttributes(BufferedWriter writer) throws IOException {
        writer.write("TYPE=\"" + this._type + "\" ");
        writer.write("CONTAINER_TYPE=\"" + this._containerType + "\" ");
        writer.write("CONTAINER_PATH=\"" + this._containerPath + "\" ");
        writer.write("POSITION=\"" + this._position + "\" ");
    }

    @Override
    public abstract Component createComponent();

    public static AbstractAttachableComponentDescriptor newInstance(String type) {
        Class theClass = (Class)_classes.get(type);
        try {
            Constructor theConstructor = theClass.getDeclaredConstructor(new Class[0]);
            return (AbstractAttachableComponentDescriptor)theConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        _classes.put("ITEM_ACTION", ItemDescriptor.class);
        _classes.put("MENU", MenuDescriptor.class);
        _classes.put("SEPARATOR", SeparatorDescriptor.class);
    }
}

