/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.swing;

import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.border.Border;

public abstract class CeciliaAction
extends AbstractAction {
    boolean _isToggleAction = false;
    public static Border STANDARD_BORDER = BorderFactory.createEmptyBorder(5, 0, 5, 0);
    public static Border LINE_BORDER = BorderFactory.createEmptyBorder(0, 0, 0, 0);
    public static Dimension RIGID_AREA = new Dimension(5, 5);

    public CeciliaAction(String name) {
        this.putValue("Name", name);
    }

    public CeciliaAction(Icon icon, String strMenu) {
        super(strMenu, icon);
    }

    public CeciliaAction(Icon icon, String strMenu, String strTooltip) {
        super(strMenu, icon);
        this.putValue("ShortDescription", strTooltip);
    }

    public CeciliaAction(String name, Icon icon, String desc, int mnemo, KeyStroke keyStroke) {
        this.putValue("Name", name);
        this.putValue("SmallIcon", icon);
        this.putValue("ShortDescription", desc);
        this.putValue("MnemonicKey", mnemo);
        this.putValue("AcceleratorKey", keyStroke);
        this.setEnabled(false);
    }

    public CeciliaAction setName(String name) {
        this.putValue("Name", name);
        return this;
    }

    public CeciliaAction setIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
        return this;
    }

    public CeciliaAction setDesc(String desc) {
        this.putValue("ShortDescription", desc);
        return this;
    }

    public CeciliaAction setMnemo(int mnemo) {
        this.putValue("MnemonicKey", mnemo);
        return this;
    }

    public CeciliaAction setKey(KeyStroke keyStroke) {
        this.putValue("AcceleratorKey", keyStroke);
        return this;
    }

    public CeciliaAction setToggleable(boolean value) {
        this._isToggleAction = value;
        return this;
    }

    public AbstractButton createButton(BorderStyle borderStyle) {
        AbstractButton result = this._isToggleAction ? new JToggleButton(this) : new JButton(this);
        result.setText("");
        result.setToolTipText((String)this.getValue("Name"));
        switch (borderStyle) {
            case NONE: {
                result.setBorder(BorderFactory.createEmptyBorder());
                break;
            }
            case LIGHT: {
                result.setMargin(new Insets(1, 1, 1, 1));
                break;
            }
        }
        return result;
    }

    public JMenuItem createMenuItem() {
        JMenuItem result = this._isToggleAction ? new JCheckBoxMenuItem(this) : new JMenuItem(this);
        return result;
    }

    public static enum BorderStyle {
        NONE,
        LIGHT,
        NORMAL;

    }
}

