/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.swing.other;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class JIntegerTextField
extends JTextField
implements KeyListener {
    String _lastValue;
    int _min;
    int _max;
    boolean _bound = false;

    public JIntegerTextField(String value) {
        super(value);
        this._lastValue = value;
        this.addKeyListener(this);
    }

    public JIntegerTextField(String value, int column) {
        super(value, column);
        this._lastValue = value;
        this.addKeyListener(this);
    }

    public JIntegerTextField(String value, int min, int max) {
        super(value);
        this._lastValue = value;
        this._min = min;
        this._max = max;
        this._bound = true;
        this.addKeyListener(this);
    }

    public JIntegerTextField(String value, int column, int min, int max) {
        super(value, column);
        this._lastValue = value;
        this._min = min;
        this._max = max;
        this._bound = true;
        this.addKeyListener(this);
    }

    @Override
    public void setText(String t) {
        this._lastValue = t;
        super.setText(t);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        try {
            int value = Integer.parseInt(this.getText());
            if (this._bound && (value < this._min || value > this._max)) {
                this.setText(this._lastValue);
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgVoc.msgFormat("MSG_BOUND_FLOAT", this._min, this._max), ResMsgVoc.getString("VOC_ERROR"), 0);
            } else {
                this._lastValue = this.getText();
            }
        }
        catch (NumberFormatException ex) {
            this.setText(this._lastValue);
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgVoc.msgFormat("MSG_PARSE_INT", this.getText()), ResMsgVoc.getString("VOC_ERROR"), 0);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

