/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.swing.other;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class ToggleBorderLayout
implements LayoutManager {
    public static JComponent simulate(JToggleButton toggle, JComponent subcomponent) {
        JPanel tmpPanel = new JPanel(new GridBagLayout());
        tmpPanel.setBorder(BorderFactory.createEtchedBorder());
        tmpPanel.add((Component)subcomponent, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 12, 1, new Insets(10, 0, 0, 0), 0, 0));
        JPanel contents = new JPanel(new GridBagLayout());
        contents.add((Component)toggle, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 15, 0, 0), 0, 0));
        contents.add((Component)tmpPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 12, 1, new Insets(10, 10, 10, 10), 0, 0));
        return contents;
    }

    public static void configure(Container target, JToggleButton first, JComponent other) {
        target.removeAll();
        target.add(first);
        JPanel pOther = new JPanel(new BorderLayout());
        pOther.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(10, 5, 5, 5)));
        pOther.add((Component)other, "Center");
        target.add(pOther);
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        System.out.println("ToggleBorderLayout::addLayoutComponent(" + name + ", " + comp.getClass().getName() + ")");
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        System.out.println("ToggleBorderLayout::removeLayoutComponent(" + comp.getClass().getName() + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            boolean first = false;
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getPreferredSize();
                if (m instanceof JToggleButton && !first) {
                    dim.width = Math.max(dim.width, d.width + 10);
                    dim.height += d.height / 2;
                    first = true;
                    continue;
                }
                dim.width = Math.max(dim.width, d.width);
                dim.height += d.height;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            boolean first = false;
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getMinimumSize();
                if (m instanceof JToggleButton && !first) {
                    dim.width = Math.max(dim.width, d.width + 10);
                    dim.height += d.height / 2;
                    first = true;
                    continue;
                }
                dim.width = Math.max(dim.width, d.width);
                dim.height += d.height;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Component m;
            int i;
            Insets insets = target.getInsets();
            int maxwidth = target.getSize().width - (insets.left + insets.right);
            int nmembers = target.getComponentCount();
            int y = insets.top;
            int idx = -1;
            for (i = 0; i < nmembers; ++i) {
                m = target.getComponent(i);
                if (!(m instanceof JToggleButton)) continue;
                idx = i;
            }
            if (idx != -1) {
                Component m2 = target.getComponent(idx);
                Dimension d = m2.getPreferredSize();
                m2.setSize(d.width, d.height);
                y += d.height / 2;
                m2.setLocation(insets.left + 5, insets.top);
            }
            for (i = 0; i < nmembers; ++i) {
                m = target.getComponent(i);
                if (!m.isVisible() || i == idx) continue;
                Dimension d = m.getPreferredSize();
                m.setSize(maxwidth, d.height);
                m.setLocation(insets.left, y);
                y += d.height;
            }
        }
    }
}

