/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.swing.table;

import com.dassault.cecilia.core.swing.table.TableDecoredRenderer;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Insets;
import javax.swing.JTable;

public class LeftDotTableCellRenderer
extends TableDecoredRenderer {
    protected String getText(Object value) {
        return this.getText();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        int availableWidth = table.getColumnModel().getColumn(column).getWidth();
        availableWidth = (int)((double)availableWidth - table.getIntercellSpacing().getWidth());
        Insets borderInsets = this.getBorder().getBorderInsets(this);
        String cellText = this.getText(value);
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics.stringWidth(cellText) > (availableWidth -= borderInsets.left + borderInsets.right)) {
            int i;
            String dots = "...";
            int textWidth = fontMetrics.stringWidth(dots);
            for (i = cellText.length() - 1; i > 0 && (textWidth += fontMetrics.charWidth(cellText.charAt(i))) <= availableWidth; --i) {
            }
            this.setText(dots + cellText.substring(i + 1));
            this.setToolTipText(cellText);
        }
        return this;
    }
}

