/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.swing.table;

import com.dassault.cecilia.core.swing.other.AbstractCollectionPanel;
import com.dassault.cecilia.core.swing.table.CeciliaTable;
import com.dassault.cecilia.core.swing.table.TableDecoredRenderer;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public abstract class TablePanel
extends AbstractCollectionPanel {
    private final Window _window;
    TableModel _modelTable;
    protected JTable _ctrlTable;

    public TablePanel(Window window, TableModel model, boolean bInit, boolean bCreate) {
        super(false);
        this._window = window;
        this._modelTable = model;
        if (bInit) {
            this.initialise();
        }
        if (bCreate) {
            this.createPanel();
        }
    }

    public TablePanel(Window window, TableModel model, boolean bInit) {
        this(window, model, bInit, bInit);
    }

    protected TableModel getTableModel() {
        return this._modelTable;
    }

    protected CeciliaTable createTable(TableModel model) {
        return new CeciliaTable(this._modelTable);
    }

    @Override
    protected JTable createCtrlCollection() {
        this._ctrlTable = this.createTable(this._modelTable);
        this._ctrlTable.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        TableDecoredRenderer rendered = new TableDecoredRenderer();
        this._ctrlTable.setDefaultRenderer(String.class, rendered);
        this._ctrlTable.setPreferredScrollableViewportSize(this.getPreferredScrollableViewportSize());
        ListSelectionModel selMod = this._ctrlTable.getSelectionModel();
        selMod.setSelectionMode(0);
        selMod.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TablePanel.this.refreshCtrl();
            }
        });
        this._modelTable.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                TablePanel.this.callRefreshCtrl();
            }
        });
        this._ctrlTable.putClientProperty("terminateEditOnFocusLost", true);
        if (this._window != null) {
            this._window.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    if (TablePanel.this._ctrlTable.isEditing()) {
                        TablePanel.this._ctrlTable.getCellEditor().stopCellEditing();
                    }
                }
            });
        }
        return this._ctrlTable;
    }

    @Override
    protected int getSelectedRow() {
        return this._ctrlTable.getSelectedRow();
    }

    @Override
    protected int getSelectedRowCount() {
        return this._ctrlTable.getSelectedRowCount();
    }

    @Override
    protected int[] getSelectedRows() {
        return this._ctrlTable.getSelectedRows();
    }

    @Override
    protected void initialise() {
        super.initialise();
        this.createPanel();
    }

    protected Dimension getPreferredScrollableViewportSize() {
        return new Dimension(400, 100);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._ctrlTable.setEnabled(enabled);
    }
}

