/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db.dao.sql.def;

import com.dassault.cecilia.db.DBProperty;
import com.dassault.cecilia.db.dao.DAOProperty;
import com.dassault.cecilia.db.dao.sql.SQLTable;
import com.dassault.cecilia.db.dao.sql.def.DefaultFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.TreeMap;
import java.util.logging.Level;

public class DefaultProperty
extends DAOProperty {
    protected Connection _connect = null;
    protected DefaultFactory _factory = null;

    public DefaultProperty(Connection connect, DefaultFactory factory) {
        this._connect = connect;
        this._factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean insert(DBProperty obj) {
        try {
            int nbrChg = 0;
            this._factory.beginTransaction(false);
            PreparedStatement prepare = this._connect.prepareStatement("DELETE FROM " + SQLTable.PROPERTIES + " WHERE dbp_name = ?");
            this._factory.initStatement(prepare);
            try {
                prepare.setString(1, obj.getName());
                nbrChg = prepare.executeUpdate();
                if (nbrChg > 0) {
                    DefaultFactory._LOG.finer("DefaultProperty::insert(" + obj.getName() + "): delete old value.");
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
            prepare = this._connect.prepareStatement("INSERT INTO " + SQLTable.PROPERTIES + " (dbp_name, dbp_value, dbp_description) VALUES (?, ?, ?)");
            this._factory.initStatement(prepare);
            try {
                prepare.setString(1, obj.getName());
                prepare.setString(2, obj.getValue());
                prepare.setString(3, obj.getDescription());
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
            this._factory.endTransaction();
            return (nbrChg += prepare.executeUpdate()) > 0;
        }
        catch (Exception e) {
            try {
                this._factory.abortTransaction();
            }
            catch (Exception abortExc) {
                DefaultFactory._LOG.log(Level.SEVERE, "Exception during abort transaction operation: Risk of corruption of data", abortExc);
            }
            this.logException(e, "DefaultProperty::insert(" + obj.getName() + ")");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean delete(DBProperty obj) {
        try {
            PreparedStatement prepare = this._connect.prepareStatement("DELETE FROM " + SQLTable.PROPERTIES + " WHERE dbp_name = ?");
            this._factory.initStatement(prepare);
            try {
                prepare.setString(1, obj.getName());
                int nbrChg = prepare.executeUpdate();
                if (nbrChg != 1) return false;
                boolean bl = true;
                return bl;
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultProperty::delete(" + obj.getName() + ")");
            return false;
        }
        catch (Exception e) {
            this.logException(e, "DefaultProperty::delete(" + obj.getName() + ")");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBProperty find(String name) {
        DBProperty obj = null;
        try {
            PreparedStatement prepare = this._connect.prepareStatement("SELECT dbp_name, dbp_value, dbp_description FROM " + SQLTable.PROPERTIES + " WHERE dbp_name = ?", 1004, 1007);
            this._factory.initStatement(prepare);
            try {
                prepare.setString(1, name);
                ResultSet resultSet = prepare.executeQuery();
                try {
                    if (resultSet.first()) {
                        obj = new DBProperty(name);
                        obj.setValue(resultSet.getString(2));
                        obj.setDescription(resultSet.getString(3));
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultProperty::find(" + name + ")");
        }
        catch (Exception e) {
            this.logException(e, "DefaultProperty::find(" + name + ")");
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<DBProperty> findAll() {
        TreeMap<String, DBProperty> result = new TreeMap<String, DBProperty>();
        try {
            PreparedStatement prepare = this._connect.prepareStatement("SELECT dbp_name, dbp_value, dbp_description FROM " + SQLTable.PROPERTIES, 1004, 1007);
            this._factory.initStatement(prepare);
            try {
                ResultSet resultSet = prepare.executeQuery();
                try {
                    while (resultSet.next()) {
                        String name = resultSet.getString(1);
                        DBProperty obj = new DBProperty(name);
                        obj.setValue(resultSet.getString(2));
                        obj.setDescription(resultSet.getString(3));
                        result.put(name, obj);
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            result.clear();
            this.logSQLException(e, "DefaultProperty::findAll()");
        }
        catch (Exception e) {
            result.clear();
            this.logException(e, "DefaultProperty::findAll()");
        }
        return result.values();
    }
}

