/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.config;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.ccf.CCF;
import com.dassault.cecilia.dbobj.faulttree.config.FTConfigAbstract;
import com.dassault.cecilia.dbobj.faulttree.dsf.DSFEquation;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.lib.util.AlphaNumComparator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class FTConfig
extends FTConfigAbstract {
    private static Logger _LOG = Logger.getLogger(FTConfig.class.getPackage().getName());
    public static final String XML_EVENT = "event";
    public static final String XML_TREE = "tree";
    public static final String XML_CRITICITY_COMPUTE = "criticity.compute";
    public static final String DEFAULT = "Default";
    private static AlphaNumComparator _COMPARATOR_ALPHANUM = new AlphaNumComparator();
    private static Comparator<ConfigItem> _COMPARATOR_ITEM = new Comparator<ConfigItem>(){

        @Override
        public int compare(ConfigItem o1, ConfigItem o2) {
            int result = o1.getDBFolder().getParent().getRefPath().compareTo(o2.getDBFolder().getParent().getRefPath());
            if (result == 0) {
                result = _COMPARATOR_ALPHANUM.compare(o1.getDBFolder().getName(), o2.getDBFolder().getName());
            }
            return result;
        }
    };
    String _name = null;
    String _label = "";
    List<DSFConfigItem> _dsfCollection = new ArrayList<DSFConfigItem>();
    List<DSFConfigItem> _dsfCollectionView = null;
    Map<Long, DSFConfigItem> _dsfMap = new HashMap<Long, DSFConfigItem>();
    List<CCFConfigItem> _ccfCollection = new ArrayList<CCFConfigItem>();
    Map<Long, CCFConfigItem> _ccfMap = new HashMap<Long, CCFConfigItem>();
    boolean _isCritCompute = false;
    int _nbrHeight;
    private boolean _bLastVerifyRight = false;

    public static String verifyName(String name, JComponent owner) {
        if (DBFactory.verifyName(name) == 0) {
            return name;
        }
        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(owner), ResMsgObj.getString("MSG_ERR_VERIFY_NAME"), ResMsgVoc.getString("VOC_ERROR"), 0);
        return null;
    }

    public FTConfig() {
        super(false);
    }

    public String toString() {
        return this._name;
    }

    public String getName() {
        return this._name;
    }

    public FTConfig setName(String value) {
        this._name = value;
        return this;
    }

    public String getLabel() {
        return this._label;
    }

    public FTConfig setLabel(String value) {
        this._label = value;
        return this;
    }

    @Override
    public boolean withDSFSubTree(DSFEquation dsf) {
        DSFConfigItem item = this._dsfMap.get(dsf.getDBFolder().getID());
        if (item == null) {
            return false;
        }
        return !item.isFRB();
    }

    @Override
    public boolean withCCF(CCF ccf) {
        CCFConfigItem item = this._ccfMap.get(ccf.getDBFolder().getID());
        if (item == null) {
            return false;
        }
        return item.isSelected();
    }

    public List<DSFConfigItem> getDSFItems() {
        return this._dsfCollection;
    }

    public synchronized List<DSFConfigItem> getDSFItemsView() {
        if (this._dsfCollectionView == null) {
            this._dsfCollectionView = new ArrayList<DSFConfigItem>(this._dsfCollection.size());
            for (DSFConfigItem dsfCfg : this._dsfCollection) {
                if (!dsfCfg.isVisible()) continue;
                this._dsfCollectionView.add(dsfCfg);
            }
        }
        return this._dsfCollectionView;
    }

    public List<CCFConfigItem> getCCFItems() {
        return this._ccfCollection;
    }

    public DSFConfigItem getDSFItem(DBFolder dbFolder) {
        return this._dsfMap.get(dbFolder.getID());
    }

    public CCFConfigItem getCCFItem(DBFolder dbFolder) {
        return this._ccfMap.get(dbFolder.getID());
    }

    public void addDSFItem(DSFConfigItem item) {
        long id = item.getDBFolder().getID();
        DSFConfigItem other = this._dsfMap.get(id);
        if (other != null) {
            for (int i = this._dsfCollection.size() - 1; i >= 0; --i) {
                if (this._dsfCollection.get(i).getDBFolder().getID() != id) continue;
                this._dsfCollection.remove(i);
            }
        }
        this._dsfMap.put(id, item);
        this._dsfCollection.add(item);
        this._dsfCollectionView = null;
    }

    public void addCCFItem(CCFConfigItem item) {
        long id = item.getDBFolder().getID();
        CCFConfigItem other = this._ccfMap.get(id);
        if (other != null) {
            for (int i = this._ccfCollection.size() - 1; i >= 0; --i) {
                if (this._ccfCollection.get(i).getDBFolder().getID() != id) continue;
                this._ccfCollection.remove(i);
            }
        }
        this._ccfMap.put(id, item);
        this._ccfCollection.add(item);
    }

    public boolean isCritCompute() {
        return this._isCritCompute;
    }

    public void setCritCompute(boolean isCritCompute) {
        this._isCritCompute = isCritCompute;
    }

    public void configLightest(Map<DBFolder, Boolean> dsfs, Map<DBFolder, Boolean> ccfs) {
        ConfigItem item;
        for (Map.Entry<DBFolder, Boolean> dsf : dsfs.entrySet()) {
            item = new DSFConfigItem(dsf.getKey()).setFRB(dsf.getValue());
            this.addDSFItem((DSFConfigItem)item);
        }
        for (Map.Entry<DBFolder, Boolean> ccf : ccfs.entrySet()) {
            item = new CCFConfigItem(ccf.getKey()).setSelected(ccf.getValue());
            this.addCCFItem((CCFConfigItem)item);
        }
    }

    public FTConfig getCopy() {
        FTConfig dest = new FTConfig();
        dest.copy(this);
        return dest;
    }

    public void copy(FTConfig src) {
        this.setName(src.getName());
        this.setLabel(src.getLabel());
        this.setCritCompute(src.isCritCompute());
        this.clear();
        for (DSFConfigItem dSFConfigItem : src.getDSFItems()) {
            this.addDSFItem(new DSFConfigItem(dSFConfigItem));
        }
        for (CCFConfigItem cCFConfigItem : src.getCCFItems()) {
            this.addCCFItem(new CCFConfigItem(cCFConfigItem));
        }
    }

    public void clear() {
        this._ccfCollection.clear();
        this._ccfMap.clear();
        this._dsfCollection.clear();
        this._dsfMap.clear();
        this._dsfCollectionView = null;
    }

    public void computeHeight() {
        int countCR = this._label.length();
        if (countCR > 0) {
            countCR -= this._label.replace("\n", "").length();
        }
        this._nbrHeight = 0;
        for (int i = this._dsfCollection.size() - 1; i >= 0; --i) {
            DSFConfigItem dsfCfg = this._dsfCollection.get(i);
            if (!dsfCfg.isVisible() || !dsfCfg.isEnable() && !dsfCfg.isOnlyFRB()) continue;
            ++this._nbrHeight;
        }
        int nbrCCF = 0;
        for (int i = this._ccfCollection.size() - 1; i >= 0; --i) {
            if (!this._ccfCollection.get(i).isEnable()) continue;
            ++nbrCCF;
        }
        if (nbrCCF > 0) {
            ++this._nbrHeight;
        }
        if (this._nbrHeight <= countCR) {
            this._nbrHeight = countCR + 1;
        }
        if (this._nbrHeight > 6) {
            this._nbrHeight = 6;
        }
    }

    public int getHeigth() {
        if (this._nbrHeight == 0) {
            this.computeHeight();
        }
        return this._nbrHeight;
    }

    public boolean withCCF() {
        for (int i = this._ccfCollection.size() - 1; i >= 0; --i) {
            if (!this._ccfCollection.get(i).isSelected()) continue;
            return true;
        }
        return false;
    }

    public void sortConfigs() {
        Collections.sort(this._dsfCollection, _COMPARATOR_ITEM);
        Collections.sort(this._ccfCollection, _COMPARATOR_ITEM);
    }

    public boolean validateConfig(DBFolder dbFolder, Collection<DBRelation> relations, CECFactory daoFactory, boolean readFromDB) {
        this._dsfCollectionView = null;
        if (readFromDB) {
            Iterator<ConfigItem> iter = this._dsfCollection.iterator();
            while (iter.hasNext()) {
                DSFConfigItem dSFConfigItem = iter.next();
                if (!dSFConfigItem.isFRB()) continue;
                iter.remove();
                this._dsfMap.remove(dSFConfigItem.getDBFolder().getID());
            }
        } else {
            for (DSFConfigItem dSFConfigItem : this._dsfCollection) {
                dSFConfigItem.clear();
            }
        }
        for (CCFConfigItem cCFConfigItem : this._ccfCollection) {
            cCFConfigItem.clear();
        }
        this.validateConfig_rec(null, dbFolder, relations, daoFactory);
        this.sortConfigs();
        boolean result = true;
        for (DSFConfigItem dSFConfigItem : this._dsfCollection) {
            if (dSFConfigItem.isVisible() || !dSFConfigItem.isSelected()) continue;
            result = false;
        }
        for (CCFConfigItem cCFConfigItem : this._ccfCollection) {
            if (cCFConfigItem.isVisible() || !cCFConfigItem.isSelected()) continue;
            result = false;
        }
        return result;
    }

    private void addDSFConfigItem(DSFConfigItem item, DBFolder dbSrc) {
        this._dsfMap.put(item.getDBFolder().getID(), item);
        this._dsfCollection.add(item);
        if (_LOG.isLoggable(Level.FINEST)) {
            DBFolder dbFolder = item.getDBFolder();
            _LOG.finest("DSFConfig '" + dbFolder.getRefPath() + "'\t\t(from '" + dbSrc.getRefPath() + "')");
            for (DSFConfigItem dsfConfigItem : this._dsfCollection) {
                if (dsfConfigItem == item || !dsfConfigItem.getDBFolder().getParent().equals(dbFolder.getParent())) continue;
                _LOG.fine("DSFConfig confict '" + dbFolder.getRefPath() + "' (other version '" + dsfConfigItem.getDBFolder().getName() + "')");
            }
        }
    }

    private void validateConfig_rec(DSFConfigItem parent, DBFolder dbFolder, Collection<DBRelation> relations, CECFactory daoFactory) {
        for (DBRelation dbRelat : relations) {
            ConfigItem item;
            DBFolder dbDest;
            if (!dbRelat.getSource().equals(dbFolder) || !(dbDest = dbRelat.getDestination()).isVersion()) continue;
            if (dbDest.getFamily() == DBFolder.Family.PROJECT && (dbDest.getFamilyFlag() == 3 || dbDest.getFamilyFlag() == 2 || dbDest.getFamilyFlag() == 5)) {
                item = parent;
                DBWrap dbWrap = daoFactory.findOrCreateWrap(dbDest);
                if (dbWrap == null) {
                    _LOG.warning("Erreur lors de la lecture d'une DSFEquation : " + dbDest.getRefPath());
                    continue;
                }
                if (dbDest.getFamilyFlag() == 3) {
                    item = this._dsfMap.get(dbDest.getID());
                    if (item == null) {
                        item = new DSFConfigItem(dbDest);
                        if (dbWrap instanceof DSFEquation) {
                            DSFEquation dbDSF = (DSFEquation)dbWrap;
                            if (dbDSF.getSubTree() == null) {
                                ((DSFConfigItem)item).setOnlyFRB(true);
                            }
                        } else {
                            _LOG.warning("Erreur lors de la lecture d'une DSFEquation : " + dbDest.getRefPath());
                        }
                        this.addDSFConfigItem((DSFConfigItem)item, dbFolder);
                    }
                    if (parent != null) {
                        item.addParent(parent);
                    } else {
                        item.setIsTop(true);
                    }
                    item.setVisible(true);
                }
                Collection<DBRelation> subrelations = dbWrap.getUseRelations();
                this.validateConfig_rec((DSFConfigItem)item, dbDest, subrelations, daoFactory);
                continue;
            }
            if (dbDest.getFamily() != DBFolder.Family.CCF_MODEL) continue;
            item = this._ccfMap.get(dbDest.getID());
            if (item == null) {
                item = new CCFConfigItem(dbDest);
                this._ccfMap.put(dbDest.getID(), (CCFConfigItem)item);
                this._ccfCollection.add((CCFConfigItem)item);
            }
            if (parent != null) {
                item.addParent(parent);
            } else {
                item.setIsTop(true);
            }
            item.setVisible(true);
        }
    }

    public boolean withError() {
        return false;
    }

    public void toXML(Appendable out, String indent) throws IOException {
        out.append(indent).append("<").append("ft.cfg");
        DBObjectXmlUtility.appendXML(out.append(" ").append("name").append("='"), this._name).append("'");
        if (this._isCritCompute) {
            out.append(' ').append(XML_CRITICITY_COMPUTE).append("='true'");
        }
        out.append(">\n");
        if (this._label.length() > 0) {
            out.append(indent).append("  <").append("label").append(">");
            DBObjectXmlUtility.appendXML(out, this._label);
            out.append("</").append("label").append(">\n");
        }
        for (DSFConfigItem dSFConfigItem : this.getDSFItems()) {
            if (!dSFConfigItem.isVisible() || !dSFConfigItem.isEnable() && !dSFConfigItem.isFRB()) continue;
            out.append("  ").append(indent).append("<").append("ft.cfg.dsf");
            DBObjectXmlUtility.writeDBFolder(out, dSFConfigItem.getDBFolder(), null);
            out.append(" ").append("type").append("='").append(dSFConfigItem.isFRB() ? XML_EVENT : XML_TREE).append("'");
            out.append("/>\n");
        }
        for (CCFConfigItem cCFConfigItem : this.getCCFItems()) {
            out.append("  ").append(indent).append("<").append("ft.cfg.ccf");
            DBObjectXmlUtility.writeDBFolder(out, cCFConfigItem.getDBFolder(), null);
            out.append(" ").append("value").append("='").append(cCFConfigItem.isSelected() ? "true" : "false").append("'");
            out.append("/>\n");
        }
        out.append(indent).append("</").append("ft.cfg").append(">\n");
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FTConfig)) {
            return false;
        }
        FTConfig conf = (FTConfig)obj;
        if (!conf.getCCFItems().equals(this.getCCFItems())) {
            return false;
        }
        if (!conf.getDSFItems().equals(this.getDSFItems())) {
            return false;
        }
        if (!conf.getLabel().equals(this.getLabel())) {
            return false;
        }
        return conf.getName().equals(this.getName());
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        hashCode = 2 * hashCode + this._ccfCollection.hashCode();
        hashCode = 3 * hashCode + this._ccfMap.hashCode();
        hashCode = 5 * hashCode + this._dsfCollection.hashCode();
        hashCode = 7 * hashCode + this._dsfMap.hashCode();
        hashCode = 11 * hashCode + this._label.hashCode();
        hashCode = 13 * hashCode + this._name.hashCode();
        hashCode = 17 * hashCode + this._nbrHeight;
        return hashCode;
    }

    public void addRelation(DBFolder dbSrcFolder, String typeSrcRelation, Set<DBRelation> relations) {
        for (DSFConfigItem dSFConfigItem : this.getDSFItems()) {
            if (!dSFConfigItem.isEnable()) continue;
            relations.add(new DBRelation(dbSrcFolder, typeSrcRelation, dSFConfigItem.getDBFolder(), "DSF_V"));
        }
        for (CCFConfigItem cCFConfigItem : this.getCCFItems()) {
            relations.add(new DBRelation(dbSrcFolder, typeSrcRelation, cCFConfigItem.getDBFolder(), "CCF_MODEL"));
        }
    }

    public boolean getLastVerifyRight() {
        return this._bLastVerifyRight;
    }

    private boolean doVerifyRight(DBUser dbUser, CECFactory daoFactory) {
        for (DSFConfigItem item : this.getDSFItemsView()) {
            if (item.isFRB() || item.isOnlyFRB()) continue;
            DBWrap dbWrap = daoFactory.findOrCreateWrap(item.getDBFolder());
            if (dbWrap == null) {
                return false;
            }
            DSFEquation dbDSF = (DSFEquation)dbWrap;
            if (dbDSF.getSubTree() == null) continue;
            switch (dbDSF.getSubTree().getDBFolder().getAccessRight(dbUser)) {
                case INTEGRATE: {
                    return false;
                }
                case NONE: {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean verifyRight(DBUser dbUser, CECFactory daoFactory) {
        this._bLastVerifyRight = this.doVerifyRight(dbUser, daoFactory);
        return this._bLastVerifyRight;
    }

    public static class CCFConfigItem
    extends ConfigItem {
        boolean _isSelected;

        public CCFConfigItem(DBFolder dbFolder) {
            super(dbFolder);
            this._isSelected = true;
        }

        CCFConfigItem(CCFConfigItem src) {
            super(src._dbFolder);
            this._isSelected = src._isSelected;
        }

        @Override
        public boolean isSelected() {
            return this._isSelected;
        }

        public CCFConfigItem setSelected(boolean value) {
            this._isSelected = value;
            return this;
        }
    }

    public static class DSFConfigItem
    extends ConfigItem {
        boolean _isFRB;
        boolean _isOnlyFRB;

        public DSFConfigItem(DBFolder dbFolder) {
            super(dbFolder);
            this._isFRB = true;
        }

        DSFConfigItem(DSFConfigItem src) {
            super(src._dbFolder);
            this._isFRB = src._isFRB;
            this._isOnlyFRB = src._isOnlyFRB;
        }

        public boolean isFRB() {
            return this._isFRB;
        }

        public DSFConfigItem setFRB(boolean value) {
            this._isFRB = value;
            return this;
        }

        public boolean isOnlyFRB() {
            return this._isOnlyFRB;
        }

        public DSFConfigItem setOnlyFRB(boolean value) {
            this._isOnlyFRB = value;
            if (this._isOnlyFRB) {
                this._isFRB = true;
            }
            return this;
        }

        @Override
        public boolean isEnable() {
            if (this._isOnlyFRB) {
                return false;
            }
            return super.isEnable();
        }

        @Override
        public boolean isSelected() {
            return !this._isFRB;
        }
    }

    public static abstract class ConfigItem {
        DBFolder _dbFolder;
        List<? super ConfigItem> _parents;
        boolean _visible;
        boolean _isTop;

        ConfigItem(DBFolder dbFolder) {
            this._dbFolder = dbFolder;
            this._parents = new ArrayList<ConfigItem>();
            this._visible = true;
            this._isTop = false;
        }

        public void clear() {
            this._parents.clear();
            this._visible = false;
            this._isTop = false;
        }

        public boolean isVisible() {
            return this._visible;
        }

        public void setVisible(boolean value) {
            this._visible = value;
        }

        public void setIsTop(boolean value) {
            this._isTop = value;
        }

        public void addParent(ConfigItem cfgItem) {
            if (!this._parents.contains(cfgItem)) {
                this._parents.add(cfgItem);
            }
        }

        public boolean isEnable() {
            if (!this._visible) {
                return false;
            }
            if (this._isTop) {
                return true;
            }
            for (int i = this._parents.size() - 1; i >= 0; --i) {
                ConfigItem parent = this._parents.get(i);
                if (!parent.isEnable() || !parent.isSelected()) continue;
                return true;
            }
            return false;
        }

        public DBFolder getDBFolder() {
            return this._dbFolder;
        }

        public abstract boolean isSelected();

        public int hashCode() {
            return this.getDBFolder().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof ConfigItem) {
                return this.getDBFolder().equals(((ConfigItem)obj).getDBFolder());
            }
            return false;
        }

        public String toString() {
            return this._dbFolder.getRefPath();
        }

        public String toDebug() {
            StringBuilder sb = new StringBuilder();
            sb.append(this._dbFolder.getRefPath()).append("[");
            if (this._isTop) {
                sb.append("T");
            }
            if (this._visible) {
                sb.append("V");
            }
            sb.append("]{");
            Iterator<? super ConfigItem> i = this._parents.iterator();
            while (i.hasNext()) {
                sb.append(i.next());
                if (!i.hasNext()) continue;
                sb.append(",");
            }
            sb.append("}");
            return sb.toString();
        }
    }
}

