/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.config.gui;

import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.config.FTConfig;
import java.awt.Component;
import java.awt.EventQueue;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class FTConfigTableCellRenderer
extends DefaultTableCellRenderer {
    public FTConfigTableCellRenderer() {
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(final JTable table, Object value, boolean isSelected, boolean hasFocus, final int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (!(value instanceof FTConfig)) {
            return this;
        }
        FTConfig cfg = (FTConfig)value;
        String text = null;
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        int i = 0;
        for (FTConfig.DSFConfigItem dsfCfg : cfg.getDSFItemsView()) {
            if (!dsfCfg.isEnable() && !dsfCfg.isOnlyFRB()) continue;
            if (i > 0) {
                sb.append("<br/>");
            }
            if (i == 5) {
                text = sb.toString() + "...</html>";
            }
            sb.append(ResMsgArbor.getString("CFG_DLG_DSF")).append("[");
            sb.append(dsfCfg.getDBFolder().getRefPath()).append("] ");
            sb.append(ResMsgArbor.getString(dsfCfg.isFRB() ? "CFG_DLG_DSF_FRB" : "CFG_DLG_DSF_SUBTREE"));
            ++i;
        }
        int j = 0;
        for (FTConfig.CCFConfigItem ccfCfg : cfg.getCCFItems()) {
            if (!ccfCfg.isEnable()) continue;
            if (j == 0) {
                sb.append(ResMsgArbor.getString("CFG_DLG_CCF")).append(" : ");
            } else if (j % 3 == 0) {
                sb.append(",<br/>");
            } else {
                sb.append(", ");
            }
            sb.append(ccfCfg.getDBFolder().getRefPath());
            ++j;
        }
        if (i == 0 && j == 0) {
            sb = new StringBuilder();
        } else {
            sb.append("</html>");
        }
        if (text == null) {
            text = sb.toString();
        }
        this.setText(text);
        if (sb.length() == 0) {
            this.setToolTipText(null);
        } else {
            this.setToolTipText(sb.toString());
        }
        final int newHeight = cfg.getHeigth() * table.getRowHeight();
        if (table.getRowHeight(row) != newHeight) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    table.setRowHeight(row, newHeight);
                }
            });
        }
        return this;
    }
}

