/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.config.io;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FTConfigReaderRaw {
    private static Logger _LOG = Logger.getLogger(FTConfigReaderRaw.class.getPackage().getName());
    Map<DBFolder, Boolean> _dsfConfigs;
    Map<DBFolder, Boolean> _ccfConfigs;
    CECFactory _cecFactory;
    DBLogs.DBLogsManager _logMng;
    FTEquation _ftEquation;
    protected static final String XML_ELT_COMPUTE_CONFIG = "compute-config";
    protected static final String XML_ELT_DSF_CONFIG = "dsf-config";
    protected static final String XML_ELT_DSF_ITEM = "dsf";
    protected static final String XML_ELT_CCF_CONFIG = "ccf-config";
    protected static final String XML_ELT_CCF_ITEM = "ccf";
    protected static final String XML_ATT_ID = "id";
    protected static final String XML_ATT_NAME = "name";
    protected static final String XML_ATT_TYPE = "type";
    private static final Pattern _PATTERN_REF_PATH = Pattern.compile("(.*) \\(([0-9]+\\.[0-9]+)\\)");

    public FTConfigReaderRaw(CECFactory cecFactory, DBLogs.DBLogsManager logMng, FTEquation ftEquation) {
        this._cecFactory = cecFactory;
        this._logMng = logMng;
        this._ftEquation = ftEquation;
        this._dsfConfigs = new LinkedHashMap<DBFolder, Boolean>();
        this._ccfConfigs = new LinkedHashMap<DBFolder, Boolean>();
    }

    public Map<DBFolder, Boolean> getDSFs() {
        return this._dsfConfigs;
    }

    public Map<DBFolder, Boolean> getCCFs() {
        return this._ccfConfigs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean read(InputStream stream) {
        try {
            BufferedInputStream buffer = new BufferedInputStream(stream, 1024);
            buffer.mark(1024);
            byte[] begin = new byte[64];
            buffer.read(begin);
            buffer.reset();
            if (new String(begin).startsWith("<?xml")) {
                this.loadXML(buffer);
            } else {
                this.loadOldFormat(new BufferedReader(new InputStreamReader(buffer)));
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            _LOG.log(Level.SEVERE, "Probleme lors de la lecture du flux de donnee", ioe);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                _LOG.log(Level.INFO, "Probleme de fermeture d'un flux de configuration", e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadOldFormat(BufferedReader reader) throws IOException {
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                int index = line.indexOf(";");
                String itemName = line.substring(0, index);
                boolean configFRB = line.substring(index + 1).startsWith("0");
                this.putDSFName(itemName, configFRB);
            }
        }
        finally {
            reader.close();
        }
    }

    private void loadXML(InputStream inputStream) throws IOException {
        class ConfigHandler
        extends DefaultHandler {
            Locator _locator;

            ConfigHandler() {
            }

            public Locator getLocator() {
                return this._locator;
            }

            @Override
            public void setDocumentLocator(Locator locator) {
                this._locator = locator;
                super.setDocumentLocator(locator);
            }

            private String getValAttribute(Attributes attrs, String name, String entity) throws SAXException {
                int idx = attrs.getIndex(name);
                if (idx == -1) {
                    throw new SAXException("No attribute '" + name + "' for element '" + entity + "' !");
                }
                return attrs.getValue(idx);
            }

            @Override
            public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
                String eltName;
                if (attrs == null) {
                    return;
                }
                String string = eltName = "".equals(sName) ? qName : sName;
                if (eltName.equals(FTConfigReaderRaw.XML_ELT_DSF_ITEM)) {
                    String id = "-1";
                    int idx = attrs.getIndex(FTConfigReaderRaw.XML_ATT_ID);
                    if (idx != -1) {
                        id = attrs.getValue(idx);
                    }
                    String name = this.getValAttribute(attrs, FTConfigReaderRaw.XML_ATT_NAME, eltName);
                    String type = this.getValAttribute(attrs, FTConfigReaderRaw.XML_ATT_TYPE, eltName);
                    FTConfigReaderRaw.this.putDSF(id, name, type.equals("0"));
                } else if (eltName.equals(FTConfigReaderRaw.XML_ELT_CCF_ITEM)) {
                    String id = this.getValAttribute(attrs, FTConfigReaderRaw.XML_ATT_ID, eltName);
                    String type = this.getValAttribute(attrs, FTConfigReaderRaw.XML_ATT_TYPE, eltName);
                    FTConfigReaderRaw.this.putCCF(id, type.equals("1"));
                }
            }
        }
        ConfigHandler handler = null;
        try {
            SAXParserFactory fabrique = SAXParserFactory.newInstance();
            handler = new ConfigHandler();
            SAXParser parseur = fabrique.newSAXParser();
            parseur.parse(inputStream, (DefaultHandler)handler);
        }
        catch (IOException e) {
            _LOG.log(Level.FINE, "IOException during ComputeConfigIO.loadXML", e);
            throw e;
        }
        catch (Exception e) {
            Locator loc;
            StringBuffer sb = new StringBuffer();
            sb.append("SAX Parser Exception\n");
            if (handler != null && (loc = handler.getLocator()) != null) {
                sb.append("in [line = ");
                sb.append(loc.getLineNumber());
                sb.append("] [col = ");
                sb.append(loc.getColumnNumber());
                sb.append("]\n");
            }
            sb.append(e.getMessage());
            throw new IOException(sb.toString(), e);
        }
    }

    public void putDSF(String refID, String refPath, boolean configFRB) {
        long id = -1L;
        if (!refID.isEmpty()) {
            try {
                id = Long.parseLong(refID);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (id < 0L) {
                this._logMng.addLog(DBLogs.DBLevel.FINEST, ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", XML_ELT_DSF_ITEM, XML_ATT_ID, refID));
            } else {
                long idFolder = this._cecFactory.createUtilityDAO().convertMigrationOldIDObjectToIDFolder(id);
                if (idFolder == -1L) {
                    this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_RAW_IDMIGRATION_UNKNOWN", id));
                } else {
                    id = idFolder;
                }
            }
        }
        if (!this.putDSF(id, refPath, configFRB)) {
            _LOG.info("Unknown Config/DSFitem (id=" + refID + ", name=" + refPath + ", frb=" + configFRB + ")");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean putDSF(long id, String refPath, boolean configFRB) {
        Matcher matcher = _PATTERN_REF_PATH.matcher(refPath);
        if (matcher.matches()) {
            String dbRefPath = new StringBuilder(refPath.length()).append(matcher.group(1)).append(";").append(matcher.group(2)).toString();
            DBFolder dbFolder = this._cecFactory.createFolderDAO().findFolder(id, dbRefPath, DBFolder.Family.PROJECT.getRootName());
            if (dbFolder == null) {
                this._logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_FOLDER", refPath));
                return false;
            }
            if (dbFolder.getFamily() != DBFolder.Family.PROJECT) {
                this._logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_FOLDER_FAMILY", new Object[]{dbFolder.getRefPath(), DBFolder.Family.PROJECT}));
                return false;
            }
            if (dbFolder.getFamilyFlag() != 3) {
                this._logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_FOLDER_FAMILY_FLAG", dbFolder.getRefPath(), "DSF"));
                return false;
            }
            DBWrap dbWrap = this._cecFactory.findOrCreateWrap(dbFolder);
            if (dbWrap == null) {
                this._logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgObj.msgFormat("MSG_XML_MODEL_EVENT_READ", dbFolder.getRefPath()));
                return false;
            }
            this._dsfConfigs.put(dbFolder, configFRB);
            return true;
        }
        FTVariableAbstract var = this._ftEquation.getVariable(refPath);
        if (var == null) {
            this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgArbor.msgFormat("MSG_ERR_VAR_UNKNOWN", refPath));
            return false;
        }
        if (var.getLink() != null && var.getLink().isDSF()) {
            this._dsfConfigs.put(var.getLink().getSubTree().getDBFolder(), configFRB);
            return true;
        }
        this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgArbor.msgFormat("MSG_ERR_VAR_IS_NOT_DSF", refPath));
        return false;
    }

    public void putDSFName(String refPath, boolean configFRB) {
        if (!this.putDSF(-1L, refPath, configFRB)) {
            _LOG.warning("Unknown old Config/DSFitem (name=" + refPath + ", frb=" + configFRB + ")");
        }
    }

    public void putCCF(String refID, boolean configCCF) {
        DBFolder dbFolder;
        long id = -1L;
        if (!refID.isEmpty()) {
            try {
                id = Long.parseLong(refID);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (id < 0L) {
                this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", XML_ELT_CCF_ITEM, XML_ATT_ID, refID));
                return;
            }
            long idCCF = this._cecFactory.createUtilityDAO().convertMigrationIDCCFToIDFolder(id);
            if (idCCF == -1L) {
                this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_RAW_IDMIGRATION_UNKNOWN", id));
                return;
            }
            id = idCCF;
        }
        if ((dbFolder = (DBFolder)this._cecFactory.createFolderDAO().find(id)) == null) {
            this._logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_FOLDER", refID));
        } else if (dbFolder.getFamily() != DBFolder.Family.CCF_MODEL) {
            this._logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_FOLDER_FAMILY", new Object[]{dbFolder.getRefPath(), DBFolder.Family.CCF_MODEL}));
        } else {
            DBWrap dbWrap = this._cecFactory.findOrCreateWrap(dbFolder);
            if (dbWrap == null) {
                this._logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgObj.msgFormat("MSG_XML_MODEL_EVENT_READ", dbFolder.getRefPath()));
            } else {
                this._ccfConfigs.put(dbFolder, configCCF);
                return;
            }
        }
    }
}

