/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.criticity;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.dbobj.faulttree.criticity.ListCriticityUtility;
import com.dassault.cecilia.lib.util.format.DoubleFormat;
import javax.swing.table.DefaultTableModel;

public abstract class CriticityResultTableModel
extends DefaultTableModel {
    public static final int IDX_COL_VALUE_NAME = 0;
    public static final int IDX_COL_CRITICITY_VALUE = 1;
    public static final int IDX_COL_RESULT_VALUE = 2;
    public static final int IDX_COL_OK_KO = 3;
    public static final int IDX_ROW_PROBABILITY = 0;
    public static final int IDX_ROW_ORDER = 1;
    public static final int IDX_ROW_PROB_EVIDENT = 3;
    public static final int IDX_ROW_PROB_LATENT = 2;
    private final ListCriticityUtility.CriticityResult _criticityResult;
    protected DoubleFormat _formatter;

    protected CriticityResultTableModel(ListCriticityUtility.CriticityResult criticityResult, DoubleFormat formatter) {
        this._criticityResult = criticityResult;
        this._formatter = formatter;
    }

    @Override
    public int getRowCount() {
        if (this._criticityResult == null) {
            return 0;
        }
        return this._criticityResult.isALSRCompute() ? 4 : 2;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return ResMsgVoc.getString("VOC_VALUE");
            }
            case 2: {
                return ResMsgVoc.getString("VOC_VALUE");
            }
            case 1: {
                return ResMsgVoc.getString("VOC_CRITICITY");
            }
            case 3: {
                return ResMsgVoc.getString("VOC_OKKO");
            }
        }
        assert (false);
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: 
            case 1: 
            case 2: {
                return String.class;
            }
            case 3: {
                return ListCriticityUtility.CriticityResult.OKKO.class;
            }
        }
        assert (false);
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this._criticityResult == null) {
            return null;
        }
        switch (column) {
            case 0: {
                switch (row) {
                    case 0: {
                        return ResMsgVoc.getString("VOC_PROBABILITY");
                    }
                    case 1: {
                        return ResMsgVoc.getString("VOC_ORDER");
                    }
                    case 3: {
                        return ResMsgVoc.getString("VOC_LSR_EVIDENT");
                    }
                    case 2: {
                        return ResMsgVoc.getString("VOC_LSR_LATENT");
                    }
                }
                assert (false);
                return null;
            }
            case 1: {
                return this.getValueCriticity(row);
            }
            case 2: {
                switch (row) {
                    case 0: {
                        return this._formatter.format(this._criticityResult.getProbValue().doubleValue());
                    }
                    case 1: {
                        return this._criticityResult.getOrderValue();
                    }
                    case 3: {
                        return this._criticityResult.getEvidentLSRCutError() != null ? this._criticityResult.getEvidentLSRCutError() : ListCriticityUtility.CriticityResult.OKKO.NaN.name();
                    }
                    case 2: {
                        return this._criticityResult.getLatentLSRCutError() != null ? this._criticityResult.getLatentLSRCutError() : ListCriticityUtility.CriticityResult.OKKO.NaN.name();
                    }
                }
                assert (false);
                return null;
            }
            case 3: {
                switch (row) {
                    case 0: {
                        return this.getValueResult(this._criticityResult.getProbRespected());
                    }
                    case 1: {
                        return this.getValueResult(this._criticityResult.getOrderCritRespected());
                    }
                    case 3: {
                        return this.getValueResult(this._criticityResult.getEvidentLSRRespected());
                    }
                    case 2: {
                        return this.getValueResult(this._criticityResult.getLatentLSRRespected());
                    }
                }
                assert (false);
                return null;
            }
        }
        return super.getValueAt(row, column);
    }

    private final ListCriticityUtility.CriticityResult.OKKO getValueResult(Boolean bool) {
        if (bool == null) {
            return ListCriticityUtility.CriticityResult.OKKO.NaN;
        }
        if (bool.booleanValue()) {
            return ListCriticityUtility.CriticityResult.OKKO.OK;
        }
        return ListCriticityUtility.CriticityResult.OKKO.KO;
    }

    protected abstract String getValueCriticity(int var1);
}

