/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.criticity;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.error.GeneralError;
import com.dassault.cecilia.core.cecilia.export.ExpBook;
import com.dassault.cecilia.core.cecilia.export.ExpBookUtility;
import com.dassault.cecilia.core.cecilia.export.JChooserFileUtility;
import com.dassault.cecilia.core.cecilia.folder.dnd.DBFolderList;
import com.dassault.cecilia.core.cecilia.folder.dnd.DBFolderListDropTargetListener;
import com.dassault.cecilia.core.cecilia.folder.dnd.DBFolderListTransferable;
import com.dassault.cecilia.core.cecilia.folder.dnd.DBFolderTransferable;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderDlgDisplayError;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldBoolean;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldsCategory;
import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.core.cecilia.pref.PrintPreviewPrefsDlg;
import com.dassault.cecilia.core.cecilia.print.ListProcessorJavaInteractive;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.PlugModel;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.FileFilterExtention;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.dbobj.faulttree.ResIcoArbor;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.config.FTConfig;
import com.dassault.cecilia.dbobj.faulttree.criticity.ExportCriticity;
import com.dassault.cecilia.dbobj.faulttree.criticity.ListCriticityGenerateCmd;
import com.dassault.cecilia.dbobj.faulttree.criticity.ListCriticityPrintPreferencies;
import com.dassault.cecilia.dbobj.faulttree.criticity.ListCriticityTable;
import com.dassault.cecilia.dbobj.faulttree.criticity.ListCriticityTableModel;
import com.dassault.cecilia.dbobj.faulttree.criticity.ListCriticityUtility;
import com.dassault.cecilia.dbobj.faulttree.gui.ItemAbstractInternalFrame;
import com.dassault.cecilia.dbobj.faulttree.gui.ItemAbstractTableModel;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ListCriticityInternalFrame
extends ItemAbstractInternalFrame<ListCriticityUtility.CriticityIdentifier>
implements PlugModel {
    private static Logger _LOG = Logger.getLogger(ListCriticityInternalFrame.class.getPackage().getName());
    private final List<ListCriticityUtility.CriticityIdentifier> _listCrits;
    private final CAppl _cAppl;
    private JButton _saveButton;
    private JButton _deleteButton;

    public ListCriticityInternalFrame(CAppl cAppl, List<ListCriticityUtility.CriticityIdentifier> listCrits) {
        super(ResIcoArbor.getImageIcon("LIST_ITEM_PI_CRIT"), ResMsgVoc.getString("VOC_CRITICITY"), ResMsgArbor.getString("MSG_LIST_CRITICITY_TITLE"));
        this._listCrits = listCrits;
        this._cAppl = cAppl;
        this.build();
        this.setFrameIcon(ResIcoArbor.getImageIcon("LIST_ITEM_PI_CRIT"));
        this._table.setAutoResizeMode(4);
        assert (this._scrollTable != null) : "Le ScrollPane doit etre instanci\u00e9 au niveau du build()";
        ExportElementsPanel drop = new ExportElementsPanel(this._scrollTable);
        assert (drop != null) : "Grave erreur : le dragndrop pas pris en compte list criticit\u00e9.";
        this.setPreferredSize(new Dimension(1200, 300));
        this.pack();
    }

    @Override
    protected ItemAbstractTableModel<ListCriticityUtility.CriticityIdentifier> createModel() {
        this._modelTable = new ListCriticityTableModel(this._cAppl, this._listCrits);
        this._modelTable.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ListCriticityInternalFrame.this._saveButton.setEnabled(ListCriticityInternalFrame.this._modelTable.getRowCount() != 0);
            }
        });
        return this._modelTable;
    }

    @Override
    protected JTable createTable(ItemAbstractTableModel<ListCriticityUtility.CriticityIdentifier> model) {
        this._table = new ListCriticityTable(this._cAppl, model);
        this._table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int[] selectedRows = ListCriticityInternalFrame.this._table.getSelectedRows();
                ListCriticityInternalFrame.this._deleteButton.setEnabled(selectedRows.length != 0);
            }
        });
        this._table.setAutoCreateRowSorter(true);
        return this._table;
    }

    @Override
    public String getInfo(String key) {
        return null;
    }

    @Override
    public IModel getModel(String key) {
        if (!key.equals("docbook.file") && !key.equals("word.file")) {
            return null;
        }
        JChooserFileUtility.Type type = ExpBookUtility.convertModelKey(key);
        if (type == null) {
            return null;
        }
        CeciliaAppl application = (CeciliaAppl)this._cAppl;
        File file = ExpBookUtility.selectFile(type, application.getPlugable(), this, null, "ListOfCriticity");
        if (file == null) {
            return null;
        }
        ExpBook book = new ExpBook(application.getDAOFactory());
        book.setPageFormat(application.getPageFormat());
        book.setPreferencies(application.getPreferencies());
        ExportCriticity export = new ExportCriticity(this._cAppl, this.getTitle());
        export.configBook(book, this._modelTable);
        if (ExpBookUtility.realiseExport(book, file, this)) {
            return new IModel.DefaultModel(key, file);
        }
        return null;
    }

    @Override
    protected JPanel createButtonsPanel() {
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        this._saveButton = new JButton(ResIcoCore.getImageIcon("BUT_SAVE"));
        JButton loadButton = new JButton(ResIcoCore.getImageIcon("BUT_LOAD"));
        this._deleteButton = new JButton(ResIcoCore.getImageIcon("BUT_DEL"));
        this._saveButton.setEnabled(!this._listCrits.isEmpty());
        this._deleteButton.setEnabled(false);
        this._saveButton.setBorder(BorderFactory.createEmptyBorder());
        loadButton.setBorder(BorderFactory.createEmptyBorder());
        this._deleteButton.setBorder(BorderFactory.createEmptyBorder());
        this._saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListCriticityInternalFrame.this.doExportToXML();
            }
        });
        loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListCriticityInternalFrame.this.doImportToXML();
            }
        });
        this._deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((ListCriticityTable)ListCriticityInternalFrame.this._table).doDeleteCriticity();
            }
        });
        int idxX = 0;
        buttonsPanel.add((Component)loadButton, new GridBagConstraints(idxX++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        buttonsPanel.add((Component)this._saveButton, new GridBagConstraints(idxX++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        buttonsPanel.add((Component)this._deleteButton, new GridBagConstraints(idxX++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 12, 2, 2), 0, 0));
        JPanel fieldButton = super.createButtonsPanel();
        buttonsPanel.add((Component)fieldButton, new GridBagConstraints(idxX++, 0, 1, 1, 1.0, 1.0, 13, 2, new Insets(2, 2, 2, 0), 0, 0));
        return buttonsPanel;
    }

    @Override
    public PageFormat getDefaultPageFormat() {
        return this._cAppl.getPageFormat();
    }

    @Override
    public List<PrefFieldBoolean> getPrintExportOptionnalFields() {
        PluginWithOptions prefs = this._cAppl.getPreferencies().getOptions(ListCriticityPrintPreferencies.PREF_KEY);
        if (prefs == null || !(prefs instanceof ListCriticityPrintPreferencies)) {
            prefs = new ListCriticityPrintPreferencies();
            this._cAppl.getPreferencies().addOptions(prefs);
            prefs.refreshOptions(((CeciliaAppl)this._cAppl).getPlugable());
        }
        List<PrefFieldBoolean> listPrefs = ((PrefFieldsCategory)prefs).getBooleanFields();
        return listPrefs;
    }

    @Override
    public void toDoWhenActivated() {
        super.toDoWhenActivated();
        ((CeciliaAppl)this._cAppl).getTopWindow().setEnabledAction("PRINT", true);
        ((CeciliaAppl)this._cAppl).getTopWindow().setEnabledAction("PRINT_PREVIEW", true);
    }

    @Override
    public void toDoWhenDeActivated() {
        super.toDoWhenDeActivated();
        ((CeciliaAppl)this._cAppl).getTopWindow().setEnabledAction("PRINT", false);
        ((CeciliaAppl)this._cAppl).getTopWindow().setEnabledAction("PRINT_PREVIEW", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Pageable createPageable(PageFormat format, Preferencies pref) {
        ListProcessorJavaInteractive printable = null;
        SrbInputStream scribe = new SrbInputStream("");
        List<PrefFieldBoolean> currentPrefs = this._modelTable.getColumnModel().getOptionnalFields();
        try {
            ArrayList<PrefFieldBoolean> fields = new ArrayList<PrefFieldBoolean>(((PrefFieldsCategory)pref.getOptions(ListCriticityPrintPreferencies.PREF_KEY)).getBooleanFields());
            fields.add(((PrefFieldsCategory)pref.getOptions(ListCriticityPrintPreferencies.PREF_KEY)).getPref("Content.CriticityDef"));
            this._modelTable.getColumnModel().setOptionnalFields(((PrefFieldsCategory)pref.getOptions(ListCriticityPrintPreferencies.PREF_KEY)).getBooleanFields());
            this._modelTable.exportToScribeFile(scribe, this._table);
        }
        catch (IOException err) {
            _LOG.log(Level.WARNING, "Exception lors de l'impression de la vue en cours : " + this.getDBFolder(), err);
            Pageable pageable = null;
            return pageable;
        }
        finally {
            this._modelTable.getColumnModel().setOptionnalFields(currentPrefs);
            scribe.close();
        }
        printable = new ListProcessorJavaInteractive(scribe);
        printable.processScribeFile();
        printable.computePageCount(format);
        return printable;
    }

    @Override
    public boolean preview() {
        Pageable fgPageable = this.createPageable(this.getDefaultPageFormat(), this._cAppl.getPreferencies());
        if (fgPageable == null) {
            return false;
        }
        PrintPreviewPrefsDlg dlg = new PrintPreviewPrefsDlg(JOptionCecilia.getWindowOf(this), fgPageable, this._cAppl, new PrefFieldsCategory[]{(PrefFieldsCategory)this._cAppl.getPreferencies().getOptions(ListCriticityPrintPreferencies.PREF_KEY)}){

            @Override
            public void updatePreferencies() {
                this.setBook(ListCriticityInternalFrame.this.createPageable(this.getFormat(), this.getPreferencies()));
            }
        };
        dlg.setLocationRelativeTo(JOptionCecilia.getWindowOf(this));
        dlg.setVisible(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void doExportToXML() {
        block23: {
            File f = this.getFile(true);
            if (f == null) {
                return;
            }
            BufferedWriter writer = null;
            writer = new BufferedWriter(new FileWriter(f));
            writer.append("<?xml version='1.0' encoding='iso-8859-15'?>\n");
            writer.append("<cec.crit.conf>\n");
            for (int row = 0; row < this._modelTable.getRowCount(); ++row) {
                ListCriticityUtility.CriticityResult result;
                ListCriticityUtility.CriticityIdentifier critID = (ListCriticityUtility.CriticityIdentifier)this._modelTable.getItem(row);
                DBFolder folder = critID.getFolder();
                writer.append("  ").append("<").append("ft.crit.conf");
                writer.append(' ').append("refPath").append("='");
                writer.append(this.ToXML(folder.getRefPath())).append("'");
                if (critID.getEquation() != null) {
                    writer.append(' ').append("failureCond").append("='");
                    writer.append(this.ToXML(critID.getEquation().getTopEvent().getName())).append("'");
                    writer.append(' ').append("config").append("='");
                    String configName = null;
                    for (FTConfig config : critID.getEquation().getConfigs()) {
                        if (!config.isCritCompute()) continue;
                        configName = config.getName();
                    }
                    if (configName == null) {
                        configName = "Default";
                    }
                    writer.append(this.ToXML(configName)).append("'");
                }
                if (critID.getCriticityCrit() != null) {
                    writer.append(' ').append("criticity").append("='");
                    writer.append(this.ToXML(critID.getCriticityCrit().getName())).append("'");
                }
                if ((result = critID.getResult()) != null && result.isAComputeCriticity()) {
                    writer.append(' ').append("proba").append("='");
                    writer.append(String.valueOf(critID.getResult().getProbValue())).append("'");
                    writer.append(' ').append("order").append("='");
                    writer.append(String.valueOf(critID.getResult().getOrderValue())).append("'");
                    if (result.getEvidentLSRRespected() != null) {
                        writer.append(' ').append("evident").append("='");
                        if (result.getEvidentLSRCutError() != null) {
                            writer.append(ListCriticityUtility.CriticityResult.OKKO.KO.name()).append(" (").append(critID.getResult().getEvidentLSRCutError()).append(")'");
                        } else {
                            writer.append(ListCriticityUtility.CriticityResult.OKKO.OK.name()).append("'");
                        }
                    }
                    if (result.getLatentLSRRespected() != null) {
                        writer.append(' ').append("latent").append("='");
                        if (result.getLatentLSRCutError() != null) {
                            writer.append(ListCriticityUtility.CriticityResult.OKKO.KO.name()).append(" (").append(critID.getResult().getLatentLSRCutError()).append(")'");
                        } else {
                            writer.append(ListCriticityUtility.CriticityResult.OKKO.OK.name()).append("'");
                        }
                    }
                }
                writer.append(" />").append('\n');
            }
            writer.append("</cec.crit.conf>");
            try {
                writer.close();
            }
            catch (IOException e) {
                _LOG.warning(e.getMessage());
                JOptionPane.showMessageDialog(this, ResMsgArbor.msgFormat("MSG_LIST_CRITICITY_ERR_SAVING", e.getMessage()), this.getTitle(), 0);
            }
            break block23;
            catch (IOException error) {
                try {
                    String msgError = this.ToXML(error.getMessage());
                    _LOG.warning(msgError);
                    error.printStackTrace();
                    JOptionPane.showMessageDialog(this, ResMsgArbor.msgFormat("MSG_LIST_CRITICITY_ERR_SAVING", msgError), this.getTitle(), 0);
                }
                catch (Throwable throwable) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        _LOG.warning(e.getMessage());
                        JOptionPane.showMessageDialog(this, ResMsgArbor.msgFormat("MSG_LIST_CRITICITY_ERR_SAVING", e.getMessage()), this.getTitle(), 0);
                    }
                    throw throwable;
                }
                try {
                    writer.close();
                }
                catch (IOException e) {
                    _LOG.warning(e.getMessage());
                    JOptionPane.showMessageDialog(this, ResMsgArbor.msgFormat("MSG_LIST_CRITICITY_ERR_SAVING", e.getMessage()), this.getTitle(), 0);
                }
                return;
            }
        }
    }

    private String ToXML(String original) {
        return original.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;");
    }

    private final void doImportToXML() {
        File f = this.getFile(false);
        if (f == null) {
            return;
        }
        List<String> paths = null;
        try {
            FileInputStream inputStream = new FileInputStream(f);
            SAXParserFactory fabrique = SAXParserFactory.newInstance();
            ListCriticityConfigReader handler = new ListCriticityConfigReader();
            SAXParser parseur = fabrique.newSAXParser();
            parseur.parse((InputStream)inputStream, (DefaultHandler)handler);
            paths = handler.getPaths();
        }
        catch (Exception e) {
            String msgError = this.ToXML(e.getMessage());
            _LOG.severe(msgError);
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, ResMsgArbor.msgFormat("MSG_LIST_CRITICITY_ERR_PARSING", msgError), this.getTitle(), 0);
            return;
        }
        if (paths == null || paths.isEmpty()) {
            return;
        }
        ((ListCriticityTableModel)this._modelTable).getListCrits().clear();
        DAOFolder daoFolder = this._cAppl.getDAOFactory().createFolderDAO();
        final ArrayList<GeneralError<Object>> errors = new ArrayList<GeneralError<Object>>();
        for (String path : paths) {
            DBFolder folder = daoFolder.findFolder("PROJECTS", path);
            if (folder == null) {
                String msgError = ResMsgArbor.msgFormat("MSG_LIST_CRITICITY_ERR_PARSING_UNKNOW_TREE", path);
                _LOG.warning(msgError);
                errors.add(new GeneralError<Object>(null, msgError));
                continue;
            }
            ListCriticityUtility.CriticityIdentifier critID = ListCriticityGenerateCmd.createCriticityIdentifierFromDBFolder(this._cAppl, this, folder);
            ((ListCriticityTableModel)this._modelTable).getListCrits().add(critID);
        }
        if (!errors.isEmpty()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DBFolderDlgDisplayError dlg = new DBFolderDlgDisplayError(ListCriticityInternalFrame.this._cAppl.getTopWindow());
                    dlg.setTitle(ListCriticityInternalFrame.this.getTitle());
                    dlg.setErrors(errors);
                    dlg.setModal(true);
                    dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(ListCriticityInternalFrame.this));
                    dlg.setVisible(true);
                }
            });
        }
        this._modelTable.refresh(true, false);
    }

    private final File getFile(boolean export) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setMultiSelectionEnabled(false);
        FileFilterExtention xmlFilter = new FileFilterExtention(ResMsgCore.getString("FILE_TYPE_XML"), ".xml").verifyWrite(true);
        if (export) {
            xmlFilter.verifyWrite(true);
        } else {
            xmlFilter.verifyRead(true);
        }
        fileChooser.addChoosableFileFilter(xmlFilter);
        fileChooser.setFileFilter(xmlFilter);
        if (export) {
            File file;
            if (!(fileChooser.showSaveDialog(JOptionCecilia.getTopContainerOf(this)) != 0 || (file = fileChooser.getSelectedFile()) == null || (file = FileFilterExtention.addDefaultExtention(fileChooser)).exists() && 0 != JOptionPane.showConfirmDialog(JOptionCecilia.getTopContainerOf(this), ResMsgCore.msgFormat("FILE_MSG_EXIST_FRM", file), JOptionCecilia.getTopTitleOf(this), 0))) {
                return file;
            }
        } else {
            fileChooser.showOpenDialog(JOptionCecilia.getTopContainerOf(this));
            return fileChooser.getSelectedFile();
        }
        return null;
    }

    public Set<DBFolder> getSelectedFolders() {
        LinkedHashSet<DBFolder> setFolder = new LinkedHashSet<DBFolder>();
        for (int i = 0; i < this._table.getRowCount(); ++i) {
            DBFolder folder = ((ListCriticityUtility.CriticityIdentifier)this._modelTable.getItem(i)).getFolder();
            setFolder.add(folder);
        }
        return setFolder;
    }

    public int addToModel(DBFolder node, short filterFamilyFlag, Set<DBFolder> nodesTreated) {
        if (nodesTreated.contains(node)) {
            return 0;
        }
        nodesTreated.add(node);
        int res = 0;
        if (node.isVersion()) {
            if (node.getFamilyFlag() != 5 && node.getFamilyFlag() != 2) {
                return 0;
            }
            if (filterFamilyFlag == 0 || filterFamilyFlag == node.getFamilyFlag()) {
                this.addToModel(node);
                ++res;
            }
        } else {
            boolean treatChildren = false;
            if (node.isFolder() || node.isModel() || node.isSystem()) {
                treatChildren = true;
            }
            if (treatChildren) {
                List<DBFolder> children = node.getChildren();
                if (children == null) {
                    children = this._cAppl.getDAOFactory().createFolderDAO().findChildren(node);
                }
                for (DBFolder dbChild : children) {
                    res += this.addToModel(dbChild, filterFamilyFlag, nodesTreated);
                }
            }
        }
        return res;
    }

    private void addToModel(DBFolder node) {
        _LOG.finest("Ajout de la criticit\u00e9 du DBFolder :" + node.getParent().getName() + '(' + node.getName() + ')');
        ListCriticityUtility.CriticityIdentifier critID = ListCriticityGenerateCmd.createCriticityIdentifierFromDBFolder(this._cAppl, this, node);
        ((ListCriticityTableModel)this._modelTable).getListCrits().add(critID);
    }

    class ExportChooseDropTargetListener
    extends DBFolderListDropTargetListener {
        public ExportChooseDropTargetListener(JComponent c) {
            super(c);
        }

        @Override
        protected boolean isDnDAcceptable(DBFolderList dataDnD) {
            for (DBFolder folder : dataDnD.getFolders()) {
                if (folder.getFamily() != DBFolder.Family.PROJECT) continue;
                return true;
            }
            _LOG.warning("Aucun DBFolder de l'action Drag'N'Drop en cours ne contient d'arbre.");
            return false;
        }

        @Override
        protected void dropDnD(DBFolderList dataDnD, Point point) {
            _LOG.finest("D\u00e9but du drag'n'drop");
            Set<DBFolder> nodesTreated = ListCriticityInternalFrame.this.getSelectedFolders();
            Collection<DBFolder> selectedFolders = dataDnD.getFolders();
            int nbFolder = 0;
            for (DBFolder node : selectedFolders) {
                short familyFlag = node.getFamilyFlag();
                if (familyFlag == 8) {
                    familyFlag = 0;
                }
                nbFolder += ListCriticityInternalFrame.this.addToModel(node, familyFlag, nodesTreated);
            }
            if (nbFolder == 0) {
                _LOG.warning("Aucun \u00e9l\u00e9ment n'a \u00e9t\u00e9 import\u00e9.");
            }
            _LOG.finest("Fin du Drag'n'Drop");
            ((ListCriticityTableModel)ListCriticityInternalFrame.this._modelTable).refresh(true, false);
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            if (!this.isDropAcceptable(event)) {
                event.rejectDrop();
                return;
            }
            event.acceptDrop(2);
            Transferable transferable = event.getTransferable();
            try {
                DBFolderList dataDnD = (DBFolderList)transferable.getTransferData(DBFolderListTransferable.DB_FLAVOR);
                this.dropDnD(dataDnD, event.getLocation());
                event.dropComplete(true);
            }
            catch (IOException dataDnD) {
            }
            catch (UnsupportedFlavorException e) {
                try {
                    DBFolder dataDnD = (DBFolder)transferable.getTransferData(DBFolderTransferable.DB_FLAVOR);
                    DBFolderList list = new DBFolderList(false, dataDnD);
                    this.dropDnD(list, event.getLocation());
                    event.dropComplete(true);
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public class ExportElementsPanel
    extends DropTarget {
        public ExportElementsPanel(JComponent component) {
            super(component, 2, new ExportChooseDropTargetListener(component));
        }
    }

    private final class ListCriticityConfigReader
    extends DefaultHandler {
        public static final String KEY_CRITCONFIG = "cec.crit.conf";
        public static final String KEY_ELEM = "ft.crit.conf";
        public static final String ATTR_PATH = "refPath";
        public static final String ATTR_FAILURECOND = "failureCond";
        public static final String ATTR_CONFIG = "config";
        public static final String ATTR_CRITICITY = "criticity";
        public static final String ATTR_RESULT_PROBA = "proba";
        public static final String ATTR_RESULT_ORDER = "order";
        public static final String ATTR_RESULT_LATENT = "latent";
        public static final String ATTR_RESULT_EVIDENT = "evident";
        private final List<String> _paths = new ArrayList<String>();

        public List<String> getPaths() {
            return this._paths;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals(KEY_CRITCONFIG)) {
                _LOG.finest("Il s'agit bien d'un fichier de configuration de liste de Criticite");
            } else if (qName.equals(KEY_ELEM)) {
                this._paths.add(attributes.getValue(ATTR_PATH));
            } else {
                _LOG.severe("TAG " + qName + " inconnue.");
                throw new SAXException("error unknown tag :" + qName);
            }
        }
    }
}

