/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.egli.export;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.export.ExpBook;
import com.dassault.cecilia.core.cecilia.export.ExpTable;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldBoolean;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldsCategory;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.db.DBGlobEvent;
import com.dassault.cecilia.dbobj.CLawManager;
import com.dassault.cecilia.dbobj.faulttree.egli.FTGlobEventAbstract;
import com.dassault.cecilia.dbobj.faulttree.egli.FTGlobEventUtility;
import com.dassault.cecilia.dbobj.faulttree.egli.pref.EGLPrintPreferencies;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.filter.Filter;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.law.FctParamSelect;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.LawFormat;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.ParamFMEA;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class ExpEGLTable
extends ExpTable {
    private static Logger _LOG = Logger.getLogger(ExpEGLTable.class.getPackage().getName());
    CLawManager _lawManager = null;
    List<FTGlobEventAbstract> _vars;
    List<PrefFieldBoolean> _cols;
    Filter<FTGlobEventAbstract> _filter;
    boolean _bSynthesis = false;
    List<FTGlobEventAbstract> _currents;

    public ExpEGLTable(List<FTGlobEventAbstract> input) {
        this._vars = input;
    }

    public ExpEGLTable setFilter(Filter<FTGlobEventAbstract> filter) {
        this._filter = filter;
        return this;
    }

    public Filter<FTGlobEventAbstract> getFilter() {
        return this._filter;
    }

    public ExpEGLTable setSynthesis(boolean value) {
        this._bSynthesis = value;
        return this;
    }

    public boolean getSynthesis() {
        return this._bSynthesis;
    }

    @Override
    public void writeDocbook(DBKOutput output) throws IOException {
        if (!this.prepareExport()) {
            return;
        }
        super.writeDocbook(output);
    }

    @Override
    public void writeScribe(SrbInputStream scribe) throws IOException {
        if (!this.prepareExport()) {
            return;
        }
        super.writeScribe(scribe);
    }

    private boolean prepareExport() {
        ExpBook book = this.getBook();
        if (book == null) {
            _LOG.severe("Don't find root book for exportation");
            return false;
        }
        PrefFieldsCategory prefs = this.readPreferencies(book);
        List<PrefFieldBoolean> listPrefs = prefs.getBooleanFields();
        this._cols = this.filterFields(listPrefs);
        this._lawManager = book.getDAOFactory().getLawManager();
        this._currents = this._bSynthesis ? FTGlobEventUtility.computeSynthesis(this._vars, this._filter) : FTGlobEventUtility.computeFilter(this._vars, this._filter);
        return true;
    }

    private List<PrefFieldBoolean> filterFields(List<PrefFieldBoolean> listPrefs) {
        ArrayList<PrefFieldBoolean> fields = new ArrayList<PrefFieldBoolean>(listPrefs.size());
        for (PrefFieldBoolean prefField : listPrefs) {
            if (!prefField.isSelected()) continue;
            fields.add(prefField.getCopy());
        }
        return fields;
    }

    private PrefFieldsCategory readPreferencies(ExpBook book) {
        PluginWithOptions prefs = book.getPreferencies().getOptions(EGLPrintPreferencies.PREF_KEY);
        if (prefs == null || !(prefs instanceof EGLPrintPreferencies)) {
            prefs = new EGLPrintPreferencies();
            book.getPreferencies().addOptions(prefs);
        }
        return (PrefFieldsCategory)prefs;
    }

    protected int transcodeCol(int col) {
        if (this._bSynthesis) {
            if (col == 0) {
                return -1;
            }
            switch (this._cols.size() - col) {
                case -1: {
                    return -2;
                }
                case -2: {
                    return -3;
                }
                case -3: {
                    return -4;
                }
            }
            return col - 1;
        }
        switch (col) {
            case 3: {
                return -1;
            }
            case 2: {
                return -2;
            }
            case 1: {
                return -3;
            }
            case 0: {
                return -4;
            }
        }
        return col - 4;
    }

    @Override
    protected int getColumnCount() {
        return this._cols.size() + 4;
    }

    @Override
    protected String getColumnName(int col) {
        col = this.transcodeCol(col);
        switch (col) {
            case -4: {
                return ResMsgVoc.getString("VOC_PROJECT");
            }
            case -3: {
                return ResMsgVoc.getString("VOC_SYSTEM");
            }
            case -2: {
                return ResMsgVoc.getString("VOC_TREE");
            }
            case -1: {
                return ResMsgVoc.getString("VOC_NAME");
            }
        }
        return this._cols.get(col).getLabel();
    }

    @Override
    protected ExpTable.ExpAlign getColumnAlign(int col) {
        if ((col = this.transcodeCol(col)) < 0) {
            return ExpTable.ExpAlign.LEFT;
        }
        Object info = this._cols.get(col).getInfo("Align");
        if (info == null) {
            return ExpTable.ExpAlign.LEFT;
        }
        switch (info.toString()) {
            case "R": {
                return ExpTable.ExpAlign.RIGHT;
            }
            case "C": {
                return ExpTable.ExpAlign.CENTER;
            }
        }
        return ExpTable.ExpAlign.LEFT;
    }

    @Override
    protected int getColumnWidth(int col) {
        if ((col = this.transcodeCol(col)) < 0) {
            return 12;
        }
        Object info = this._cols.get(col).getInfo("Width");
        if (info == null || !(info instanceof Number)) {
            return 5;
        }
        return ((Number)info).intValue();
    }

    @Override
    protected int getRowCount() {
        return this._currents.size();
    }

    @Override
    protected void writeDocbookEntryAt(DBKOutput output, int col, int row) throws IOException {
        int codCol = -1;
        col = this.transcodeCol(col);
        switch (col) {
            case -4: {
                codCol = 2;
                break;
            }
            case -3: {
                codCol = 3;
                break;
            }
            case -2: {
                codCol = 4;
                break;
            }
            case -1: {
                codCol = 1;
                break;
            }
            default: {
                codCol = this._cols.get(col).getIdxCode();
            }
        }
        FTGlobEventAbstract var = this._currents.get(row);
        String value = this.getValueAt(codCol, var);
        if (value != null && !value.isEmpty()) {
            output.write(value, true);
        }
    }

    @Override
    protected void exportToScribeEntryAt(StringBuilder buffer, int col, int row, int idx) {
        int codCol = -1;
        col = this.transcodeCol(col);
        switch (col) {
            case -4: {
                codCol = 2;
                break;
            }
            case -3: {
                codCol = 3;
                break;
            }
            case -2: {
                codCol = 4;
                break;
            }
            case -1: {
                codCol = 1;
                break;
            }
            default: {
                codCol = this._cols.get(col).getIdxCode();
            }
        }
        FTGlobEventAbstract var = this._currents.get(row);
        String value = this.getValueAt(codCol, var);
        if (value != null && !value.isEmpty()) {
            buffer.append(value);
        }
    }

    private String getValueAt(int codCol, FTGlobEventAbstract item) {
        switch (codCol) {
            case 1: {
                return item.getName();
            }
            case 4: {
                if (item.getTree().isEmpty()) {
                    return item.getVersion();
                }
                return item.getTree() + ";" + item.getVersion();
            }
            case 3: {
                return item.getSystem();
            }
            case 2: {
                return item.getProject();
            }
            case 100: {
                return item.getCommentLong();
            }
            case 101: {
                return item.getDefinition();
            }
            case 102: {
                if (item.getLaw() != null) {
                    return this.ltos(item.getLaw());
                }
                return "";
            }
            case 103: {
                if (item.getState() != null) {
                    return item.getState().getLabel();
                }
                return "";
            }
            case 115: {
                if (item.getStyle() != null) {
                    return item.getStyle().getLabel();
                }
                return "";
            }
            case 104: {
                return item.getGenericFlag() ? ResMsgVoc.getString("VOC_YES") : "";
            }
            case 105: {
                return item.getGenericSuffix();
            }
            case 106: {
                return item.getLink() == DBGlobEvent.Link.TREE ? ResMsgVoc.getString("VOC_YES") : "";
            }
            case 107: {
                return item.getLink() == DBGlobEvent.Link.DSF ? ResMsgVoc.getString("VOC_YES") : "";
            }
            case 108: {
                if (item.getSubTree() != null) {
                    return item.getSubTree().getRefPath();
                }
                return "";
            }
            case 109: {
                if (item.getModelLaw() != null) {
                    return item.getModelLaw().getRefPath();
                }
                return "";
            }
            case 110: {
                Set<Param> params = item.recupParams(new LinkedHashSet<Param>(), new FctParamSelect.FctParamFMEA());
                return ParamFMEA.transcodeCollections(params);
            }
            case 111: {
                if (item.getInspected() != null) {
                    return this.ptos(item.getInspected());
                }
                return "";
            }
            case 112: {
                if (item.getInflightTested() != null) {
                    return this.ptos(item.getInflightTested());
                }
                return "";
            }
            case 113: {
                if (item.getAttributes() != null) {
                    StringBuilder buf = new StringBuilder();
                    Iterator<DBAttrib.Value> iterAttrib = item.getAttributes().iterator();
                    while (iterAttrib.hasNext()) {
                        DBAttrib.Value dbValue = iterAttrib.next();
                        dbValue.appendDisplay(buf);
                        if (!iterAttrib.hasNext()) continue;
                        buf.append("; ");
                    }
                    return buf.toString();
                }
                return "";
            }
            case 114: {
                if (item.getCCF() != null) {
                    return item.getCCF().getRefPath();
                }
                return "";
            }
        }
        return "";
    }

    protected String ptos(Param param) {
        return LawFormat.DEFAULT.format(param, this.getBook().getDoubleFormat());
    }

    protected String ltos(Law law) {
        return LawFormat.DEFAULT.format(law, this.getBook().getDoubleFormat());
    }
}

