/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft;

import com.dassault.cecilia.core.Util;
import com.dassault.cecilia.db.DBAccess;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObjProperty;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.config.FTConfig;
import com.dassault.cecilia.dbobj.faulttree.dsf.DSFEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.FTComputeParameters;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.io.dagdef.EquBoolStdParser;
import com.dassault.cecilia.dbobj.faulttree.obj.FTDefinition;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEvent;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.law.LawFormat;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.ParamFMEA;
import com.dassault.cecilia.dbobj.general.nparam.DBParam;
import com.dassault.cecilia.dbobj.project.AverageAttributeCriterion;
import com.dassault.cecilia.dbobj.project.AverageAttributeDriver;
import com.dassault.cecilia.dbobj.project.CriticityCriterion;
import com.dassault.cecilia.dbobj.project.DBProject;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.lib.util.format.DoubleFormat;
import com.dassault.cecilia.lib.util.format.DoubleFormatJava;
import com.dassault.cecilia.lib.util.io.CRCWriter;
import com.dassault.cecilia.lib.util.io.ConsumerReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class FTComputeGenerator {
    private static Logger _LOG = Logger.getLogger(FTComputeGenerator.class.getPackage().getName());
    private static final String DATE_FORMAT_PATTERN = "dd-MMM-yyyy";
    private static final String TIME_FORMAT_PATTERN = "HH:mm:ss";
    private static final String DATE_TIME_FORMAT_PATTERN = "dd-MMM-yyyy HH:mm:ss";
    FTEquation _delegate;
    FTVariableAbstract _ftTopEvent;
    FTConfig _config;
    FTComputeParameters _ftParameters;
    DateFormat _dateFormat = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss", Locale.ENGLISH);
    private static final int FLAG_EXPORT_NO = 0;
    private static final int FLAG_EXPORT_ALL = 1;
    private static final int FLAG_EXPORT_LAW = 2;
    private static final int FLAG_EXPORT_DEF = 3;

    public FTComputeParameters getComputeParameters() {
        return this._ftParameters;
    }

    public FTVariableAbstract getTopEvent() {
        return this._ftTopEvent;
    }

    public FTComputeGenerator(FTEquation delegate) {
        this._delegate = delegate;
        this._ftTopEvent = null;
        this._ftParameters = new FTComputeParameters();
    }

    public void setDateFormat(DateFormat dateFormat) {
        this._dateFormat = dateFormat;
    }

    public FTVariableAbstract getVariable(String name) {
        return this._delegate.getVariable(name);
    }

    public void setFlags(int value) {
        for (FTVariableAbstract var : this._delegate.getAllVariables()) {
            var.setFlags(value);
        }
    }

    public void propageFlag(FTVariableAbstract var, int value) {
        if (var.getFlags() == value) {
            return;
        }
        var.setFlags(value);
        FTDefinition ftDefinition = var.getDefinition();
        if (ftDefinition != null) {
            for (FTVariableAbstract arg : ftDefinition.getArgs()) {
                this.propageFlag(arg, value);
            }
        }
    }

    public void clearProbabilities() {
        for (FTVariableAbstract var : this._delegate.getAllVariables()) {
            var.setProbability(Double.NaN);
            if (!var.isLeaf()) continue;
            var.getEvent().clearIFs();
        }
    }

    private FTVariableAbstract getDSFinition(FTVariableAbstract var) {
        FTDefinition ftDefinition = var.getDefinition();
        return ftDefinition.getArgs().iterator().next();
    }

    public void propageFlagCompute(FTVariableAbstract var) {
        block6: {
            block4: {
                block5: {
                    if (var.getFlags() != 0) {
                        return;
                    }
                    if (var.getLink() == null || !var.getLink().isDSF()) break block4;
                    var.setFlags(1);
                    if (this._config != null && this._config.withDSFSubTree((DSFEquation)var.getLink().getSubTree())) break block5;
                    this.getDSFinition(var).setFlags(2);
                    break block6;
                }
                var = this.getDSFinition(var);
                var.setFlags(3);
                FTDefinition ftDefinition = var.getDefinition();
                if (ftDefinition == null) break block6;
                for (FTVariableAbstract arg : ftDefinition.getArgs()) {
                    this.propageFlagCompute(arg);
                }
                break block6;
            }
            var.setFlags(1);
            FTDefinition ftDefinition = var.getDefinition();
            if (ftDefinition != null) {
                for (FTVariableAbstract arg : ftDefinition.getArgs()) {
                    this.propageFlagCompute(arg);
                }
            }
        }
    }

    public void prepareWith(FTConfig config, FTVariableAbstract root) {
        this._config = config;
        this._ftTopEvent = root;
        if (this._ftTopEvent == null) {
            this._ftTopEvent = this._delegate.getTopEvent();
        }
        if (this._delegate.isBigTree()) {
            this.setFlags(1);
        } else {
            this.setFlags(0);
            this.propageFlagCompute(this._ftTopEvent);
        }
        if (_LOG.isLoggable(Level.FINEST)) {
            HashMap<Integer, StringBuilder> _mapLog = new HashMap<Integer, StringBuilder>();
            for (FTVariableAbstract fTVariableAbstract : this._delegate.getAllVariables()) {
                if (fTVariableAbstract.getFlags() == 1) continue;
                StringBuilder log = (StringBuilder)_mapLog.get(fTVariableAbstract.getFlags());
                if (log == null) {
                    log = new StringBuilder();
                    _mapLog.put(fTVariableAbstract.getFlags(), log);
                }
                if (log.length() > 0) {
                    log.append(", ");
                }
                log.append(fTVariableAbstract.getExportName());
            }
            if (!_mapLog.isEmpty()) {
                _LOG.finest("Flags for generate boolean formulae");
                for (Map.Entry entry : _mapLog.entrySet()) {
                    _LOG.finest("     " + entry.getKey() + " : " + entry.getValue());
                }
            }
        }
    }

    public void writeEqu(Appendable out) throws IOException {
        for (FTVariableAbstract var : this._delegate.getAllVariables()) {
            if (var.getFlags() != 1 && var.getFlags() != 3) continue;
            var.writeEqu(out);
        }
    }

    private void writeDBFolderInformations(CRCWriter writer, DBFolder dbFolder, String key, boolean full) throws IOException {
        writer.append((CharSequence)"    <info n='").append(key).append("' v='");
        Util.appendForXml((Appendable)writer, dbFolder.getName().trim()).append("'/>\n");
        if (dbFolder.getUserOwner() != null) {
            writer.append((CharSequence)"    <info n='").append(key).append("-Owner' v='");
            Util.appendForXml((Appendable)writer, dbFolder.getUserOwner().getLogin()).append("'/>\n");
        }
        if (dbFolder.getGroupOwner() != null) {
            writer.append((CharSequence)"    <info n='").append(key).append("-Group' v='");
            Util.appendForXml((Appendable)writer, dbFolder.getGroupOwner().getName()).append("'/>\n");
        }
        if (dbFolder.getRightGroup() != null) {
            writer.append((CharSequence)"    <info n='").append(key).append("-Access-Group' v='");
            writer.append(dbFolder.getRightGroup().getChar()).append("'/>\n");
        }
        if (dbFolder.getRightOther() != null) {
            writer.append((CharSequence)"    <info n='").append(key).append("-Access-Other' v='");
            writer.append(dbFolder.getRightOther().getChar()).append("'/>\n");
        }
        writer.append((CharSequence)"    <info n='").append(key).append("-Create-Date' v='");
        Util.appendForXml((Appendable)writer, this._dateFormat.format(dbFolder.getDateCreate())).append("'/>\n");
        String label = dbFolder.getDescription();
        if (label != null && label.length() > 0) {
            writer.append((CharSequence)"    <info n='").append(key).append("-Comment' v='");
            Util.appendForXml((Appendable)writer, label).append("'/>\n");
        }
        if (full) {
            DBObjProperty dbObjProp = null;
            if (dbFolder.isVersion() && dbFolder.getObject() != null) {
                dbObjProp = dbFolder.getObject().getProperty("object.creator");
            }
            if (dbObjProp != null) {
                writer.append((CharSequence)"    <info n='").append(key).append("-Create-By' v='");
                Util.appendForXml((Appendable)writer, dbObjProp.getValue()).append("'/>\n");
            }
            writer.append((CharSequence)"    <info n='").append(key).append("-Modify-Date' v='");
            Util.appendForXml((Appendable)writer, this._dateFormat.format(dbFolder.getDateModify())).append("'/>\n");
            if (dbFolder.getUserModify() != null) {
                writer.append((CharSequence)"    <info n='").append(key).append("-Modify-By' v='");
                Util.appendForXml((Appendable)writer, dbFolder.getUserModify().getLogin()).append("'/>\n");
            }
        }
    }

    private void writeTreeInformations(FTVariableAbstract root, CRCWriter writer, FTConfig ccfg, CECFactory daoFactory, DBUser dbUser, Set<DBRelation> setDBRelations) throws IOException {
        DBObject dbProjectObject;
        double missionTime;
        writer.append((CharSequence)"  <tree>\n");
        writer.setUpdate(false);
        DBFolder folVersion = this._delegate.getDBFolder();
        DBFolder folTree = folVersion.getParent();
        DBFolder folSystem = folTree.getParent();
        DBFolder folProject = folSystem.getParent();
        this.writeDBFolderInformations(writer, folProject, "Project", false);
        this.writeDBFolderInformations(writer, folSystem, "System", false);
        this.writeDBFolderInformations(writer, folTree, "Tree", false);
        if (this._delegate.isBigTree()) {
            writer.append((CharSequence)"    <info n='Tree-BigTree' v='true'/>\n");
        }
        this.writeDBFolderInformations(writer, folVersion, "Version", true);
        boolean readOnly = false;
        if (this._delegate.getDBFolder().isReadOnly()) {
            readOnly = true;
        }
        if (root != this._delegate.getTopEvent()) {
            readOnly = true;
        }
        if (this._delegate.getDBFolder().isFreeze()) {
            readOnly = true;
            writer.append((CharSequence)"    <info n='Frozen' v='true'/>\n");
        } else {
            writer.append((CharSequence)"    <info n='Frozen' v='false'/>\n");
        }
        if (dbUser == null || daoFactory.createFolderDAO().getAccessRight(this._delegate.getDBFolder(), dbUser) != DBAccess.Right.WRITE) {
            readOnly = true;
            writer.append((CharSequence)"    <info n='AccessWrite' v='false'/>\n");
        } else {
            writer.append((CharSequence)"    <info n='AccessWrite' v='true'/>\n");
        }
        writer.append((CharSequence)"    <info n='ReadOnly' v='");
        writer.append((CharSequence)(readOnly ? "true" : "false")).append("'/>\n");
        writer.append((CharSequence)"    <info n='Locked' v='");
        writer.append((CharSequence)(this._delegate.getDBFolder().isLocked() ? "true" : "false")).append("'/>\n");
        if (ccfg != null) {
            writer.append((CharSequence)"    <info n='Configuration' v='");
            Util.appendForXml((Appendable)writer, ccfg.getName()).append("'/>\n");
            for (FTConfig.DSFConfigItem dsfPath : ccfg.getDSFItems()) {
                if (!dsfPath.isEnable()) continue;
                boolean frb = dsfPath.isFRB();
                writer.append((CharSequence)"    <dsf path='");
                Util.appendForXml((Appendable)writer, dsfPath.getDBFolder().getRefPath()).append("'");
                writer.append((CharSequence)" frb='").append(frb ? "true" : "false").append("'/>\n");
            }
        }
        if (!Double.isNaN(missionTime = this.getComputeParameters().getTime())) {
            writer.append((CharSequence)"    <info n='Mission-Time' v='");
            Util.appendForXml((Appendable)writer, Double.toString(missionTime)).append("'/>\n");
        }
        if ((dbProjectObject = folProject.getObject()) != null) {
            DBObjProperty property = dbProjectObject.getProperty("project.latentprobability.defaultvalue");
            if (property != null) {
                writer.append((CharSequence)"    <info n='Latent-Probability' v='");
                Util.appendForXml((Appendable)writer, property.getValue()).append("'/>\n");
            }
            writer.setUpdate(true);
            DBProject dbProject = null;
            DBWrap dbWrap = daoFactory.findOrCreateWrap(folProject);
            if (dbWrap != null && dbWrap instanceof DBProject) {
                dbProject = (DBProject)dbWrap;
            }
            writer.setUpdate(false);
            if (this._delegate.getCriticityLevel() != null && dbProject != null && !dbProject.getCriticityCriterium().isEmpty()) {
                CriticityCriterion criterion = null;
                String level = this._delegate.getCriticityLevel();
                for (CriticityCriterion curCriterion : dbProject.getCriticityCriterium()) {
                    if (!curCriterion.getName().equals(level)) continue;
                    criterion = curCriterion;
                    break;
                }
                if (criterion != null) {
                    writer.append((CharSequence)"    <info n='Criticity' v='");
                    Util.appendForXml((Appendable)writer, criterion.getName()).append("'/>\n");
                    writer.append((CharSequence)"    <info n='Criticity-Probability' v='").append(Double.toString(criterion.getProbability())).append("'/>\n");
                    writer.append((CharSequence)"    <info n='Criticity-OrderCuts' v='").append(Integer.toString(criterion.getOrder())).append("'/>\n");
                    writer.append((CharSequence)"    <info n='Criticity-LSR-Latent' v='").append(Double.toString(criterion.getLSRLatent())).append("'/>\n");
                    writer.append((CharSequence)"    <info n='Criticity-LSR-Evident' v='").append(Double.toString(criterion.getLSREvident())).append("'/>\n");
                }
            }
            if (this._delegate.getInitialConfMBSA() != null && !this._delegate.getInitialConfMBSA().isEmpty()) {
                writer.append((CharSequence)"    <info n='InitialConfMBSA' v='");
                Util.appendForXml((Appendable)writer, this._delegate.getInitialConfMBSA());
                writer.append((CharSequence)"'/>\n");
            }
            if (this._delegate.getTargetMBSA() != null && !this._delegate.getTargetMBSA().isEmpty()) {
                writer.append((CharSequence)"    <info n='TargetMBSA' v='");
                Util.appendForXml((Appendable)writer, this._delegate.getTargetMBSA());
                writer.append((CharSequence)"'/>\n");
            }
            if (this._delegate.getModelePathMBSA() != null && !this._delegate.getModelePathMBSA().isEmpty()) {
                writer.append((CharSequence)"    <info n='ModelPathMBSA' v='");
                Util.appendForXml((Appendable)writer, this._delegate.getModelePathMBSA());
                writer.append((CharSequence)"'/>\n");
            }
            writer.setUpdate(true);
            if (dbProject != null && !dbProject.getAttributeDrivers().isEmpty()) {
                AverageAttributeDriver driver = dbProject.getAttributeDrivers().get(dbProject.getAttributeDrivers().size() - 1);
                DBAttrib attr = driver.getAttribute();
                int attrType = 0;
                switch (attr.getType()) {
                    case NUMBER: {
                        attrType = 1;
                        break;
                    }
                    case STRING: {
                        attrType = 2;
                        break;
                    }
                    case ENUM: {
                        attrType = 3;
                        break;
                    }
                }
                String attrName = attr.toString();
                int id = 1;
                for (AverageAttributeCriterion crit : driver.getCriterions(false)) {
                    writer.append((CharSequence)"    <attr-avg");
                    writer.append((CharSequence)" id='").append(Integer.toString(id)).append("'");
                    writer.append((CharSequence)" n='");
                    Util.appendForXml((Appendable)writer, attrName).append("'");
                    writer.append((CharSequence)" t='").append(Integer.toString(attrType)).append("'");
                    writer.append((CharSequence)" o='");
                    Util.appendForXml((Appendable)writer, crit.getCriterion().getOperator().toString()).append("'");
                    writer.append((CharSequence)" d='");
                    Util.appendForXml((Appendable)writer, crit.getCriterion().getData()).append("'");
                    writer.append((CharSequence)" c='");
                    Util.appendForXml((Appendable)writer, crit.getChoice().toString()).append("'");
                    Param critParam = crit.getDefaultParameter();
                    if (critParam != null) {
                        critParam.addRelation(this._delegate.getDBFolder(), "TREE_V", setDBRelations);
                        writer.append((CharSequence)" p='");
                        Util.appendForXml((Appendable)writer, crit.getDefaultParameter().toString()).append("'");
                    }
                    writer.append((CharSequence)"/>\n");
                    ++id;
                }
            }
            writer.setUpdate(false);
            DBObjProperty property2 = dbProjectObject.getProperty("project.flightduration.averagevalue");
            if (property2 != null) {
                writer.append((CharSequence)"    <info n='Average-Flight-Duration' v='");
                Util.appendForXml((Appendable)writer, property2.getValue()).append("'/>\n");
            }
            writer.setUpdate(true);
        }
        writer.setUpdate(true);
        writer.append((CharSequence)"  </tree>\n");
    }

    public void writeComputeEvents(FTVariableAbstract root, CRCWriter writer, boolean withCCF, FTConfig ccfg, CECFactory daoFactory, DBUser dbUser) throws IOException {
        writer.append((CharSequence)"<?xml version='1.0' encoding='iso-8859-15'?>\n");
        writer.append((CharSequence)"<tree-informations>\n");
        HashSet<DBRelation> setDBRelations = new HashSet<DBRelation>();
        DoubleFormatJava format = new DoubleFormatJava();
        this.writeTreeInformations(root, writer, ccfg, daoFactory, dbUser, setDBRelations);
        writer.append((CharSequence)"  <events>\n");
        for (FTVariableAbstract item : this._delegate.getAllVariables()) {
            if (item.getFlags() == 0) continue;
            String computeName = item.getExportName();
            boolean usedForCCF = false;
            if (!withCCF || item.isLeaf()) {
                // empty if block
            }
            writer.append((CharSequence)"    <evt");
            writer.append((CharSequence)" n='");
            Util.appendForXml((Appendable)writer, computeName).append("'");
            int t = 1;
            if (item == root) {
                t = 0;
            } else if (item.isLeaf()) {
                t = item.getFlags() == 3 ? 1 : 2;
            } else if (item.getLink() != null) {
                t = item.getLink().isDSF() ? 5 : 4;
            }
            writer.append((CharSequence)" t='").append(Integer.toString(t == 2 && usedForCCF ? 3 : t)).append("'");
            if (!item.isIntern()) {
                writer.append((CharSequence)" ext='true'");
            }
            if (t == 1 || t == 0) {
                FTDefinition ftDefinition = item.getDefinition();
                boolean bGSR = ftDefinition != null && ftDefinition.isGSR();
                String label = item.getLabel();
                if (!label.isEmpty() || bGSR) {
                    writer.append((CharSequence)">\n");
                    if (!label.isEmpty()) {
                        writer.append((CharSequence)"      <fld n='label' v='");
                        Util.appendForXml((Appendable)writer, label).append("'/>\n");
                    }
                    if (bGSR) {
                        writer.append((CharSequence)"      <fld n='gsr' v='true'/>\n");
                    }
                    writer.append((CharSequence)"    </evt>\n");
                    continue;
                }
                writer.append((CharSequence)"/>\n");
                continue;
            }
            if (t == 2) {
                writer.append((CharSequence)">\n");
                FTEvent ftEvent = item.getEvent();
                if (ftEvent.getState() != FTEvent.State.DEFAULT) {
                    writer.append((CharSequence)"      <fld n='state' v='").append(Integer.toString(ftEvent.getState().ordinal())).append("'/>\n");
                }
                if (ftEvent.getLaw() != null) {
                    ftEvent.getLaw().addRelation(this._delegate.getDBFolder(), "TREE_V", setDBRelations);
                    String bufferLaw = LawFormat.DEFAULT.format(ftEvent.getLaw(), (DoubleFormat)format);
                    if (bufferLaw.length() > 0) {
                        String law = bufferLaw.replace(ParamFMEA.FLAG_FMEA, "");
                        writer.append((CharSequence)"      <fld n='law' v='");
                        Util.appendForXml((Appendable)writer, law).append("'/>\n");
                    }
                }
                if (ftEvent.isInspected()) {
                    ftEvent.getInspected().addRelation(this._delegate.getDBFolder(), "TREE_V", setDBRelations);
                    String buffer = LawFormat.DEFAULT.format(ftEvent.getInspected(), (DoubleFormat)format);
                    if (buffer.length() > 0) {
                        writer.append((CharSequence)"      <fld n='inspected' v='");
                        Util.appendForXml((Appendable)writer, buffer).append("'/>\n");
                    }
                }
                if (ftEvent.isInflightTested()) {
                    ftEvent.getInflightTested().addRelation(this._delegate.getDBFolder(), "TREE_V", setDBRelations);
                    String buffer = LawFormat.DEFAULT.format(ftEvent.getInflightTested(), (DoubleFormat)format);
                    if (buffer.length() > 0) {
                        writer.append((CharSequence)"      <fld n='inflight' v='");
                        Util.appendForXml((Appendable)writer, buffer).append("'/>\n");
                    }
                }
                if (!item.getLabel().isEmpty()) {
                    writer.append((CharSequence)"      <fld n='label' v='");
                    Util.appendForXml((Appendable)writer, item.getLabel()).append("'/>\n");
                }
                if (item.isGeneric()) {
                    writer.append((CharSequence)"      <fld n='generic' v='true'/>\n");
                }
                if (ftEvent.getModelLaw() != null) {
                    writer.append((CharSequence)"      <fld n='frb' v='");
                    Util.appendForXml((Appendable)writer, ftEvent.getModelLaw().getRefPath()).append("'/>\n");
                    String fmea = "";
                    if (!fmea.isEmpty() && !"-".equals(fmea)) {
                        writer.append((CharSequence)"      <fld n='fmea' v='");
                        Util.appendForXml((Appendable)writer, fmea).append("'/>\n");
                    }
                }
                for (DBAttrib.Value dbValue : ftEvent.getAttributes()) {
                    String attrName = dbValue.getKey().getRefPath();
                    int tAttr = 0;
                    String vAttr = "null";
                    switch (dbValue.getKey().getType()) {
                        case ALIAS: {
                            break;
                        }
                        case NUMBER: {
                            tAttr = 1;
                            vAttr = dbValue.getValue().toString();
                            break;
                        }
                        case STRING: {
                            tAttr = 2;
                            vAttr = dbValue.getValue().toString();
                            break;
                        }
                        case ENUM: {
                            tAttr = 3;
                            vAttr = dbValue.getValue().toString();
                        }
                    }
                    writer.append((CharSequence)"      <attr");
                    writer.append((CharSequence)" n='");
                    Util.appendForXml((Appendable)writer, attrName).append("'");
                    writer.append((CharSequence)" v='");
                    Util.appendForXml((Appendable)writer, vAttr).append("'");
                    writer.append((CharSequence)" t='").append(Integer.toString(tAttr)).append("'");
                    writer.append((CharSequence)"/>\n");
                }
                writer.append((CharSequence)"    </evt>\n");
                continue;
            }
            writer.append((CharSequence)"/>\n");
        }
        if (withCCF) {
            // empty if block
        }
        writer.append((CharSequence)"  </events>\n");
        if (setDBRelations.size() > 0) {
            writer.append((CharSequence)"  <parameters>\n");
            for (DBRelation dbRelation : setDBRelations) {
                DBWrap dbWrap;
                if (!dbRelation.getTypeDestination().equals("PARAMETER") || (dbWrap = daoFactory.findOrCreateWrap(dbRelation.getDestination())) == null || dbWrap.getFamily() != DBFolder.Family.PARAMETER) continue;
                DBParam dbParam = (DBParam)dbWrap;
                String buffer = LawFormat.DEFAULT.format(dbParam.getValue(), (DoubleFormat)format);
                writer.append((CharSequence)"    <param");
                writer.append((CharSequence)" n='&apos;");
                Util.appendForXml((Appendable)writer, dbParam.getRefPath()).append("&apos;'");
                writer.append((CharSequence)" v='");
                Util.appendForXml((Appendable)writer, buffer).append("'");
                writer.append((CharSequence)" id='").append(Long.toString(dbParam.getRefID())).append("'");
                writer.append((CharSequence)"/>\n");
            }
            writer.append((CharSequence)"  </parameters>\n");
        }
        writer.append((CharSequence)"</tree-informations>\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateModelEvents(File fileXml, FTVariableAbstract ftRoot, boolean useCCF, FTConfig ftConfig, CECFactory daoFactory, DBUser dbUser) throws IOException, NoSuchAlgorithmException {
        String crcXml = null;
        fileXml.deleteOnExit();
        try (CRCWriter writerXml = null;){
            writerXml = new CRCWriter((Writer)new BufferedWriter(new FileWriter(fileXml)));
            this.writeComputeEvents(ftRoot, writerXml, useCCF, ftConfig, daoFactory, dbUser);
            crcXml = writerXml.getCRC();
        }
        return crcXml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateEquation(File fileDag, CECFactory cecFactory) throws IOException, NoSuchAlgorithmException {
        String crcDag = null;
        fileDag.deleteOnExit();
        try (CRCWriter writerDag = null;){
            writerDag = new CRCWriter((Writer)new BufferedWriter(new FileWriter(fileDag)));
            this.writeComputeEquation((Writer)writerDag, cecFactory);
            crcDag = writerDag.getCRC();
            _LOG.finest("CRC DAG generated: " + crcDag);
        }
        return crcDag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeComputeEquation(Writer writer, CECFactory cecFactory) throws IOException {
        if (this._delegate.isBigTree()) {
            DBObjModel modelDag = this._delegate.getDBFolder().getObject().getModel("tree.dag");
            if (modelDag == null) {
                throw new IOException("Le DBFolder/DBObject n'a pas de modele ayant la bonne nature 'tree.dag'");
            }
            InputStream istream = cecFactory.createObjModelDAO().getBinaryStream(modelDag);
            if (istream == null) {
                throw new IOException("Probleme au niveau de la base de donnee pour recuperer le flux d'equation");
            }
            InflaterInputStream iInflaterStream = new InflaterInputStream(istream, new Inflater());
            try (BufferedReader iReader = new BufferedReader(new InputStreamReader(iInflaterStream));){
                ConsumerReader consume = new ConsumerReader((Reader)iReader, writer);
                EquBoolStdParser parser = new EquBoolStdParser((Reader)consume, null);
                parser.run();
                consume.close();
                if (parser.isBigError()) {
                    throw new IOException(ResMsgArbor.getString("MSG_ERR_COMPATIBLE_BIGTREE"));
                }
                for (FTVariableAbstract var : this._delegate.getAllVariables()) {
                    if (!var.isLeaf()) continue;
                    var.writeHouseEvent(writer);
                }
            }
        } else {
            this.writeEqu(writer);
        }
    }
}

