/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.gui;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.export.ExpBook;
import com.dassault.cecilia.core.cecilia.export.ExpBookUtility;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldBoolean;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldsCategory;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldsFactory;
import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.core.cecilia.pref.PrintPreviewPrefsDlg;
import com.dassault.cecilia.core.cecilia.print.ListProcessorJavaInteractive;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.FTVariable;
import com.dassault.cecilia.dbobj.faulttree.ft.SelectionPackage;
import com.dassault.cecilia.dbobj.faulttree.ft.export.ExpFTListVariables51;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FGContentFrame;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTEditPanel;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTEquationFrame;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTPluginAction;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTVariableListModel;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTVariableListTable;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.actions.FTCmdDelete;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.actions.FTCmdEventsEdit;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.actions.FTCmdVarEventEdit;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.actions.FTCmdVarGateEdit;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.actions.FTCmdVarLinkEdit;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.actions.FTCmdVarRename;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.actions.FTCmdVarSubstitution;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.filter.Filter;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.filter.TypeFilter;
import com.dassault.cecilia.dbobj.faulttree.obj.FTClipboard;
import com.dassault.cecilia.dbobj.faulttree.obj.FTClipboardTransferable;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import com.dassault.cecilia.dbobj.faulttree.pref.FTVariableListDisplayPreferencies;
import com.dassault.cecilia.dbobj.faulttree.pref.FTVariableListPrintPreferencies;
import com.dassault.cecilia.dbobj.wrap.PageableThread;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class FTVariableListPanel
extends FTEditPanel
implements FTEquation.ChangeListener,
SelectionPackage.ChangeSelectionListener<FTVariableAbstract> {
    private static Logger _LOG = Logger.getLogger(FTVariableListPanel.class.getPackage().getName());
    FTVariableListModel _model;
    boolean _bChangeFilterOfModel = false;
    FTVariableListTable _table;
    JPopupMenu _popupMenu;
    CeciliaAction _actionEdit;
    CeciliaAction _actionRename;
    CeciliaAction _actionConvertToGate;
    CeciliaAction _actionConvertToEvent;
    CeciliaAction _actionConvertToLink;
    AbstractAction _actionNavDownOther;
    AbstractAction _actionDelete;
    AbstractAction _actionCopy;
    FTPluginAction _pluginMCS;
    FTPluginAction _pluginMEL;
    private JButton _tousButton = new JButton(ResMsgVoc.getString("VOC_ALL"));
    private JComboBox _selecteur = new JComboBox();
    private JLabel _labelQuantite = new JLabel(ResMsgVoc.getString("VOC_QUANTITY"));
    private JLabel _quantite = new JLabel(ResMsgCore.msgFormat("MSG_X_ON_Y", "X", "Y"));
    private JCheckBox _ctrlForOneHour;
    JButton _filtersDlg;

    public FTVariableListPanel(FTEquationFrame frame) {
        super(frame);
        this.setLayout(new GridBagLayout());
        this.makePanel();
        this.refreshFilterSelected();
    }

    public FTVariableListTable getTable() {
        return this._table;
    }

    protected FTVariableListModel createModel() {
        List<PrefFieldBoolean> finalPrefs;
        FTVariableListModel modelTable = new FTVariableListModel(this._frame);
        PluginWithOptions prefs = this.getAppl().getPreferencies().getOptions(FTVariableListDisplayPreferencies.PREF_KEY);
        if (prefs == null || !(prefs instanceof FTVariableListDisplayPreferencies)) {
            prefs = new FTVariableListDisplayPreferencies();
            this.getAppl().getPreferencies().addOptions(prefs);
            prefs.refreshOptions(this.getAppl().getPlugable());
        }
        List<PrefFieldBoolean> listPrefs = ((PrefFieldsCategory)prefs).getBooleanFields();
        if (this._isBigTree) {
            int len = listPrefs.size();
            finalPrefs = new ArrayList<PrefFieldBoolean>(len);
            block3: for (int i = 0; i < len; ++i) {
                PrefFieldBoolean field = listPrefs.get(i);
                switch (field.getIdxCode()) {
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 15: 
                    case 30: {
                        continue block3;
                    }
                    default: {
                        finalPrefs.add(field.getCopy());
                    }
                }
            }
        } else {
            finalPrefs = PrefFieldsFactory.clone(listPrefs);
        }
        modelTable.getColumnModel().setOptionnalFields(finalPrefs);
        return modelTable;
    }

    private void makePanel() {
        this._model = this.createModel();
        this._selecteur = new JComboBox();
        this._filtersDlg = new JButton(ResMsgVoc.getString("VOC_FILTER"));
        JButton fieldsDlg = new JButton(ResMsgVoc.getString("VOC_FIELDS"));
        JButton substitutionDlg = new JButton(ResMsgArbor.getString("MSG_SUBSTITUTION_TITLE"));
        this._ctrlForOneHour = new JCheckBox(this._ftEquation.getComputeParameters().getOneHourAction());
        this._ftEquation.getComputeParameters().getOneHourAction().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FTVariableListPanel.this._table.repaint();
            }
        });
        int idxX = 0;
        this._tousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FTVariableListTable.PublicListSelectionModel selectionModel = FTVariableListPanel.this._table.getSelectionModel();
                int nbrRow = FTVariableListPanel.this._table.getModel().getRowCount();
                if (nbrRow > 0) {
                    selectionModel.setSelectionInterval(0, nbrRow - 1);
                } else {
                    selectionModel.clearSelection();
                }
            }
        });
        this.add((Component)this._tousButton, new GridBagConstraints(idxX++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this._selecteur.addItem(FTVariableListModel.FilterELFactory.createItem(TypeFilter.ALL, this._ftEquation));
        this._selecteur.addItem(FTVariableListModel.FilterELFactory.createItem(TypeFilter.ROOTS, this._ftEquation));
        if (!this._isBigTree) {
            this._selecteur.addItem(FTVariableListModel.FilterELFactory.createItem(TypeFilter.GATES, this._ftEquation));
        }
        this._selecteur.addItem(FTVariableListModel.FilterELFactory.createItem(TypeFilter.LEAVES, this._ftEquation));
        if (!this._isBigTree) {
            this._selecteur.addItem(FTVariableListModel.FilterELFactory.createItem(TypeFilter.SUBTREE, this._ftEquation));
            this._selecteur.addItem(FTVariableListModel.FilterELFactory.createItem(TypeFilter.DSF, this._ftEquation));
        }
        this._selecteur.addItem(FTVariableListModel.FilterELFactory.createItem(TypeFilter.INSPECTED, this._ftEquation));
        this._selecteur.addItem(FTVariableListModel.FilterELFactory.createItem(TypeFilter.INFLYTESTED, this._ftEquation));
        this._selecteur.addItem(FTVariableListModel.FilterELFactory.createItem(TypeFilter.FILTERED, this._ftEquation));
        int idxSelect = PlugableUtility.getIntOpt(this.getAppl().getPlugable(), FTVariableListDisplayPreferencies.PREF_FILTER_SELECT, 0);
        if (this._isBigTree) {
            switch (idxSelect) {
                case 0: 
                case 1: {
                    break;
                }
                case 2: {
                    idxSelect = 0;
                    break;
                }
                case 3: {
                    --idxSelect;
                    break;
                }
                case 4: 
                case 5: {
                    idxSelect = 0;
                    break;
                }
                case 6: 
                case 7: {
                    idxSelect -= 3;
                }
            }
        }
        this._selecteur.setSelectedIndex(idxSelect);
        this._selecteur.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FTVariableListPanel.this.refreshFilterSelected();
                    }
                });
            }
        });
        this.add((Component)this._selecteur, new GridBagConstraints(idxX++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this._filtersDlg.setEnabled(false);
        this.add((Component)this._filtersDlg, new GridBagConstraints(idxX++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this._filtersDlg.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                Object selectedItem = FTVariableListPanel.this._selecteur.getSelectedItem();
                if (selectedItem == null) {
                    return;
                }
                if (!(selectedItem instanceof Filter)) {
                    return;
                }
                Filter filter = (Filter)selectedItem;
                if (!filter.withDialog()) {
                    return;
                }
                if (!filter.displayDialog(FTVariableListPanel.this._selecteur)) {
                    return;
                }
                FTVariableListPanel.this._bChangeFilterOfModel = true;
                try {
                    FTVariableListPanel.this._model.refresh(true, false);
                }
                finally {
                    FTVariableListPanel.this._bChangeFilterOfModel = false;
                }
                FTVariableListPanel.this.updateExternalSelection();
            }
        });
        JPanel panelQuantite = new JPanel(new GridBagLayout());
        this._labelQuantite = new JLabel(ResMsgVoc.getString("VOC_QUANTITY"));
        panelQuantite.add((Component)this._labelQuantite, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 2), 0, 0));
        this._quantite = new JLabel(ResMsgCore.msgFormat("MSG_X_ON_Y", "X", "Y"));
        panelQuantite.add((Component)this._quantite, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 2, 0, 0), 0, 0));
        this._model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                FTVariableListPanel.this._quantite.setText(ResMsgCore.msgFormat("MSG_X_ON_Y", FTVariableListPanel.this._model.getRowCount(), FTVariableListPanel.this._model.getFullRowCount()));
            }
        });
        this.add((Component)panelQuantite, new GridBagConstraints(idxX++, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 10), 0, 0));
        JLabel glue = new JLabel();
        this.add((Component)glue, new GridBagConstraints(idxX++, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._ctrlForOneHour, new GridBagConstraints(idxX++, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 10), 0, 0));
        glue = new JLabel();
        this.add((Component)glue, new GridBagConstraints(idxX++, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)fieldsDlg, new GridBagConstraints(idxX++, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(10, 10, 10, 10), 0, 0));
        fieldsDlg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<PrefFieldBoolean> originItems = FTVariableListPanel.this._model.getColumnModel().getOptionnalFields();
                List<PrefFieldBoolean> copyItems = PrefFieldsFactory.clone(originItems);
                if (!PrefFieldsFactory.displayDlgChangeFields(FTVariableListPanel.this._table, copyItems)) {
                    return;
                }
                boolean change = PrefFieldsFactory.copySelected(copyItems, originItems);
                if (change) {
                    FTVariableListPanel.this._model.getColumnModel().resetFilterIndexes();
                    FTVariableListPanel.this._model.refresh(false, true);
                }
            }
        });
        this.add((Component)substitutionDlg, new GridBagConstraints(idxX++, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(10, 10, 10, 10), 0, 0));
        substitutionDlg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<FTVariable> listVars = new ArrayList<FTVariable>();
                for (int i = 0; i < FTVariableListPanel.this._table.getRowCount(); ++i) {
                    FTVariableAbstract ftVar = FTVariableListPanel.this._model.getItem(i);
                    if (!(ftVar instanceof FTVariable)) continue;
                    listVars.add((FTVariable)ftVar);
                }
                if (listVars.isEmpty()) {
                    JOptionPane.showMessageDialog(FTVariableListPanel.this.getGUI(), ResMsgArbor.getString("MSG_SUBSTITUTION_ERROR_EMPTY_EVENTS"), ResMsgArbor.getString("MSG_SUBSTITUTION_TITLE"), 0);
                } else {
                    FTCmdVarSubstitution cmdSubstitution = new FTCmdVarSubstitution(FTVariableListPanel.this.getAppl(), FTVariableListPanel.this.getFrame(), listVars);
                    cmdSubstitution.realiseDo();
                }
            }
        });
        this.createActions();
        this.createPopupMenu();
        this._table = new FTVariableListTable(this._model, this.getAppl()){

            @Override
            protected void doubleClickLeft(MouseEvent e) {
                int idxColView;
                int idxColModel;
                int idxRowView = FTVariableListPanel.this._table.rowAtPoint(e.getPoint());
                int idxRowModel = FTVariableListPanel.this._table.convertRowIndexToModel(idxRowView);
                if (!this._model.isCellEditable(idxRowModel, idxColModel = FTVariableListPanel.this._table.convertColumnIndexToModel(idxColView = FTVariableListPanel.this._table.columnAtPoint(e.getPoint())))) {
                    FTVariableListPanel.this.doEdit();
                }
            }
        };
        this._table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (FTVariableListPanel.this._bChangeFilterOfModel) {
                    return;
                }
                if (e.getValueIsAdjusting()) {
                    return;
                }
                FTVariableListPanel.this.refreshActions();
                int min = e.getFirstIndex();
                int max = e.getLastIndex();
                ArrayList<FTVariableAbstract> selectChange = new ArrayList<FTVariableAbstract>();
                for (int i = min; i <= max; ++i) {
                    boolean selectTable = FTVariableListPanel.this._table.getSelectionModel().isSelectedIndex(i);
                    int idxRowModel = FTVariableListPanel.this._table.convertRowIndexToModel(i);
                    FTVariableAbstract ftVar = FTVariableListPanel.this._model.getItem(idxRowModel);
                    if (ftVar.isSelected() == selectTable) continue;
                    ftVar.setSelected(selectTable);
                    selectChange.add(ftVar);
                }
                if (!selectChange.isEmpty()) {
                    FTVariableAbstract last = (FTVariableAbstract)selectChange.remove(selectChange.size() - 1);
                    SelectionPackage.ChangeSelectionEvent<FTVariableAbstract> changeEvent = new SelectionPackage.ChangeSelectionEvent<FTVariableAbstract>(last, last.isSelected(), (Collection<FTVariableAbstract>)selectChange);
                    FTVariableListPanel.this._ftEquation.fireChangeSelection(changeEvent, FTVariableListPanel.this._table);
                }
            }
        });
        JScrollPane scrollTableItem = new JScrollPane(this._table);
        scrollTableItem.setComponentPopupMenu(this._popupMenu);
        scrollTableItem.setVerticalScrollBarPolicy(22);
        this.add((Component)scrollTableItem, new GridBagConstraints(0, 1, idxX, 1, 1.0, 1.0, 17, 1, new Insets(0, 10, 10, 10), 0, 0));
    }

    private void createActions() {
        this._actionEdit = new CeciliaAction(ResIcoCore.getImageIcon("BUT_EDIT"), ResMsgVoc.getString("VOC_EDIT"), ResMsgCore.getString("ACTION_EDIT_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FTVariableListPanel.this.doEdit();
            }
        };
        this._actionRename = new CeciliaAction(ResMsgVoc.getString("VOC_RENAME")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FTVariable ftVar = FTVariableListPanel.this.getSelectSingleInterneVariable();
                if (ftVar != null) {
                    FTCmdVarRename cmd = new FTCmdVarRename(FTVariableListPanel.this.getAppl(), FTVariableListPanel.this.getFrame(), ftVar, null, FTVariableListPanel.this._table);
                    cmd.realiseDo();
                }
            }
        };
        this._actionDelete = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Collection<FTVariable> initialVars = FTVariableListPanel.this.getSelectInterneVariables();
                if (!initialVars.isEmpty()) {
                    FTCmdDelete cmd = new FTCmdDelete(FTVariableListPanel.this.getAppl(), FTVariableListPanel.this.getFrame(), initialVars, FTVariableListPanel.this._table);
                    cmd.realiseDo();
                }
            }
        };
        this._actionCopy = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FTVariable ftVar = FTVariableListPanel.this.getSelectSingleInterneVariable();
                if (ftVar != null) {
                    List<FTVariable> vars = ftVar.extractVariables();
                    FTClipboardTransferable transferable = new FTClipboardTransferable(new FTClipboard(vars));
                    FTVariableListPanel.this.getAppl().getLocalClipboard(false).setContents(transferable, null);
                }
            }
        };
        this._actionConvertToEvent = new CeciliaAction(ResMsgArbor.getString("LBL_CONVERT_TO_EVENT")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FTVariable ftVar = FTVariableListPanel.this.getSelectSingleInterneVariable();
                if (ftVar != null) {
                    FTCmdVarEventEdit cmd = new FTCmdVarEventEdit(FTVariableListPanel.this.getAppl(), FTVariableListPanel.this.getFrame(), ftVar, FTVariableListPanel.this._table);
                    cmd.realiseDo();
                }
            }
        };
        this._actionConvertToGate = new CeciliaAction(ResMsgArbor.getString("LBL_CONVERT_TO_GATE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FTVariable ftVar = FTVariableListPanel.this.getSelectSingleInterneVariable();
                if (ftVar != null && (ftVar.getLink() != null || ftVar.getEvent() != null)) {
                    FTCmdVarGateEdit cmd = new FTCmdVarGateEdit(FTVariableListPanel.this.getAppl(), FTVariableListPanel.this.getFrame(), ftVar, FTVariableListPanel.this._table);
                    cmd.realiseDo();
                }
            }
        };
        this._actionConvertToLink = new CeciliaAction(ResMsgArbor.getString("LBL_CONVERT_TO_LINK")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FTVariable ftVar = FTVariableListPanel.this.getSelectSingleInterneVariable();
                if (ftVar != null && ftVar.getLink() == null) {
                    FTCmdVarLinkEdit cmd = new FTCmdVarLinkEdit(FTVariableListPanel.this.getAppl(), FTVariableListPanel.this.getFrame(), ftVar, FTVariableListPanel.this._table);
                    cmd.realiseDo();
                }
            }
        };
        this._actionNavDownOther = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FTVariableAbstract ftVar = FTVariableListPanel.this.getSelectSingleVariable();
                if (ftVar.equals(FTVariableListPanel.this._ftEquation.getTopEvent())) {
                    return;
                }
                if (ftVar.getLink() != null || ftVar.getDefinition() != null) {
                    FGContentFrame iframe = new FGContentFrame(FTVariableListPanel.this.getFrame(), ftVar);
                    iframe.showView(FTVariableListPanel.this.getAppl().getTopWindow().getDesktop());
                }
            }
        };
        this._pluginMCS = new FTPluginAction("com.dassault.cecilia.plugin.faulttree.compute.PluginCmdMCS", this.getFrame());
        this._pluginMEL = new FTPluginAction("com.dassault.cecilia.plugin.faulttree.compute.PluginCmdMEL", this.getFrame());
    }

    private void createPopupMenu() {
        this._popupMenu = new JPopupMenu();
        this._popupMenu.add(this.getAppl().getTopWindow().getAction("UNDO").createMenuItem());
        this._popupMenu.add(this.getAppl().getTopWindow().getAction("REDO").createMenuItem());
        this._popupMenu.addSeparator();
        if (!this._isBigTree) {
            this._popupMenu.add(this.getAppl().getTopWindow().getAction("OCAS_DOWN_OTHER").createMenuItem());
            this._popupMenu.addSeparator();
            this._popupMenu.add(this._actionRename);
        }
        this._popupMenu.add(this._actionEdit);
        if (!this._isBigTree) {
            this._popupMenu.add(this.getAppl().getTopWindow().getAction("DELETE").createMenuItem());
            this._popupMenu.addSeparator();
            this._popupMenu.add(this._actionConvertToEvent);
            this._popupMenu.add(this._actionConvertToGate);
            this._popupMenu.add(this._actionConvertToLink);
        }
        this._popupMenu.addSeparator();
        this._popupMenu.add(this._pluginMCS);
        this._popupMenu.add(this._pluginMEL);
    }

    protected Collection<FTVariable> getSelectInterneVariables() {
        LinkedHashSet<FTVariable> result = new LinkedHashSet<FTVariable>();
        int[] idxSel = this._table.getSelectedRows();
        for (int i = 0; i < idxSel.length; ++i) {
            int idxMod = this._table.convertRowIndexToModel(idxSel[i]);
            FTVariableAbstract ftVar = this._model.getItem(idxMod);
            if (ftVar == null || result.contains(ftVar) || !ftVar.isIntern() || ftVar.isLocked()) continue;
            result.add((FTVariable)ftVar);
        }
        return result;
    }

    protected FTVariableAbstract getSelectSingleVariable() {
        int nbrSel = this._table.getSelectedRowCount();
        if (nbrSel != 1) {
            return null;
        }
        int idxMod = this._table.convertRowIndexToModel(this._table.getSelectedRow());
        FTVariableAbstract ftVar = this._model.getItem(idxMod);
        if (ftVar == null) {
            return null;
        }
        return ftVar;
    }

    protected FTVariable getSelectSingleInterneVariable() {
        FTVariableAbstract ftVar = this.getSelectSingleVariable();
        if (ftVar == null) {
            return null;
        }
        if (!ftVar.isIntern()) {
            return null;
        }
        if (ftVar.isLocked()) {
            return null;
        }
        return (FTVariable)ftVar;
    }

    protected void refreshActions() {
        boolean canCompute;
        boolean enableEdit = false;
        boolean canDelete = true;
        int[] indices = this._table.getSelectedRows();
        FTVariableAbstract firstVar = null;
        int cptSelect = 0;
        if (indices.length > 0) {
            enableEdit = true;
            int cptEvents = 0;
            int cptGate = 0;
            int cptLink = 0;
            for (int i = 0; enableEdit && i < indices.length; ++i) {
                int idxMod = this._table.convertRowIndexToModel(indices[i]);
                FTVariableAbstract ftVar = this._model.getItem(idxMod);
                if (i == 0) {
                    firstVar = ftVar;
                }
                if (ftVar == null) continue;
                if (canDelete) {
                    boolean bl = canDelete = ftVar.isIntern() && !ftVar.isRoot();
                }
                if (!ftVar.isIntern() || ftVar.isLocked()) continue;
                ++cptSelect;
                if (ftVar.getEvent() != null) {
                    ++cptEvents;
                } else if (ftVar.getLink() != null) {
                    ++cptLink;
                } else if (ftVar.getDefinition() != null) {
                    ++cptGate;
                }
                if (cptGate > 1 || cptLink > 1) {
                    enableEdit = false;
                    continue;
                }
                if (cptEvents > 0 && (cptGate > 0 || cptLink > 0)) {
                    enableEdit = false;
                    continue;
                }
                if (cptGate <= 0 || cptLink <= 0) continue;
                enableEdit = false;
            }
        }
        this._actionEdit.setEnabled(cptSelect > 0 && enableEdit && (!this._isBigTree || !firstVar.isRoot()));
        this.getGUI().getDelegateAction("DELETE").setEnabled(this._actionDelete, !this._isBigTree && canDelete && cptSelect > 0);
        this.getGUI().getDelegateAction("OCAS_DOWN_OTHER").setEnabled(this._actionNavDownOther, !this._isBigTree && firstVar != null && indices.length == 1 && firstVar != this._ftEquation.getTopEvent() && (firstVar.getLink() != null || firstVar.getDefinition() != null));
        if (firstVar != null && cptSelect != 1) {
            firstVar = null;
        }
        this._actionRename.setEnabled(firstVar != null);
        this._actionConvertToGate.setEnabled(firstVar != null && (firstVar.getLink() != null || firstVar.getEvent() != null));
        this._actionConvertToLink.setEnabled(firstVar != null && !firstVar.isRoot() && firstVar.getLink() == null);
        this._actionConvertToEvent.setEnabled(firstVar != null && !firstVar.isRoot() && firstVar.getEvent() == null);
        boolean bl = canCompute = !this._ftEquation.getManuelInstanciate() && firstVar != null && firstVar.getDefinition() != null;
        if (this._isBigTree) {
            canCompute = firstVar != null && firstVar.isRoot();
        }
        this._pluginMCS.setEnabled(canCompute);
        this._pluginMEL.setEnabled(canCompute);
    }

    @Override
    public void toDoWhenActivated() {
        super.toDoWhenActivated();
        this.getGUI().setEnabledAction("PRINT", true);
        this.getGUI().setEnabledAction("PRINT_PREVIEW", true);
        this.getGUI().getDelegateAction("OCAS_DOWN_OTHER").addDelegate(this._actionNavDownOther);
        this.getGUI().getDelegateAction("DELETE").addDelegate(this._actionDelete);
        this.refreshActions();
    }

    @Override
    public void toDoWhenDeActivated() {
        this.getGUI().setEnabledAction("PRINT", false);
        this.getGUI().setEnabledAction("PRINT_PREVIEW", false);
        this.getGUI().getDelegateAction("OCAS_DOWN_OTHER").delDelegate(this._actionNavDownOther);
        this.getGUI().getDelegateAction("DELETE").delDelegate(this._actionDelete).setEnabled(false);
        super.toDoWhenDeActivated();
    }

    private void refreshFilterSelected() {
        Filter filter;
        Object selectedItem = this._selecteur.getSelectedItem();
        Filter filter2 = filter = selectedItem != null && selectedItem instanceof Filter ? (Filter)selectedItem : null;
        if (filter != null) {
            filter.selectFilter(this._selecteur);
        }
        this._filtersDlg.setEnabled(filter != null && filter.withDialog());
        this._bChangeFilterOfModel = true;
        try {
            this._model.setFilter(filter);
        }
        finally {
            this._bChangeFilterOfModel = false;
        }
        this.updateExternalSelection();
    }

    @Override
    public void doEdit() {
        int[] indices = this._table.getSelectedRows();
        if (indices.length == 0) {
            return;
        }
        StringBuilder names = new StringBuilder(64);
        boolean stopAppendName = false;
        FTVariableAbstract ftDef = null;
        FTVariableAbstract ftLink = null;
        ArrayList<FTVariable> selectEvents = new ArrayList<FTVariable>(indices.length);
        for (int i = 0; i < indices.length; ++i) {
            int idxMod = this._table.convertRowIndexToModel(indices[i]);
            FTVariableAbstract ftVar = this._model.getItem(idxMod);
            if (ftVar == null || !ftVar.isIntern() || ftVar.isLocked()) continue;
            if (!(ftVar instanceof FTVariable)) {
                _LOG.warning("Une variable interne n'est pas de la classe FTVariable: " + ftVar.getExportName());
                continue;
            }
            if (ftVar.getLink() != null) {
                if (ftLink != null) {
                    return;
                }
                ftLink = ftVar;
            } else if (ftVar.getEvent() != null) {
                if (!stopAppendName) {
                    if (names.length() > 0) {
                        names.append(", ");
                    }
                    if (names.length() > 48) {
                        names.append("...");
                        stopAppendName = true;
                    } else {
                        names.append(ftVar.getName());
                    }
                }
                selectEvents.add((FTVariable)ftVar);
            } else if (ftVar.getDefinition() != null) {
                if (ftDef != null) {
                    return;
                }
                ftDef = ftVar;
            }
            if (!(selectEvents.isEmpty() || ftLink == null && ftDef == null)) {
                return;
            }
            if (ftLink == null || ftDef == null) continue;
            return;
        }
        if (!this._isBigTree && selectEvents.size() == 1 && ((FTVariable)selectEvents.get(0)).isRoot()) {
            FTCmdVarGateEdit cmd = new FTCmdVarGateEdit(this.getAppl(), this.getFrame(), selectEvents.get(0), this);
            cmd.realiseDo();
        } else if (!selectEvents.isEmpty()) {
            FTCmdEventsEdit cmd = new FTCmdEventsEdit(this.getAppl(), this.getFrame(), names.toString(), selectEvents, this);
            cmd.realiseDo();
        } else if (!this._isBigTree && ftDef != null) {
            FTCmdVarGateEdit cmd = new FTCmdVarGateEdit(this.getAppl(), this.getFrame(), (FTVariable)ftDef, this);
            cmd.realiseDo();
        } else if (!this._isBigTree && ftLink != null) {
            FTCmdVarLinkEdit cmd = new FTCmdVarLinkEdit(this.getAppl(), this.getFrame(), (FTVariable)ftLink, this);
            cmd.realiseDo();
        }
    }

    protected void doRename() {
        if (this._isBigTree) {
            return;
        }
        int[] indices = this._table.getSelectedRows();
        if (indices.length != 1) {
            return;
        }
        int idxMod = this._table.convertRowIndexToModel(indices[0]);
        FTVariableAbstract ftVar = this._model.getItem(idxMod);
        if (ftVar != null && ftVar.isIntern() && !ftVar.isLocked()) {
            if (!(ftVar instanceof FTVariable)) {
                _LOG.warning("Une variable interne n'est pas de la classe FTVariable: " + ftVar.getExportName());
            } else {
                FTCmdVarRename cmd = new FTCmdVarRename(this.getAppl(), this.getFrame(), (FTVariable)ftVar, null, this);
                cmd.realiseDo();
            }
        }
    }

    protected void updateExternalSelection() {
        FTVariableListTable.PublicListSelectionModel selectModel = this._table.getSelectionModel();
        selectModel.setValueIsAdjusting(true);
        int min = -1;
        int max = -1;
        for (int i = 0; i < this._table.getRowCount(); ++i) {
            boolean selectTable = selectModel.isSelectedIndex(i);
            int idxRowModel = this._table.convertRowIndexToModel(i);
            FTVariableAbstract ftVar = this._model.getItem(idxRowModel);
            if (ftVar.isSelected() == selectTable) continue;
            if (min == -1) {
                min = i;
            }
            max = i;
            if (ftVar.isSelected()) {
                selectModel.addSelectionInterval(i, i);
                continue;
            }
            selectModel.removeSelectionInterval(i, i);
        }
        selectModel.setValueIsAdjusting(false);
        if (max != -1) {
            selectModel.fireValueChanged(min, max, false);
        }
    }

    @Override
    public void changeSelection(SelectionPackage.ChangeSelectionEvent<FTVariableAbstract> csevt) {
        if (csevt.getOwner() != this._table) {
            this.updateExternalSelection();
        }
        this._table.repaint();
    }

    public void changePreferencies(Preferencies prefs) {
        this._table.changePreferencies(prefs);
        this._table.repaint();
    }

    @Override
    public void changeEvents(Collection<? extends FTVariableAbstract> vars, Component source) {
        this._table.repaint();
    }

    @Override
    public void changeDefinitions(Collection<FTVariable> vars, Component source) {
        this._bChangeFilterOfModel = true;
        try {
            this._model.refresh(true, false);
        }
        finally {
            this._bChangeFilterOfModel = false;
        }
        this.updateExternalSelection();
    }

    @Override
    public IModel getModel(String key, File file) {
        if (key.equals("docbook.file") || key.equals("word.file")) {
            ExpBook book = this.prepareBook(this.getAppl().getPageFormat(), this.getAppl().getPreferencies());
            if (ExpBookUtility.realiseExport(book, file, this)) {
                return new IModel.DefaultModel(key, file, this._ftEquation.getTopEvent().getName(), this._ftEquation.getDBFolder().getID());
            }
            return null;
        }
        _LOG.fine("Call getModel with unknown key: " + key);
        return null;
    }

    protected ExpBook prepareBook(PageFormat format, Preferencies prefs) {
        ExpBook expBook = new ExpBook(this.getAppl().getDAOFactory());
        expBook.setPageFormat(format);
        expBook.setPreferencies(prefs);
        expBook.add(new ExpFTListVariables51(expBook, this._ftEquation));
        return expBook;
    }

    protected Pageable createPageable(final PageFormat format, final Preferencies pref) {
        PageableThread thread = new PageableThread(this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Pageable doCreatePageable() {
                ExpBook book = FTVariableListPanel.this.prepareBook(format, pref);
                try (SrbInputStream scribe = new SrbInputStream("");){
                    book.writeScribe(scribe);
                }
                ListProcessorJavaInteractive printable = new ListProcessorJavaInteractive(scribe);
                printable.processScribeFile();
                printable.computePageCount(format);
                return printable;
            }
        };
        thread.realiseDo();
        return thread.getPageable();
    }

    @Override
    public boolean print() {
        Pageable fgPageable = this.createPageable(this.getAppl().getPageFormat(), this.getAppl().getPreferencies());
        if (fgPageable == null) {
            return false;
        }
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPageable(fgPageable);
        if (job.printDialog()) {
            try {
                job.print();
            }
            catch (PrinterException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    @Override
    public boolean preview() {
        Pageable fgPageable = this.createPageable(this.getAppl().getPageFormat(), this.getAppl().getPreferencies());
        if (fgPageable == null) {
            return false;
        }
        PrintPreviewPrefsDlg dlg = new PrintPreviewPrefsDlg(JOptionCecilia.getWindowOf(this), fgPageable, this.getAppl(), new PrefFieldsCategory[]{(PrefFieldsCategory)this.getAppl().getPreferencies().getOptions(FTVariableListPrintPreferencies.PREF_KEY)}){

            @Override
            public void updatePreferencies() {
                this.setBook(FTVariableListPanel.this.createPageable(this.getFormat(), this.getPreferencies()));
            }
        };
        dlg.setLocationRelativeTo(JOptionCecilia.getWindowOf(this));
        dlg.setVisible(true);
        return true;
    }

    static /* synthetic */ Logger access$300() {
        return _LOG;
    }
}

