/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.gui.actions;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.FTVariable;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class DlgSubstitution
extends JDialogCecilia {
    private List<FTVariable> _currentFTVars;
    private FTEquation _ftEquation;
    private JComboBox<String> _nameCommCB;
    private JTextField _findJtf;
    private JTextField _replaceJtf;
    private JCheckBox _caseSentitiveCheck;
    private JCheckBox _regExprCheck;
    private Map<FTVariable, String> _mapFTVarsToNewValue;

    public DlgSubstitution(Window window) {
        super(window, ResMsgArbor.getString("MSG_SUBSTITUTION_TITLE"), true);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.createSubstitutionPanel(), "Center");
        this.getContentPane().add((Component)this.createButPanel(true), "South");
        this.setLocationRelativeTo(window);
        this.init();
        this.pack();
        this.setMinimumSize(this.getSize());
    }

    public DlgSubstitution configure(List<FTVariable> currentFTVars, FTEquation ftEquation) {
        this._currentFTVars = currentFTVars;
        this._ftEquation = ftEquation;
        if (this._ftEquation.isBigTree()) {
            this._nameCommCB.setSelectedIndex(1);
            this._nameCommCB.setEnabled(false);
        } else {
            this._nameCommCB.setEnabled(true);
        }
        return this;
    }

    private final JPanel createSubstitutionPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel fieldLbl = new JLabel(ResMsgVoc.getString("VOC_FIELD"));
        this._nameCommCB = new JComboBox<String>(new String[]{ResMsgArbor.getString("MSG_SUBSTITUTION_NAME_CB"), ResMsgArbor.getString("MSG_SUBSTITUTION_COMMENT_CB")});
        int idxY = 0;
        panel.add((Component)fieldLbl, new GridBagConstraints(0, idxY, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 15, 5, 5), 0, 0));
        panel.add(this._nameCommCB, new GridBagConstraints(1, idxY++, 1, 1, 100.0, 0.0, 17, 2, new Insets(15, 5, 5, 15), 0, 0));
        JLabel findLbl = new JLabel(ResMsgArbor.getString("MSG_SUBSTITUTION_REPLACE_LBL"));
        this._findJtf = new JTextField(10);
        panel.add((Component)findLbl, new GridBagConstraints(0, idxY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 5, 5), 0, 0));
        panel.add((Component)this._findJtf, new GridBagConstraints(1, idxY++, 1, 1, 100.0, 0.0, 17, 2, new Insets(5, 5, 5, 15), 0, 0));
        JLabel replaceLbl = new JLabel(ResMsgArbor.getString("MSG_SUBSTITUTION_BY_LBL"));
        this._replaceJtf = new JTextField(10);
        panel.add((Component)replaceLbl, new GridBagConstraints(0, idxY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 5, 5), 0, 0));
        panel.add((Component)this._replaceJtf, new GridBagConstraints(1, idxY++, 1, 1, 100.0, 0.0, 17, 2, new Insets(5, 5, 5, 15), 0, 0));
        this._caseSentitiveCheck = new JCheckBox(ResMsgArbor.getString("MSG_SUBSTITUTION_IGNORE_CASE_CB"));
        this._regExprCheck = new JCheckBox(ResMsgArbor.getString("MSG_SUBSTITUTION_REGUL_EXPR_CB"));
        panel.add((Component)this._caseSentitiveCheck, new GridBagConstraints(1, idxY++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this._regExprCheck, new GridBagConstraints(1, idxY++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        return panel;
    }

    private final boolean isCaseSensitive() {
        return this._caseSentitiveCheck.isSelected();
    }

    private final boolean isRegularExpression() {
        return this._regExprCheck.isSelected();
    }

    @Override
    protected boolean verifyParameters() {
        String replaceChaine = this._findJtf.getText();
        String byChaine = this._replaceJtf.getText();
        if (replaceChaine == null || replaceChaine.isEmpty()) {
            this._findJtf.requestFocus();
            JOptionPane.showMessageDialog(this.getOwner(), ResMsgArbor.getString("MSG_SUBSTITUTION_ERROR_EMPTY_REPLACE_FIELD"), ResMsgArbor.getString("MSG_SUBSTITUTION_TITLE"), 0);
            return false;
        }
        int illegalChar = DBFactory.verifyName(byChaine);
        if (illegalChar != 0 && !byChaine.isEmpty()) {
            this._replaceJtf.requestFocus();
            JOptionPane.showMessageDialog(this.getOwner(), ResMsgArbor.msgFormat("MSG_SUBSTITUTION_ERROR_ILLEGAL_CHARACTERS", Character.valueOf((char)illegalChar), byChaine), this.getTitle(), 0);
            return false;
        }
        for (FTVariableAbstract varAbstr : this._ftEquation.getAllVariables()) {
            try {
                varAbstr.getName().replaceAll(replaceChaine, byChaine);
            }
            catch (PatternSyntaxException err) {
                JOptionPane.showMessageDialog(this.getOwner(), ResMsgArbor.msgFormat("MSG_SUBSTITUTION_ERROR_REGEX_PATTERN", replaceChaine), this.getTitle(), 0);
                return false;
            }
            catch (IndexOutOfBoundsException err) {
                JOptionPane.showMessageDialog(this.getOwner(), ResMsgArbor.msgFormat("MSG_SUBSTITUTION_ERROR_REGEX_OUTOFBOUNDS", byChaine), this.getTitle(), 0);
                return false;
            }
        }
        boolean atLeastOneFTVar = false;
        Pattern pattern = null;
        if (this.isRegularExpression()) {
            pattern = Pattern.compile(replaceChaine, !this.isCaseSensitive() ? 2 : 0);
        }
        for (FTVariable ftVar : this._currentFTVars) {
            String varName;
            String string = varName = this.isSearchForNames() ? ftVar.getName() : ftVar.getLabel();
            if (this.isRegularExpression()) {
                Matcher matcher;
                String newName;
                if (!pattern.matcher(varName).find() || (newName = (matcher = pattern.matcher(varName)).replaceAll(byChaine)).equals(varName)) continue;
                atLeastOneFTVar = true;
                break;
            }
            if (!this.isCaseSensitive()) {
                if (!varName.toLowerCase().contains(replaceChaine.toLowerCase()) || varName.replaceAll("(?i)" + replaceChaine, byChaine).equals(varName)) continue;
                atLeastOneFTVar = true;
                break;
            }
            if (!varName.contains(replaceChaine) || varName.replace(replaceChaine, byChaine).equals(varName)) continue;
            atLeastOneFTVar = true;
            break;
        }
        if (!atLeastOneFTVar) {
            JOptionPane.showMessageDialog(this, ResMsgArbor.getString("MSG_SUBSTITUTION_ERROR_NO_VARS_FOUND"), ResMsgArbor.getString("MSG_SUBSTITUTION_TITLE"), 0);
            return false;
        }
        return true;
    }

    @Override
    protected void validDialog() {
        if (!this.verifyParameters()) {
            return;
        }
        TableModel tableModel = this.createTableModel();
        DlgVisualisation visualisationDlg = new DlgVisualisation(this.getOwner(), tableModel);
        visualisationDlg.setVisible(true);
        if (!visualisationDlg.getResult()) {
            return;
        }
        this._mapFTVarsToNewValue = visualisationDlg.getMapSelectedFTVarsToNewName();
        this._result = true;
        this.setVisible(false);
    }

    public final Map<FTVariable, String> getMapFTVarsToNewValue() {
        assert (this._mapFTVarsToNewValue != null);
        return this._mapFTVarsToNewValue;
    }

    public final boolean isSearchForNames() {
        return this._nameCommCB.getSelectedIndex() == 0;
    }

    private final TableModel createTableModel() {
        String replaceStr = this._findJtf.getText();
        String byStr = this._replaceJtf.getText();
        ArrayList<Object[]> listArrays = new ArrayList<Object[]>();
        DefaultTableModel result = null;
        Pattern pattern = null;
        if (this.isRegularExpression()) {
            pattern = Pattern.compile(replaceStr, !this.isCaseSensitive() ? 2 : 0);
        }
        for (FTVariable var : this._currentFTVars) {
            String varName;
            String string = varName = this.isSearchForNames() ? var.getName() : var.getLabel();
            if (this.isRegularExpression()) {
                Matcher matcher = pattern.matcher(varName);
                String newName = matcher.replaceAll(byStr);
                if (newName.equals(varName)) continue;
                if (this.isSearchForNames()) {
                    listArrays.add(new Object[]{var, newName});
                    continue;
                }
                listArrays.add(new Object[]{var, var.getLabel(), newName});
                continue;
            }
            String newName = varName.replaceAll((this.isCaseSensitive() ? "" : "(?i)") + replaceStr, byStr);
            if (newName.equals(varName)) continue;
            if (this.isSearchForNames()) {
                listArrays.add(new Object[]{var, newName});
                continue;
            }
            listArrays.add(new Object[]{var, var.getLabel(), newName});
        }
        Object[][] data = new Object[listArrays.size()][];
        for (int i = 0; i < listArrays.size(); ++i) {
            data[i] = (Object[])listArrays.get(i);
        }
        result = this.isSearchForNames() ? new DefaultTableModel(data, new Object[]{ResMsgArbor.getString("MSG_SUBSTITUTION_EVENT_NAME_HEADER"), ResMsgArbor.getString("MSG_SUBSTITUTION_NEW_EVENT_NAME_HEADER")}) : new DefaultTableModel(data, new Object[]{ResMsgArbor.getString("MSG_SUBSTITUTION_EVENT_NAME_HEADER"), ResMsgArbor.getString("MSG_SUBSTITUTION_OLD_COMMENT_HEADER"), ResMsgArbor.getString("MSG_SUBSTITUTION_NEW_COMMENT_HEADER")});
        return result;
    }

    private class DlgVisualisation
    extends JDialogCecilia {
        private final List<String> _unallowedName;
        private final Map<String, String> _oldNameToNewName;
        private static final int IDX_COLUMN_NAME_EVENT = 0;
        private static final int IDX_COLUMN_NEW_NAME_EVENT = 1;
        private static final int IDX_COLUMN_OLD_COMM = 1;
        private static final int IDX_COLUMN_NEW_COMM = 2;
        private JTable _table;

        public DlgVisualisation(Window owner, TableModel model) {
            super(owner, ResMsgArbor.getString("MSG_SUBSTITUTION_VISUA_TITLE"), true);
            if (DlgSubstitution.this.isSearchForNames()) {
                this._unallowedName = this.createUnallowedList();
                this._oldNameToNewName = this.createMapOldNameToNewName(model);
            } else {
                this._unallowedName = null;
                this._oldNameToNewName = null;
            }
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.createVisualisationPanel(model), "Center");
            this.getContentPane().add((Component)this.createButPanel(true), "South");
            this.setLocationRelativeTo(owner);
            this.init();
            this.pack();
            this.setMinimumSize(this.getSize());
            this.resizeTable();
            this._ctrlOK.requestFocus();
        }

        private final JPanel createVisualisationPanel(TableModel model) {
            JPanel panel = new JPanel(new GridBagLayout());
            this._table = new JTable(model);
            this._table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table2, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    String newName;
                    JLabel label = (JLabel)super.getTableCellRendererComponent(table2, value, isSelected, hasFocus, row, column);
                    FTVariableAbstract ftVar = (FTVariableAbstract)table2.getValueAt(row, 0);
                    if (column == 0) {
                        label.setText(ftVar.getName());
                    }
                    if (DlgSubstitution.this.isSearchForNames() && (DlgVisualisation.this.isConflicting(newName = (String)table2.getValueAt(row, 1)) || DlgVisualisation.this.sameValuesTwice(row))) {
                        Font font = label.getFont();
                        label.setFont(new Font(font.getFamily(), 1, font.getSize()));
                    }
                    return label;
                }
            });
            this._table.setPreferredScrollableViewportSize(new Dimension(500, 250));
            if (this._table.getRowCount() > 0) {
                this._table.setRowSelectionInterval(0, this._table.getRowCount() - 1);
                this._table.setColumnSelectionInterval(0, this._table.getColumnCount() - 1);
            }
            JScrollPane scrollPane = new JScrollPane(this._table);
            panel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 100.0, 100.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
            return panel;
        }

        public final Map<FTVariable, String> getMapSelectedFTVarsToNewName() {
            int[] selectedRows = this._table.getSelectedRows();
            LinkedHashMap<FTVariable, String> mapFTVarsToNewName = new LinkedHashMap<FTVariable, String>();
            int idxColumn = DlgSubstitution.this.isSearchForNames() ? 1 : 2;
            for (int selectedRowIdx : selectedRows) {
                FTVariable ftVar = (FTVariable)this._table.getValueAt(selectedRowIdx, 0);
                String newName = (String)this._table.getValueAt(selectedRowIdx, idxColumn);
                mapFTVarsToNewName.put(ftVar, newName);
            }
            return mapFTVarsToNewName;
        }

        private void resizeTable() {
            if (this._table.getColumnCount() != 3) {
                return;
            }
            int tableWidth = this._table.getWidth();
            this._table.getColumnModel().getColumn(0).setPreferredWidth(tableWidth / 4);
            this._table.getColumnModel().getColumn(1).setPreferredWidth(tableWidth * 3 / 8);
            this._table.getColumnModel().getColumn(2).setPreferredWidth(tableWidth * 3 / 8);
        }

        private final boolean sameValuesTwice(int row) {
            String value = (String)this._table.getValueAt(row, 1);
            for (int i = 0; i < this._table.getRowCount(); ++i) {
                String valueAtI;
                if (i == row || !(valueAtI = (String)this._table.getValueAt(i, 1)).equals(value)) continue;
                return true;
            }
            return false;
        }

        private final boolean isConflicting(String newName) {
            String currentFtVar = this._oldNameToNewName.get(newName);
            if (currentFtVar != null) {
                return this.isConflicting(currentFtVar);
            }
            return this._unallowedName.contains(newName);
        }

        private final List<String> createUnallowedList() {
            ArrayList<String> unallowedList = new ArrayList<String>();
            for (FTVariableAbstract ftVar : DlgSubstitution.this._ftEquation.getAllVariables()) {
                unallowedList.add(ftVar.getName());
            }
            return unallowedList;
        }

        private Map<String, String> createMapOldNameToNewName(TableModel model) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (int i = 0; i < model.getRowCount(); ++i) {
                FTVariableAbstract ftVar = (FTVariableAbstract)model.getValueAt(i, 0);
                String newName = (String)model.getValueAt(i, 1);
                map.put(ftVar.getName(), newName);
            }
            return map;
        }

        @Override
        protected boolean verifyParameters() {
            int[] selectedRows = this._table.getSelectedRows();
            if (selectedRows.length == 0) {
                JOptionPane.showMessageDialog(this, ResMsgArbor.getString("MSG_SUBSTITUTION_ERROR_NO_SELECTED_ROWS"), ResMsgArbor.getString("MSG_SUBSTITUTION_TITLE"), 0);
                return false;
            }
            if (DlgSubstitution.this.isSearchForNames()) {
                for (int selectedRowIdx : selectedRows) {
                    FTVariableAbstract ftVar = (FTVariableAbstract)this._table.getValueAt(selectedRowIdx, 0);
                    String newName = (String)this._table.getValueAt(selectedRowIdx, 1);
                    if (!DlgSubstitution.this.isSearchForNames() || !this.isConflicting(newName) && !this.sameValuesTwice(selectedRowIdx)) continue;
                    JOptionPane.showMessageDialog(this, ResMsgArbor.msgFormat("MSG_SUBSTITUTION_ERROR_CONFLICT_SELECTED", ftVar.getName(), newName), ResMsgArbor.getString("MSG_SUBSTITUTION_TITLE"), 0);
                    return false;
                }
            }
            return true;
        }
    }
}

