/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.gui.actions;

import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.faulttree.ft.FTVariable;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTEquationFrame;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.actions.FTCmdWithExtract;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEquationAbstract;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.general.log.gui.DBLogsSimpleDlg;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Component;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class FTCmdSubTreeRestore
extends FTCmdWithExtract {
    private static Logger _LOG = Logger.getLogger(FTCmdSubTreeRestore.class.getPackage().getName());
    List<FTVariable> _appendVars;

    public FTCmdSubTreeRestore(CeciliaAppl appl, FTEquationFrame frame, FTVariable ftVar, Component source) {
        super(appl, frame, ftVar, source);
    }

    @Override
    protected boolean prepareDo() {
        if (this._ftVariable == null) {
            return false;
        }
        if (this._ftVariable.getLink() == null) {
            return false;
        }
        return !this._ftVariable.getLink().isDSF();
    }

    @Override
    protected void firstDo() {
        this.prepareUndo();
        FTEquationAbstract ftSubEquation = this._ftVariable.getLink().getSubTree().getCopy();
        String generic = this._ftVariable.getLink().getGeneric();
        this._appendVars = ftSubEquation.getInternalVariables();
        for (FTVariable ftVariable : this._appendVars) {
            if (ftVariable.getLink() != null && ftVariable.getDefinition() != null) {
                ftVariable.setDefinition(null);
            }
            ftVariable.setFlags(0);
        }
        FTVariable rootVar = null;
        Iterator<FTVariable> iterVar = this._appendVars.iterator();
        while (iterVar.hasNext()) {
            FTVariable curVar = iterVar.next();
            if (curVar.isRoot()) {
                rootVar = curVar;
                iterVar.remove();
                continue;
            }
            if (generic.isEmpty() || !curVar.isGeneric()) continue;
            curVar.setName(curVar.getName() + generic);
        }
        if (rootVar == null) {
            _LOG.warning("Sous-arbre sans variable root");
            return;
        }
        boolean result = false;
        DBLogs dbLogs = new DBLogs();
        DBLogs.DefaultManager logMng = new DBLogs.DefaultManager(this.getAppl().getDBUser().getLogin(), dbLogs);
        if (this._ftEquation.addVariables(this._appendVars, logMng) && !logMng.withLogs(DBLogs.DBLevel.WARNING)) {
            this._ftVariable.setEvent(null);
            this._ftVariable.setLink(null);
            this._ftEquation.changeDefinitionOf(this._ftVariable, rootVar.getDefinition());
            this.verifyInstanciate(true);
            this._ftEquation.defineLockedVariables();
            this.prepareRedo();
            result = true;
        }
        if (!result) {
            DBLogsSimpleDlg dlg = new DBLogsSimpleDlg(JOptionCecilia.getWindowOf(this.getSource()));
            dlg.setDBLogs(dbLogs);
            dlg.setVisible(true);
        }
        if (result) {
            this._ftEquation.setModified(true);
            this._ftEquation.clearResults();
            this.redoChangeDSFConfig();
            this._ftEquation.updateDependTimeUpdt(this.getAppl().getDAOFactory(), this._ftEquation.getWorkingRelations());
            this.getSource().refreshCtrlInstanciate();
            this._ftEquation.fireChangeDefinitions(Collections.singleton(this._ftVariable), this._source);
            this.getSource().refreshCtrlLogs();
            this.getSource().addHisto(this);
        } else {
            this.undo();
        }
    }
}

