/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.gui.actions;

import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.faulttree.config.FTConfig;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import java.util.ArrayList;
import java.util.List;

public class FTUtilCmdChangeDSFConfig {
    FTEquation _ftEqu;
    CECFactory _daoFactory;
    List<FTConfig> _originConfigs;

    public FTUtilCmdChangeDSFConfig(FTEquation ftEqu, CECFactory daoFactory) {
        this._ftEqu = ftEqu;
        this._daoFactory = daoFactory;
    }

    public boolean prepareDo() {
        List<FTConfig> originConfigs = this._ftEqu.getConfigs();
        int size = originConfigs.size();
        if (size == 0) {
            return false;
        }
        this._originConfigs = new ArrayList<FTConfig>(size);
        for (int i = 0; i < size; ++i) {
            FTConfig ftConfig = originConfigs.get(i);
            this._originConfigs.add(ftConfig.getCopy());
        }
        return true;
    }

    public void redo() {
        List<FTConfig> originConfigs = this._ftEqu.getConfigs();
        int size = originConfigs.size();
        for (int i = 0; i < size; ++i) {
            FTConfig ftConfig = originConfigs.get(i);
            ftConfig.validateConfig(this._ftEqu.getDBFolder(), this._ftEqu.getWorkingRelations(), this._daoFactory, false);
        }
    }

    public void undo() {
        int size = this._originConfigs.size();
        for (int i = 0; i < size; ++i) {
            FTConfig undoConfig = this._originConfigs.get(i);
            FTConfig ftConfig = this._ftEqu.getConfig(undoConfig.getName());
            if (ftConfig == null) continue;
            ftConfig.copy(undoConfig);
            ftConfig.validateConfig(this._ftEqu.getDBFolder(), this._ftEqu.getWorkingRelations(), this._daoFactory, false);
        }
    }
}

