/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.gui.filter;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.filter.FilterAbstract;

public abstract class FilterLaw<T>
extends FilterAbstract<T> {
    boolean _isSelect = false;
    Type _type = Type.EXP;
    Op _op = Op.GT;
    double _limit = 0.0;

    public FilterLaw() {
        super(ResMsgVoc.getString("VOC_LAW"));
    }

    public boolean isSelected() {
        return this._isSelect;
    }

    public void setSelected(boolean value) {
        this._isSelect = value;
    }

    public Type getType() {
        return this._type;
    }

    public void setType(Type value) {
        this._type = value;
    }

    public Op getOp() {
        return this._op;
    }

    public void setOp(Op value) {
        this._op = value;
    }

    public double getLimit() {
        return this._limit;
    }

    public void setLimit(double value) {
        this._limit = value;
    }

    public abstract double getValueOfLaw(T var1);

    @Override
    public boolean filter(T row) {
        if (!this._isSelect) {
            return true;
        }
        double value = this.getValueOfLaw(row);
        if (Double.isNaN(value)) {
            return false;
        }
        switch (this._op) {
            case GEq: {
                return value >= this._limit;
            }
            case GT: {
                return value > this._limit;
            }
            case LEq: {
                return value <= this._limit;
            }
            case LT: {
                return value < this._limit;
            }
        }
        return false;
    }

    public static enum Op {
        GT(">"),
        GEq(">="),
        LT("<"),
        LEq("<=");

        String _lbl;

        private Op(String lbl) {
            this._lbl = lbl;
        }

        public String toString() {
            return this._lbl;
        }
    }

    public static enum Type {
        CST(ResMsgObj.getString("LAW_CSTE")),
        EXP(ResMsgObj.getString("LAW_EXP"));

        String _label;

        private Type(String strLabel) {
            this._label = strLabel;
        }

        public String toString() {
            return this._label;
        }
    }
}

