/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.io.dagdef;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.FTVariable;
import com.dassault.cecilia.dbobj.faulttree.ft.io.dagdef.DefReader;
import com.dassault.cecilia.dbobj.faulttree.ft.io.dagdef.EquBoolBigStore;
import com.dassault.cecilia.dbobj.faulttree.ft.io.dagdef.EquBoolNode;
import com.dassault.cecilia.dbobj.faulttree.ft.io.dagdef.EquBoolStdStore;
import com.dassault.cecilia.dbobj.faulttree.ft.io.dagdef.EquBoolStore;
import com.dassault.cecilia.dbobj.faulttree.obj.FTDefinition;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEvent;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.TypeParam;
import com.dassault.cecilia.dbobj.general.law.io.LawParser;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.modellaw.DBModelLaw;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EquBoolConvert
extends DefReader {
    private static Logger _LOG = Logger.getLogger(EquBoolConvert.class.getPackage().getName());
    private static int FLAG_VAR_GENERATED = 1;
    private static int FLAG_VAR_ATDELETE = 2;
    private static int FLAG_NODE_TREATED = 1;
    boolean _bBigTree;
    FTEquation _equation;
    Map<EquBoolNode, FTVariable> _mapVariables;
    List<FTVariable> _lstVariables;
    boolean _bProcessLeaves;
    String _criticity = null;
    String _initialConf = null;
    String _userGeneration = null;
    String _modelRefPath = null;
    String _dateGeneration = null;
    String _target = null;
    private long _autoGenName = 0L;
    private static final int sep1 = 47;
    private static final int sep2 = 91;
    private static final int sep3 = 93;
    private static final Pattern __PATTERN_UNICODE = Pattern.compile("0x[0-9a-fA-F]{4}");

    public EquBoolConvert(CECFactory cecFactory, DBLogs.DBLogsManager logMng, boolean bigTree) {
        super(cecFactory, logMng);
        this._bBigTree = bigTree;
        this._equation = null;
        this._mapVariables = new IdentityHashMap<EquBoolNode, FTVariable>();
        this._lstVariables = new LinkedList<FTVariable>();
        this._bProcessLeaves = true;
    }

    @Override
    protected boolean treatBigTree() {
        return this._bBigTree;
    }

    public EquBoolConvert setProcessLeaves(boolean value) {
        this._bProcessLeaves = value;
        return this;
    }

    public synchronized FTEquation getEquation(DBFolder dbFolder) {
        if (this._equation == null) {
            this._equation = new FTEquation(dbFolder);
            this.prepareEquation(this._equation);
        }
        return this._equation;
    }

    public void prepareEquation(FTEquation ftEquation) {
        Iterator<FTVariable> iterVar = this._lstVariables.iterator();
        while (iterVar.hasNext()) {
            if (iterVar.next().getFlags() != FLAG_VAR_ATDELETE) continue;
            iterVar.remove();
        }
        ftEquation.setVariables(this._lstVariables, this._logMng, true);
    }

    @Override
    public Collection<FTVariable> getVariables() {
        Iterator<FTVariable> iterVar = this._lstVariables.iterator();
        while (iterVar.hasNext()) {
            if (iterVar.next().getFlags() != FLAG_VAR_ATDELETE) continue;
            iterVar.remove();
        }
        return this._lstVariables;
    }

    @Override
    protected FTVariable findVariable(String originName) {
        return (FTVariable)this._mapDictionary.get(originName);
    }

    @Override
    protected boolean isLeaf(FTVariable var) {
        return this._bBigTree ? !var.isRoot() : var.isLeaf();
    }

    public String getReadingCriticity() {
        return this._criticity;
    }

    public String getReadingInitialConf() {
        return this._initialConf;
    }

    public String getReadingDateGeneration() {
        return this._dateGeneration;
    }

    public String getReadingModelRefPath() {
        return this._modelRefPath;
    }

    public String getReadingUserGeneration() {
        return this._userGeneration;
    }

    public String getReadingTarget() {
        return this._target;
    }

    public boolean readDag(Reader dag) {
        EquBoolStore store = this._bBigTree ? new EquBoolBigStore() : new EquBoolStdStore();
        boolean result = store.loadStream(dag);
        for (String msg : store.getSyntaxError()) {
            this._logMng.addLog(DBLogs.DBLevel.WARNING, msg);
        }
        if (!result) {
            this._logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgArbor.getString("KEY_1208"));
        }
        if (!(result = store.verify())) {
            this._logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgArbor.getString("MSG_ERR_DAG_FT_VERIFY"));
        }
        if (this._bBigTree) {
            for (EquBoolNode equBoolNode : store.getVariables()) {
                if (equBoolNode.isRoot()) {
                    this.createVariable(equBoolNode);
                    continue;
                }
                if (!equBoolNode.isLeaf() || equBoolNode.getType() == EquBoolNode.Type.TRUE || equBoolNode.getType() == EquBoolNode.Type.FALSE) continue;
                this.createVariable(equBoolNode);
            }
        } else {
            for (EquBoolNode equBoolNode : store.getVariables()) {
                if (this.findVariable(equBoolNode.getName()) != null) continue;
                this.createVariable(equBoolNode);
            }
            for (EquBoolNode equBoolNode : store.getVariables()) {
                if (equBoolNode.isLeaf() || equBoolNode.getFlag() != 0) continue;
                this.processNode(equBoolNode, null);
            }
        }
        this._mapDictionary.clear();
        for (FTVariable fTVariable : this._lstVariables) {
            this._mapDictionary.put(fTVariable.getName(), fTVariable);
        }
        return !this._logMng.withLogs(DBLogs.DBLevel.WARNING);
    }

    private FTVariable processNode(EquBoolNode node, FTVariable ftVar) {
        if (node.getType() == EquBoolNode.Type.TRUE || node.getType() == EquBoolNode.Type.FALSE) {
            if (ftVar == null) {
                FTEvent ftEvent = new FTEvent();
                ftEvent.setState(node.getType() == EquBoolNode.Type.TRUE ? FTEvent.State.TRUE : FTEvent.State.FALSE);
                ftVar = this.getGeneratedVariable();
                ftVar.setEvent(ftEvent);
            } else {
                FTEvent ftEvent;
                if (ftVar.getDefinition() != null) {
                    this._logMng.addLog(DBLogs.DBLevel.INFO, ResMsgArbor.msgFormat("MSG_ERR_DAG_VAR_WITH_DEF", ftVar.getName()));
                }
                if ((ftEvent = ftVar.getEvent()) == null) {
                    ftEvent = new FTEvent();
                    ftVar.setEvent(ftEvent);
                }
                ftEvent.setState(node.getType() == EquBoolNode.Type.TRUE ? FTEvent.State.TRUE : FTEvent.State.FALSE);
            }
            return ftVar;
        }
        if (node.getFlag() == FLAG_NODE_TREATED) {
            return this._mapVariables.get(node);
        }
        node.setFlag(FLAG_NODE_TREATED);
        switch (node.getType()) {
            case VAR: {
                FTVariable var = this.findVariable(node.getName());
                switch (node.getChildren().size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        EquBoolNode arg = node.getChildren().get(0);
                        if (arg.getType() == EquBoolNode.Type.VAR) {
                            var.setDefinition(new FTDefinition(FTDefinition.Type.OR, this.findVariable(arg.getName())));
                            break;
                        }
                        this.processNode(node.getChildren().get(0), var);
                        break;
                    }
                    case 2: {
                        this._logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.msgFormat("MSG_INTERNAL_ERROR", node));
                    }
                }
                return var;
            }
            case AND: 
            case OR: 
            case IFF: 
            case XOR: 
            case KOfN: 
            case CARD: 
            case ITE: {
                FTVariable result = this.processDefinition(node, ftVar);
                if (result != null) {
                    this._mapVariables.put(node, result);
                }
                return result;
            }
            case NOT: {
                if (node.getChildren().size() == 1) {
                    FTVariable result = this.processNode(node.getChildren().get(0), null);
                    if (result != null && result.getFlags() == FLAG_VAR_GENERATED) {
                        boolean simplified = true;
                        switch (result.getType()) {
                            case AND: {
                                result.getDefinition().setType(FTDefinition.Type.NAND);
                                break;
                            }
                            case NAND: {
                                result.getDefinition().setType(FTDefinition.Type.AND);
                                break;
                            }
                            case OR: {
                                result.getDefinition().setType(FTDefinition.Type.NOR);
                                break;
                            }
                            case NOR: {
                                result.getDefinition().setType(FTDefinition.Type.OR);
                                break;
                            }
                            case NOT: {
                                FTVariable arg = (FTVariable)result.getDefinition().getArgs().iterator().next();
                                result.setFlags(FLAG_VAR_ATDELETE);
                                result = arg;
                                break;
                            }
                            default: {
                                simplified = false;
                            }
                        }
                        if (simplified) {
                            if (ftVar != null) {
                                if (result.getType() == FTDefinition.Type.VAR) {
                                    ftVar.setDefinition(new FTDefinition(FTDefinition.Type.OR, result));
                                } else {
                                    ftVar.setDefinition(result.getDefinition());
                                    result.setFlags(FLAG_VAR_ATDELETE);
                                }
                                return ftVar;
                            }
                            return result;
                        }
                    }
                    if (ftVar == null) {
                        ftVar = this.getGeneratedVariable();
                    }
                    ftVar.setDefinition(new FTDefinition(FTDefinition.Type.NOT, result));
                    return ftVar;
                }
                this._logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.msgFormat("MSG_INTERNAL_ERROR", node));
            }
        }
        this._logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgArbor.msgFormat("MSG_ERR_DAG_TYPE_DEF", node));
        return null;
    }

    private FTVariable processDefinition(EquBoolNode node, FTVariable parent) {
        FTDefinition.Type typeDef = null;
        switch (node.getType()) {
            case AND: {
                typeDef = FTDefinition.Type.AND;
                break;
            }
            case VAR: {
                typeDef = FTDefinition.Type.OR;
                break;
            }
            case OR: {
                typeDef = FTDefinition.Type.OR;
                break;
            }
            case IFF: {
                typeDef = FTDefinition.Type.NXOR;
                break;
            }
            case XOR: {
                typeDef = FTDefinition.Type.XOR;
                break;
            }
            case ITE: {
                typeDef = FTDefinition.Type.ITE;
                break;
            }
            case KOfN: {
                typeDef = FTDefinition.Type.KOFN;
                break;
            }
            case NOT: {
                typeDef = FTDefinition.Type.NOT;
                break;
            }
            case CARD: {
                int atMost = -1;
                try {
                    atMost = Integer.parseInt(node.getAttribute("#AtMost"));
                }
                catch (NumberFormatException e) {
                    _LOG.log(Level.WARNING, "AtMost is not integer", e);
                }
                if (atMost != node.getChildren().size()) break;
                typeDef = FTDefinition.Type.KOFN;
            }
        }
        if (typeDef == null) {
            this._logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgArbor.msgFormat("MSG_ERR_DAG_TYPE_DEF", node));
            return null;
        }
        List<? extends EquBoolNode> nodes = node.getChildren();
        ArrayList<FTVariable> args = new ArrayList<FTVariable>(nodes.size());
        for (int i = 0; i < nodes.size(); ++i) {
            FTVariable arg = this.processNode(nodes.get(i), null);
            if (arg == null) continue;
            args.add(arg);
        }
        int nbrArg = args.size();
        if (nbrArg < typeDef.getMinArg() || nbrArg > typeDef.getMaxArg()) {
            this._logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgArbor.msgFormat("MSG_ERR_DAG_NBRARG_DEF", node, nbrArg));
            return null;
        }
        FTDefinition ftDef = new FTDefinition(typeDef, args);
        if (typeDef == FTDefinition.Type.KOFN) {
            int atLeast = -1;
            try {
                atLeast = Integer.parseInt(node.getAttribute("#AtLeast"));
            }
            catch (NumberFormatException e) {
                _LOG.log(Level.WARNING, "AtLeast is not integer", e);
            }
            if (atLeast < 1) {
                _LOG.info("AtLeast is lesser than 1");
                atLeast = 1;
            } else if (atLeast > args.size()) {
                _LOG.info("AtLeast is greater than number of son");
                atLeast = args.size();
            }
            ftDef.setAtLeast(atLeast);
        }
        if (parent == null) {
            parent = this.getGeneratedVariable();
        }
        parent.setDefinition(ftDef);
        return parent;
    }

    private FTVariable getGeneratedVariable() {
        String name = this.getGeneratedName();
        FTVariable result = new FTVariable().setName(name);
        result.setFlags(FLAG_VAR_GENERATED);
        this._mapDictionary.put(name, result);
        this._lstVariables.add(result);
        return result;
    }

    private String getGeneratedName() {
        String name = null;
        while (this._autoGenName < Long.MAX_VALUE && this._mapDictionary.get(name = "AUTO_GEN_" + this._autoGenName++) != null) {
        }
        return name;
    }

    private FTVariable createVariable(EquBoolNode node) {
        String name = node.getName();
        if (name.startsWith("`") || name.startsWith("'")) {
            name = name.substring(1, name.length() - 1);
        }
        FTVariable result = new FTVariable().setName(name);
        if (this._bBigTree) {
            if (!result.getExportName().equals(node.getName())) {
                result.setExportName(node.getName());
            }
        } else {
            result.setExportName(null);
        }
        this._mapDictionary.put(node.getName(), result);
        this._mapVariables.put(node, result);
        this._lstVariables.add(result);
        if (node.isLeaf()) {
            FTEvent ftEvent = new FTEvent();
            if (this._bProcessLeaves) {
                this.processLeaf(node, ftEvent, result);
            }
            result.setEvent(ftEvent);
        }
        if (node.isRoot()) {
            result.setRoot(true);
            String criticity = this.getAttribute(node, "DassaultSpecialCriticity");
            if (this._criticity != null) {
                this._logMng.addLog(DBLogs.DBLevel.WARNING, "Multiple definition of criticity");
                return null;
            }
            this._criticity = criticity;
            String initialConf = this.getAttribute(node, "DassaultSpecialInitialConf");
            if (this._initialConf != null) {
                this._logMng.addLog(DBLogs.DBLevel.WARNING, "Multiple definition of initial conf");
                return null;
            }
            this._initialConf = initialConf;
            String modelRefPath = this.getAttribute(node, "DassaultSpecialModelRefPath");
            if (this._modelRefPath != null) {
                this._logMng.addLog(DBLogs.DBLevel.WARNING, "Multiple definition of model ref path");
                return null;
            }
            this._modelRefPath = modelRefPath;
            String userGeneration = this.getAttribute(node, "DassaultSpecialUserGeneration");
            if (this._userGeneration != null) {
                this._logMng.addLog(DBLogs.DBLevel.WARNING, "Multiple definition of user of generation");
                return null;
            }
            this._userGeneration = userGeneration;
            String dateGeneration = this.getAttribute(node, "DassaultSpecialDateGeneration");
            if (this._dateGeneration != null) {
                this._logMng.addLog(DBLogs.DBLevel.WARNING, "Multiple definition of date generation");
                return null;
            }
            this._dateGeneration = dateGeneration;
            String target = this.getAttribute(node, "DassaultSpecialTarget");
            if (this._target != null) {
                this._logMng.addLog(DBLogs.DBLevel.WARNING, "Multiple def of Target");
                return null;
            }
            this._target = target;
        }
        return result;
    }

    private String getAttribute(EquBoolNode node, String attr) {
        String value = node.getAttribute(attr);
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).isEmpty()) {
            return null;
        }
        if (value.indexOf(39) != -1) {
            if (!value.startsWith("'") || !value.endsWith("'") || value.length() <= 2) {
                this._logMng.addLog(DBLogs.DBLevel.WARNING, "Bad format for " + attr + " value: " + value);
                return null;
            }
            value = value.substring(1, value.length() - 1);
        }
        if (value.indexOf(39) != -1) {
            this._logMng.addLog(DBLogs.DBLevel.WARNING, "Bad format for " + attr + " value: " + value);
            return null;
        }
        return value;
    }

    private void processLeaf(EquBoolNode node, FTEvent ftEvent, FTVariable ftVar) {
        Map<String, String> attributes = node.getAttributes();
        if (attributes == null) {
            return;
        }
        ftEvent.clearProperties();
        for (String key : attributes.keySet()) {
            Param param;
            LawParser lawParser;
            String value;
            if (key.equals("#Law")) {
                value = attributes.get(key);
                if (value == null) continue;
                value = EquBoolConvert.convertSepFromUnicode(value);
                lawParser = this.createLawParser();
                Law law = lawParser.parseLaw(value);
                if (law != null) {
                    ftEvent.setOccurrence(law);
                    continue;
                }
                lawParser.traceError(this._logMng, ftVar.getName(), value, _LOG, true);
                continue;
            }
            if (key.equals("DassaultSpecialRemark")) {
                String label = attributes.get(key);
                ftVar.setLabel(this.decodeRemark(label));
                continue;
            }
            if (key.equals("DassaultSpecialCtrlPeriod")) {
                value = EquBoolConvert.convertSepFromUnicode(attributes.get(key));
                lawParser = this.createLawParser();
                param = lawParser.parseParam(value);
                if (param != null) {
                    param.setType(TypeParam.DELAY);
                    ftEvent.setInspected(param);
                    continue;
                }
                lawParser.traceError(this._logMng, ftVar.getName(), value, _LOG, false);
                continue;
            }
            if (key.equals("DassaultSpecialTestBeforeUse")) {
                value = EquBoolConvert.convertSepFromUnicode(attributes.get(key));
                lawParser = this.createLawParser();
                param = lawParser.parseParam(value);
                if (param != null) {
                    param.setType(TypeParam.DELAY);
                    ftEvent.setInflightTested(param);
                    continue;
                }
                lawParser.traceError(this._logMng, ftVar.getName(), value, _LOG, false);
                continue;
            }
            if (key.equals("DassaultSpecialLawModifier")) {
                value = attributes.get(key);
                if (value.startsWith("inspected(") && value.endsWith(")")) {
                    value = value.substring(10, value.length() - 1);
                    value = EquBoolConvert.convertSepFromUnicode(value);
                    lawParser = this.createLawParser();
                    param = lawParser.parseParam(value);
                    if (param != null) {
                        param.setType(TypeParam.DELAY);
                        ftEvent.setInspected(param);
                        continue;
                    }
                    lawParser.traceError(this._logMng, ftVar.getName(), value, _LOG, false);
                    continue;
                }
                if (value.startsWith("inflight(") && value.endsWith(")")) {
                    value = value.substring(9, value.length() - 1);
                    value = EquBoolConvert.convertSepFromUnicode(value);
                    lawParser = this.createLawParser();
                    param = lawParser.parseParam(value);
                    if (param != null) {
                        param.setType(TypeParam.DELAY);
                        ftEvent.setInflightTested(param);
                        continue;
                    }
                    lawParser.traceError(this._logMng, ftVar.getName(), value, _LOG, false);
                    continue;
                }
                if (value.isEmpty()) continue;
                this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_RAW_ATTRIB_UNCOMPATIBLE_WITH_EVT", "DassaultSpecialLawModifier = " + value, ftVar.getName()));
                continue;
            }
            if (key.equals("DassaultSpecialBTP")) {
                String path = attributes.get(key);
                if (path.isEmpty()) continue;
                DBFolder dbFolder = this._cecFactory.createFolderDAO().findFolder("LAW_MODELS", path);
                if (dbFolder == null) {
                    this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_RAW_EVENT_UNKNOWN", path, ftVar.getName()));
                    continue;
                }
                DBWrap dbWrap = this._cecFactory.findOrCreateWrap(dbFolder);
                if (dbWrap == null) {
                    this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_RAW_EVENT_READ", dbFolder.getRefPath(), ftVar.getName()));
                    continue;
                }
                ftEvent.setModelLaw((DBModelLaw)dbWrap);
                continue;
            }
            value = attributes.get(key);
            String path = key;
            path = key.startsWith("'") && key.endsWith("'") && key.length() > 2 ? key.substring(1, key.length() - 1) : EquBoolConvert.convertSepFromUnicode(key);
            DBFolder dbFolder = this._cecFactory.createFolderDAO().findFolder("ATTRIBUTES", path);
            if (dbFolder == null) {
                this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_RAW_ATTRIB_UNKNOWN_WITH_EVT", path, ftVar.getName()));
                continue;
            }
            DBWrap dbWrap = this._cecFactory.findOrCreateWrap(dbFolder);
            if (dbWrap == null) {
                this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_RAW_ATTRIB_READ", path, ftVar.getName()));
                continue;
            }
            DBAttrib.Value dbValue = ((DBAttrib)dbWrap).createInstance(value);
            if (dbValue == null) {
                String definition = new StringBuilder(128).append("'").append(path).append("' = ").append((Object)value).toString();
                this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_RAW_ATTRIB_UNCOMPATIBLE_WITH_EVT", definition, ftVar.getName()));
                continue;
            }
            ftEvent.addAttribute(dbValue);
        }
    }

    private String decodeRemark(String current) {
        int index = 0;
        StringBuilder remark = new StringBuilder(current.length());
        while (index != -1) {
            index = current.indexOf("\\");
            if (index == -1) {
                remark.append(current);
                continue;
            }
            if (index > current.length() - 2) {
                remark.append(current);
                continue;
            }
            char carSuivant = current.charAt(index + 1);
            remark.append(current.substring(0, index));
            if (carSuivant == 'n') {
                remark.append("\n");
            } else if (carSuivant == '\\') {
                remark.append("\\");
            } else {
                remark.append(carSuivant);
            }
            current = current.substring(index + 2);
        }
        return remark.toString();
    }

    public static String convertSepFromUnicode(String path) {
        Matcher match = __PATTERN_UNICODE.matcher(path);
        StringBuffer sb = new StringBuffer();
        int pos = 0;
        while (match.find(pos)) {
            String code;
            int sep;
            if (pos < match.start()) {
                sb.append(path.substring(pos, match.start()));
            }
            if ((sep = Integer.parseInt(code = path.substring(match.start() + 2, match.end()), 16)) == 47 || sep == 91 || sep == 93) {
                sb.append((char)sep);
            }
            pos = match.end();
        }
        sb.append(path.substring(pos));
        return sb.toString();
    }
}

