/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.obj;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.dsf.DSFEquation;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEquationAbstract;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import java.io.IOException;
import java.util.Set;

public class FTLink {
    String _strGeneric = "";
    FTEquationAbstract _ftSubTree = null;

    public String getGeneric() {
        return this._strGeneric;
    }

    public FTLink setGeneric(String value) {
        this._strGeneric = value;
        return this;
    }

    public boolean isDSF() {
        FTEquationAbstract subTree = this.getSubTree();
        return subTree != null && subTree instanceof DSFEquation;
    }

    public FTEquationAbstract getSubTree() {
        return this._ftSubTree;
    }

    public FTLink setSubTree(FTEquationAbstract value) {
        this._ftSubTree = value;
        return this;
    }

    public FTLink getCopy() {
        FTLink result = new FTLink();
        result._strGeneric = this._strGeneric;
        result._ftSubTree = this._ftSubTree;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof FTLink) {
            FTLink ftLink = (FTLink)obj;
            if (!this._strGeneric.equals(ftLink._strGeneric)) {
                return false;
            }
            return this.getSubTree().getDBFolder().equals(ftLink.getSubTree().getDBFolder());
        }
        return false;
    }

    public void toXML(Appendable out, String indent) throws IOException {
        out.append(indent).append("  <").append("ft.link");
        DBObjectXmlUtility.writeDBFolder(out, this._ftSubTree.getDBFolder(), null);
        if (!this._strGeneric.isEmpty()) {
            DBObjectXmlUtility.appendXML(out.append(" ").append("addIfGeneric").append("='"), this._strGeneric).append("'");
        }
        out.append("/>\n");
    }

    public void addRelation(DBFolder dbSrcFolder, String typeSrcRelation, Set<DBRelation> relations) {
        if (this._ftSubTree != null && this._ftSubTree.getDBFolder() != null) {
            relations.add(new DBRelation(dbSrcFolder, typeSrcRelation, this._ftSubTree.getDBFolder(), this.isDSF() ? "DSF_V" : "TREE_V"));
        }
    }

    public boolean isEquivalentTo(FTLink other, StringBuilder out) {
        if (!other.getSubTree().getDBFolder().equals(this.getSubTree().getDBFolder())) {
            out.append(ResMsgArbor.msgFormat("_MSG_EQUI_LINK", this.getSubTree().getRefPath(), other.getSubTree().getRefPath()));
            return false;
        }
        if (!this.getGeneric().equals(other.getGeneric())) {
            out.append(ResMsgArbor.msgFormat("_MSG_EQUI_GENERIC", this.getGeneric(), other.getGeneric()));
            return false;
        }
        return true;
    }

    public boolean update(CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        DBWrap dbWrap = DBWrap.createOrFind(cecFactory, this.getSubTree().getDBFolder(), logMng, FTEquationAbstract.class);
        if (dbWrap == null) {
            return false;
        }
        this.setSubTree((FTEquationAbstract)dbWrap);
        return true;
    }
}

