/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.obj.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.dependencies.Generate;
import com.dassault.cecilia.core.cecilia.dependencies.GenerateDepFolders;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.dsf.DSFEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.FTVariable;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTEquationPanelSelect;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEquationAbstract;
import com.dassault.cecilia.dbobj.faulttree.obj.FTLink;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class FTLinkDlgEdit
extends JDialogCecilia {
    CeciliaAppl _appl;
    private static FTLinkDlgEdit __dlg;
    JTextField _ctrlName;
    JTextArea _ctrlLabel;
    FTEquationPanelSelect _ctrlPanelSubTree;
    JTextField _ctrlGeneric;
    JLabel _lblGeneric;
    FTEquation _ftEquation;
    FTVariable _ftVariable;
    FTLink _ftLink;

    public static FTLinkDlgEdit getInstance(Window owner, CeciliaAppl appl) {
        if (__dlg == null) {
            __dlg = new FTLinkDlgEdit(owner, appl);
        }
        return __dlg;
    }

    private FTLinkDlgEdit(Window owner, CeciliaAppl appl) throws HeadlessException {
        super(owner, ResMsgArbor.getString("TITLE_EDIT_LINK"), true);
        this._appl = appl;
        this.make();
        this.fixSize(owner);
    }

    protected void fixSize(Window owner) {
        this.pack();
        this.setSize(720, 450);
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(owner));
    }

    private void make() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.createContentPanel(), "Center");
        this.getContentPane().add((Component)this.createButPanel(), "South");
        this.init();
    }

    protected Component createContentPanel() {
        JPanel content = new JPanel(new GridBagLayout());
        content.add(this.createFatherPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.6, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        content.add(this.createLinkPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 15, 2, new Insets(5, 5, 5, 5), 0, 0));
        content.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return content;
    }

    private Component createFatherPanel() {
        this._ctrlName = new JTextField(20);
        this._ctrlName.setEnabled(false);
        this._ctrlLabel = new JTextArea(5, 20);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(ResMsgVoc.getString("VOC_NAME")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._ctrlName, new GridBagConstraints(1, 0, 4, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        JScrollPane scrollLabel = new JScrollPane(this._ctrlLabel);
        panel.add((Component)new JLabel(ResMsgVoc.getString("VOC_DESCRIPTION")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)scrollLabel, new GridBagConstraints(1, 1, 4, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    protected Component createLinkPanel() {
        this._ctrlPanelSubTree = new FTEquationPanelSelect(this._appl, true){

            @Override
            protected void refreshWithEquation(FTEquationAbstract equation) {
                super.refreshWithEquation(equation);
                boolean isDSF = equation != null && equation instanceof DSFEquation;
                FTLinkDlgEdit.this._lblGeneric.setEnabled(!isDSF);
                FTLinkDlgEdit.this._ctrlGeneric.setEnabled(!isDSF);
            }
        };
        this._ctrlPanelSubTree.setFilterDSF(true).setFilterTree(true);
        this._lblGeneric = new JLabel(ResMsgArbor.getString("MSG_LBL_LINK_GENERIC"));
        this._ctrlGeneric = new JTextField(20);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this._ctrlPanelSubTree, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this._lblGeneric, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._ctrlGeneric, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResMsgArbor.getString("VOC_LINK_AT")));
        return panel;
    }

    public void setVariable(FTEquation ftEquation, FTVariable ftVar, FTLink ftLink) {
        this._ftEquation = ftEquation;
        this._ftVariable = ftVar;
        this._ftLink = ftLink;
        GenerateDepFolders depsFolder = new GenerateDepFolders(this._appl.getDAOFactory()){

            @Override
            protected boolean dontTreatThisFamily(DBFolder.Family family) {
                return family != DBFolder.Family.PROJECT;
            }
        };
        depsFolder.setDirection(Generate.Direction.UP);
        depsFolder.prepare(this._ftEquation.getDBFolder(), this._ftEquation.getDBFolder(), null);
        Set<DBFolder> dependFolders = depsFolder.getDepends(false);
        HashSet<DBFolder> excludeFolders = new HashSet<DBFolder>();
        for (DBFolder dependFolder : dependFolders) {
            if (dependFolder.isVersion()) {
                excludeFolders.add(dependFolder.getParent());
                List<DBFolder> children = dependFolder.getParent().getChildren();
                if (children == null) {
                    children = this._appl.getDAOFactory().createFolderDAO().findChildren(dependFolder.getParent());
                }
                for (DBFolder dbChild : children) {
                    excludeFolders.add(dbChild);
                }
                continue;
            }
            excludeFolders.add(dependFolder);
        }
        this._ctrlPanelSubTree.defineExcludeFolders(excludeFolders);
        this._ctrlName.setText(this._ftVariable.getName());
        this._ctrlName.setCaretPosition(0);
        this._ctrlLabel.setText(this._ftVariable.getLabel());
        this._ctrlLabel.setCaretPosition(0);
        if (this._ftLink != null) {
            this._ctrlPanelSubTree.setEquation(this._ftLink.getSubTree());
            this._ctrlGeneric.setText(this._ftLink.getGeneric());
        } else {
            this._ctrlPanelSubTree.setEquation(null);
            this._ctrlGeneric.setText("");
        }
    }

    @Override
    protected boolean verifyParameters() {
        String generic;
        FTEquationAbstract ftEquation = this._ctrlPanelSubTree.getEquation();
        if (ftEquation == null) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlPanelSubTree), ResMsgArbor.getString("MSG_ERR_DSF_NO_SUBTREE"), this.getTitle(), 0);
            this._ctrlPanelSubTree.requestFocus();
            return false;
        }
        if (!(ftEquation instanceof DSFEquation) && !(generic = this._ctrlGeneric.getText().trim()).isEmpty() && DBFactory.verifyName(generic) != 0) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlGeneric), ResMsgArbor.getString("MSG_ERR_LINK_GENERIC"), this.getTitle(), 0);
            this._ctrlGeneric.requestFocus();
            return false;
        }
        return true;
    }

    public String getLabel() {
        return this._ctrlLabel.getText();
    }

    public FTLink getFTLink() {
        FTEquationAbstract ftEquation = this._ctrlPanelSubTree.getEquation();
        if (ftEquation == null) {
            return null;
        }
        FTLink ftResult = new FTLink().setSubTree(ftEquation.getCopy());
        if (!(ftEquation instanceof DSFEquation)) {
            String generic = this._ctrlGeneric.getText().trim();
            if (!generic.isEmpty() && DBFactory.verifyName(generic) != 0) {
                return null;
            }
            ftResult.setGeneric(generic);
        }
        return ftResult;
    }
}

