/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.ihm.modeldefinition;

import com.dassault.cecilia.core.cecilia.CApplInit;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.fmea.ihm.dialog.DictionnaryManagerPanel;
import com.dassault.cecilia.dbobj.fmea.ihm.dialog.SortDlg;
import com.dassault.cecilia.dbobj.fmea.ihm.modeldefinition.AttributeDefinitionComboBoxModel;
import com.dassault.cecilia.dbobj.fmea.ihm.modeldefinition.EditDialog;
import com.dassault.cecilia.dbobj.fmea.ihm.modeldefinition.EntityDefinitionComboBoxModel;
import com.dassault.cecilia.dbobj.fmea.ihm.modeldefinition.FmeaModelDefinitionPanel;
import com.dassault.cecilia.dbobj.fmea.ihm.modeldefinition.Messages;
import com.dassault.cecilia.dbobj.fmea.model.DictionnaryManager;
import com.dassault.cecilia.dbobj.fmea.model.FmeaAttributeDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaColumnDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaEntityDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaTableDefinition;
import com.dassault.cecilia.dbobj.fmea.model.Formula;
import com.dassault.cecilia.dbobj.fmea.model.SortData;
import com.dassault.cecilia.dbobj.fmea.util.Util;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;

class FmeaTableDefinitionPanel
extends JPanel {
    private final FmeaModelDefinitionPanel _definitionPanel;
    private FmeaTableModel _tFmeaModel;
    private JTable _table;
    private JScrollPane _scpane;
    private JButton _bAdd = new JButton(Messages.getString("FmeaTableDefinitionPanel.0"));
    private JButton _bEdit = new JButton(Messages.getString("FmeaTableDefinitionPanel.17"));
    private JButton _bRemove = new JButton(Messages.getString("FmeaTableDefinitionPanel.1"));
    private JButton _bMoveUp = new JButton(Messages.getString("FmeaTableDefinitionPanel.2"));
    private JButton _bMoveDown = new JButton(Messages.getString("FmeaTableDefinitionPanel.3"));
    private JButton _bSort = new JButton(Messages.getString("FmeaTableDefinitionPanel.39"));
    private JButton _bDico = new JButton(Messages.getString("FmeaTableDefinitionPanel.41"));
    private JComboBox _combo1;
    private JComboBox _combo2;
    private boolean _enabled = true;

    FmeaTableDefinitionPanel(FmeaModelDefinitionPanel panel) {
        super(new GridBagLayout());
        this._definitionPanel = panel;
        this._tFmeaModel = new FmeaTableModel();
        this._table = new JTable(this._tFmeaModel){

            @Override
            public boolean isCellEditable(int row, int col) {
                return FmeaTableDefinitionPanel.this._enabled && super.isCellEditable(row, col);
            }

            @Override
            public Component prepareEditor(TableCellEditor editor, int row, int column) {
                if (column == 3) {
                    FmeaColumnDefinition def = (FmeaColumnDefinition)((FmeaTableDefinitionPanel)FmeaTableDefinitionPanel.this)._definitionPanel._fmeaData[row];
                    Object[] attributeData = def.getEntityDefinition() == null ? null : def.getEntityDefinition().getAttributeDefinitions();
                    ((AttributeDefinitionComboBoxModel)FmeaTableDefinitionPanel.this._combo2.getModel()).setAttributeData(attributeData);
                }
                return super.prepareEditor(editor, row, column);
            }
        };
        this._scpane = new JScrollPane(this._table);
        this._combo1 = new JComboBox(new EntityDefinitionComboBoxModel(this._definitionPanel));
        this._combo2 = new JComboBox(new AttributeDefinitionComboBoxModel());
        this._table.setPreferredScrollableViewportSize(new Dimension(700, 300));
        this._table.getTableHeader().setReorderingAllowed(false);
        JPanel bPanel = new JPanel(new GridBagLayout());
        bPanel.add((Component)this._bAdd, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        bPanel.add((Component)this._bEdit, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        bPanel.add((Component)this._bRemove, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        bPanel.add((Component)this._bMoveUp, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        bPanel.add((Component)this._bMoveDown, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        bPanel.add((Component)this._bSort, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        bPanel.add((Component)this._bDico, new GridBagConstraints(0, 6, 1, 1, 0.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this._scpane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)bPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this._table.getColumnModel().getColumn(0).setMaxWidth(30);
        this._table.getColumnModel().getColumn(0).setResizable(false);
        DefaultCellEditor cellEditor = new DefaultCellEditor(this._combo1);
        cellEditor.setClickCountToStart(2);
        this._table.getColumnModel().getColumn(2).setCellEditor(cellEditor);
        cellEditor = new DefaultCellEditor(this._combo2);
        cellEditor.setClickCountToStart(2);
        this._table.getColumnModel().getColumn(3).setCellEditor(cellEditor);
        this._bAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((FmeaTableDefinitionPanel)FmeaTableDefinitionPanel.this)._definitionPanel._entityData.length == 0) {
                    return;
                }
                FmeaColumnDefinition def = new FmeaColumnDefinition(null, null, null, null);
                final EditFmeaPanel editPanel = new EditFmeaPanel(def);
                Window window = SwingUtilities.getWindowAncestor(FmeaTableDefinitionPanel.this._definitionPanel);
                EditDialog dlg = null;
                dlg = window instanceof Frame ? new EditDialog((Frame)window, Messages.getString("FmeaTableDefinitionPanel.4"), true, editPanel, 3){

                    @Override
                    protected boolean closeEnabled() {
                        return editPanel.validateFields();
                    }
                } : new EditDialog((Dialog)window, Messages.getString("FmeaTableDefinitionPanel.4"), true, editPanel, 3){

                    @Override
                    protected boolean closeEnabled() {
                        return editPanel.validateFields();
                    }
                };
                dlg.setVisible(true);
                dlg.dispose();
                if (dlg.isCanceled()) {
                    return;
                }
                ((FmeaTableDefinitionPanel)FmeaTableDefinitionPanel.this)._definitionPanel._fmea.getModel().getTableDefinition().addColumnDefinition(def);
                ((FmeaTableDefinitionPanel)FmeaTableDefinitionPanel.this)._definitionPanel._fmeaData = ((FmeaTableDefinitionPanel)FmeaTableDefinitionPanel.this)._definitionPanel._fmea.getModel().getTableDefinition().getColumnDefinitions();
                FmeaTableDefinitionPanel.this._tFmeaModel.fireTableDataChanged();
            }
        });
        this._bEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = FmeaTableDefinitionPanel.this._table.getSelectedRow();
                if (row == -1) {
                    return;
                }
                FmeaColumnDefinition colDef = (FmeaColumnDefinition)((FmeaTableDefinitionPanel)FmeaTableDefinitionPanel.this)._definitionPanel._fmeaData[row];
                FmeaColumnDefinition copy = colDef.getCopy();
                final EditFmeaPanel editPanel = new EditFmeaPanel(copy);
                Window window = SwingUtilities.getWindowAncestor(FmeaTableDefinitionPanel.this._definitionPanel);
                EditDialog dlg = null;
                dlg = window instanceof Frame ? new EditDialog((Frame)window, Messages.getString("FmeaTableDefinitionPanel.4"), true, editPanel, 3){

                    @Override
                    protected boolean closeEnabled() {
                        return editPanel.validateFields();
                    }
                } : new EditDialog((Dialog)window, Messages.getString("FmeaTableDefinitionPanel.37"), true, editPanel, 3){

                    @Override
                    protected boolean closeEnabled() {
                        return editPanel.validateFields();
                    }
                };
                dlg.setVisible(true);
                dlg.dispose();
                if (dlg.isCanceled()) {
                    return;
                }
                colDef.copy(copy);
                FmeaTableDefinitionPanel.this._tFmeaModel.fireTableDataChanged();
            }
        });
        this._bRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FmeaTableDefinitionPanel.this._tFmeaModel.removeRows(FmeaTableDefinitionPanel.this._table.getSelectedRows());
            }
        });
        this._bMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FmeaTableDefinitionPanel.this._table.getSelectedRowCount() == 0 || FmeaTableDefinitionPanel.this._table.getSelectedRow() == 0) {
                    return;
                }
                int row = FmeaTableDefinitionPanel.this._table.getSelectedRow();
                ((FmeaTableDefinitionPanel)FmeaTableDefinitionPanel.this)._definitionPanel._fmea.getModel().getTableDefinition().changeColumnPosition(row, row - 1);
                ((FmeaTableDefinitionPanel)FmeaTableDefinitionPanel.this)._definitionPanel._fmeaData = ((FmeaTableDefinitionPanel)FmeaTableDefinitionPanel.this)._definitionPanel._fmea.getModel().getTableDefinition().getColumnDefinitions();
                FmeaTableDefinitionPanel.this._tFmeaModel.fireTableDataChanged();
                FmeaTableDefinitionPanel.this._table.setRowSelectionInterval(row - 1, row - 1);
            }
        });
        this._bMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FmeaTableDefinitionPanel.this._table.getSelectedRowCount() == 0 || FmeaTableDefinitionPanel.this._table.getSelectedRow() == FmeaTableDefinitionPanel.this._table.getRowCount() - 1) {
                    return;
                }
                int row = FmeaTableDefinitionPanel.this._table.getSelectedRow();
                ((FmeaTableDefinitionPanel)FmeaTableDefinitionPanel.this)._definitionPanel._fmea.getModel().getTableDefinition().changeColumnPosition(row, row + 1);
                ((FmeaTableDefinitionPanel)FmeaTableDefinitionPanel.this)._definitionPanel._fmeaData = ((FmeaTableDefinitionPanel)FmeaTableDefinitionPanel.this)._definitionPanel._fmea.getModel().getTableDefinition().getColumnDefinitions();
                FmeaTableDefinitionPanel.this._tFmeaModel.fireTableDataChanged();
                FmeaTableDefinitionPanel.this._table.setRowSelectionInterval(row + 1, row + 1);
            }
        });
        this._bSort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window window = SwingUtilities.getWindowAncestor(FmeaTableDefinitionPanel.this._definitionPanel);
                SortDlg dlg = null;
                if (window instanceof Frame) {
                    dlg = new SortDlg((Frame)window, Messages.getString("FmeaTableDefinitionPanel.40"));
                } else if (window instanceof Dialog) {
                    dlg = new SortDlg((Dialog)window, Messages.getString("FmeaTableDefinitionPanel.40"));
                }
                if (dlg == null) {
                    return;
                }
                Vector<FmeaColumnDefinition> columns = new Vector<FmeaColumnDefinition>();
                Vector<FmeaColumnDefinition> numericColumns = new Vector<FmeaColumnDefinition>();
                for (int i = 0; i < ((FmeaTableDefinitionPanel)FmeaTableDefinitionPanel.this)._definitionPanel._fmeaData.length; ++i) {
                    FmeaColumnDefinition colDef = (FmeaColumnDefinition)((FmeaTableDefinitionPanel)FmeaTableDefinitionPanel.this)._definitionPanel._fmeaData[i];
                    columns.add(colDef);
                    if (colDef.getColumnClass() != FmeaAttributeDefinition.Integer.class && colDef.getColumnClass() != FmeaAttributeDefinition.Double.class) continue;
                    numericColumns.add(colDef);
                }
                SortData sortData = ((FmeaTableDefinitionPanel)FmeaTableDefinitionPanel.this)._definitionPanel._fmea.getModel().getSortData() == null ? new SortData(false) : ((FmeaTableDefinitionPanel)FmeaTableDefinitionPanel.this)._definitionPanel._fmea.getModel().getSortData().copy();
                dlg.setData(columns, numericColumns, sortData);
                dlg.setVisible(true);
                dlg.dispose();
                if (dlg.canceled()) {
                    return;
                }
                ((FmeaTableDefinitionPanel)FmeaTableDefinitionPanel.this)._definitionPanel._fmea.getModel().setSortData(dlg.getData());
            }
        });
        this._bDico.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CApplInit appli = CApplInit.getInstance();
                DictionnaryManager dicoMgr = ((FmeaTableDefinitionPanel)FmeaTableDefinitionPanel.this)._definitionPanel._fmea.getModel().getDicoMgr();
                DictionnaryManagerPanel dicoMgrDlg = new DictionnaryManagerPanel(appli.getTopWindow(), Messages.getString("FmeaTableDefinitionPanel.42"));
                dicoMgrDlg.setDictionnaries(dicoMgr.getDictionnaries());
                dicoMgrDlg.setWriteAccess(true);
                dicoMgrDlg.setVisible(true);
                if (dicoMgrDlg.canceled()) {
                    return;
                }
                dicoMgr.setDictionnaries(dicoMgrDlg.getDictionnaries());
            }
        });
        this._table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FmeaTableDefinitionPanel.this.updateButtonStates();
            }
        });
    }

    void updateButtonStates() {
        this._bAdd.setEnabled(this._enabled && this._definitionPanel._entityData.length != 0);
        this._bEdit.setEnabled(this._enabled && this._table.getSelectedRowCount() == 1);
        this._bRemove.setEnabled(this._enabled && this._table.getSelectedRowCount() != 0);
        this._bMoveUp.setEnabled(this._enabled && this._table.getSelectedRowCount() == 1);
        this._bMoveDown.setEnabled(this._enabled && this._table.getSelectedRowCount() == 1);
        this._bSort.setEnabled(this._enabled && this._table.getRowCount() != 0);
        this._bDico.setEnabled(this._enabled);
    }

    public void updateContent() {
        this._tFmeaModel.fireTableDataChanged();
        this.updateButtonStates();
    }

    public void setPanelEnabled(boolean enabled) {
        this._enabled = enabled;
        this.updateButtonStates();
    }

    class EditFmeaPanel
    extends JPanel {
        private FmeaColumnDefinition columnDefinition;
        private JLabel label1;
        private JLabel label2;
        private JLabel label3;
        private JTextField field1;
        private JComboBox combo1;
        private JComboBox combo2;
        private JRadioButton rb1;
        private JRadioButton rb2;
        private JTextArea ta;
        private JButton bEdit;

        public EditFmeaPanel(FmeaColumnDefinition colDef) {
            super(new GridBagLayout());
            this.label1 = new JLabel(Messages.getString("FmeaTableDefinitionPanel.11"));
            this.label2 = new JLabel(Messages.getString("FmeaTableDefinitionPanel.12"));
            this.label3 = new JLabel(Messages.getString("FmeaTableDefinitionPanel.13"));
            this.field1 = new JTextField(20);
            this.combo1 = new JComboBox(new EntityDefinitionComboBoxModel(FmeaTableDefinitionPanel.this._definitionPanel));
            this.combo2 = new JComboBox(new AttributeDefinitionComboBoxModel());
            this.rb1 = new JRadioButton(Messages.getString("FmeaTableDefinitionPanel.18"));
            this.rb2 = new JRadioButton(Messages.getString("FmeaTableDefinitionPanel.19"));
            this.ta = new JTextArea();
            this.bEdit = new JButton(Messages.getString("FmeaTableDefinitionPanel.20"));
            this.columnDefinition = colDef;
            this.add((Component)this.label1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 20), 0, 0));
            this.add((Component)this.field1, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            JPanel p = new JPanel(new GridBagLayout());
            p.add((Component)this.rb1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            p.add((Component)new JSeparator(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            this.add((Component)p, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this.label2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 20), 0, 0));
            this.add((Component)this.label3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 20), 0, 0));
            this.add((Component)this.combo1, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this.combo2, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            p = new JPanel(new GridBagLayout());
            p.add((Component)this.rb2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            p.add((Component)new JSeparator(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            this.add((Component)p, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            JScrollPane scpane = new JScrollPane(this.ta);
            this.add((Component)scpane, new GridBagConstraints(0, 5, 2, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this.bEdit, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.ta.setOpaque(false);
            this.ta.setEditable(false);
            scpane.setPreferredSize(new Dimension(0, 50));
            ButtonGroup group = new ButtonGroup();
            group.add(this.rb1);
            group.add(this.rb2);
            this.rb1.setSelected(true);
            this.rb1.setFocusPainted(false);
            this.rb2.setFocusPainted(false);
            this.init(colDef);
            this.updateComponentStates();
            this.defineListeners();
        }

        protected void init(FmeaColumnDefinition colDef) {
            this.field1.setText(colDef.getName());
            this.ta.setText(colDef.getFormula() == null ? "" : colDef.getFormula().getText());
            if (colDef.isLinkedToAttribute()) {
                this.rb1.setSelected(true);
                this.combo1.setSelectedItem(colDef.getEntityDefinition());
                this.updateAttributeComboBox();
                this.combo2.setSelectedItem(colDef.getAttributeDefinition());
            } else if (colDef.getFormula() != null) {
                this.rb2.setSelected(true);
            }
            if (colDef.getEntityDefinition() == null) {
                this.updateAttributeComboBox();
            }
        }

        protected void defineListeners() {
            ItemListener itemListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    EditFmeaPanel.this.updateComponentStates();
                }
            };
            this.rb1.addItemListener(itemListener);
            this.rb2.addItemListener(itemListener);
            this.combo1.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    EditFmeaPanel.this.updateAttributeComboBox();
                }
            });
            this.bEdit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditFormula editor = new EditFormula(EditFmeaPanel.this.ta.getText());
                    if (!EditFmeaPanel.this.editFormula(editor)) {
                        return;
                    }
                    EditFmeaPanel.this.ta.setText(editor.getFormula());
                }
            });
        }

        protected void updateComponentStates() {
            if (this.rb1.isSelected()) {
                this.combo1.setEnabled(true);
                this.combo2.setEnabled(true);
                this.bEdit.setEnabled(false);
                this.ta.setEnabled(false);
                this.ta.setFocusable(false);
            } else if (this.rb2.isSelected()) {
                this.combo1.setEnabled(false);
                this.combo2.setEnabled(false);
                this.bEdit.setEnabled(true);
                this.ta.setEnabled(true);
                this.ta.setFocusable(true);
            }
        }

        protected void updateAttributeComboBox() {
            FmeaEntityDefinition entityDef = (FmeaEntityDefinition)this.combo1.getSelectedItem();
            if (entityDef != null) {
                ((AttributeDefinitionComboBoxModel)this.combo2.getModel()).setAttributeData(entityDef.getAttributeDefinitions());
            }
        }

        public boolean validateFields() {
            String name = this.field1.getText();
            if (name.length() == 0) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), Messages.getString("FmeaTableDefinitionPanel.14"), Messages.getString("ErrorManager.2"), 0);
                return false;
            }
            if (!name.equals(this.columnDefinition.getName())) {
                for (int i = 0; i < ((FmeaTableDefinitionPanel)FmeaTableDefinitionPanel.this)._definitionPanel._fmeaData.length; ++i) {
                    FmeaColumnDefinition colDef = (FmeaColumnDefinition)((FmeaTableDefinitionPanel)FmeaTableDefinitionPanel.this)._definitionPanel._fmeaData[i];
                    if (!name.equals(colDef.getName())) continue;
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), Messages.getString("FmeaTableDefinitionPanel.15"), Messages.getString("ErrorManager.2"), 0);
                    return false;
                }
            }
            if (this.rb2.isSelected() && this.ta.getText().length() == 0) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), Messages.getString("FmeaTableDefinitionPanel.38"), Messages.getString("ErrorManager.2"), 0);
                return false;
            }
            try {
                Formula formula = new Formula(this.ta.getText());
                this.columnDefinition.setFormula(formula);
            }
            catch (Formula.InvalidExpressionException e) {
                e.printStackTrace();
                return false;
            }
            this.columnDefinition.setName(name);
            if (this.rb1.isSelected()) {
                this.columnDefinition.setLinkToAttribute(true);
                this.columnDefinition.setEntityDefinition((FmeaEntityDefinition)this.combo1.getSelectedItem());
                this.columnDefinition.setAttributeDefinition((FmeaAttributeDefinition)this.combo2.getSelectedItem());
            } else if (this.rb2.isSelected()) {
                this.columnDefinition.setLinkToAttribute(false);
                this.columnDefinition.setEntityDefinition(null);
                this.columnDefinition.setAttributeDefinition(null);
            }
            return true;
        }

        public String getSelectedName() {
            return this.field1.getText();
        }

        public FmeaEntityDefinition getSelectedRelatedEntityDefinition() {
            return (FmeaEntityDefinition)this.combo1.getSelectedItem();
        }

        public FmeaAttributeDefinition getSelectedRelatedAttributeDefinition() {
            return (FmeaAttributeDefinition)this.combo2.getSelectedItem();
        }

        public boolean isLink() {
            return this.rb1.isSelected();
        }

        public boolean isFormula() {
            return this.rb2.isSelected();
        }

        public String getFormula() {
            return this.ta.getText();
        }

        public boolean editFormula(final EditFormula editor) {
            Window window = SwingUtilities.getWindowAncestor(FmeaTableDefinitionPanel.this._definitionPanel);
            EditDialog dlg = null;
            String title = Messages.getString("FmeaTableDefinitionPanel.21");
            dlg = window instanceof Frame ? new EditDialog((Frame)window, title, true, editor, 3){

                @Override
                protected boolean closeEnabled() {
                    return editor.isValidFormula();
                }
            } : new EditDialog((Dialog)window, title, true, editor, 3){

                @Override
                protected boolean closeEnabled() {
                    return editor.isValidFormula();
                }
            };
            dlg.pack();
            dlg.setVisible(true);
            dlg.dispose();
            return !dlg.isCanceled();
        }

        private class EditFormula
        extends JPanel {
            private JTextArea lab;
            private JTextArea ta1;
            private JLabel lab2;
            private JTextArea ta2;

            public EditFormula(String formula) {
                super(new GridBagLayout());
                this.lab = new JTextArea();
                this.ta1 = new JTextArea();
                this.lab2 = new JLabel(Messages.getString("FmeaTableDefinitionPanel.22"));
                this.ta2 = new JTextArea();
                String label = "";
                label = label + Messages.getString("FmeaTableDefinitionPanel.24");
                label = label + Messages.getString("FmeaTableDefinitionPanel.25");
                label = label + Messages.getString("FmeaTableDefinitionPanel.26");
                this.lab.setText(label);
                this.lab.setCaretPosition(0);
                this.lab.setLineWrap(true);
                this.lab.setWrapStyleWord(true);
                this.lab.setOpaque(false);
                this.lab.setFont(new JLabel().getFont());
                this.lab.setEditable(false);
                this.lab.setFocusable(false);
                this.add((Component)this.lab, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
                JScrollPane scpane = new JScrollPane(this.ta1);
                this.add((Component)scpane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
                this.add((Component)this.lab2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
                JScrollPane scpane2 = new JScrollPane(this.ta2);
                this.add((Component)scpane2, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
                this.ta1.setText(formula);
                this.ta1.setCaretPosition(0);
                scpane.setMinimumSize(new Dimension(200, 50));
                scpane.setPreferredSize(new Dimension(200, 50));
                int row = FmeaTableDefinitionPanel.this._table.getSelectedRow();
                FmeaColumnDefinition curColDef = null;
                if (row != -1) {
                    curColDef = (FmeaColumnDefinition)((FmeaTableDefinitionPanel)FmeaTableDefinitionPanel.this)._definitionPanel._fmeaData[row];
                }
                FmeaTableDefinition tableDef = ((FmeaTableDefinitionPanel)FmeaTableDefinitionPanel.this)._definitionPanel._fmea.getModel().getTableDefinition();
                String content = "";
                int count = 0;
                int i = 0;
                while (i < tableDef.getColumnCount()) {
                    FmeaColumnDefinition colDef = tableDef.getColumnDefinition(i);
                    if (colDef != curColDef && colDef.getColumnType() instanceof FmeaAttributeDefinition.Number) {
                        content = content + "$" + count + " = " + colDef.getName() + "\n";
                    }
                    ++i;
                    ++count;
                }
                this.ta2.setText(content);
                this.ta2.setCaretPosition(0);
                this.ta2.setOpaque(false);
                this.ta2.setEditable(false);
                this.ta2.setFont(new JLabel().getFont());
                scpane2.setBorder(null);
                scpane2.setMinimumSize(new Dimension(200, 60));
                scpane2.setPreferredSize(new Dimension(200, 60));
            }

            public String getFormula() {
                return this.ta1.getText();
            }

            public boolean isValidFormula() {
                try {
                    if (this.ta1.getText().length() == 0) {
                        return true;
                    }
                    Formula formula = new Formula(this.ta1.getText());
                    int row = FmeaTableDefinitionPanel.this._table.getSelectedRow();
                    FmeaColumnDefinition curColDef = null;
                    if (row != -1) {
                        curColDef = (FmeaColumnDefinition)((FmeaTableDefinitionPanel)FmeaTableDefinitionPanel.this)._definitionPanel._fmeaData[row];
                    }
                    FmeaTableDefinition tableDef = ((FmeaTableDefinitionPanel)FmeaTableDefinitionPanel.this)._definitionPanel._fmea.getModel().getTableDefinition();
                    int count = 0;
                    int i = 0;
                    while (i < tableDef.getColumnCount()) {
                        FmeaColumnDefinition colDef = tableDef.getColumnDefinition(i);
                        if (formula.containsOperand(count) && (colDef == curColDef || !(colDef.getColumnType() instanceof FmeaAttributeDefinition.Number))) {
                            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), Util.FormatString(Messages.getString("FmeaTableDefinitionPanel.36"), "$" + count), Messages.getString("ErrorManager.2"), 0);
                            return false;
                        }
                        ++i;
                        ++count;
                    }
                    return true;
                }
                catch (Formula.InvalidExpressionException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), e.getMessage(), Messages.getString("ErrorManager.2"), 0);
                    return false;
                }
            }
        }
    }

    private class FmeaTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{Messages.getString("FmeaTableDefinitionPanel.6"), Messages.getString("FmeaTableDefinitionPanel.7"), Messages.getString("FmeaTableDefinitionPanel.8"), Messages.getString("FmeaTableDefinitionPanel.9"), Messages.getString("FmeaTableDefinitionPanel.19")};

        private FmeaTableModel() {
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return ((FmeaTableDefinitionPanel)FmeaTableDefinitionPanel.this)._definitionPanel._fmeaData.length;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            FmeaColumnDefinition colDef;
            if (col == 0) {
                return false;
            }
            if (col == 1) {
                return true;
            }
            if ((col == 2 || col == 3) && (colDef = (FmeaColumnDefinition)((FmeaTableDefinitionPanel)FmeaTableDefinitionPanel.this)._definitionPanel._fmeaData[row]).getEntityDefinition() == null) {
                return false;
            }
            return col != 4;
        }

        public Class getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return Integer.class;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return String.class;
                }
            }
            return null;
        }

        @Override
        public Object getValueAt(int row, int col) {
            FmeaColumnDefinition def = (FmeaColumnDefinition)((FmeaTableDefinitionPanel)FmeaTableDefinitionPanel.this)._definitionPanel._fmeaData[row];
            switch (col) {
                case 0: {
                    return row;
                }
                case 1: {
                    return def.getName();
                }
                case 2: {
                    return def.getEntityDefinition();
                }
                case 3: {
                    return def.getAttributeDefinition();
                }
                case 4: {
                    return def.isLinkedToAttribute() ? null : def.getFormula().getText();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            FmeaColumnDefinition def = (FmeaColumnDefinition)((FmeaTableDefinitionPanel)FmeaTableDefinitionPanel.this)._definitionPanel._fmeaData[row];
            switch (col) {
                case 0: {
                    break;
                }
                case 1: {
                    if (value.equals(def.getName())) {
                        return;
                    }
                    if (value == null || value.toString().length() == 0) {
                        String msg = Messages.getString("FmeaTableDefinitionPanel.16");
                        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(FmeaTableDefinitionPanel.this), msg, Messages.getString("ErrorManager.2"), 0);
                        return;
                    }
                    if (((FmeaTableDefinitionPanel)FmeaTableDefinitionPanel.this)._definitionPanel._fmea.getModel().getTableDefinition().getColumnDefinitionWithName((String)value) == null) {
                        def.setName((String)value);
                        break;
                    }
                    String msg = Messages.getString("FmeaTableDefinitionPanel.10");
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(FmeaTableDefinitionPanel.this), msg, Messages.getString("ErrorManager.2"), 0);
                    break;
                }
                case 2: {
                    FmeaEntityDefinition entityDef = (FmeaEntityDefinition)value;
                    if (entityDef == def.getEntityDefinition()) break;
                    def.setEntityDefinition(entityDef);
                    def.setAttributeDefinition((FmeaAttributeDefinition)entityDef.getAttributeDefinitions()[0]);
                    super.fireTableCellUpdated(row, 3);
                    break;
                }
                case 3: {
                    def.setAttributeDefinition((FmeaAttributeDefinition)value);
                    break;
                }
            }
        }

        public void removeRows(int[] rows) {
            for (int i = rows.length - 1; i >= 0; --i) {
                FmeaColumnDefinition def = (FmeaColumnDefinition)((FmeaTableDefinitionPanel)FmeaTableDefinitionPanel.this)._definitionPanel._fmeaData[rows[i]];
                ((FmeaTableDefinitionPanel)FmeaTableDefinitionPanel.this)._definitionPanel._fmea.getModel().getTableDefinition().removeColumnDefinition(def);
                if (((FmeaTableDefinitionPanel)FmeaTableDefinitionPanel.this)._definitionPanel._fmea.getModel().getSortData() == null) continue;
                ((FmeaTableDefinitionPanel)FmeaTableDefinitionPanel.this)._definitionPanel._fmea.getModel().getSortData().removeColumn(def);
            }
            ((FmeaTableDefinitionPanel)FmeaTableDefinitionPanel.this)._definitionPanel._fmeaData = ((FmeaTableDefinitionPanel)FmeaTableDefinitionPanel.this)._definitionPanel._fmea.getModel().getTableDefinition().getColumnDefinitions();
            super.fireTableDataChanged();
        }
    }
}

