/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.model;

import com.dassault.cecilia.dbobj.fmea.Messages;
import com.dassault.cecilia.dbobj.fmea.model.FmeaObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Formula
extends FmeaObject {
    private static final int __code_operator = 0;
    private static final int __code_operand = 1;
    private static final int __code_digit = 2;
    private static final int __code_parenthesis = 3;
    private static final int __code_expression = 4;
    private static final Pattern PATTERN_COLUMN_NAME = Pattern.compile("\\$(0|([1-9][0-9]*))");
    private static final String Digits = "(\\p{Digit}+)";
    private static final String Exp = "[eE][+-]?(\\p{Digit}+)";
    private static final String fpRegex = "((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)[fFdD]?))";
    private static final Pattern PATTERN_FLOATING_POINT = Pattern.compile("((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)[fFdD]?))");
    private String _text = new String();
    private int _countOperands;
    private List<Operand> _operandNames = new ArrayList<Operand>();
    private Stack<Lexer.Token> _stack = new Stack();
    private Lexer _lexer = new Lexer();
    private int _countParenthesis = 0;

    public Formula(String text) throws InvalidExpressionException {
        if (text == null) {
            throw new IllegalArgumentException(Messages.getString("Formula.13"));
        }
        this._text = text;
        this.compile();
    }

    public String getText() {
        return this._text;
    }

    public int getCountOperands() {
        return this._countOperands;
    }

    public boolean containsOperand(int operand) {
        for (int i = 0; i < this._operandNames.size(); ++i) {
            Operand cur = this._operandNames.get(i);
            if (cur._value != operand) continue;
            return true;
        }
        return false;
    }

    public String getOperandName(int index) {
        return this._operandNames.get(index).toString();
    }

    public double apply(Map<String, Number> operands) {
        Stack<Lexer.Token> copy = new Stack<Lexer.Token>();
        copy.addAll(this._stack);
        return this.apply(operands, copy);
    }

    public boolean positionRemoved(int pos) {
        Collections.sort(this._operandNames, new Comparator<Operand>(){

            @Override
            public int compare(Operand o1, Operand o2) {
                return o1._value - o2._value;
            }
        });
        for (int i = 0; i < this._operandNames.size(); ++i) {
            int opPos;
            if (pos == (opPos = this._operandNames.get((int)i)._value--)) {
                return false;
            }
            if (pos > opPos) continue;
            this._text = this._text.replace("$" + opPos, "$" + (opPos - 1));
        }
        return true;
    }

    public void changePosition(int oldPos, int newPos) {
        if (oldPos == newPos) {
            return;
        }
        if (oldPos < newPos) {
            Collections.sort(this._operandNames, new Comparator<Operand>(){

                @Override
                public int compare(Operand o1, Operand o2) {
                    return o1._value - o2._value;
                }
            });
            this._text = this._text.replace("$" + oldPos, "$tmp");
            for (int i = 0; i < this._operandNames.size(); ++i) {
                if (oldPos == this._operandNames.get((int)i)._value) {
                    this._operandNames.get((int)i)._value = newPos;
                    continue;
                }
                if (oldPos >= this._operandNames.get((int)i)._value || this._operandNames.get((int)i)._value > newPos) continue;
                --this._operandNames.get((int)i)._value;
                String oldChar = "$" + (this._operandNames.get((int)i)._value + 1);
                String newChar = "$" + this._operandNames.get((int)i)._value;
                this._text = Formula.replace(this._text, oldChar, newChar);
            }
            this._text = this._text.replace("$tmp", "$" + newPos);
        } else {
            Collections.sort(this._operandNames, new Comparator<Operand>(){

                @Override
                public int compare(Operand o1, Operand o2) {
                    return o2._value - o1._value;
                }
            });
            this._text = this._text.replace("$" + oldPos, "$tmp");
            for (int i = 0; i < this._operandNames.size(); ++i) {
                if (oldPos == this._operandNames.get((int)i)._value) {
                    this._operandNames.get((int)i)._value = newPos;
                    continue;
                }
                if (newPos > this._operandNames.get((int)i)._value || this._operandNames.get((int)i)._value >= oldPos) continue;
                ++this._operandNames.get((int)i)._value;
                String oldChar = "$" + (this._operandNames.get((int)i)._value - 1);
                String newChar = "$" + this._operandNames.get((int)i)._value;
                this._text = Formula.replace(this._text, oldChar, newChar);
            }
            this._text = this._text.replace("$tmp", "$" + newPos);
        }
    }

    private double apply(Map<String, Number> operands, Stack<Lexer.Token> s) {
        if (s.isEmpty()) {
            return 0.0;
        }
        Lexer.Token token = s.pop();
        if (token._type == 1) {
            return operands.get(String.valueOf(token._operand._value)).doubleValue();
        }
        if (token._type == 2) {
            return Double.parseDouble(token._value);
        }
        if (token._type == 4) {
            Stack<Lexer.Token> copy = new Stack<Lexer.Token>();
            copy.addAll(token._privateStack);
            return this.apply(operands, copy);
        }
        if (token._value.equals("+")) {
            return this.apply(operands, s) + this.apply(operands, s);
        }
        if (token._value.equals("-")) {
            return this.apply(operands, s) - this.apply(operands, s);
        }
        if (token._value.equals("*")) {
            return this.apply(operands, s) * this.apply(operands, s);
        }
        if (token._value.equals("/")) {
            return this.apply(operands, s) / this.apply(operands, s);
        }
        return 0.0;
    }

    private void compile() throws InvalidExpressionException {
        this._lexer.parse(this._text);
        this.compile(this._text, this._stack);
    }

    private void compile(String text, Stack<Lexer.Token> s) throws InvalidExpressionException {
        Lexer.Token token = null;
        block9: while ((token = this._lexer.nextToken()) != null) {
            switch (token._type) {
                case 0: {
                    Lexer.Token expr;
                    Stack<Lexer.Token> s2;
                    if (this._lexer.previous != null && this._lexer.previous._value.equals("(")) {
                        throw this.buildInvalidExpressionException(Messages.getString("Formula.31"), this._lexer.pos - 1);
                    }
                    Lexer.Token next = this._lexer.nextToken();
                    if (next == null) {
                        throw this.buildInvalidExpressionException(Messages.getString("Formula.31"), this._lexer.pos - 1);
                    }
                    switch (next._type) {
                        case 1: 
                        case 2: {
                            s.push(next);
                            break;
                        }
                        case 3: {
                            if (next._value.equals("(")) {
                                ++this._countParenthesis;
                                s2 = new Stack();
                                this.compile(text, s2);
                                Lexer lexer = this._lexer;
                                lexer.getClass();
                                expr = lexer.new Lexer.Token(4, s2);
                                s.push(expr);
                                break;
                            }
                            throw this.buildInvalidExpressionException(Messages.getString("Formula.31"), this._lexer.pos - 1);
                        }
                        default: {
                            throw this.buildInvalidExpressionException(Messages.getString("Formula.31"), this._lexer.pos - 1);
                        }
                    }
                    s.push(token);
                    continue block9;
                }
                case 1: 
                case 2: {
                    s.push(token);
                    continue block9;
                }
                case 3: {
                    Lexer.Token expr;
                    Stack<Lexer.Token> s2;
                    if (token._value.equals("(")) {
                        ++this._countParenthesis;
                        s2 = new Stack<Lexer.Token>();
                        this.compile(text, s2);
                        Lexer lexer = this._lexer;
                        lexer.getClass();
                        expr = lexer.new Lexer.Token(4, s2);
                        s.push(expr);
                        continue block9;
                    }
                    if (!token._value.equals(")")) continue block9;
                    --this._countParenthesis;
                    if (this._lexer.previous != null && this._lexer.previous._value.equals("(") || this._countParenthesis < 0) {
                        throw this.buildInvalidExpressionException(Messages.getString("Formula.31"), this._lexer.pos - 1);
                    }
                    return;
                }
            }
            throw this.buildInvalidExpressionException(Messages.getString("Formula.31"), this._lexer.pos - 1);
        }
        if (this._countParenthesis > 0) {
            throw this.buildInvalidExpressionException(Messages.getString("Formula.31"), this._lexer.pos - 1);
        }
    }

    private InvalidExpressionException buildInvalidExpressionException(String msg, int pos) {
        return new InvalidExpressionException(msg + " (" + Messages.getString("Formula.12") + " = " + pos + ")\n" + this._text.substring(0, pos + 1));
    }

    private static String replace(String str, String oldChar, String newChar) {
        if (str == null) {
            return null;
        }
        char[] res = new char[str.length()];
        char[] s = str.toCharArray();
        char[] oldchar = oldChar.toCharArray();
        char[] newchar = newChar.toCharArray();
        for (int i = 0; i < s.length; ++i) {
            if (s[i] == oldchar[0]) {
                boolean b = true;
                int j = 1;
                int k = 1;
                while (k + i < s.length && j < oldchar.length) {
                    if (s[k + i] != oldchar[j]) {
                        b = false;
                        break;
                    }
                    ++j;
                    ++k;
                }
                if (b && k + i < s.length && '0' <= s[k + i] && s[k + i] <= '9') {
                    b = false;
                }
                if (b) {
                    for (j = 0; j < k; ++j) {
                        res[i + j] = newchar[j];
                    }
                } else {
                    for (j = 0; j <= k; ++j) {
                        res[i + j] = s[i + j];
                    }
                }
                i += k - 1;
                continue;
            }
            res[i] = s[i];
        }
        return new String(res);
    }

    public static void main(String[] args) {
        Formula formula = null;
        try {
            String text = "$0+$2";
            System.out.println(text);
            formula = new Formula(text);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        HashMap<String, Number> operands = new HashMap<String, Number>();
        operands.put("0", 7);
        operands.put("2", 3);
        operands.put("3", 3);
        double result = formula.apply(operands);
        System.out.println(formula.getText() + "=" + result);
        String text = "$1+$12";
        System.out.println(text);
        text = Formula.replace(text, "$1", "$3");
        System.out.println(text);
    }

    private class Operand {
        int _value;

        public Operand(int value) {
            this._value = value;
        }

        public String toString() {
            return String.valueOf(this._value);
        }
    }

    private class Lexer {
        String txt;
        int pos;
        Token tok = null;
        Token previous = null;

        public void parse(String text) {
            this.txt = text;
        }

        public Token nextToken() throws InvalidExpressionException {
            if (this.txt.length() == 0) {
                return null;
            }
            if (Character.isWhitespace(this.txt.charAt(0))) {
                this.txt = this.txt.substring(1);
                ++this.pos;
                return this.nextToken();
            }
            if (this.txt.startsWith("+")) {
                this.txt = this.txt.substring(1);
                ++this.pos;
                this.previous = this.tok;
                this.tok = new Token(0, "+");
                return this.tok;
            }
            if (this.txt.startsWith("-")) {
                this.txt = this.txt.substring(1);
                ++this.pos;
                this.previous = this.tok;
                this.tok = new Token(0, "-");
                return this.tok;
            }
            if (this.txt.startsWith("*")) {
                this.txt = this.txt.substring(1);
                ++this.pos;
                this.previous = this.tok;
                this.tok = new Token(0, "*");
                return this.tok;
            }
            if (this.txt.startsWith("/")) {
                this.txt = this.txt.substring(1);
                ++this.pos;
                this.previous = this.tok;
                this.tok = new Token(0, "/");
                return this.tok;
            }
            if (this.txt.startsWith("(")) {
                this.txt = this.txt.substring(1);
                ++this.pos;
                this.previous = this.tok;
                this.tok = new Token(3, "(");
                return this.tok;
            }
            if (this.txt.startsWith(")")) {
                this.txt = this.txt.substring(1);
                ++this.pos;
                this.previous = this.tok;
                this.tok = new Token(3, ")");
                return this.tok;
            }
            Matcher matcher = PATTERN_FLOATING_POINT.matcher(this.txt);
            if (matcher.lookingAt()) {
                String d = matcher.group(0);
                this.pos += d.length();
                this.txt = this.txt.substring(d.length(), this.txt.length());
                this.previous = this.tok;
                this.tok = new Token(2, d);
                return this.tok;
            }
            matcher = PATTERN_COLUMN_NAME.matcher(this.txt);
            if (matcher.lookingAt()) {
                String op = matcher.group(0);
                this.pos += op.length();
                this.txt = this.txt.substring(op.length(), this.txt.length());
                this.previous = this.tok;
                int opVal = Integer.parseInt(op.substring(1, op.length()));
                Operand ope = new Operand(opVal);
                this.tok = new Token(1, ope);
                Formula.this._countOperands++;
                Formula.this._operandNames.add(ope);
                return this.tok;
            }
            throw Formula.this.buildInvalidExpressionException(Messages.getString("Formula.56"), this.pos);
        }

        public class Token {
            public int _type;
            public String _value = "";
            public Operand _operand;
            public Stack _privateStack;

            private Token(int type, String value) {
                this._type = type;
                this._value = value;
            }

            private Token(int type, Operand operand) {
                this._type = type;
                this._operand = operand;
            }

            private Token(int type, Stack s) {
                this._type = type;
                this._privateStack = s;
            }

            public String toString() {
                return this._value.toString();
            }
        }
    }

    public class InvalidExpressionException
    extends Exception {
        public InvalidExpressionException(String msg) {
            super(msg);
        }
    }
}

