/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.event.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.general.event.Event;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.gui.LawPanel;
import com.dassault.cecilia.dbobj.modellaw.DBModelLaw;
import com.dassault.cecilia.dbobj.modellaw.gui.DBModelLawPanelSelect;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class EventLawPanel
extends JPanel {
    CeciliaAppl _appl;
    JRadioButton _ctrlSelectLaw;
    JRadioButton _ctrlSelectFrb;
    JRadioButton _ctrlSelectNone;
    JRadioButton _ctrlSelectNothing;
    LawPanel _ctrlPanelLaw;
    DBModelLawPanelSelect _ctrlPanelFrb;
    JPanel _ctrlDistribPanel;
    CardLayout _ctrlDistribLayout;

    public EventLawPanel(CeciliaAppl appl) {
        super(new GridBagLayout());
        this._appl = appl;
        this._ctrlSelectLaw = new JRadioButton(ResMsgVoc.getString("VOC_LAW"));
        this._ctrlSelectLaw.setHorizontalAlignment(0);
        this._ctrlSelectFrb = new JRadioButton(ResMsgVoc.getString("VOC_FRB"));
        this._ctrlSelectFrb.setHorizontalAlignment(0);
        this._ctrlSelectNone = new JRadioButton(ResMsgVoc.getString("VOC_NONE"));
        this._ctrlSelectNone.setHorizontalAlignment(0);
        this._ctrlSelectNothing = new JRadioButton(ResMsgVoc.getString("VOC_ALL"));
        ButtonGroup group = new ButtonGroup();
        group.add(this._ctrlSelectLaw);
        group.add(this._ctrlSelectFrb);
        group.add(this._ctrlSelectNone);
        group.add(this._ctrlSelectNothing);
        int nbrSelect = 0;
        this.add((Component)this._ctrlSelectLaw, new GridBagConstraints(nbrSelect++, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._ctrlSelectFrb, new GridBagConstraints(nbrSelect++, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._ctrlSelectNone, new GridBagConstraints(nbrSelect++, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._ctrlPanelLaw = new LawPanel(this._appl.getDAOFactory().getLawManager(), this._appl);
        this._ctrlPanelFrb = new DBModelLawPanelSelect(this._appl, false);
        this._ctrlDistribLayout = new CardLayout();
        this._ctrlDistribPanel = new JPanel(this._ctrlDistribLayout);
        this._ctrlDistribPanel.add((Component)this._ctrlPanelLaw, "VOC_LAW");
        this._ctrlDistribPanel.add((Component)this._ctrlPanelFrb, "VOC_FRB");
        this._ctrlDistribPanel.add((Component)new JPanel(), "VOC_NONE");
        this._ctrlDistribPanel.add((Component)new JPanel(), "VOC_ALL");
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventLawPanel.this.doChangeLayout();
            }
        };
        this._ctrlSelectLaw.addActionListener(action);
        this._ctrlSelectFrb.addActionListener(action);
        this._ctrlSelectNone.addActionListener(action);
        this._ctrlDistribPanel.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)this._ctrlDistribPanel, new GridBagConstraints(0, 1, nbrSelect, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void doChangeLayout() {
        String label = "VOC_ALL";
        if (this._ctrlSelectLaw.isSelected()) {
            label = "VOC_LAW";
        } else if (this._ctrlSelectFrb.isSelected()) {
            label = "VOC_FRB";
        } else if (this._ctrlSelectNone.isSelected()) {
            label = "VOC_NONE";
        }
        this._ctrlDistribLayout.show(this._ctrlDistribPanel, label);
    }

    @Override
    public void setVisible(boolean bVisible) {
        if (bVisible) {
            this._ctrlPanelLaw.setModified(false);
            this._ctrlPanelFrb.setModified(false);
        }
        super.setVisible(bVisible);
    }

    public void setLaw(int typeDistrib, Law valueLaw, DBModelLaw dbModelLaw) {
        switch (typeDistrib) {
            default: {
                this._ctrlSelectNothing.setSelected(true);
                this._ctrlPanelLaw.setLaw(null);
                this._ctrlPanelFrb.setModelLaw(null);
                break;
            }
            case 1: {
                this._ctrlSelectLaw.setSelected(true);
                this._ctrlPanelLaw.setLaw(valueLaw);
                this._ctrlPanelFrb.setModelLaw(null);
                break;
            }
            case 2: {
                this._ctrlSelectFrb.setSelected(true);
                this._ctrlPanelLaw.setLaw(null);
                this._ctrlPanelFrb.setModelLaw(dbModelLaw);
                break;
            }
            case 3: {
                this._ctrlSelectNone.setSelected(true);
                this._ctrlPanelLaw.setLaw(null);
                this._ctrlPanelFrb.setModelLaw(null);
            }
        }
        this.doChangeLayout();
    }

    public Law getLaw() {
        DBModelLaw dbModelLaw;
        if (this._ctrlSelectLaw.isSelected()) {
            return this._ctrlPanelLaw.getLaw();
        }
        if (this._ctrlSelectFrb.isSelected() && (dbModelLaw = this._ctrlPanelFrb.getModelLaw()) != null) {
            return dbModelLaw.getLaw();
        }
        return null;
    }

    public void affectEvent(Event next) {
        if (this._ctrlSelectLaw.isSelected()) {
            Law law = this._ctrlPanelLaw.getLaw();
            if (law != null) {
                next.setModelLaw(null);
                next.setOccurrence(law.getCopy());
            }
        } else if (this._ctrlSelectFrb.isSelected()) {
            DBModelLaw dbModelLaw = this._ctrlPanelFrb.getModelLaw();
            if (dbModelLaw != null) {
                next.setOccurrence(null);
                next.setModelLaw(dbModelLaw);
            }
        } else if (this._ctrlSelectNone.isSelected()) {
            next.setModelLaw(null);
            next.setOccurrence(null);
        }
    }

    public boolean verifyParameters(int typeDistrib, String title) {
        if (this._ctrlSelectLaw.isSelected()) {
            if (this._ctrlPanelLaw.isModified() || typeDistrib != 1) {
                if (!this._ctrlPanelLaw.validateParams(null)) {
                    return false;
                }
                if (this._ctrlPanelLaw.getLaw() == null) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlPanelLaw), ResMsgObj.getString("MSG_ERR_LAW_EMPTY"), title, 0);
                    this._ctrlPanelLaw.getFocusableComponent().requestFocus();
                    return false;
                }
            }
        } else if (this._ctrlSelectFrb.isSelected() && (this._ctrlPanelFrb.isModified() || typeDistrib != 2) && this._ctrlPanelFrb.getModelLaw() == null) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlPanelFrb), ResMsgCore.getString("MSG_ERR_BAD_FIELD"), title, 0);
            this._ctrlPanelFrb.getFocusableComponent().requestFocus();
            return false;
        }
        return true;
    }
}

