/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.event.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.dependencies.DependsListener;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.CTextFieldWithCallback;
import com.dassault.cecilia.dbobj.general.law.LawException;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.TypeParam;
import com.dassault.cecilia.dbobj.general.law.gui.ParamValueDlgEdit;
import com.dassault.cecilia.dbobj.general.law.io.LawParser;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ParamSimplePanel
extends JPanel {
    CeciliaAppl _appl;
    String _label;
    TypeParam _defaultType;
    double _defaultValue;
    LawParser _lawParser;
    Param _select;
    CTextFieldWithCallback _ctrlInput;
    private static ParamValueDlgEdit _instanceParamDlg = null;
    private static Object _instanceParamDlgLocker = new Object();
    boolean _bModified = false;
    List<DependsListener> _listeners = new ArrayList<DependsListener>();

    public ParamSimplePanel(String label, TypeParam defaultType, double defaultValue, CeciliaAppl appl) {
        super(new GridBagLayout());
        this._label = label;
        this._defaultType = defaultType;
        this._defaultValue = defaultValue;
        this._appl = appl;
        this._lawParser = new LawParser(this._appl.getDAOFactory().getLawManager(), this._appl.getDAOFactory());
        this.make();
    }

    public void setParam(Param param) {
        this._bModified = false;
        this._select = param;
        if (param != null) {
            this._ctrlInput.setText(param.toString());
        } else {
            this._ctrlInput.setText("");
        }
    }

    public Param getParam() {
        return this._select;
    }

    public JComponent getFocusableComponent() {
        return this._ctrlInput;
    }

    private void make() {
        this._ctrlInput = new CTextFieldWithCallback(20){

            @Override
            protected void notifyChange() {
                ParamSimplePanel.this.setModified(true);
            }
        };
        JButton butEdit = new JButton("...");
        JLabel lblUnit = new JLabel(this._defaultType.getSymbol());
        lblUnit.setToolTipText(this._defaultType.getSymbolToolTip());
        int posX = 0;
        this.add((Component)new JLabel(this._label), new GridBagConstraints(posX++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 5), 0, 0));
        this.add((Component)this._ctrlInput, new GridBagConstraints(posX++, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 2), 0, 0));
        this.add((Component)lblUnit, new GridBagConstraints(posX++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 5), 0, 0));
        this.add((Component)butEdit, new GridBagConstraints(posX, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        butEdit.addActionListener(e -> this.doClicAction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParamValueDlgEdit getParamDlg(Window owner, CeciliaAppl appl) {
        if (_instanceParamDlg == null) {
            Object object = _instanceParamDlgLocker;
            synchronized (object) {
                ParamValueDlgEdit dlg = new ParamValueDlgEdit(owner, appl, true, false, false);
                if (_instanceParamDlg == null) {
                    _instanceParamDlg = dlg;
                }
            }
        }
        return _instanceParamDlg;
    }

    protected void doClicAction() {
        ParamValueDlgEdit dlg = ParamSimplePanel.getParamDlg(SwingUtilities.getWindowAncestor(this._ctrlInput), this._appl);
        dlg.setTitle(ResMsgCore.msgFormat("TITLE_PARAM_VALUE_EDIT_FRM", this._label));
        dlg.setParamType(this._defaultType);
        Param select = this._select;
        dlg.setParam(select);
        dlg.setVisible(true);
        if (dlg.getResult()) {
            Param param = dlg.getParam();
            if (param == null) {
                return;
            }
            if (param.equals(select)) {
                return;
            }
            this.setParam(param);
            this.setModified(true);
            if (select != null && select.withDepends() || param.withDepends()) {
                this.fireChangeDepends();
            }
        }
    }

    public void setModified(boolean bModified) {
        this._bModified = bModified;
        if (this._bModified) {
            this._ctrlInput.setText(this._ctrlInput.getText());
        }
    }

    public boolean isModified() {
        return this._bModified || this._ctrlInput.isModified();
    }

    public boolean validateParams() {
        String strParam = this._ctrlInput.getText();
        this._lawParser.clearErrors();
        Param par = this._lawParser.parseParam(strParam);
        if (par != null && !this._lawParser.withError()) {
            if (par.getType() == null) {
                par.setType(this._defaultType);
            } else if (par.getType() != this._defaultType) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgCore.msgFormat("PAR_ERR_TYPE_FRM", this._defaultType.getLabel()), ResMsgVoc.getString("VOC_ERROR"), 0);
                this._select = null;
                this._ctrlInput.requestFocus();
                return false;
            }
            try {
                par.verify(this._appl.getDAOFactory());
                this._select = par;
                return true;
            }
            catch (LawException e) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), e.getMessage(), ResMsgVoc.getString("VOC_ERROR"), 0);
                this._select = null;
                this._ctrlInput.requestFocus();
                return false;
            }
        }
        StringBuilder errorMsg = new StringBuilder();
        if (this._lawParser.withError()) {
            for (String msg : this._lawParser.getErrors()) {
                errorMsg.append(msg).append("\n");
            }
        } else {
            errorMsg.append(ResMsgCore.msgFormat("MSG_INTERNAL_ERROR", "Erreur lors du d\u00e9chiffrage du param\u00e8tre."));
        }
        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), errorMsg.toString(), ResMsgVoc.getString("VOC_ERROR"), 0);
        this._select = null;
        this._ctrlInput.requestFocus();
        return false;
    }

    public void addDependsListener(DependsListener l) {
        if (!this._listeners.contains(l)) {
            this._listeners.add(l);
        }
    }

    public void removeDependsListener(DependsListener l) {
        this._listeners.remove(l);
    }

    protected void fireChangeDepends() {
        for (int i = this._listeners.size() - 1; i >= 0; --i) {
            this._listeners.get(i).changeDepends();
        }
    }
}

