/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.icon.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeModel;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeNode;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderDlgDisplayError;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.folder.DBFolderTreeEditable;
import com.dassault.cecilia.dbobj.general.icon.gui.DBIconCmdInsert;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class IconFolderTree
extends DBFolderTreeEditable {
    boolean _onlySelect;

    public IconFolderTree(CeciliaAppl application, DBFolderTreeModel model, boolean onlySelect) {
        super(application, model, false);
        this._onlySelect = onlySelect;
        this.initialize();
    }

    @Override
    protected CeciliaAppl getAppl() {
        return (CeciliaAppl)super.getAppl();
    }

    @Override
    protected JPopupMenu createMenuActions(JPopupMenu popupList) {
        popupList.add(this._ctrlAddFolder);
        popupList.addSeparator();
        popupList.add(this._ctrlAdd);
        if (!this._onlySelect) {
            popupList.add(this._ctrlProp);
            popupList.add(this._ctrlRename);
            popupList.add(this._ctrlDel);
        }
        popupList.addSeparator();
        popupList.add(this._ctrlExpand);
        popupList.add(this._ctrlCollapse);
        popupList.add(this._ctrlRefresh);
        if (this.getAppl().isDebugMode()) {
            popupList.addSeparator();
            popupList.add(this._ctrlDebug);
        }
        if (!this._onlySelect) {
            popupList.addSeparator();
            popupList.add(this._ctrlFreeze);
        }
        return popupList;
    }

    @Override
    protected boolean isEnabledAddFile(DBFolder dbFolder) {
        return false;
    }

    @Override
    protected void doInsert(DBFolder dbParent) {
        boolean createFamily;
        DBFolder.Family familyFolder = dbParent.getFamily();
        if (familyFolder == DBFolder.Family.APPLICATION) {
            return;
        }
        int depth = dbParent.getDepthUntilSystem();
        boolean bl = createFamily = depth < familyFolder.getDepthFolder();
        if (createFamily) {
            super.doInsert(dbParent);
            return;
        }
        if (!dbParent.isFolder()) {
            return;
        }
        DBFolderTreeNode ndParent = this._model.getTreeNode(dbParent);
        if (ndParent == null) {
            return;
        }
        if (ndParent.isReadOnly()) {
            return;
        }
        DBIconCmdInsert cmd = new DBIconCmdInsert((CAppl)this.getAppl(), this);
        cmd.setDBFolder(dbParent).setDBUser(this._model.getDBUser());
        cmd.realiseDo();
        if (cmd.withWarnning()) {
            DBFolderDlgDisplayError dlg = new DBFolderDlgDisplayError(SwingUtilities.getWindowAncestor(this));
            dlg.setTitle(ResMsgVoc.getString("VOC_ERROR") + " - " + this.getAppl().getTitle());
            dlg.setErrors(cmd.getErrors());
            dlg.setSelectTree(this);
            dlg.setModal(true);
            dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this));
            dlg.setVisible(true);
        }
    }

    @Override
    protected void doEdit(DBFolderTreeNode selectNode, boolean readOnly) {
    }

    @Override
    protected void refreshActions() {
        super.refreshActions();
        if (this.getSelectionCount() == 1) {
            TreePath selPath = this.getSelectionPath();
            DBFolderTreeNode selFolder = (DBFolderTreeNode)selPath.getLastPathComponent();
            boolean isReadOnly = selFolder.isReadOnly();
            this._ctrlAdd.setEnabled(!isReadOnly && selFolder.getDBFolder().isFolder());
        }
    }
}

