/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.log;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.lib.util.format.Convertable;
import java.awt.Component;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class DBLogs {
    static Logger _LOG = Logger.getLogger(DBLogs.class.getPackage().getName());
    static DateFormat __DATE_FORMAT = new SimpleDateFormat("ddMMyy-HHmmss");
    ArrayList<Log> _logs;

    public static DBLevel convertLoggerLevel(Level llvl) {
        if (llvl.equals(Level.SEVERE)) {
            return DBLevel.ERROR;
        }
        if (llvl.equals(Level.WARNING)) {
            return DBLevel.WARNING;
        }
        if (llvl.equals(Level.INFO)) {
            return DBLevel.INFO;
        }
        if (llvl.equals(Level.FINE)) {
            return DBLevel.FINE;
        }
        if (llvl.equals(Level.FINER)) {
            return DBLevel.FINER;
        }
        if (llvl.equals(Level.FINEST)) {
            return DBLevel.FINEST;
        }
        return DBLevel.ERROR;
    }

    public DBLogs() {
        this._logs = new ArrayList();
    }

    DBLogs(int size) {
        this._logs = new ArrayList(size);
    }

    public DBLogs getCopy() {
        DBLogs result = new DBLogs(this._logs.size());
        for (int i = 0; i < this._logs.size(); ++i) {
            result._logs.add(this._logs.get(i).getCopy());
        }
        return result;
    }

    public Log addLog(Date create, String user, DBLevel level, String msg) {
        Log log = new Log(this._logs.size());
        log.setCreate(create).setUser(user).setLevel(level).setMessage(msg);
        this._logs.add(log);
        return log;
    }

    public void addLog(Log log) {
        log._idx = this._logs.size();
        this._logs.add(log);
    }

    public void removeLog(Log log) {
        if (log.getLevel() == DBLevel.FINEST || log.isPrivate()) {
            this._logs.remove(log);
        } else {
            _LOG.severe("Tentative de suppression d'un DBLog qui n'est pas Finest : " + log.toString());
        }
    }

    public boolean changeLog(Log log, DBLevel level) {
        if (log.getLevel().compareTo(level) <= 0) {
            return false;
        }
        log.setLevel(level);
        log.setModif(new Date());
        return true;
    }

    public DBLevel getMaxLevel() {
        return this.getMaxLevel(false);
    }

    public DBLevel getMaxLevel(boolean withoutPrivateLog) {
        if (this._logs.isEmpty()) {
            return DBLevel.ZERO;
        }
        DBLevel dbLevel = DBLevel.ZERO;
        for (int i = 0; i < this._logs.size(); ++i) {
            Log log = this._logs.get(i);
            if (withoutPrivateLog && log.isPrivate() || log.getLevel().compareTo(dbLevel) <= 0) continue;
            dbLevel = log.getLevel();
        }
        return dbLevel;
    }

    public boolean withLogs(DBLevel limit) {
        if (this._logs.isEmpty()) {
            return false;
        }
        if (limit == DBLevel.FINEST) {
            return true;
        }
        for (int i = 0; i < this._logs.size(); ++i) {
            Log log = this._logs.get(i);
            if (log.getLevel().compareTo(limit) < 0) continue;
            return true;
        }
        return false;
    }

    public List<Log> getLogs(DBLevel limit) {
        if (limit == DBLevel.FINEST) {
            return new ArrayList<Log>(this._logs);
        }
        if (this._logs.size() == 0) {
            return new ArrayList<Log>();
        }
        ArrayList<Log> result = new ArrayList<Log>(this._logs.size() / 2 + 1);
        for (int i = 0; i < this._logs.size(); ++i) {
            Log log = this._logs.get(i);
            if (log.getLevel().compareTo(limit) < 0) continue;
            result.add(log);
        }
        return result;
    }

    public void traceLogs(Logger logger, DBLevel limit) {
        for (int i = 0; i < this._logs.size(); ++i) {
            Log log = this._logs.get(i);
            if (log.getLevel().compareTo(limit) < 0) continue;
            logger.log(log.getLevel().getJavaLevel(), log.getMessage());
        }
    }

    public void toXML(Appendable out, String indent) throws IOException {
        out.append(indent).append("<").append("cec.logs").append(">\n");
        String logIndent = indent + "  ";
        for (int i = 0; i < this._logs.size(); ++i) {
            Log log = this._logs.get(i);
            out.append(logIndent).append("<").append("cec.log");
            out.append(" ").append("create").append("='").append(Long.toString(log.getCreate().getTime())).append("'");
            DBObjectXmlUtility.appendXML(out.append(" ").append("user").append("='"), log.getUser()).append("'");
            out.append(" ").append("level").append("='").append(log.getLevel().toString().toLowerCase()).append("'");
            if (log.getModif() != null) {
                out.append(" ").append("modify").append("='").append(Long.toString(log.getModif().getTime())).append("'");
            }
            if (log.isPrivate()) {
                out.append(" ").append("private").append("='true'");
            }
            out.append(">");
            DBObjectXmlUtility.appendXML(out, log.getMessage());
            out.append("</").append("cec.log").append(">\n");
        }
        out.append(indent).append("</").append("cec.logs").append(">\n");
    }

    static {
        __DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public static class Log {
        int _idx;
        Date _create;
        String _user;
        Date _modif;
        DBLevel _level;
        String _msg;
        boolean _private;

        Log(int idx) {
            this._idx = idx;
        }

        Log setCreate(Date date) {
            this._create = date;
            return this;
        }

        public Log setModif(Date date) {
            this._modif = date;
            return this;
        }

        Log setUser(String str) {
            this._user = str;
            return this;
        }

        Log setMessage(String str) {
            this._msg = str;
            return this;
        }

        Log setLevel(DBLevel lvl) {
            this._level = lvl;
            return this;
        }

        public Log setPrivate(boolean priv) {
            this._private = priv;
            return this;
        }

        public int getID() {
            return this._idx;
        }

        public Date getCreate() {
            return this._create;
        }

        public Date getModif() {
            return this._modif;
        }

        public String getUser() {
            return this._user;
        }

        public String getMessage() {
            return this._msg;
        }

        public DBLevel getLevel() {
            return this._level;
        }

        public boolean isPrivate() {
            return this._private;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this._level.name().toLowerCase()).append(":").append(this._msg);
            if (this._modif != null) {
                sb.append(" {").append(__DATE_FORMAT.format(this._modif)).append(",").append(this._user).append("}");
            } else {
                sb.append(" [").append(__DATE_FORMAT.format(this._create)).append(",").append(this._user).append("]");
            }
            return sb.toString();
        }

        public Log getCopy() {
            return new Log(this._idx).setCreate(this._create).setUser(this._user).setLevel(this._level).setMessage(this._msg).setModif(this._modif).setPrivate(this._private);
        }
    }

    public static enum DBLevel implements Convertable
    {
        ZERO(Level.ALL, "Zero"),
        FINEST(Level.FINEST, ResMsgVoc.getString("VOC_FINEST")),
        FINER(Level.FINER, ResMsgVoc.getString("VOC_FINER")),
        FINE(Level.FINE, ResMsgVoc.getString("VOC_FINE")),
        INFO(Level.FINE, ResMsgVoc.getString("VOC_INFO")),
        WARNING(Level.INFO, ResMsgVoc.getString("VOC_WARNING")),
        ERROR(Level.INFO, ResMsgVoc.getString("VOC_ERROR")),
        INIT(Level.INFO, ResMsgVoc.getString("VOC_NOINIT"));

        Level _javaLogLevel;
        String _label;
        String _lower;
        private static ListCellRenderer _listCellRenderer;
        private static TableCellRenderer _tableCellRenderer;

        private DBLevel(Level logLevel, String label) {
            this._javaLogLevel = logLevel;
            this._label = label;
            this._lower = this.toString().toLowerCase();
        }

        public Level getJavaLevel() {
            return this._javaLogLevel;
        }

        public String getLabel() {
            return this._label;
        }

        public String convertToString() {
            return this._lower;
        }

        public static ListCellRenderer getListCellRenderer() {
            return _listCellRenderer;
        }

        public static TableCellRenderer getTableCellRenderer() {
            return _tableCellRenderer;
        }

        static {
            _listCellRenderer = new ListDBLevelRenderer();
            _tableCellRenderer = new TableDBLevelRenderer();
        }

        public static class TableDBLevelRenderer
        extends DefaultTableCellRenderer {
            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
                if (value instanceof DBLevel) {
                    this.setText(((DBLevel)((Object)value)).getLabel());
                }
                return this;
            }
        }

        public static class ListDBLevelRenderer
        extends DefaultListCellRenderer {
            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof DBLevel) {
                    this.setText(((DBLevel)((Object)value)).getLabel());
                }
                return this;
            }
        }
    }

    public static class DefaultManager
    implements DBLogsManager {
        String _login;
        DBLogs _logs;

        public DefaultManager(String login, DBLogs logs) {
            this._login = login;
            this._logs = logs;
        }

        @Override
        public void addLog(DBLevel dbLvl, String msg, boolean bPrivate) {
            this._logs.addLog(new Date(), this._login, dbLvl, msg).setPrivate(bPrivate);
        }

        @Override
        public void addLog(Log log) {
            this._logs.addLog(log);
        }

        @Override
        public boolean withLogs(DBLevel limit) {
            return this._logs.withLogs(limit);
        }

        public Log getLog(DBLevel level, String msg) {
            for (Log log : this._logs.getLogs(level)) {
                if (!log.getMessage().equals(msg)) continue;
                return log;
            }
            return null;
        }

        public void removeLog(Log log) {
            this._logs.removeLog(log);
        }
    }

    public static interface DBLogsManager {
        public void addLog(Log var1);

        public void addLog(DBLevel var1, String var2, boolean var3);

        public boolean withLogs(DBLevel var1);

        default public void addLog(DBLevel dbLvl, String msg) {
            this.addLog(dbLvl, msg, false);
        }

        default public void addAll(List<Log> logs) {
            if (logs.isEmpty()) {
                return;
            }
            for (Log log : logs) {
                this.addLog(log);
            }
        }
    }
}

