/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.nparam.io;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.TypeParam;
import com.dassault.cecilia.dbobj.general.law.io.LawParser;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.general.log.io.SAXLogHandler;
import com.dassault.cecilia.dbobj.general.nparam.io.DBParamHandler;
import java.util.Map;
import java.util.logging.Logger;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DBParamHandlerRaw
extends SAXLogHandler
implements DBParamHandler {
    private static Logger _LOG = Logger.getLogger(DBParamHandlerRaw.class.getPackage().getName());
    boolean _bXMLRoot = false;
    TypeParam _type;
    Param _value;
    CECFactory _cecFactory;

    public DBParamHandlerRaw(DBLogs.DBLogsManager logMng, CECFactory cecFactory) {
        super(logMng);
        this._cecFactory = cecFactory;
    }

    @Override
    public TypeParam getParamType() {
        return this._type;
    }

    @Override
    public Param getParamValue() {
        return this._value;
    }

    public void startAction(String key, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (!this._bXMLRoot && key.equals("cec.parameter")) {
            String type = attrs.get("type");
            if (type == null || type.isEmpty()) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", "cec.parameter", "type"), this.getLocator()));
            } else {
                try {
                    this._type = TypeParam.getType(Integer.parseInt(type));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (this._type == null) {
                    this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", "cec.parameter", "type"), this.getLocator()));
                }
            }
            this._bXMLRoot = true;
            return;
        }
        this.errorElementUnknown(key);
    }

    public boolean endAction(String key, Map<String, String> attrs, String txt) throws SAXException {
        if (this._bXMLRoot && key.equals("cec.parameter")) {
            if (this._type == null) {
                throw new NullPointerException();
            }
            LawParser lawParser = new LawParser(this._cecFactory.getLawManager(), null);
            this._value = lawParser.parseParam(txt.trim());
            if (this._value == null) {
                String firstMsg = null;
                if (lawParser.withError()) {
                    for (String msg : lawParser.getErrors()) {
                        if (firstMsg == null) {
                            firstMsg = msg;
                        }
                        _LOG.finer(msg);
                    }
                }
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_EVENT_RAW_PARAM", txt, firstMsg != null ? firstMsg : "Unknown error"), this.getLocator()));
            }
            this._value.setType(this._type);
            this._bXMLRoot = false;
        }
        return false;
    }
}

