/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.component.gui;

import com.dassault.cecilia.core.ConfigManager;
import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.pref.GeneralTextPreferencies;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.table.CeciliaTable;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.dbobj.demo.DemoLimits;
import com.dassault.cecilia.dbobj.folder.DBFolderTreeActivable;
import com.dassault.cecilia.dbobj.mbsa.ResIcoOcas;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.component.AltaComponent;
import com.dassault.cecilia.dbobj.mbsa.component.gui.AltaEditWithZoomPanel;
import com.dassault.cecilia.dbobj.mbsa.component.gui.NamePosition;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSub;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaFlowEquipPanel;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.mbsa.node.gui.AltaDefaultTableCellRenderer;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeBool;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeBound;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeEnum;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeFloat;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeInt;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeParser;
import com.dassault.cecilia.dbobj.mbsa.type.DBType;
import com.dassault.cecilia.dbobj.mbsa.type.gui.AltaTypeTableCellRenderer;
import com.dassault.cecilia.dbobj.mbsa.type.gui.TypeDlgChooser;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class AltaFlowPanel
extends AltaEditWithZoomPanel {
    private static TypeDlgChooser _typeChooser = null;
    private static Object _LockerDlgChooser = new Object();
    private CeciliaAppl _appl;
    CeciliaAction _ctrlAdd;
    CeciliaAction _ctrlDel;
    CeciliaAction _ctrlEdit;
    CeciliaAction _ctrlNorth;
    CeciliaAction _ctrlSouth;
    CeciliaAction _ctrlWest;
    CeciliaAction _ctrlEast;
    CeciliaAction _ctrlRepartition;
    CeciliaAction _ctrlTextPositionTop;
    CeciliaAction _ctrlTextPositionBottom;
    CeciliaAction _ctrlTextPositionRight;
    CeciliaAction _ctrlTextPositionLeft;
    CeciliaAction _ctrlTextPositionCenter;
    private JPopupMenu _popupMenu = new JPopupMenu();
    private JPopupMenu _leftPopupMenu = new JPopupMenu();
    private PortTable _ctrlTable;
    private PortTableModel _ctrlTableModel;
    private JPanel _panelPort = new JPanel();
    private JLabel _portNameLabel = new JLabel(ResMsgVoc.getString("VOC_NAME"));
    private JTextField _portName = new JTextField("");
    private JLabel _portTypeLabel = new JLabel(ResMsgVoc.getString("VOC_TYPE"));
    private JComboBox _portTypeSelector = new JComboBox();
    private JLabel _portSensLabel = new JLabel(ResMsgVoc.getString("VOC_SENS"));
    private JComboBox _portSensSelector = new JComboBox();
    private JButton _allocatePortTypeButton = new JButton(ResMsgVoc.getString("VOC_AFFECT"));
    private JPanel _enumPanel = new JPanel();
    private JTextField _valueEnumTypePort = new JTextField("");
    private JPanel _predefinePanel = new JPanel();
    private JTextField _predefineType = new JTextField("");
    private JButton _selectPredefineType = new JButton("...");
    private JPanel _xyPanel = new JPanel();
    private JLabel _xLabel = new JLabel("X");
    private JLabel _yLabel = new JLabel("Y");
    private JTextField _xValue = new JTextField("");
    private JTextField _yValue = new JTextField("");
    private JPanel _intervalPanel = new JPanel();
    private JLabel _minLabel = new JLabel("Min");
    private JLabel _maxLabel = new JLabel("Max");
    private JTextField _minValue = new JTextField("");
    private JTextField _maxValue = new JTextField("");
    private JLabel _labels = new JLabel(ResMsgVoc.getString("VOC_DISPLAY"));
    private JComboBox _displayMode = new JComboBox();
    private List<AltaFlow> _selectionFlows = new ArrayList<AltaFlow>();
    AltaSub _instanceComponent;
    EditPanel _editor = new EditPanel();
    JSplitPane _splitPane = new JSplitPane(1);
    String _maxCommun = "";
    String _minCommun = "";
    int _mode;
    JComboBox _listDirectionCombo = new JComboBox();
    ItemListener _listDirectionListener;
    PortTableEditor _portNameEditor = new PortTableEditor();
    int _editingPortRow = -1;
    int _editingPortColumn = -1;
    double _zoom = 1.0;
    private static final int ID_MOVE_UP = 0;
    private static final int ID_MOVE_LEFT = 1;
    private static final int ID_MOVE_DOWN = 2;
    private static final int ID_MOVE_RIGHT = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TypeDlgChooser getDlgChooser(Window win, CeciliaAppl appl) {
        if (_typeChooser == null) {
            TypeDlgChooser dlg = null;
            Object object = _LockerDlgChooser;
            synchronized (object) {
                if (_typeChooser == null) {
                    dlg = new TypeDlgChooser(win, appl);
                }
                if (_typeChooser == null) {
                    _typeChooser = dlg;
                }
            }
        }
        return _typeChooser;
    }

    boolean isEquipmentFlowPanel() {
        return this instanceof AltaFlowEquipPanel;
    }

    @Override
    public double getZoom() {
        return this._zoom;
    }

    @Override
    public void setZoom(double value) {
        this._zoom = value;
    }

    public AltaFlowPanel(CeciliaAppl appl) {
        super(appl);
        this._appl = appl;
        this.createActions();
        this.createTable();
        this.make();
        this.defineActions();
    }

    private void make() {
        JPanel portInfoPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.add((Component)this._splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 10, 2, 10), 0, 0));
        this.add((Component)portInfoPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 10, 5, 10), 0, 0));
        JToolBar panelIcon = new JToolBar();
        panelIcon.add(this._ctrlAdd.createButton(CeciliaAction.BorderStyle.LIGHT));
        panelIcon.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        panelIcon.add(this._ctrlDel.createButton(CeciliaAction.BorderStyle.LIGHT));
        panelIcon.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        panelIcon.add(this._ctrlNorth.createButton(CeciliaAction.BorderStyle.LIGHT));
        panelIcon.add(this._ctrlSouth.createButton(CeciliaAction.BorderStyle.LIGHT));
        panelIcon.add(this._ctrlWest.createButton(CeciliaAction.BorderStyle.LIGHT));
        panelIcon.add(this._ctrlEast.createButton(CeciliaAction.BorderStyle.LIGHT));
        panelIcon.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        panelIcon.add(this._ctrlEdit.createButton(CeciliaAction.BorderStyle.LIGHT));
        panelIcon.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        panelIcon.add(this._ctrlRepartition.createButton(CeciliaAction.BorderStyle.LIGHT));
        panelIcon.setFloatable(false);
        this._ctrlAdd.setEnabled(true);
        this._ctrlNorth.setEnabled(false);
        this._ctrlSouth.setEnabled(false);
        this._ctrlWest.setEnabled(false);
        this._ctrlEast.setEnabled(false);
        this._ctrlEdit.setEnabled(false);
        this._ctrlRepartition.setEnabled(false);
        this._scrollView = this._zoomDecorator.createScrollPane();
        JToolBar leftPanelIcon = new JToolBar();
        leftPanelIcon.add(this._ctrlTextPositionTop.createButton(CeciliaAction.BorderStyle.LIGHT));
        leftPanelIcon.add(this._ctrlTextPositionBottom.createButton(CeciliaAction.BorderStyle.LIGHT));
        leftPanelIcon.add(this._ctrlTextPositionLeft.createButton(CeciliaAction.BorderStyle.LIGHT));
        leftPanelIcon.add(this._ctrlTextPositionRight.createButton(CeciliaAction.BorderStyle.LIGHT));
        leftPanelIcon.add(this._ctrlTextPositionCenter.createButton(CeciliaAction.BorderStyle.LIGHT));
        leftPanelIcon.setFloatable(false);
        JPanel leftPanel = new JPanel(new GridBagLayout());
        leftPanel.add((Component)this._scrollView, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 2, 5), 0, 0));
        leftPanel.add((Component)leftPanelIcon, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
        this._scrollView.setComponentPopupMenu(this._leftPopupMenu);
        this._splitPane.setLeftComponent(leftPanel);
        this._splitPane.setRightComponent(this._panelPort);
        this._panelPort.setLayout(new GridBagLayout());
        JScrollPane scrollTable = new JScrollPane(this._ctrlTable);
        scrollTable.setComponentPopupMenu(this._popupMenu);
        this._panelPort.add((Component)scrollTable, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 2, 5), 0, 0));
        this._panelPort.add((Component)panelIcon, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 2, 5), 0, 0));
        portInfoPanel.setLayout(new GridBagLayout());
        portInfoPanel.setBorder(BorderFactory.createEtchedBorder());
        portInfoPanel.add((Component)this._portNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        portInfoPanel.add((Component)this._portName, new GridBagConstraints(1, 0, 6, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        portInfoPanel.add((Component)this._portTypeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        portInfoPanel.add((Component)this._portTypeSelector, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        portInfoPanel.add((Component)this._predefinePanel, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        portInfoPanel.add((Component)this._enumPanel, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        portInfoPanel.add((Component)this._intervalPanel, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        portInfoPanel.add((Component)this._xyPanel, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        portInfoPanel.add((Component)this._portSensLabel, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        portInfoPanel.add((Component)this._portSensSelector, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        portInfoPanel.add((Component)this._allocatePortTypeButton, new GridBagConstraints(6, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._enumPanel.setLayout(new GridBagLayout());
        this._enumPanel.add((Component)this._valueEnumTypePort, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        this._predefinePanel.setLayout(new GridBagLayout());
        this._predefinePanel.add((Component)this._predefineType, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 2), 0, 0));
        this._predefinePanel.add((Component)this._selectPredefineType, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 5), 0, 0));
        this._intervalPanel.setLayout(new GridBagLayout());
        this._intervalPanel.add((Component)this._minLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this._intervalPanel.add((Component)this._minValue, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        this._intervalPanel.add((Component)this._maxLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this._intervalPanel.add((Component)this._maxValue, new GridBagConstraints(3, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        this._xyPanel.setLayout(new GridBagLayout());
        this._xyPanel.add((Component)this._xLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this._xyPanel.add((Component)this._xValue, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        this._xyPanel.add((Component)this._yLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this._xyPanel.add((Component)this._yValue, new GridBagConstraints(3, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        this._portNameLabel.setForeground(Color.black);
        this._portTypeLabel.setForeground(Color.black);
        this._minLabel.setForeground(Color.black);
        this._maxLabel.setForeground(Color.black);
        this._enumPanel.setVisible(false);
        this._predefinePanel.setVisible(false);
        this._intervalPanel.setVisible(false);
        this._portTypeSelector.addItem("bool");
        this._portTypeSelector.addItem("enum");
        this._portTypeSelector.addItem(ResMsgVoc.getString("VOC_INTERVAL"));
        this._portTypeSelector.addItem(ResMsgOcas.getString("OCAS_PREDEFINE"));
        this._portTypeSelector.addItem("int");
        this._portTypeSelector.addItem("float");
        this._listDirectionCombo.addItem(AltaFlow.Orientation.IN);
        this._listDirectionCombo.addItem(AltaFlow.Orientation.OUT);
        this._listDirectionCombo.addItem(AltaFlow.Orientation.LOCAL);
        this._portSensSelector.addItem(AltaFlow.Orientation.IN);
        this._portSensSelector.addItem(AltaFlow.Orientation.OUT);
        this._portSensSelector.addItem(AltaFlow.Orientation.LOCAL);
        DefaultListCellRenderer renderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof AltaFlow.Orientation) {
                    this.setText(((AltaFlow.Orientation)((Object)value)).getLabel());
                }
                return this;
            }
        };
        this._listDirectionCombo.setRenderer(renderer);
        this._portSensSelector.setRenderer(renderer);
    }

    private void createTable() {
        this._ctrlTableModel = new PortTableModel();
        this._ctrlTable = new PortTable(this._ctrlTableModel);
        this._ctrlTable.getTableHeader().setReorderingAllowed(false);
        this._ctrlTable.setSelectionMode(2);
        this._ctrlTable.setRowHeight(20);
        this._ctrlTable.setDefaultRenderer(String.class, new AltaDefaultTableCellRenderer());
        this._ctrlTable.setDefaultRenderer(AltaType.class, new AltaTypeTableCellRenderer());
        this._ctrlTable.setDefaultRenderer(AltaFlow.Orientation.class, new AltaFlow.Orientation.SpecificTableCellRenderer());
        this._ctrlTable.setDefaultRenderer(Integer.class, new AltaDefaultTableCellRenderer(0));
        PortTableCellEditor defaultEditor = new PortTableCellEditor(this._listDirectionCombo);
        this._ctrlTable.setDefaultEditor(String.class, defaultEditor);
        this._ctrlTable.setDefaultEditor(AltaFlow.Orientation.class, defaultEditor);
        this._ctrlTable.setDefaultEditor(Integer.class, defaultEditor);
    }

    private Component getSourceComponent(ActionEvent e) {
        Object src = e.getSource();
        if (src != null && src instanceof Component) {
            return (Component)src;
        }
        return this;
    }

    private void createActions() {
        this._ctrlAdd = new CeciliaAction(ResIcoCore.getImageIcon("BUT_ADD"), ResMsgVoc.getString("VOC_ADD")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaFlowPanel.this.addIO();
                AltaFlowPanel.this._portName.requestFocus();
                AltaFlowPanel.this.getAltaComponent().setModified(true);
            }
        }.setDesc(ResMsgOcas.getString("MODEL_EDIT_ADD_FLOW"));
        this._ctrlDel = new CeciliaAction(ResIcoCore.getImageIcon("BUT_DEL"), ResMsgVoc.getString("VOC_DELETE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaFlowPanel.this.doRemoveAction();
            }
        }.setDesc(ResMsgOcas.getString("MODEL_EDIT_DEL_FLOW"));
        this._ctrlEdit = new CeciliaAction(ResIcoCore.getImageIcon("BUT_EDIT"), ResMsgVoc.getString("VOC_EDIT")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AltaFlowPanel.this._ctrlTable.getSelectedRowCount() == 0) {
                    return;
                }
                if (AltaFlowPanel.this._selectionFlows == null || AltaFlowPanel.this._selectionFlows.size() != 1) {
                    return;
                }
                AltaType type = ((AltaFlow)AltaFlowPanel.this._selectionFlows.get(0)).getType();
                if (!(type instanceof DBType)) {
                    return;
                }
                if (((DBType)type).getDBFolder() == null) {
                    return;
                }
                DBFolderTreeActivable tree = AltaFlowPanel.this._appl.getTopWindow().getFolders().getTree(DBFolder.Family.TYPE);
                if (tree != null) {
                    tree.edit(((DBType)type).getDBFolder(), false);
                }
            }
        }.setDesc(ResMsgOcas.getString("CMD_TYPE_EDIT"));
        this._ctrlNorth = new CeciliaAction(ResIcoOcas.getImageIcon("IO_PORT_NORTH"), ResMsgOcas.getString("MODEL_EDIT_FLOW_MOVE_NORST")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaFlowPanel.this.moveFlowsToPosition(AltaFlowPanel.this.getSourceComponent(e), PositionFlow.NORTH);
            }
        }.setDesc(ResMsgOcas.getString("MODEL_EDIT_FLOW_MOVE_NORST"));
        this._ctrlSouth = new CeciliaAction(ResIcoOcas.getImageIcon("IO_PORT_SOUTH"), ResMsgOcas.getString("MODEL_EDIT_FLOW_MOVE_SOUTH")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaFlowPanel.this.moveFlowsToPosition(AltaFlowPanel.this.getSourceComponent(e), PositionFlow.SOUTH);
            }
        }.setDesc(ResMsgOcas.getString("MODEL_EDIT_FLOW_MOVE_SOUTH"));
        this._ctrlWest = new CeciliaAction(ResIcoOcas.getImageIcon("IO_PORT_WEST"), ResMsgOcas.getString("MODEL_EDIT_FLOW_MOVE_WEST")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaFlowPanel.this.moveFlowsToPosition(AltaFlowPanel.this.getSourceComponent(e), PositionFlow.WEST);
            }
        }.setDesc(ResMsgOcas.getString("MODEL_EDIT_FLOW_MOVE_WEST"));
        this._ctrlEast = new CeciliaAction(ResIcoOcas.getImageIcon("IO_PORT_EAST"), ResMsgOcas.getString("MODEL_EDIT_FLOW_MOVE_EAST")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaFlowPanel.this.moveFlowsToPosition(AltaFlowPanel.this.getSourceComponent(e), PositionFlow.EAST);
            }
        }.setDesc(ResMsgOcas.getString("MODEL_EDIT_FLOW_MOVE_EAST"));
        this._ctrlRepartition = new CeciliaAction(ResIcoOcas.getImageIcon("CMD_GRF_EQUIDIST"), ResMsgOcas.getString("MODEL_EDIT_FLOW_DISTRIB")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaFlowPanel.this.createRepartition();
                AltaFlowPanel.this.getSourceComponent(e).requestFocus();
            }
        }.setDesc(ResMsgOcas.getString("MODEL_EDIT_FLOW_AUTO_MOVA"));
        this._ctrlTextPositionTop = new CeciliaAction(ResIcoOcas.getImageIcon("CMD_GRF_TEXT_T"), ResMsgOcas.getString("TEXT_POSITION_TOP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaFlowPanel.this.changeLabelOrientationPosition(NamePosition.TOP);
            }
        }.setDesc(ResMsgOcas.getString("TEXT_POSITION_TOP"));
        this._ctrlTextPositionBottom = new CeciliaAction(ResIcoOcas.getImageIcon("CMD_GRF_TEXT_B"), ResMsgOcas.getString("TEXT_POSITION_BOTTOM")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaFlowPanel.this.changeLabelOrientationPosition(NamePosition.BOTTOM);
            }
        }.setDesc(ResMsgOcas.getString("TEXT_POSITION_BOTTOM"));
        this._ctrlTextPositionLeft = new CeciliaAction(ResIcoOcas.getImageIcon("CMD_GRF_TEXT_L"), ResMsgOcas.getString("TEXT_POSITION_LEFT")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaFlowPanel.this.changeLabelOrientationPosition(NamePosition.LEFT);
            }
        }.setDesc(ResMsgOcas.getString("TEXT_POSITION_LEFT"));
        this._ctrlTextPositionRight = new CeciliaAction(ResIcoOcas.getImageIcon("CMD_GRF_TEXT_R"), ResMsgOcas.getString("TEXT_POSITION_RIGHT")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaFlowPanel.this.changeLabelOrientationPosition(NamePosition.RIGHT);
            }
        }.setDesc(ResMsgOcas.getString("TEXT_POSITION_RIGHT"));
        this._ctrlTextPositionCenter = new CeciliaAction(ResIcoOcas.getImageIcon("CMD_GRF_TEXT_C"), ResMsgOcas.getString("TEXT_POSITION_CENTER")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaFlowPanel.this.changeLabelOrientationPosition(NamePosition.CENTER);
            }
        }.setDesc(ResMsgOcas.getString("TEXT_POSITION_CENTER"));
    }

    private void changeLabelOrientationPosition(NamePosition position) {
        this.getAltaComponent().setTextPosition(position);
        this.getAltaComponent().setModified(true);
        this.setEnabledBtnsOrientation(position);
        this._editor.requestFocus();
        this._editor.updateUI();
    }

    private void setEnabledBtnsOrientation(NamePosition nextPosition) {
        this._ctrlTextPositionBottom.setEnabled(!nextPosition.equals((Object)NamePosition.BOTTOM));
        this._ctrlTextPositionTop.setEnabled(!nextPosition.equals((Object)NamePosition.TOP));
        this._ctrlTextPositionRight.setEnabled(!nextPosition.equals((Object)NamePosition.RIGHT));
        this._ctrlTextPositionLeft.setEnabled(!nextPosition.equals((Object)NamePosition.LEFT));
        this._ctrlTextPositionCenter.setEnabled(!nextPosition.equals((Object)NamePosition.CENTER));
    }

    private void defineActions() {
        this._listDirectionListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int viewRow = AltaFlowPanel.this._ctrlTable.getSelectedRow();
                if (viewRow != -1) {
                    int modelRow = AltaFlowPanel.this._ctrlTable.convertRowIndexToModel(viewRow);
                    AltaFlow port = AltaFlowPanel.this._currentComponent.getFlows().get(modelRow);
                    if (AltaFlowPanel.this._listDirectionCombo.getSelectedItem() != null) {
                        AltaFlow.Orientation orientation = (AltaFlow.Orientation)((Object)AltaFlowPanel.this._listDirectionCombo.getSelectedItem());
                        AltaFlowPanel.this._ctrlTable.removeEditor();
                        AltaFlowPanel.this._listDirectionCombo.removeItemListener(AltaFlowPanel.this._listDirectionListener);
                        if (!port.getOrientation().equals((Object)orientation)) {
                            AltaFlowPanel.this.modifyPorts(Collections.singletonList(new PortModifier(port).setOrientation(orientation)), AltaFlowPanel.this._listDirectionCombo);
                        }
                        AltaFlowPanel.this._editor.updateUI();
                        AltaFlowPanel.this.refreshTable();
                        viewRow = AltaFlowPanel.this._ctrlTable.convertRowIndexToView(modelRow);
                        if (viewRow != -1) {
                            AltaFlowPanel.this._ctrlTable.setRowSelectionInterval(viewRow, viewRow);
                        }
                        AltaFlowPanel.this.getAltaComponent().setModified(true);
                    }
                }
            }
        };
        this._portTypeSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (AltaFlowPanel.this._portTypeSelector.getSelectedIndex()) {
                    case 1: {
                        AltaFlowPanel.this._enumPanel.setVisible(true);
                        AltaFlowPanel.this._intervalPanel.setVisible(false);
                        AltaFlowPanel.this._predefinePanel.setVisible(false);
                        AltaFlowPanel.this._valueEnumTypePort.setText("");
                        break;
                    }
                    case 2: {
                        AltaFlowPanel.this._enumPanel.setVisible(false);
                        AltaFlowPanel.this._intervalPanel.setVisible(true);
                        AltaFlowPanel.this._predefinePanel.setVisible(false);
                        AltaFlowPanel.this._minValue.setText("");
                        AltaFlowPanel.this._maxValue.setText("");
                        break;
                    }
                    case 3: {
                        AltaFlowPanel.this._enumPanel.setVisible(false);
                        AltaFlowPanel.this._intervalPanel.setVisible(false);
                        AltaFlowPanel.this._predefinePanel.setVisible(true);
                        AltaFlowPanel.this._predefineType.setText("");
                        break;
                    }
                    default: {
                        AltaFlowPanel.this._enumPanel.setVisible(false);
                        AltaFlowPanel.this._intervalPanel.setVisible(false);
                        AltaFlowPanel.this._predefinePanel.setVisible(false);
                    }
                }
            }
        });
        this._allocatePortTypeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AltaFlowPanel.this._selectionFlows == null || AltaFlowPanel.this._selectionFlows.isEmpty()) {
                    return;
                }
                AltaFlowPanel.this.allocateIO((AltaFlow)AltaFlowPanel.this._selectionFlows.get(0));
            }
        });
        this._portName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    AltaFlowPanel.this.addIO();
                }
            }
        });
        this._ctrlTable.getActionMap().put("DELETE", this._ctrlDel);
        this._ctrlTable.getInputMap(0).put(KeyStroke.getKeyStroke("DELETE"), "DELETE");
        this._selectPredefineType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TypeDlgChooser dlg = AltaFlowPanel.getDlgChooser(SwingUtilities.getWindowAncestor(AltaFlowPanel.this._selectPredefineType), AltaFlowPanel.this._appl);
                DAOFolder daoFolder = AltaFlowPanel.this._appl.getDAOFactory().createFolderDAO();
                DBFolder dbFolder = daoFolder.findFolder("TYPE_FAMILIES", AltaFlowPanel.this._predefineType.getText());
                if (dbFolder != null) {
                    dlg.setSelectFolder(dbFolder);
                }
                dlg.setVisible(true);
                if (dlg.getResult() && (dbFolder = dlg.getSelectFolder()) != null) {
                    AltaFlowPanel.this._predefineType.setText(dbFolder.getRefPath());
                }
            }
        });
        this._popupMenu.add(this._ctrlEdit);
        this._popupMenu.addSeparator();
        this._popupMenu.add(this._ctrlDel);
        this._leftPopupMenu.add(this._ctrlTextPositionTop);
        this._leftPopupMenu.add(this._ctrlTextPositionBottom);
        this._leftPopupMenu.add(this._ctrlTextPositionLeft);
        this._leftPopupMenu.add(this._ctrlTextPositionRight);
        this._leftPopupMenu.add(this._ctrlTextPositionCenter);
        this._leftPopupMenu.addSeparator();
        this._leftPopupMenu.add(this._ctrlRepartition);
    }

    private final void moveFlowsToPosition(Component owner, PositionFlow flow) {
        int[] viewIndices = this._ctrlTable.getSelectedRows();
        if (viewIndices.length != 0) {
            ArrayList<PortModifier> ports = new ArrayList<PortModifier>(viewIndices.length + 1);
            for (int i = 0; i < viewIndices.length; ++i) {
                AltaFlow port = this._currentComponent.getFlows().get(this._ctrlTable.convertRowIndexToModel(viewIndices[i]));
                Point p = new Point();
                switch (flow) {
                    case NORTH: {
                        p.x = this._currentComponent.getWidth() / 2;
                        p.y = 0;
                        break;
                    }
                    case WEST: {
                        p.x = 0;
                        p.y = this._currentComponent.getHeight() / 2;
                        break;
                    }
                    case SOUTH: {
                        p.x = this._currentComponent.getWidth() / 2;
                        p.y = this._currentComponent.getHeight();
                        break;
                    }
                    case EAST: {
                        p.x = this._currentComponent.getWidth();
                        p.y = this._currentComponent.getHeight() / 2;
                        break;
                    }
                    default: {
                        assert (false) : "Pas de PositionFlux renseigne.";
                        break;
                    }
                }
                ports.add(new PortModifier(port).setLocation(p));
            }
            this.modifyPorts(ports, owner);
            this._editor.updateUI();
            this.refreshTable();
            this.refreshSelection(ports);
            owner.requestFocus();
        }
    }

    @Override
    public void focusTreatment() {
        super.focusTreatment();
        this._portName.requestFocus();
    }

    public Point portOnDrawBorder(int xCursor, int yCursor) {
        Point p = new Point(0, 0);
        if (xCursor <= 0 && yCursor <= 0) {
            p.x = 0;
            p.y = 0;
        } else if (xCursor >= this._currentComponent.getWidth() && yCursor <= 0) {
            p.x = this._currentComponent.getWidth();
            p.y = 0;
        } else if (xCursor <= 0 && yCursor >= this._currentComponent.getHeight()) {
            p.x = 0;
            p.y = this._currentComponent.getHeight();
        } else if (xCursor >= this._currentComponent.getWidth() && yCursor >= this._currentComponent.getHeight()) {
            p.x = this._currentComponent.getWidth();
            p.y = this._currentComponent.getHeight();
        } else {
            int currentLength;
            int lengthEst;
            int lengthOuest;
            int minLength = 100000;
            Rectangle rect = new Rectangle(this._currentComponent.getWidth(), this._currentComponent.getHeight());
            if (rect.contains(new Point(xCursor, 0))) {
                lengthOuest = Math.abs(yCursor);
                if (lengthOuest < (lengthEst = Math.abs(yCursor - this._currentComponent.getHeight()))) {
                    currentLength = lengthOuest;
                    if (currentLength < minLength) {
                        minLength = currentLength;
                        p.x = Math.min(xCursor, this._currentComponent.getWidth());
                        p.y = 0;
                    }
                } else {
                    currentLength = lengthEst;
                    if (currentLength < minLength) {
                        minLength = currentLength;
                        p.x = Math.min(xCursor, this._currentComponent.getWidth());
                        p.y = this._currentComponent.getHeight();
                    }
                }
            }
            if (rect.contains(new Point(0, yCursor))) {
                lengthOuest = Math.abs(xCursor);
                if (lengthOuest < (lengthEst = Math.abs(xCursor - this._currentComponent.getWidth()))) {
                    currentLength = lengthOuest;
                    if (currentLength < minLength) {
                        minLength = currentLength;
                        p.x = 0;
                        p.y = Math.min(yCursor, this._currentComponent.getHeight());
                    }
                } else {
                    currentLength = lengthEst;
                    if (currentLength < minLength) {
                        minLength = currentLength;
                        p.x = this._currentComponent.getWidth();
                        p.y = Math.min(yCursor, this._currentComponent.getHeight());
                    }
                }
            }
        }
        return p;
    }

    public void refreshEditCtrlAfterSelection() {
        this._selectionFlows.clear();
        int[] viewIndices = this._ctrlTable.getSelectedRows();
        if (this._currentComponent != null) {
            if (viewIndices.length != 0) {
                AltaFlow currentPort = this.getCommunPortSelectedRows();
                for (AltaFlow port : this._currentComponent.getFlows()) {
                    port.setSelected(false);
                }
                for (int i = 0; i < viewIndices.length; ++i) {
                    AltaFlow port;
                    port = this._currentComponent.getFlows().get(this._ctrlTable.convertRowIndexToModel(viewIndices[i]));
                    port.setSelected(true);
                    if (port == null || this._selectionFlows.contains(port)) continue;
                    this._selectionFlows.add(port);
                }
                this._portName.setText(currentPort.getName());
                if (currentPort.getOrientation() == null) {
                    this._portSensSelector.setSelectedIndex(-1);
                } else {
                    this._portSensSelector.setSelectedItem((Object)currentPort.getOrientation());
                }
                if (currentPort.getX() != -1) {
                    this._xValue.setText("" + currentPort.getX());
                } else {
                    this._xValue.setText("");
                }
                if (currentPort.getY() != -1) {
                    this._yValue.setText("" + currentPort.getY());
                } else {
                    this._yValue.setText("");
                }
                boolean isPredefineType = false;
                AltaType currentType = currentPort.getType();
                if (currentType != null) {
                    if (currentType instanceof AltaTypeBool) {
                        this._portTypeSelector.setSelectedIndex(0);
                    } else if (currentType instanceof AltaTypeEnum) {
                        String enumeration = currentType.getValue();
                        this._portTypeSelector.setSelectedIndex(1);
                        if (enumeration.indexOf("{") != -1) {
                            enumeration = enumeration.substring(1, enumeration.length() - 1);
                        }
                        this._valueEnumTypePort.setText(enumeration);
                    } else if (currentType instanceof AltaTypeBound) {
                        this._portTypeSelector.setSelectedIndex(2);
                        this._minValue.setText(this._minCommun);
                        this._maxValue.setText(this._maxCommun);
                    } else if (currentType instanceof DBType) {
                        this._portTypeSelector.setSelectedIndex(3);
                        this._predefineType.setText(((DBType)currentType).getDBFolder().getRefPath());
                        isPredefineType = true;
                    } else if (currentType instanceof AltaTypeInt) {
                        this._portTypeSelector.setSelectedIndex(4);
                    } else if (currentType instanceof AltaTypeFloat) {
                        this._portTypeSelector.setSelectedIndex(5);
                    }
                    this._ctrlEdit.setEnabled(isPredefineType);
                } else {
                    this._ctrlEdit.setEnabled(false);
                    this._portTypeSelector.setSelectedIndex(-1);
                }
                this._ctrlDel.setEnabled(true);
                this._ctrlNorth.setEnabled(true);
                this._ctrlSouth.setEnabled(true);
                this._ctrlWest.setEnabled(true);
                this._ctrlEast.setEnabled(true);
                this._ctrlRepartition.setEnabled(this.canBeReparted());
            } else {
                this._ctrlDel.setEnabled(false);
                this._ctrlNorth.setEnabled(false);
                this._ctrlSouth.setEnabled(false);
                this._ctrlWest.setEnabled(false);
                this._ctrlEast.setEnabled(false);
                this._ctrlRepartition.setEnabled(false);
                this._ctrlEdit.setEnabled(false);
                for (AltaFlow port : this._currentComponent.getFlows()) {
                    port.setSelected(false);
                }
                this._portName.setText("");
                this._portTypeSelector.setSelectedIndex(0);
                this._portSensSelector.setSelectedIndex(0);
                this._minValue.setText("");
                this._maxValue.setText("");
                this._predefineType.setText("");
                this._valueEnumTypePort.setText("");
                this._xValue.setText("");
                this._yValue.setText("");
            }
        } else {
            this._ctrlDel.setEnabled(false);
            this._ctrlNorth.setEnabled(false);
            this._ctrlSouth.setEnabled(false);
            this._ctrlWest.setEnabled(false);
            this._ctrlEast.setEnabled(false);
            this._ctrlRepartition.setEnabled(false);
            this._ctrlEdit.setEnabled(false);
        }
        this._editor.updateUI();
    }

    public AltaFlow getCommunPortSelectedRows() {
        if (this._currentComponent != null) {
            int[] viewIndices = this._ctrlTable.getSelectedRows();
            this._minCommun = "";
            this._maxCommun = "";
            if (viewIndices.length != 0) {
                if (viewIndices.length == 1) {
                    AltaFlow communPort = this._currentComponent.getFlows().get(this._ctrlTable.convertRowIndexToModel(viewIndices[0]));
                    AltaType communType = communPort.getType();
                    if (communType instanceof AltaTypeBound) {
                        this._minCommun = Integer.toString(((AltaTypeBound)communType).getMin());
                        this._maxCommun = Integer.toString(((AltaTypeBound)communType).getMax());
                    }
                    return communPort;
                }
                ArrayList<String> enumValues = new ArrayList<String>();
                AltaFlow communPort = this._currentComponent.getFlows().get(this._ctrlTable.convertRowIndexToModel(viewIndices[0])).getCopy();
                communPort.setName("");
                AltaType communType = communPort.getType();
                boolean isBoolType = communType instanceof AltaTypeBool;
                boolean isBoundType = communType instanceof AltaTypeBound;
                boolean isIntType = communType instanceof AltaTypeInt;
                boolean isFloatType = communType instanceof AltaTypeFloat;
                boolean isEnumType = communType instanceof AltaTypeEnum;
                boolean isPredefineType = communType instanceof DBType;
                if (isBoundType) {
                    this._minCommun = Integer.toString(((AltaTypeBound)communType).getMin());
                    this._maxCommun = Integer.toString(((AltaTypeBound)communType).getMax());
                }
                for (int i = 1; i < viewIndices.length; ++i) {
                    AltaFlow oldPort = this._currentComponent.getFlows().get(this._ctrlTable.convertRowIndexToModel(viewIndices[i]));
                    if (communPort.getX() != oldPort.getX()) {
                        communPort.setX(-1);
                    }
                    if (communPort.getY() != oldPort.getY()) {
                        communPort.setY(-1);
                    }
                    if (communPort.getOrientation() != null && !communPort.getOrientation().equals((Object)oldPort.getOrientation())) {
                        communPort.setOrientation(null);
                    }
                    AltaType oldType = oldPort.getType();
                    isBoolType = isBoolType && oldType instanceof AltaTypeBool;
                    isBoundType = isBoundType && oldType instanceof AltaTypeBound;
                    isIntType = isIntType && oldType instanceof AltaTypeInt;
                    isFloatType = isFloatType && oldType instanceof AltaTypeFloat;
                    isEnumType = isEnumType && oldType instanceof AltaTypeEnum;
                    boolean bl = isPredefineType = isPredefineType && oldType instanceof DBType;
                    if (isBoundType) {
                        if (!Integer.toString(((AltaTypeBound)oldType).getMin()).equals(this._minCommun)) {
                            this._minCommun = "";
                        }
                        if (Integer.toString(((AltaTypeBound)oldType).getMax()).equals(this._maxCommun)) continue;
                        this._maxCommun = "";
                        continue;
                    }
                    if (isEnumType) {
                        enumValues.clear();
                        for (int idx = 0; idx < communType.getValueCount(); ++idx) {
                            String elem = communType.getValueAt(idx);
                            if (!oldType.valueExist(elem)) continue;
                            enumValues.add(elem);
                        }
                        ((AltaTypeEnum)communType).setValues(enumValues);
                        continue;
                    }
                    if (isPredefineType) {
                        if (communType.equals(oldType)) continue;
                        communPort.setType(null);
                        continue;
                    }
                    if (isBoolType || isIntType || isFloatType) continue;
                    communPort.setType(null);
                }
                return communPort;
            }
        }
        return null;
    }

    protected void doEditType() {
        if (this._ctrlTable.getSelectedRow() == -1) {
            return;
        }
        if (this.getAltaComponent() == null) {
            return;
        }
        int index = this._ctrlTable.getSelectedRow();
        AltaType type = this.getAltaComponent().getFlows().get(this._ctrlTable.convertRowIndexToModel(index)).getType();
        if (!(type instanceof DBType)) {
            return;
        }
        if (((DBType)type).getDBFolder() == null) {
            return;
        }
        DBFolderTreeActivable tree = this._appl.getTopWindow().getFolders().getTree(DBFolder.Family.TYPE);
        if (tree != null) {
            tree.edit(((DBType)type).getDBFolder(), false);
        }
    }

    protected AltaType getCurrentType() {
        switch (this._portTypeSelector.getSelectedIndex()) {
            case 0: {
                return AltaTypeBool.getInstance();
            }
            case 1: {
                return this.validateEnumFormat(this._valueEnumTypePort.getText());
            }
            case 2: {
                int minValue = Integer.MIN_VALUE;
                int maxValue = Integer.MIN_VALUE;
                try {
                    minValue = Integer.parseInt(this._minValue.getText());
                    maxValue = Integer.parseInt(this._maxValue.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (minValue < 0) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.getString("MODEL_EDIT_ERROR_MIN"), ResMsgVoc.getString("VOC_ERROR"), 0);
                    break;
                }
                if (maxValue < 0) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.getString("MODEL_EDIT_ERROR_MAX"), ResMsgVoc.getString("VOC_ERROR"), 0);
                    break;
                }
                if (minValue >= maxValue) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.getString("MODEL_EDIT_ERROR_MAXMIN_2"), ResMsgVoc.getString("VOC_ERROR"), 0);
                    break;
                }
                return new AltaTypeBound(minValue, maxValue);
            }
            case 3: {
                AltaType defaultType = AltaTypeParser.getType(this._predefineType.getText(), this._appl.getDAOFactory());
                if (defaultType == null) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.getString("TYPE_SPECIFY_DOES_NOT_EXIST"), ResMsgVoc.getString("VOC_ERROR"), 0);
                    break;
                }
                return defaultType;
            }
            case 4: {
                return AltaTypeInt.getInstance();
            }
            case 5: {
                return AltaTypeFloat.getInstance();
            }
        }
        return null;
    }

    private AltaType validateEnumFormat(String text) {
        if (text.equals("")) {
            this.showError(ResMsgOcas.getString("MODEL_EDIT_ERROR_NO_ENUM"));
        } else if (text.indexOf(" ") != -1) {
            this.showError(ResMsgOcas.getString("MODEL_EDIT_ERROR_SPACE"));
        } else {
            String convertEnumType = AltaTypeEnum.convertInEnumType(text);
            if (convertEnumType != null) {
                return new AltaTypeEnum("{" + convertEnumType + "}");
            }
            this.showError(ResMsgOcas.getString("TYPE_SPECIFY_DOES_NOT_EXIST"));
        }
        return null;
    }

    private void showError(String msg) {
        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), msg, ResMsgVoc.getString("VOC_ERROR"), 0);
    }

    private void addIO() {
        Point point;
        AltaFlow flow;
        String name;
        if (this._currentComponent == null) {
            return;
        }
        if (ConfigManager.getVersion() == ConfigManager.TypeVersion.DEMO && this._currentComponent.getFlows().size() >= DemoLimits.Limit.COMPONENT_FLOWS.getLimit()) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlTable), ResMsgOcas.getString("DEMO_COMPONENT_FLOWS"), JOptionCecilia.getTopTitleOf(this._ctrlTable), 0);
            return;
        }
        if (this._ctrlTable.isEditing()) {
            this._ctrlTable.removeEditor();
        }
        if ((name = this._portName.getText()).isEmpty()) {
            this._portName.requestFocus();
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._portName), ResMsgOcas.getString("MODEL_EDIT_PORT_EMPTY"), ResMsgVoc.getString("VOC_ERROR"), 0);
            return;
        }
        if ((name = this.validateName(name)) == null) {
            return;
        }
        AltaType type = this.getCurrentType();
        if (type == null) {
            return;
        }
        int x = 0;
        String xValue = this._xValue.getText();
        String yValue = this._yValue.getText();
        try {
            if (!xValue.isEmpty()) {
                x = Integer.parseInt(xValue);
            }
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._xValue), ResMsgOcas.getString("MODEL_EDIT_ERROR_X"), ResMsgVoc.getString("VOC_ERROR"), 0);
            return;
        }
        int y = 0;
        try {
            if (!yValue.isEmpty()) {
                y = Integer.parseInt(yValue);
            }
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._yValue), ResMsgOcas.getString("MODEL_EDIT_ERROR_Y"), ResMsgVoc.getString("VOC_ERROR"), 0);
            return;
        }
        AltaFlow port = new AltaFlow(name, type);
        port.setID(this._currentComponent.getNextFlowID());
        if (this._portSensSelector.getSelectedItem() != null) {
            port.setOrientation((AltaFlow.Orientation)((Object)this._portSensSelector.getSelectedItem()));
        }
        if ((flow = this._currentComponent.getFlowAtLocation((int)(point = this.portOnDrawBorder(x, y)).getX(), (int)point.getY())) != null) {
            this.findNewPointForNewFlow(point, flow, 8);
        }
        port.setLocation(point);
        this.addPort(port, this._currentComponent.getFlows().size());
        int selectIdx = this._currentComponent.getFlows().size() - 1;
        this._editor.updateUI();
        this.refreshTable();
        if (selectIdx != -1 && (selectIdx = this._ctrlTable.convertRowIndexToView(selectIdx)) != -1) {
            this._ctrlTable.setRowSelectionInterval(selectIdx, selectIdx);
        }
        this._portName.requestFocus();
        this.getAltaComponent().setModified(true);
        if (port.getType() instanceof DBType) {
            this.getAltaComponent().updateDependTimeUpdt(this._appl.getDAOFactory(), this.getAltaComponent().getWorkingRelations());
        }
    }

    private void findNewPointForNewFlow(Point point, AltaFlow flow, int offset) {
        Point pointTmp = (Point)point.clone();
        int moveID = 2;
        while (flow != null && moveID != -1) {
            int newY;
            int newX = (int)(moveID == 3 ? pointTmp.getX() + (double)offset : (moveID == 1 ? pointTmp.getX() - (double)offset : pointTmp.getX()));
            Point newPoint = this.portOnDrawBorder(newX, newY = (int)(moveID == 2 ? pointTmp.getY() + (double)offset : (moveID == 0 ? pointTmp.getY() - (double)offset : pointTmp.getY())));
            if (!newPoint.equals(pointTmp)) {
                flow = this._currentComponent.getFlowAtLocation((int)newPoint.getX(), (int)newPoint.getY());
                pointTmp = (Point)newPoint.clone();
                continue;
            }
            switch (moveID) {
                case 2: {
                    moveID = 3;
                    break;
                }
                case 3: {
                    moveID = 0;
                    break;
                }
                case 0: {
                    moveID = 1;
                    break;
                }
                default: {
                    moveID = -1;
                }
            }
            pointTmp.setLocation(point);
        }
        if (moveID != -1) {
            point.setLocation((int)pointTmp.getX(), (int)pointTmp.getY());
        }
    }

    private void allocateIO(AltaFlow flow) {
        int[] viewIndices;
        if (this._ctrlTable.isEditing()) {
            this._ctrlTable.removeEditor();
        }
        if ((viewIndices = this._ctrlTable.getSelectedRows()).length == 0) {
            return;
        }
        int[] modelIndices = new int[viewIndices.length];
        for (int i = 0; i < viewIndices.length; ++i) {
            modelIndices[i] = this._ctrlTable.convertRowIndexToModel(viewIndices[i]);
        }
        AltaType type = null;
        if (this._portTypeSelector.getSelectedIndex() >= 0 && (type = this.getCurrentType()) == null) {
            return;
        }
        int x = -1;
        int y = -1;
        boolean identLocation = true;
        if (!this._xValue.getText().equals("")) {
            try {
                x = Integer.parseInt(this._xValue.getText());
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._xValue), ResMsgOcas.getString("MODEL_EDIT_ERROR_X"), ResMsgVoc.getString("VOC_ERROR"), 0);
                return;
            }
        }
        if (!this._yValue.getText().equals("")) {
            try {
                y = Integer.parseInt(this._yValue.getText());
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._yValue), ResMsgOcas.getString("MODEL_EDIT_ERROR_Y"), ResMsgVoc.getString("VOC_ERROR"), 0);
                return;
            }
        }
        if (x != -1 && y != -1) {
            for (int i = 0; i < modelIndices.length; ++i) {
                AltaFlow port = this._currentComponent.getFlows().get(modelIndices[i]);
                if (x == port.getX() && y == port.getY()) continue;
                identLocation = false;
                break;
            }
        }
        AltaFlow.Orientation orientation = (AltaFlow.Orientation)((Object)this._portSensSelector.getSelectedItem());
        if (type == null && identLocation && orientation == null) {
            return;
        }
        ArrayList<PortModifier> ports = new ArrayList<PortModifier>(modelIndices.length + 1);
        boolean changeType = false;
        for (int i = 0; i < modelIndices.length; ++i) {
            AltaFlow port = this._currentComponent.getFlows().get(modelIndices[i]);
            PortModifier modify = new PortModifier(port);
            if (type != null && !port.getType().equals(type)) {
                if (port.getType() instanceof DBType || type instanceof DBType) {
                    changeType = true;
                }
                modify.setType(type);
            }
            if (orientation != null && !port.getOrientation().equals((Object)orientation)) {
                modify.setOrientation(orientation);
            }
            if (!identLocation) {
                int xPort = x == -1 ? port.getX() : x;
                int yPort = y == -1 ? port.getY() : y;
                modify.setLocation(this.portOnDrawBorder(xPort, yPort));
            }
            ports.add(modify);
        }
        this.modifyPorts(ports, this._allocatePortTypeButton);
        this._editor.updateUI();
        this.refreshTable();
        this.refreshSelection(ports);
        if (changeType) {
            this.getAltaComponent().updateDependTimeUpdt(this._appl.getDAOFactory(), this.getAltaComponent().getWorkingRelations());
        }
    }

    @Override
    public void setComponent(AltaComponent currentComponent) {
        super.setComponent(currentComponent);
        this._instanceComponent = new AltaSub(currentComponent, currentComponent.getDBFolder().getParent().getName());
        this._instanceComponent.setEquipment(this.isEquipmentFlowPanel());
        this._ctrlAdd.setEnabled(true);
        this._ctrlDel.setEnabled(false);
        this._ctrlNorth.setEnabled(false);
        this._ctrlSouth.setEnabled(false);
        this._ctrlWest.setEnabled(false);
        this._ctrlEast.setEnabled(false);
        this._ctrlRepartition.setEnabled(false);
        this._ctrlEdit.setEnabled(false);
        this.setEnabledBtnsOrientation(currentComponent.getTextPosition());
        this._splitPane.setDividerLocation(200);
        this.refreshTable();
    }

    public void updateLangage() {
        this._labels.setText(ResMsgVoc.getString("VOC_DISPLAY"));
        int mode = this._displayMode.getSelectedIndex();
        this._displayMode.removeAllItems();
        this._displayMode.addItem(ResMsgVoc.getString("VOC_AUCUN"));
        this._displayMode.addItem(ResMsgOcas.getString("VIEW_LABELS_NODES"));
        this._displayMode.addItem(ResMsgOcas.getString("VIEW_LABELS_LINKS"));
        this._displayMode.addItem(ResMsgOcas.getString("VIEW_LABELS_ALL"));
        this._displayMode.setSelectedIndex(mode);
        int type = this._portTypeSelector.getSelectedIndex();
        this._portTypeSelector.removeAllItems();
        this._portTypeSelector.addItem("bool");
        this._portTypeSelector.addItem("enum");
        this._portTypeSelector.addItem(ResMsgVoc.getString("VOC_INTERVAL"));
        this._portTypeSelector.addItem(ResMsgOcas.getString("OCAS_PREDEFINE"));
        this._portTypeSelector.addItem("int");
        this._portTypeSelector.addItem("float");
        this._portTypeSelector.setSelectedIndex(type);
        this._ctrlEdit.setName(ResMsgOcas.getString("CMD_TYPE_EDIT"));
        this._ctrlDel.setName(ResMsgVoc.getString("VOC_DELETE"));
        this._ctrlAdd.setDesc(ResMsgOcas.getString("MODEL_EDIT_ADD_FLOW"));
        this._ctrlEast.setDesc(ResMsgOcas.getString("MODEL_EDIT_FLOW_MOVE_EAST"));
        this._ctrlWest.setDesc(ResMsgOcas.getString("MODEL_EDIT_FLOW_MOVE_WEST"));
        this._ctrlNorth.setDesc(ResMsgOcas.getString("MODEL_EDIT_FLOW_MOVE_NORST"));
        this._ctrlSouth.setDesc(ResMsgOcas.getString("MODEL_EDIT_FLOW_MOVE_SOUTH"));
        this._ctrlEdit.setDesc(ResMsgOcas.getString("CMD_TYPE_EDIT"));
        this._ctrlDel.setDesc(ResMsgOcas.getString("MODEL_EDIT_DEL_FLOW"));
        this._ctrlTextPositionTop.setDesc(ResMsgOcas.getString("TEXT_POSITION_TOP"));
        this._ctrlTextPositionBottom.setDesc(ResMsgOcas.getString("TEXT_POSITION_BOTTOM"));
        this._ctrlTextPositionLeft.setDesc(ResMsgOcas.getString("TEXT_POSITION_LEFT"));
        this._ctrlTextPositionRight.setDesc(ResMsgOcas.getString("TEXT_POSITION_RIGHT"));
        this._ctrlTextPositionCenter.setDesc(ResMsgOcas.getString("TEXT_POSITION_CENTER"));
        this._portNameLabel.setText(ResMsgVoc.getString("VOC_NAME"));
        this._portTypeLabel.setText(ResMsgVoc.getString("VOC_TYPE"));
        this._allocatePortTypeButton.setText(ResMsgVoc.getString("VOC_AFFECT"));
        this.refreshTable();
        this._selectPredefineType.setText("...");
    }

    public void refreshTable() {
        this._editor.updateUI();
        this._ctrlTableModel.fireTableDataChanged();
    }

    public void refreshSelection(List<PortModifier> ports) {
        ListSelectionModel selectModel = this._ctrlTable.getSelectionModel();
        selectModel.setValueIsAdjusting(true);
        selectModel.clearSelection();
        for (int i = 0; i < ports.size(); ++i) {
            AltaFlow port = ports.get(i).getPort();
            int idx = this._currentComponent.getFlows().indexOf(port);
            if (idx == -1 || (idx = this._ctrlTable.convertRowIndexToView(idx)) == -1) continue;
            selectModel.addSelectionInterval(idx, idx);
        }
        selectModel.setValueIsAdjusting(false);
    }

    protected void addPort(AltaFlow port, int idx) {
        this._currentComponent.getFlows().add(idx, port);
    }

    protected void removePorts(List<AltaFlow> ports) {
        for (int i = 0; i < ports.size(); ++i) {
            this._currentComponent.getFlows().remove(ports.get(i));
        }
    }

    protected void modifyPorts(List<PortModifier> ports, Component owner) {
        for (int i = 0; i < ports.size(); ++i) {
            PortModifier modif = ports.get(i);
            AltaFlow flow = modif.getPort();
            if (modif.getName() != null) {
                flow.setName(modif.getName());
            }
            if (modif.getType() != null) {
                flow.setType(modif.getType().getCopy());
            }
            if (modif.getLocation() != null) {
                flow.setLocation(modif.getLocation());
            }
            if (modif.getOrientation() == null) continue;
            flow.setOrientation(modif.getOrientation());
        }
        this.getAltaComponent().setModified(true);
    }

    public void createRepartition() {
        int offset;
        boolean distribX = true;
        boolean distribY = true;
        int x0 = this._selectionFlows.get(0).getX();
        int y0 = this._selectionFlows.get(0).getY();
        for (AltaFlow flow : this._selectionFlows) {
            distribX &= flow.getY() == y0;
            distribY &= flow.getX() == x0;
        }
        if (!distribX && !distribY) {
            return;
        }
        if (distribX && distribY) {
            return;
        }
        final boolean isDistributionOnX = distribX;
        ArrayList<AltaFlow> flows = new ArrayList<AltaFlow>(this._selectionFlows);
        Collections.sort(flows, new Comparator<AltaFlow>(){

            @Override
            public int compare(AltaFlow o1, AltaFlow o2) {
                if (isDistributionOnX ? o1.getX() < o2.getX() : o1.getY() < o2.getY()) {
                    return -1;
                }
                if (isDistributionOnX ? o1.getX() > o2.getX() : o1.getY() > o2.getY()) {
                    return 1;
                }
                return 0;
            }
        });
        AltaFlow firstFlow = (AltaFlow)flows.get(0);
        AltaFlow lastFlow = (AltaFlow)flows.get(flows.size() - 1);
        int firstCoord = isDistributionOnX ? firstFlow.getX() : firstFlow.getY();
        int lastCoord = isDistributionOnX ? lastFlow.getX() : lastFlow.getY();
        int currentOffset = offset = (lastCoord - firstCoord) / (flows.size() - 1);
        ArrayList<PortModifier> listPortModifier = new ArrayList<PortModifier>();
        for (int i = 1; i < flows.size() - 1; ++i) {
            AltaFlow flow = (AltaFlow)flows.get(i);
            int newPosX = ((AltaFlow)flows.get(0)).getX() + (isDistributionOnX ? currentOffset : 0);
            int newPosY = ((AltaFlow)flows.get(0)).getY() + (!isDistributionOnX ? currentOffset : 0);
            Point p = this.portOnDrawBorder(newPosX, newPosY);
            listPortModifier.add(new PortModifier(flow).setLocation(p));
            flow.setLocation(p);
            currentOffset += offset;
        }
        this.modifyPorts(listPortModifier, this);
        this.refreshTable();
        listPortModifier.add(new PortModifier(firstFlow));
        listPortModifier.add(new PortModifier(lastFlow));
        this.refreshSelection(listPortModifier);
        this._editor.updateUI();
    }

    public boolean canBeReparted() {
        if (this._selectionFlows == null || this._selectionFlows.isEmpty() || this._selectionFlows.size() == 1 || this._selectionFlows.size() == 2) {
            return false;
        }
        AltaFlow firstFlow = this._selectionFlows.iterator().next();
        int minX = firstFlow.getX();
        int minY = firstFlow.getY();
        int maxX = firstFlow.getX();
        int maxY = firstFlow.getY();
        for (AltaFlow flow : this._selectionFlows) {
            if (firstFlow == flow) continue;
            int flowPosX = flow.getX();
            int flowPosY = flow.getY();
            if (flowPosX == minX || flowPosX == maxX || flowPosY == minY || flowPosY == maxY) continue;
            return false;
        }
        return true;
    }

    private void doRemoveAction() {
        this.requestFocus();
        int[] viewIndices = this._ctrlTable.getSelectedRows();
        if (viewIndices.length != 0) {
            if (this._ctrlTable.isEditing()) {
                this._ctrlTable.removeEditor();
            }
            int[] modelIndices = new int[viewIndices.length];
            for (int i = 0; i < viewIndices.length; ++i) {
                modelIndices[i] = this._ctrlTable.convertRowIndexToModel(viewIndices[i]);
            }
            Arrays.sort(modelIndices);
            ArrayList<AltaFlow> ports = new ArrayList<AltaFlow>(viewIndices.length + 1);
            for (int i = modelIndices.length - 1; i >= 0; --i) {
                ports.add(this._currentComponent.getFlows().get(modelIndices[i]));
            }
            this.removePorts(ports);
            this._editor.updateUI();
            this._ctrlTable.clearSelection();
            this.refreshTable();
            this.getAltaComponent().setModified(true);
            boolean withDBType = false;
            for (int i = ports.size() - 1; i >= 0; --i) {
                if (!(ports.get(i).getType() instanceof DBType)) continue;
                withDBType = true;
            }
            if (withDBType) {
                this.getAltaComponent().updateDependTimeUpdt(this._appl.getDAOFactory(), this.getAltaComponent().getWorkingRelations());
            }
        }
    }

    @Override
    public JComponent getContentView() {
        return this._editor;
    }

    @Override
    public Rectangle getSelectionRect() {
        this._editor.setSize(this._editor.getPreferredSize());
        int[] viewIndices = this._ctrlTable.getSelectedRows();
        if (viewIndices == null || viewIndices.length == 0) {
            return null;
        }
        int xMin = Integer.MAX_VALUE;
        int yMin = Integer.MAX_VALUE;
        int xMax = Integer.MIN_VALUE;
        int yMax = Integer.MIN_VALUE;
        for (int indice : viewIndices) {
            AltaFlow flow;
            Object selectedNameFlow = this._ctrlTableModel.getValueAt(this._ctrlTable.convertRowIndexToModel(indice), this._ctrlTable.convertColumnIndexToModel(0));
            if (!(selectedNameFlow instanceof String) || (flow = this.getAltaComponent().getFlow((String)selectedNameFlow)) == null) continue;
            xMin = Math.min(flow.getX(), xMin);
            yMin = Math.min(flow.getY(), yMin);
            xMax = Math.max(flow.getX(), xMax);
            yMax = Math.max(flow.getY(), yMax);
        }
        double zoom = this.getZoom();
        double margin = 20.0 * zoom;
        double startX = (double)xMin * zoom + margin;
        double startY = (double)yMin * zoom + margin;
        double endX = (double)xMax * zoom + margin - startX;
        double endY = (double)yMax * zoom + margin - startY;
        return new Rectangle((int)startX, (int)startY, (int)endX, (int)endY);
    }

    public static class PortModifier {
        AltaFlow _port;
        String _name;
        AltaType _type;
        Point _location;
        AltaFlow.Orientation _orientation;

        public PortModifier(AltaFlow port) {
            this._port = port;
        }

        public PortModifier setName(String name) {
            this._name = name;
            return this;
        }

        public PortModifier setType(AltaType type) {
            this._type = type;
            return this;
        }

        public PortModifier setLocation(Point pt) {
            this._location = pt;
            return this;
        }

        public PortModifier setOrientation(AltaFlow.Orientation orientation) {
            this._orientation = orientation;
            return this;
        }

        public AltaFlow getPort() {
            return this._port;
        }

        public String getName() {
            return this._name;
        }

        public AltaType getType() {
            return this._type;
        }

        public Point getLocation() {
            return this._location;
        }

        public AltaFlow.Orientation getOrientation() {
            return this._orientation;
        }
    }

    private static enum PositionFlow {
        NORTH,
        EAST,
        SOUTH,
        WEST;

    }

    private class EditPanel
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        private int _clicX = 0;
        private int _clicY = 0;
        private List<Integer> _listOldValues = new ArrayList<Integer>();
        private List<Integer> _listRefPoint = new ArrayList<Integer>();
        private int _clickedAtX = -1;
        private int _clickedAtY = -1;
        private int _oldDraggedX = -1;
        private int _oldDraggedY = -1;
        public static final int MARGIN = 20;

        EditPanel() {
            this.setBackground(Color.white);
            this.addMouseListener(this);
            this.addActions();
            this.addKeyListener(new KeyListener(){
                List<PortModifier> _listPortModifier = new ArrayList<PortModifier>();

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    AltaFlowPanel.this.modifyPorts(this._listPortModifier, AltaFlowPanel.this);
                    AltaFlowPanel.this.refreshTable();
                    AltaFlowPanel.this.refreshSelection(this._listPortModifier);
                    EditPanel.this.updateUI();
                }

                @Override
                public void keyPressed(KeyEvent e) {
                    int codeKey = e.getKeyCode();
                    this._listPortModifier.clear();
                    if (codeKey != 37 && codeKey != 39 && codeKey != 38 && codeKey != 40) {
                        return;
                    }
                    this.actionMovePort(codeKey);
                }

                public void actionMovePort(int moveID) {
                    int[] viewIndices = AltaFlowPanel.this._ctrlTable.getSelectedRows();
                    if (viewIndices.length == 0) {
                        return;
                    }
                    for (int i = 0; i < viewIndices.length; ++i) {
                        Point newPoint;
                        AltaFlow port = AltaFlowPanel.this._currentComponent.getFlows().get(AltaFlowPanel.this._ctrlTable.convertRowIndexToModel(viewIndices[i]));
                        switch (moveID) {
                            case 38: {
                                newPoint = AltaFlowPanel.this.portOnDrawBorder(port.getX(), port.getY() - 1);
                                break;
                            }
                            case 37: {
                                newPoint = AltaFlowPanel.this.portOnDrawBorder(port.getX() - 1, port.getY());
                                break;
                            }
                            case 40: {
                                newPoint = AltaFlowPanel.this.portOnDrawBorder(port.getX(), port.getY() + 1);
                                break;
                            }
                            case 39: {
                                newPoint = AltaFlowPanel.this.portOnDrawBorder(port.getX() + 1, port.getY());
                                break;
                            }
                            default: {
                                newPoint = null;
                            }
                        }
                        assert (newPoint != null);
                        this._listPortModifier.add(new PortModifier(port).setLocation(newPoint));
                        port.setLocation(newPoint);
                    }
                    EditPanel.this.updateUI();
                }
            });
        }

        private void addActions() {
            this.getInputMap().put(KeyStroke.getKeyStroke(127, 0, false), "delete");
            this.getActionMap().put("delete", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AltaFlowPanel.this._selectionFlows == null || AltaFlowPanel.this._selectionFlows.isEmpty()) {
                        return;
                    }
                    AltaFlowPanel.this.doRemoveAction();
                }
            });
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 3) {
                AltaFlowPanel.this._leftPopupMenu.show(this, e.getX(), e.getY());
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Object selectedFlowTable;
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            this.requestFocus();
            this._clicX = (int)((double)e.getX() / AltaFlowPanel.this.getZoom() - (double)AltaFlowPanel.this._instanceComponent.getX());
            this._clicY = (int)((double)e.getY() / AltaFlowPanel.this.getZoom() - (double)AltaFlowPanel.this._instanceComponent.getY());
            int[] viewIndices = AltaFlowPanel.this._ctrlTable.getSelectedRows();
            Object currentPort = null;
            if (viewIndices.length == 1 && this._clicX > ((AltaFlow)(selectedFlowTable = AltaFlowPanel.this._currentComponent.getFlows().get(AltaFlowPanel.this._ctrlTable.convertRowIndexToModel(viewIndices[0])))).getX() - 3 && this._clicX < ((AltaFlow)selectedFlowTable).getX() + 3 && this._clicY > ((AltaFlow)selectedFlowTable).getY() - 3 && this._clicY < ((AltaFlow)selectedFlowTable).getY() + 3) {
                currentPort = selectedFlowTable;
            }
            if (currentPort == null) {
                currentPort = AltaFlowPanel.this._currentComponent.getFlowAtLocation(this._clicX, this._clicY);
            }
            if (!(currentPort != null && (currentPort == null || AltaFlowPanel.this._selectionFlows.isEmpty() || AltaFlowPanel.this._selectionFlows.contains(currentPort)) || e.isShiftDown())) {
                for (AltaFlow flow : AltaFlowPanel.this._selectionFlows) {
                    flow.setSelected(false);
                }
                AltaFlowPanel.this._selectionFlows.clear();
            }
            ArrayList<AltaFlow> setFlows = new ArrayList<AltaFlow>();
            if (viewIndices.length != 0) {
                for (int i = 0; i < viewIndices.length; ++i) {
                    setFlows.add(AltaFlowPanel.this._currentComponent.getFlows().get(AltaFlowPanel.this._ctrlTable.convertRowIndexToModel(viewIndices[i])));
                }
                if (!setFlows.contains(currentPort) && !e.isShiftDown()) {
                    for (AltaFlow port : setFlows) {
                        port.setSelected(false);
                        int indexOfPort = AltaFlowPanel.this._currentComponent.getFlows().indexOf(port);
                        indexOfPort = AltaFlowPanel.this._ctrlTable.convertRowIndexToView(indexOfPort);
                        AltaFlowPanel.this._ctrlTable.removeRowSelectionInterval(indexOfPort, indexOfPort);
                    }
                }
            }
            if (currentPort != null && !AltaFlowPanel.this._selectionFlows.contains(currentPort)) {
                AltaFlowPanel.this._selectionFlows.add(currentPort);
            }
            if (!AltaFlowPanel.this._selectionFlows.isEmpty() && !e.isShiftDown()) {
                this._listOldValues.clear();
                this._listRefPoint.clear();
                int initialPosX = ((AltaFlow)currentPort).getX();
                int initialPosY = ((AltaFlow)currentPort).getY();
                for (AltaFlow flow : AltaFlowPanel.this._selectionFlows) {
                    int flowX = flow.getX();
                    int flowY = flow.getY();
                    this._listOldValues.add(flowX);
                    this._listOldValues.add(flowY);
                    this._listRefPoint.add(this.getRelativeDistance(initialPosX, initialPosY, flowX, flowY));
                }
                if (AltaFlowPanel.this._selectionFlows.size() == 1) {
                    AltaFlowPanel.this._ctrlTable.selectPort((AltaFlow)AltaFlowPanel.this._selectionFlows.get(0));
                }
            }
            this._clickedAtX = (int)((double)e.getX() / AltaFlowPanel.this.getZoom());
            this._clickedAtY = (int)((double)e.getY() / AltaFlowPanel.this.getZoom());
            this._oldDraggedX = -1;
            this._oldDraggedY = -1;
            this.addMouseMotionListener(this);
            this.updateUI();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            int currentPosX = (int)((double)e.getX() / AltaFlowPanel.this.getZoom());
            int currentPosY = (int)((double)e.getY() / AltaFlowPanel.this.getZoom());
            if (AltaFlowPanel.this._selectionFlows != null && !AltaFlowPanel.this._selectionFlows.isEmpty() && !e.isShiftDown()) {
                for (int i = 0; i < AltaFlowPanel.this._selectionFlows.size(); ++i) {
                    AltaFlow flow = (AltaFlow)AltaFlowPanel.this._selectionFlows.get(i);
                    int posX = currentPosX - AltaFlowPanel.this._instanceComponent.getX();
                    int posY = currentPosY - AltaFlowPanel.this._instanceComponent.getY();
                    Point p = this.setNewPos(posX, posY, this._listRefPoint.get(i));
                    flow.setLocation(p);
                }
            } else {
                this._oldDraggedX = currentPosX;
                this._oldDraggedY = currentPosY;
            }
            AltaFlowPanel.this._editor.updateUI();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            if (AltaFlowPanel.this._selectionFlows != null && !AltaFlowPanel.this._selectionFlows.isEmpty() && !e.isShiftDown()) {
                ArrayList<PortModifier> listPortModifier = new ArrayList<PortModifier>();
                for (int i = 0; i < AltaFlowPanel.this._selectionFlows.size(); ++i) {
                    AltaFlow currentPort = (AltaFlow)AltaFlowPanel.this._selectionFlows.get(i);
                    Point newPt = new Point(currentPort.getX(), currentPort.getY());
                    currentPort.setX(this._listOldValues.get(2 * i)).setY(this._listOldValues.get(2 * i + 1));
                    listPortModifier.add(new PortModifier(currentPort).setLocation(newPt));
                }
                AltaFlowPanel.this.modifyPorts(listPortModifier, this);
                AltaFlowPanel.this.refreshTable();
                AltaFlowPanel.this.refreshSelection(listPortModifier);
            } else {
                if (this._clickedAtX == -1 || this._clickedAtY == -1 || this._oldDraggedX == -1 || this._oldDraggedY == -1) {
                    return;
                }
                int minX = this._clickedAtX < this._oldDraggedX ? this._clickedAtX : this._oldDraggedX;
                int minY = this._clickedAtY < this._oldDraggedY ? this._clickedAtY : this._oldDraggedY;
                int maxX = this._clickedAtX < this._oldDraggedX ? this._oldDraggedX : this._clickedAtX;
                int maxY = this._clickedAtY < this._oldDraggedY ? this._oldDraggedY : this._clickedAtY;
                ListSelectionModel selectModel = AltaFlowPanel.this._ctrlTable.getSelectionModel();
                selectModel.setValueIsAdjusting(true);
                if (!e.isShiftDown()) {
                    selectModel.clearSelection();
                }
                for (int modelIdx = 0; modelIdx < AltaFlowPanel.this._currentComponent.getFlows().size(); ++modelIdx) {
                    AltaFlow flow = AltaFlowPanel.this._currentComponent.getFlows().get(modelIdx);
                    int flowX = flow.getX() + AltaFlowPanel.this._instanceComponent.getX();
                    int flowY = flow.getY() + AltaFlowPanel.this._instanceComponent.getY();
                    if (flowX <= minX || flowX >= maxX || flowY <= minY || flowY >= maxY) continue;
                    int viewIdx = AltaFlowPanel.this._ctrlTable.convertRowIndexToView(modelIdx);
                    selectModel.addSelectionInterval(viewIdx, viewIdx);
                }
                selectModel.setValueIsAdjusting(false);
                this._clickedAtX = -1;
                this._clickedAtY = -1;
                this.updateUI();
            }
            this._listOldValues.clear();
            this.removeMouseMotionListener(this);
        }

        private final PositionFlow getPosFromCoord(int x, int y) {
            if (x == 0 && y != 0) {
                return PositionFlow.WEST;
            }
            if (y == 0) {
                return PositionFlow.NORTH;
            }
            if (x == AltaFlowPanel.this._instanceComponent.getNode().getWidth()) {
                return PositionFlow.EAST;
            }
            return PositionFlow.SOUTH;
        }

        private final Point setNewPos(int currentX, int currentY, int length) {
            Point p = AltaFlowPanel.this.portOnDrawBorder(currentX, currentY);
            int wantedX = (int)p.getX();
            int wantedY = (int)p.getY();
            int width = AltaFlowPanel.this._instanceComponent.getNode().getWidth();
            int height = AltaFlowPanel.this._instanceComponent.getNode().getHeight();
            PositionFlow posFlow = this.getPosFromCoord((int)p.getX(), (int)p.getY());
            if (length < 0) {
                length = width * 2 + height * 2 + length;
            }
            while (length != 0) {
                switch (posFlow) {
                    case NORTH: {
                        if (length > width - wantedX) {
                            length -= width - wantedX;
                            wantedX = width;
                            posFlow = this.getNextEdge(posFlow);
                            break;
                        }
                        wantedX += length;
                        length = 0;
                        break;
                    }
                    case EAST: {
                        if (length > height - wantedY) {
                            length -= height - wantedY;
                            wantedY = height;
                            posFlow = this.getNextEdge(posFlow);
                            break;
                        }
                        wantedY += length;
                        length = 0;
                        break;
                    }
                    case SOUTH: {
                        if (length > width - (width - wantedX)) {
                            length -= width - (width - wantedX);
                            wantedX = 0;
                            posFlow = this.getNextEdge(posFlow);
                            break;
                        }
                        wantedX -= length;
                        length = 0;
                        break;
                    }
                    case WEST: {
                        if (length > height - (height - wantedY)) {
                            length -= height - (height - wantedY);
                            wantedY = 0;
                            posFlow = this.getNextEdge(posFlow);
                            break;
                        }
                        wantedY -= length;
                        length = 0;
                    }
                }
            }
            return new Point(wantedX, wantedY);
        }

        private final int getRelativeDistance(int xInitial, int yInitial, int xWanted, int yWanted) {
            PositionFlow posInitial = this.getPosFromCoord(xInitial, yInitial);
            PositionFlow posWanted = this.getPosFromCoord(xWanted, yWanted);
            Point initial = new Point(xInitial, yInitial);
            Point wanted = new Point(xWanted, yWanted);
            int distance = 0;
            while (posInitial != posWanted) {
                distance += this.getDistanceToNextEdge(posInitial, initial);
                posInitial = this.getNextEdge(posInitial);
            }
            return distance += this.getDistanceSameEdge(posInitial, initial, wanted);
        }

        private final int getDistanceSameEdge(PositionFlow flow, Point initial, Point wanted) {
            assert (flow != null);
            switch (flow) {
                case NORTH: 
                case SOUTH: {
                    int result = wanted.x - initial.x;
                    return flow == PositionFlow.NORTH ? result : -result;
                }
                case EAST: 
                case WEST: {
                    int result = wanted.y - initial.y;
                    return flow == PositionFlow.EAST ? result : -result;
                }
            }
            return -1;
        }

        private final PositionFlow getNextEdge(PositionFlow posFlow) {
            assert (posFlow != null);
            switch (posFlow) {
                case NORTH: {
                    return PositionFlow.EAST;
                }
                case EAST: {
                    return PositionFlow.SOUTH;
                }
                case SOUTH: {
                    return PositionFlow.WEST;
                }
                case WEST: {
                    return PositionFlow.NORTH;
                }
            }
            return null;
        }

        private final int getDistanceToNextEdge(PositionFlow pos, Point initial) {
            int result;
            assert (pos != null);
            switch (pos) {
                case NORTH: {
                    int width = AltaFlowPanel.this._instanceComponent.getNode().getWidth();
                    result = width - initial.x;
                    initial.x = width;
                    break;
                }
                case SOUTH: {
                    result = initial.x;
                    initial.x = 0;
                    break;
                }
                case WEST: {
                    result = initial.y;
                    initial.y = 0;
                    break;
                }
                case EAST: {
                    int height = AltaFlowPanel.this._instanceComponent.getNode().getHeight();
                    result = height - initial.y;
                    initial.y = height;
                    break;
                }
                default: {
                    result = -1;
                }
            }
            return result;
        }

        @Override
        public Dimension getPreferredSize() {
            int y;
            if (AltaFlowPanel.this._currentComponent == null) {
                return this.getParent().getSize();
            }
            int zoomedCompWidth = (int)(AltaFlowPanel.this.getZoom() * (double)AltaFlowPanel.this._currentComponent.getWidth());
            int zoomedCompHeight = (int)(AltaFlowPanel.this.getZoom() * (double)AltaFlowPanel.this._currentComponent.getHeight());
            int viewPortWidth = this.getParent().getSize().width;
            int viewPortHeight = this.getParent().getSize().height;
            int x = (viewPortWidth - (int)((double)zoomedCompWidth + 20.0 * AltaFlowPanel.this.getZoom())) / 2;
            if ((double)x < 20.0 * AltaFlowPanel.this.getZoom()) {
                x = (int)(20.0 * AltaFlowPanel.this.getZoom());
            }
            if ((double)(y = (viewPortHeight - (int)((double)zoomedCompHeight + 20.0 * AltaFlowPanel.this.getZoom())) / 2) < 20.0 * AltaFlowPanel.this.getZoom()) {
                y = (int)(20.0 * AltaFlowPanel.this.getZoom());
            }
            if (zoomedCompHeight + y * 2 > viewPortHeight || zoomedCompWidth + x * 2 > viewPortWidth) {
                return new Dimension(zoomedCompWidth + 2 * x, zoomedCompHeight + 2 * y);
            }
            return this.getParent().getSize();
        }

        public void computeComponentLocation() {
            if (AltaFlowPanel.this._currentComponent != null) {
                int y;
                int viewPortWidth = this.getParent().getSize().width;
                int viewPortHeight = this.getParent().getSize().height;
                int currentZoomedWidth = (int)((double)AltaFlowPanel.this._currentComponent.getWidth() * AltaFlowPanel.this.getZoom());
                int currentZoomedHeight = (int)((double)AltaFlowPanel.this._currentComponent.getHeight() * AltaFlowPanel.this.getZoom());
                int x = (int)((double)((viewPortWidth - currentZoomedWidth) / 2) / AltaFlowPanel.this.getZoom());
                if (x < 20) {
                    x = 20;
                }
                if ((y = (int)((double)((viewPortHeight - currentZoomedHeight) / 2) / AltaFlowPanel.this.getZoom())) < 20) {
                    y = 20;
                }
                AltaFlowPanel.this._instanceComponent.setX(x).setY(y);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g) {
            this.paintComponent(g);
            this.paintBorder(g);
            this.computeComponentLocation();
            ((Graphics2D)g).scale(AltaFlowPanel.this._zoom, AltaFlowPanel.this._zoom);
            Font oldFont = g.getFont();
            try {
                PluginWithOptions opts = AltaFlowPanel.this._appl.getPreferencies().getOptions(GeneralTextPreferencies.PREF_KEY);
                if (opts != null && opts instanceof GeneralTextPreferencies) {
                    GeneralTextPreferencies gpref = (GeneralTextPreferencies)opts;
                    g.setFont(new Font(gpref.getFontType().toString(), 0, gpref.getFontSize()));
                }
                AltaFlowPanel.this._instanceComponent.paint(g);
            }
            finally {
                g.setFont(oldFont);
            }
            if (this._clickedAtX != -1 && this._clickedAtY != -1 && this._oldDraggedX != -1 && this._oldDraggedY != -1) {
                int minX = this._clickedAtX < this._oldDraggedX ? this._clickedAtX : this._oldDraggedX;
                int minY = this._clickedAtY < this._oldDraggedY ? this._clickedAtY : this._oldDraggedY;
                int maxX = this._clickedAtX < this._oldDraggedX ? this._oldDraggedX : this._clickedAtX;
                int maxY = this._clickedAtY < this._oldDraggedY ? this._oldDraggedY : this._clickedAtY;
                ((Graphics2D)g).drawRect(minX, minY, maxX - minX, maxY - minY);
            }
        }
    }

    public class PortTableModel
    extends AbstractTableModel {
        PortTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            if (AltaFlowPanel.this._currentComponent == null) {
                return 0;
            }
            return AltaFlowPanel.this._currentComponent.getFlows().size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (AltaFlowPanel.this._currentComponent == null) {
                return " ";
            }
            switch (col) {
                case 0: {
                    return AltaFlowPanel.this._currentComponent.getFlows().get(row).getName();
                }
                case 1: {
                    AltaType type = AltaFlowPanel.this._currentComponent.getFlows().get(row).getType();
                    if (!(type instanceof DBType) || ((DBType)type).getDBFolder() == null) {
                        return type.getValue();
                    }
                    return ((DBType)type).getDBFolder().getRefPath();
                }
                case 2: {
                    return AltaFlowPanel.this._currentComponent.getFlows().get(row).getOrientation();
                }
                case 3: {
                    return AltaFlowPanel.this._currentComponent.getFlows().get(row).getX();
                }
                case 4: {
                    return AltaFlowPanel.this._currentComponent.getFlows().get(row).getY();
                }
            }
            return "";
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return ResMsgVoc.getString("VOC_NAME");
                }
                case 1: {
                    return ResMsgVoc.getString("VOC_TYPE");
                }
                case 2: {
                    return ResMsgVoc.getString("VOC_SENS");
                }
                case 3: {
                    return ResMsgVoc.getString("VOC_X");
                }
                case 4: {
                    return ResMsgVoc.getString("VOC_Y");
                }
            }
            return "";
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return AltaType.class;
                }
                case 2: {
                    return AltaFlow.Orientation.class;
                }
                case 3: {
                    return Integer.class;
                }
                case 4: {
                    return Integer.class;
                }
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (!AltaFlowPanel.this._ctrlTable.isEditable()) {
                return false;
            }
            return col != 1 && AltaFlowPanel.this._ctrlTable.getSelectedRowCount() == 1;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
        }
    }

    protected class PortTable
    extends CeciliaTable {
        public boolean _isEditable;

        PortTable(PortTableModel model) {
            super(model);
            this._isEditable = false;
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    PortTable.this._isEditable = false;
                }
            });
        }

        @Override
        public void createDefaultColumnsFromModel() {
            super.createDefaultColumnsFromModel();
            TableColumnModel tableCols = this.getColumnModel();
            for (int c = 0; c < this.getColumnCount(); ++c) {
                TableColumn tableCol = tableCols.getColumn(c);
                int idxModel = this.convertColumnIndexToModel(c);
                int width = -1;
                switch (idxModel) {
                    case 2: {
                        width = 80;
                        break;
                    }
                    case 3: {
                        width = 40;
                        break;
                    }
                    case 4: {
                        width = 40;
                    }
                }
                if (width <= 0) continue;
                tableCol.setPreferredWidth(width);
                tableCol.setMinWidth(width);
                tableCol.setMaxWidth(width);
                tableCol.setResizable(false);
            }
        }

        @Override
        protected void doubleClickLeft(MouseEvent e) {
            int colView = this.columnAtPoint(e.getPoint());
            int colModel = this.convertColumnIndexToModel(colView);
            if (colModel == 1) {
                AltaFlowPanel.this.doEditType();
            } else {
                this._isEditable = true;
                int rowView = this.rowAtPoint(e.getPoint());
                int rowModel = this.convertRowIndexToModel(rowView);
                if (this.getModel().isCellEditable(rowModel, colModel)) {
                    AltaFlowPanel.this._editingPortRow = rowModel;
                    AltaFlowPanel.this._editingPortColumn = colModel;
                    this.editCellAt(rowView, colView);
                    this.getEditorComponent().requestFocus();
                } else {
                    this._isEditable = false;
                }
            }
        }

        @Override
        public void editingCanceled(ChangeEvent e) {
            this._isEditable = false;
            super.editingCanceled(e);
        }

        @Override
        public void editingStopped(ChangeEvent e) {
            this._isEditable = false;
            super.editingStopped(e);
        }

        public boolean isEditable() {
            return this._isEditable;
        }

        public void setEditable(boolean editable) {
            this._isEditable = editable;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
            AltaFlowPanel.this.refreshEditCtrlAfterSelection();
        }

        @Override
        protected boolean withSorter() {
            return true;
        }

        public void selectPort(AltaFlow port) {
            for (int r = 0; r < this.getRowCount(); ++r) {
                String portName = (String)this.getValueAt(r, 0);
                if (!portName.equals(port.getName())) continue;
                this.setRowSelectionInterval(r, r);
                break;
            }
        }
    }

    public class PortTableCellEditor
    extends DefaultCellEditor {
        JComboBox _combo;

        PortTableCellEditor(JComboBox combo) {
            super(new JComboBox());
            this._combo = combo;
            this.setClickCountToStart(2);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (row != -1) {
                switch (column) {
                    case 0: {
                        AltaFlow port = AltaFlowPanel.this._currentComponent.getFlows().get(table.convertRowIndexToModel(row));
                        AltaFlowPanel.this._portNameEditor.setText(port.getName());
                        return AltaFlowPanel.this._portNameEditor;
                    }
                    case 2: {
                        AltaFlow port = AltaFlowPanel.this._currentComponent.getFlows().get(table.convertRowIndexToModel(row));
                        this._combo.removeItemListener(AltaFlowPanel.this._listDirectionListener);
                        this._combo.setSelectedItem((Object)port.getOrientation());
                        this._combo.addItemListener(AltaFlowPanel.this._listDirectionListener);
                        return this._combo;
                    }
                    case 3: {
                        AltaFlow port = AltaFlowPanel.this._currentComponent.getFlows().get(table.convertRowIndexToModel(row));
                        AltaFlowPanel.this._portNameEditor.setText("" + port.getX());
                        return AltaFlowPanel.this._portNameEditor;
                    }
                    case 4: {
                        AltaFlow port = AltaFlowPanel.this._currentComponent.getFlows().get(table.convertRowIndexToModel(row));
                        AltaFlowPanel.this._portNameEditor.setText("" + port.getY());
                        return AltaFlowPanel.this._portNameEditor;
                    }
                }
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    public class PortTableEditor
    extends JTextField {
        boolean enterHasBeenPressed;

        PortTableEditor() {
            super("");
            this.enterHasBeenPressed = false;
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        PortTableEditor.this.enterHasBeenPressed = true;
                        PortTableEditor.this.validText();
                    }
                }
            });
        }

        @Override
        public void processFocusEvent(FocusEvent e) {
            super.processFocusEvent(e);
            switch (e.getID()) {
                case 1005: {
                    if (!this.enterHasBeenPressed) {
                        this.validText();
                    }
                }
                case 1004: {
                    this.enterHasBeenPressed = false;
                }
            }
        }

        public void validText() {
            switch (AltaFlowPanel.this._editingPortColumn) {
                case 0: {
                    int selectedRow = AltaFlowPanel.this._editingPortRow;
                    String name = this.getText();
                    AltaFlow port = AltaFlowPanel.this._currentComponent.getFlows().get(selectedRow);
                    if (AltaFlowPanel.this._ctrlTable.getCellEditor() != null) {
                        AltaFlowPanel.this._ctrlTable.getCellEditor().stopCellEditing();
                    }
                    AltaFlowPanel.this._ctrlTable.setEditable(false);
                    if (port.getName().equals(name) || (name = AltaFlowPanel.this.validateName(name)) == null) break;
                    AltaFlowPanel.this.modifyPorts(Collections.singletonList(new PortModifier(port).setName(name)), AltaFlowPanel.this._portName);
                    AltaFlowPanel.this._portName.setText(name);
                    AltaFlowPanel.this.refreshTable();
                    selectedRow = AltaFlowPanel.this._ctrlTable.convertRowIndexToView(selectedRow);
                    AltaFlowPanel.this._ctrlTable.setRowSelectionInterval(selectedRow, selectedRow);
                    break;
                }
                case 3: 
                case 4: {
                    try {
                        int selectedRow = AltaFlowPanel.this._editingPortRow;
                        AltaFlow port = AltaFlowPanel.this._currentComponent.getFlows().get(selectedRow);
                        Integer.parseInt(this.getText());
                        Point p = AltaFlowPanel.this._editingPortColumn == 3 ? AltaFlowPanel.this.portOnDrawBorder(Integer.parseInt(this.getText()), port.getY()) : AltaFlowPanel.this.portOnDrawBorder(port.getX(), Integer.parseInt(this.getText()));
                        PortModifier modify = new PortModifier(port);
                        modify.setLocation(p);
                        AltaFlowPanel.this.modifyPorts(Collections.singletonList(modify), AltaFlowPanel.this._ctrlTable);
                        AltaFlowPanel.this._editor.updateUI();
                        AltaFlowPanel.this.refreshTable();
                        selectedRow = AltaFlowPanel.this._ctrlTable.convertRowIndexToView(selectedRow);
                        AltaFlowPanel.this._ctrlTable.setRowSelectionInterval(selectedRow, selectedRow);
                        break;
                    }
                    catch (NumberFormatException ex) {
                        AltaFlowPanel.this.refreshTable();
                        int selectedRow = AltaFlowPanel.this._ctrlTable.convertRowIndexToView(AltaFlowPanel.this._editingPortRow);
                        AltaFlowPanel.this._ctrlTable.setRowSelectionInterval(selectedRow, selectedRow);
                        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(AltaFlowPanel.this._ctrlTable), ResMsgVoc.msgFormat("MSG_PARSE_FLOAT", this.getText()), ResMsgVoc.getString("VOC_ERROR"), 0);
                    }
                }
            }
        }
    }
}

