/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.component.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderPanelSelect;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class ComponentDlgChooser
extends JDialogCecilia {
    CAppl _application;
    JTabbedPane _ctrlTab;
    DBFolderPanelSelect _ctrlSelectComponent;
    DBFolderPanelSelect _ctrlSelectEquipment;

    public ComponentDlgChooser(Window owner, CAppl appl) {
        super(owner, ResMsgOcas.getString("TITLE_ALTA_COMPONENT_CHOICE"));
        this._application = appl;
        this.make(owner);
    }

    private void make(Window owner) {
        this._ctrlTab = new JTabbedPane();
        this._ctrlSelectComponent = new DBFolderPanelSelect(this._application, DBFolder.Family.COMPONENT);
        this._ctrlSelectComponent.getCtrlTree().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                DBFolder dbFolder = ComponentDlgChooser.this._ctrlSelectComponent.getSelectFolder(false);
                if (dbFolder == null) {
                    return;
                }
                if (!dbFolder.isVersion()) {
                    return;
                }
                ComponentDlgChooser.this.validDialog();
            }
        });
        this._ctrlSelectComponent.getCtrlTree().setVisibleRowCount(15);
        this._ctrlTab.addTab(ResMsgVoc.getString("VOC_COMPONENTS"), this._ctrlSelectComponent);
        this._ctrlSelectEquipment = new DBFolderPanelSelect(this._application, DBFolder.Family.EQUIPMENT);
        this._ctrlSelectEquipment.getCtrlTree().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                DBFolder dbFolder = ComponentDlgChooser.this._ctrlSelectEquipment.getSelectFolder(false);
                if (dbFolder == null) {
                    return;
                }
                if (!dbFolder.isVersion()) {
                    return;
                }
                ComponentDlgChooser.this.validDialog();
            }
        });
        this._ctrlSelectEquipment.getCtrlTree().setVisibleRowCount(15);
        this._ctrlTab.addTab(ResMsgVoc.getString("VOC_EQUIPMENTS"), this._ctrlSelectEquipment);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this._ctrlTab, "Center");
        this.getContentPane().add((Component)this.createButPanel(), "South");
        this.init();
        this.pack();
        Dimension size = this.getSize();
        size.width = Math.max(size.width, 250);
        this.setSize(size);
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this));
        this.setModal(true);
    }

    @Override
    public void dispose() {
        this._ctrlSelectComponent.dispose();
        this._ctrlSelectEquipment.dispose();
        super.dispose();
    }

    @Override
    protected boolean verifyParameters() {
        return this.getSelectFolder() != null;
    }

    public void setSelectFolder(DBFolder dbFolder) {
        if (dbFolder.getFamily() == DBFolder.Family.COMPONENT) {
            this._ctrlTab.setSelectedIndex(0);
            this._ctrlSelectComponent.setSelectFolder(dbFolder);
        } else {
            this._ctrlTab.setSelectedIndex(1);
            this._ctrlSelectEquipment.setSelectFolder(dbFolder);
        }
    }

    public DBFolder getSelectFolder() {
        if (this._ctrlTab.getSelectedIndex() == 0) {
            return this._ctrlSelectComponent.getSelectFolder(true);
        }
        return this._ctrlSelectEquipment.getSelectFolder(true);
    }
}

