/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.component.io;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.icon.DBIcon;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.component.gui.NamePosition;
import com.dassault.cecilia.dbobj.mbsa.component.io.DBAltaEventHandlerXml;
import com.dassault.cecilia.dbobj.mbsa.node.AltaEvent;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.mbsa.node.AltaState;
import com.dassault.cecilia.dbobj.mbsa.node.io.DBAltaNodeHandlerXml;
import com.dassault.cecilia.dbobj.mbsa.node.io.DBNodeHandlerXml;
import com.dassault.cecilia.dbobj.mbsa.operator.AltaOperatorRef;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.lib.util.xmlparser.SAXExtendedHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DBComponentHandlerXml
extends DBAltaNodeHandlerXml
implements DBNodeHandlerXml {
    private static Logger _LOG = Logger.getLogger(DBComponentHandlerXml.class.getPackage().getName());
    public static final String ELT_CEC_COMPONENT = "cec.component";
    public static final String ELT_ALTA_ICON = "alta.icon";
    public static final String ELT_ALTA_SIMUL = "alta.simul";
    public static final String ATT_AUTO_MOVE = "auto-move";
    public static final String ATT_BORDER = "border";
    int _width;
    int _height;
    boolean _drawBorder;
    boolean _autoMovePort;
    NamePosition _textPosition;
    DBIcon _dbIcon;
    List<DBIcon> _lstSimuls;
    protected Map<String, AltaFlow> _mapFlows = new LinkedHashMap<String, AltaFlow>();
    protected Map<String, AltaState> _mapStates = new LinkedHashMap<String, AltaState>();
    protected Map<String, AltaEvent> _mapEvents = new LinkedHashMap<String, AltaEvent>();
    protected Map<String, AltaOperatorRef> _mapOperators = new LinkedHashMap<String, AltaOperatorRef>();
    protected String _code;
    protected DBAltaEventHandlerXml _eventHandler = null;

    public DBComponentHandlerXml(DBLogs.DBLogsManager manager, Locator locator, CECFactory cecFactory) {
        super(manager, locator, cecFactory);
        this._lstSimuls = new ArrayList<DBIcon>();
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    public NamePosition getNamePosition() {
        return this._textPosition;
    }

    public boolean getDrawBorder() {
        return this._drawBorder;
    }

    public boolean getAutoMovePort() {
        return this._autoMovePort;
    }

    public DBIcon getIcon() {
        return this._dbIcon;
    }

    public Collection<DBIcon> getSimuls() {
        return this._lstSimuls;
    }

    @Override
    public Collection<AltaFlow> getFlows() {
        return this._mapFlows.values();
    }

    public Collection<AltaState> getStates() {
        return this._mapStates.values();
    }

    public Collection<AltaEvent> getEvents() {
        return this._mapEvents.values();
    }

    @Override
    public Collection<AltaOperatorRef> getOperators() {
        return this._mapOperators.values();
    }

    @Override
    public String getCode() {
        return this._code;
    }

    @Override
    public SAXExtendedHandler getSAXHandler() {
        return this;
    }

    public AltaFlow getFlow(String name) {
        return this._mapFlows.get(name);
    }

    public void startAction(String key, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (this._eventHandler != null) {
            this._eventHandler.startAction(key, attrs, false);
        } else if (startAction) {
            if (!ELT_CEC_COMPONENT.equals(key)) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_START", ELT_CEC_COMPONENT), this.getLocator()));
            }
            this.readAttributesComponent(key, attrs);
        } else if ("alta.state".equals(key)) {
            AltaState state = this.readState(key, attrs);
            if (state != null) {
                String name = state.getName();
                if (this._mapStates.containsKey(name)) {
                    this.warning(new SAXParseException(ResMsgOcas.msgFormat("MSG_XML_COMPONENT_STATE_ALREADY", name), this.getLocator()));
                }
                this._mapStates.put(name, state);
            }
        } else if ("alta.event".equals(key)) {
            this._eventHandler = new DBAltaEventHandlerXml(this.getLogManager(), this.getLocator(), this._cecFactory, this);
            this._eventHandler.startAction(key, attrs, true);
        } else {
            this.startComponentAction(key, attrs, startAction);
        }
    }

    protected void startComponentAction(String key, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (ELT_ALTA_ICON.equals(key)) {
            DBIcon dbIcon = this.readIcon(key, attrs);
            if (dbIcon != null) {
                this._dbIcon = dbIcon;
            }
        } else if (ELT_ALTA_SIMUL.equals(key)) {
            DBIcon dbIcon = this.readIcon(key, attrs);
            if (dbIcon != null) {
                this._lstSimuls.add(dbIcon);
            }
        } else if ("alta.flow".equals(key)) {
            AltaFlow flow = this.readFlow(key, attrs);
            if (flow != null) {
                String name = flow.getName();
                if (this._mapFlows.containsKey(name)) {
                    this.warning(new SAXParseException(ResMsgOcas.msgFormat("MSG_XML_COMPONENT_FLOW_ALREADY", name), this.getLocator()));
                }
                this._mapFlows.put(name, flow);
            }
        } else {
            this.startNodeAction(key, attrs, startAction);
        }
    }

    protected void startNodeAction(String key, Map<String, String> attrs, boolean startAction) throws SAXException {
        if ("alta.operator.ref".equals(key)) {
            AltaOperatorRef operator = this.readOperatorRef(key, attrs);
            if (operator != null) {
                String name = operator.getName();
                if (this._mapOperators.containsKey(name)) {
                    this.warning(new SAXParseException(ResMsgOcas.msgFormat("MSG_XML_COMPONENT_OPERATOR_ALREADY", name), this.getLocator()));
                }
                this._mapOperators.put(name, operator);
            }
        } else if (!"alta.code".equals(key)) {
            this.errorElementUnknown(key);
        }
    }

    public DBIcon readIcon(String key, Map<String, String> attrs) throws SAXException {
        DBFolder dbFolder = this.readDBFolder(key, attrs, this._cecFactory.createFolderDAO(), "IMAGE_FAMILIES", true);
        if (dbFolder != null) {
            DBWrap dbWrap = this._cecFactory.findOrCreateWrap(dbFolder);
            if (dbWrap == null) {
                this.warning(new SAXParseException(ResMsgOcas.msgFormat("MSG_XML_ICON_READ", dbFolder.getRefPath()), this.getLocator()));
            } else {
                return (DBIcon)dbWrap;
            }
        }
        return null;
    }

    protected void readAttributesComponent(String key, Map<String, String> attrs) throws SAXException {
        String attr = attrs.get("width");
        if (attr == null || attr.isEmpty()) {
            this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", key, "width"), this.getLocator()));
        }
        int width = -1;
        try {
            width = Integer.parseInt(attr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (width < 0) {
            this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "width", attr), this.getLocator()));
            width = 10;
        }
        this._width = width;
        attr = attrs.get("height");
        if (attr == null || attr.isEmpty()) {
            this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", key, "height"), this.getLocator()));
        }
        int height = -1;
        try {
            height = Integer.parseInt(attr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (height < 0) {
            this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "height", attr), this.getLocator()));
            height = 10;
        }
        this._height = height;
        attr = attrs.get("text.position");
        NamePosition position = attr == null ? NamePosition.TOP : NamePosition.fromXML(attr);
        if (position == null) {
            this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "text.position", attr), this.getLocator()));
            position = NamePosition.TOP;
        }
        this._textPosition = position;
        attr = attrs.get(ATT_AUTO_MOVE);
        if (attr != null && !attr.isEmpty()) {
            boolean bValue = false;
            if (attr.equalsIgnoreCase("true")) {
                bValue = true;
            } else if (attr.equalsIgnoreCase("false")) {
                bValue = false;
            } else {
                this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, ATT_AUTO_MOVE, attr), this.getLocator()));
                bValue = false;
            }
            this._autoMovePort = bValue;
        }
        if ((attr = attrs.get(ATT_BORDER)) != null && !attr.isEmpty()) {
            boolean bValue = false;
            if (attr.equalsIgnoreCase("true")) {
                bValue = true;
            } else if (attr.equalsIgnoreCase("false")) {
                bValue = false;
            } else {
                this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, ATT_BORDER, attr), this.getLocator()));
                bValue = false;
            }
            this._drawBorder = bValue;
        }
    }

    public boolean endAction(String key, Map<String, String> attrs, String txt) throws SAXException {
        if (this._eventHandler != null) {
            return this.endEvent(key, attrs, txt);
        }
        if ("alta.code".equals(key)) {
            this._code = txt;
        }
        return ELT_CEC_COMPONENT.equals(key);
    }

    protected boolean endEvent(String key, Map<String, String> attrs, String txt) throws SAXException {
        boolean result = this._eventHandler.endAction(key, attrs, txt);
        if (result) {
            if ("alta.event".equals(key)) {
                AltaEvent event = this._eventHandler.getEvent();
                if (event != null) {
                    String name = event.getName();
                    if (this._mapEvents.containsKey(name)) {
                        this.warning(new SAXParseException(ResMsgOcas.msgFormat("MSG_XML_COMPONENT_EVENT_ALREADY", name), this.getLocator()));
                    }
                    this._mapEvents.put(name, event);
                }
            } else {
                _LOG.warning("Erreur interne \u00e0 la fermeture de l'\u00e9l\u00e9ment '" + key + "'");
            }
            this._eventHandler = null;
        }
        return false;
    }
}

