/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.component.pref;

import com.dassault.cecilia.core.cecilia.pref.PrefFieldBoolean;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldsCategory;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.mbsa.ResIcoOcas;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;

public class AltaContentDisplayPreferencies
extends PrefFieldsCategory {
    public static String PREF_KEY = AltaContentDisplayPreferencies.class.getName();
    public static final String PREF_AUTOMATIC_NUMEROTATION_SEPARATOR = "PREF_AUTOMATIC_NUMEROTATION_SEPARATOR";
    public static final int SEPARATOR_MAX_SIZE = 3;
    private static final String PATTERN_SEPARATOR_FORMAT = "^[A-Za-z_]{0,3}$";
    private static final Pattern PATTERN_SEPARATOR = Pattern.compile("^[A-Za-z_]{0,3}$");
    private JComboBox<LinkDisplay> _displayLinkCB;
    private LinkDisplay _valueLinkToDisplay;
    private JTextField _ctrlSeparator;
    private String _separatorValue;
    private static final String PREF_DISPLAY_LINK = "displayLinks";
    private static final int PREF_DISPLAY_LINK_DEFAULT = 0;
    private JPanel _prefsPanel;
    Border _ctrlSeparatorBorder = null;
    public static final String DISPLAY_PORTS_CODE = "displayPorts";
    public static final int BG_TYPE = 0;
    public static final int FG_TYPE = 1;
    public static final int RELATIVE_TYPE = 2;

    @Override
    public String getInfo(String key) {
        if ("plugin.key".equals(key)) {
            return PREF_KEY;
        }
        if ("plugin.key.path".equals(key)) {
            return "MBSA/DISPLAY";
        }
        if ("plugin.name".equals(key)) {
            return ResMsgOcas.getString("PREF_MBSA_TAB_CONTENT");
        }
        if ("plugin.title".equals(key)) {
            return ResMsgOcas.getString("PREF_MBSA_TAB_CONTENT");
        }
        if ("plugin.description".equals(key)) {
            return ResMsgOcas.getString("PREF_MBSA_TAB_CONTENT_DESCR");
        }
        return null;
    }

    @Override
    public Icon getIcon(String key) {
        return ResIcoOcas.getImageIcon("CMD_LINK_2POINT_V");
    }

    @Override
    protected JPanel makeContent() {
        if (this._prefsPanel == null) {
            this._prefsPanel = new JPanel(new GridBagLayout());
            JPanel linkPanel = new JPanel(new GridBagLayout());
            linkPanel.setBorder(BorderFactory.createTitledBorder(ResMsgOcas.getString("PREF_MBSA_TAB_CONTENT_LINKS")));
            JLabel linkLbl = new JLabel(ResMsgOcas.getString("PREF_MBSA_TAB_CONTENT_LINKS_TXT"));
            this._displayLinkCB = new JComboBox<LinkDisplay>(LinkDisplay.values());
            this._displayLinkCB.setSelectedItem((Object)this._valueLinkToDisplay);
            final ListCellRenderer<LinkDisplay> originalRenderer = this._displayLinkCB.getRenderer();
            this._displayLinkCB.setRenderer(new ListCellRenderer<LinkDisplay>(){

                @Override
                public Component getListCellRendererComponent(JList<? extends LinkDisplay> list, LinkDisplay value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel originalLabel = (JLabel)originalRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    originalLabel.setText(value.getRessource());
                    return originalLabel;
                }
            });
            linkPanel.add((Component)linkLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
            linkPanel.add(this._displayLinkCB, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
            linkPanel.add((Component)new JPanel(), new GridBagConstraints(2, 0, 1, 1, 100.0, 0.0, 13, 2, new Insets(0, 5, 5, 5), 0, 0));
            this._prefsPanel.add((Component)linkPanel, new GridBagConstraints(0, 0, 1, 1, 100.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
            this._prefsPanel.add(this.createSeparatorPanel(), new GridBagConstraints(0, 1, 1, 1, 100.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
            this._prefsPanel.add((Component)super.makeContent(), new GridBagConstraints(0, 2, 1, 1, 100.0, 100.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        return this._prefsPanel;
    }

    private Component createSeparatorPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this._ctrlSeparator = new JTextField(3);
        this._ctrlSeparator.setToolTipText(ResMsgOcas.getString("PREF_SEPARATOR_FORMAT_TOOLTIP"));
        this._ctrlSeparator.setText(this._separatorValue == null ? "" : this._separatorValue);
        this._ctrlSeparator.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (Character.isSpaceChar(e.getKeyChar())) {
                    e.consume();
                }
                if (AltaContentDisplayPreferencies.this._ctrlSeparator.getText().length() >= 3 && AltaContentDisplayPreferencies.this._ctrlSeparator.getSelectedText().length() == 0) {
                    e.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                AltaContentDisplayPreferencies.this.validateSeparatorTextField(AltaContentDisplayPreferencies.this._ctrlSeparator.getText());
            }
        });
        this._ctrlSeparator.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                String separatorText = AltaContentDisplayPreferencies.this._ctrlSeparator.getText();
                if (separatorText != null && !separatorText.equals("")) {
                    if (!PATTERN_SEPARATOR.matcher(separatorText).matches()) {
                        AltaContentDisplayPreferencies.this._ctrlSeparator.setText(AltaContentDisplayPreferencies.this._separatorValue);
                        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(AltaContentDisplayPreferencies.this._ctrlSeparator), ResMsgOcas.msgFormat("PREF_ERROR_MESS_SEPARATOR_FORMAT", separatorText));
                        AltaContentDisplayPreferencies.this.validateSeparatorTextField(AltaContentDisplayPreferencies.this._ctrlSeparator.getText());
                        AltaContentDisplayPreferencies.this._ctrlSeparator.requestFocus();
                    } else {
                        AltaContentDisplayPreferencies.this._separatorValue = separatorText;
                    }
                }
            }
        });
        panel.add((Component)new JLabel(ResMsgOcas.getString("PREF_SEPARATOR_LABEL")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this._ctrlSeparator, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        panel.setBorder(BorderFactory.createTitledBorder(ResMsgOcas.getString("PREF_SEPARATOR_TITLE_BORDER")));
        panel.add((Component)new JPanel(), new GridBagConstraints(2, 0, 1, 1, 100.0, 0.0, 13, 2, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private void validateSeparatorTextField(String stringToValidate) {
        if (!PATTERN_SEPARATOR.matcher(stringToValidate).matches()) {
            if (this._ctrlSeparatorBorder == null) {
                this._ctrlSeparatorBorder = this._ctrlSeparator.getBorder();
            }
            this._ctrlSeparator.setBorder(BorderFactory.createLineBorder(Color.red));
        } else if (this._ctrlSeparatorBorder != null) {
            this._ctrlSeparator.setBorder(this._ctrlSeparatorBorder);
        }
    }

    @Override
    public Component getPanel() {
        return this.makeContent();
    }

    @Override
    protected List<PrefFieldBoolean> createFields() {
        ArrayList<PrefFieldBoolean> listPrefs = new ArrayList<PrefFieldBoolean>();
        PrefFieldBoolean fieldBoolean = new PrefFieldBoolean(ResMsgOcas.getString("PREF_MBSA_TAB_CONTENT_PORTS_TXT"), DISPLAY_PORTS_CODE);
        listPrefs.add(fieldBoolean);
        return listPrefs;
    }

    @Override
    protected String getKey() {
        return PREF_KEY;
    }

    @Override
    protected void load(Plugable launcher) {
        super.load(launcher);
        int typeLinkDisplay = PlugableUtility.getIntOpt(launcher, PREF_DISPLAY_LINK, 0);
        if (typeLinkDisplay < 0) {
            typeLinkDisplay = 0;
        }
        this._valueLinkToDisplay = AltaContentDisplayPreferencies.getLinkDisplayFromType(typeLinkDisplay);
        if (this._displayLinkCB != null) {
            this._displayLinkCB.setSelectedItem((Object)this._valueLinkToDisplay);
        }
        this._separatorValue = PlugableUtility.getStrOpt(launcher, PREF_AUTOMATIC_NUMEROTATION_SEPARATOR, "");
        if (this._ctrlSeparator != null) {
            this._ctrlSeparator.setText(this._separatorValue);
        }
    }

    @Override
    protected void save(Plugable launcher) {
        launcher.setOption(PREF_AUTOMATIC_NUMEROTATION_SEPARATOR, this._separatorValue);
        LinkDisplay selectedDisplay = (LinkDisplay)((Object)this._displayLinkCB.getSelectedItem());
        launcher.setOption(PREF_DISPLAY_LINK, String.valueOf(selectedDisplay.getTypeFromLinkDisplay()));
        super.save(launcher);
    }

    public final LinkDisplay getLinkDisplayOptions() {
        return (LinkDisplay)((Object)this._displayLinkCB.getSelectedItem());
    }

    public static final LinkDisplay getLinkDisplayFromType(int type) {
        switch (type) {
            case 0: {
                return LinkDisplay.BG;
            }
            case 1: {
                return LinkDisplay.FG;
            }
            case 2: {
                return LinkDisplay.RELATIVE;
            }
        }
        assert (false);
        return null;
    }

    public final String getSeparator() {
        return this._separatorValue;
    }

    public static enum LinkDisplay {
        BG("PREF_MBSA_TAB_CONTENT_LINKS_BG"),
        FG("PREF_MBSA_TAB_CONTENT_LINKS_FG"),
        RELATIVE("PREF_MBSA_TAB_CONTENT_LINKS_SHEET");

        private final String _ress;

        private LinkDisplay(String ress) {
            this._ress = ress;
        }

        private final String getRessource() {
            return ResMsgOcas.getString(this._ress);
        }

        public final int getTypeFromLinkDisplay() {
            if (this == BG) {
                return 0;
            }
            if (this == FG) {
                return 1;
            }
            return 2;
        }
    }
}

