/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSub;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContent;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGroup;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaPort;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.lib.util.CopyUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class AltaClipboard {
    private static Logger _LOG = Logger.getLogger(AltaClipboard.class.getPackage().getName());
    ArrayList<AltaSub> _lstSub;
    List<AltaLink> _lstLinkPossible;
    List<AltaLink> _lstLink;
    AlgaContent _content;
    Map<DBFolder, Integer> _mapTranslate = new HashMap<DBFolder, Integer>();
    private static int DELTA_TRANSLATE = 20;

    public Collection<AltaSub> getSubs() {
        return this._lstSub;
    }

    public Collection<AltaLink> getLinks() {
        return this._lstLink;
    }

    public AlgaContent getContent() {
        return this._content;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("AltaClipboard(");
        sb.append("Sub[").append(this._lstSub.size()).append("]");
        if (!this._lstSub.isEmpty()) {
            sb.append("{");
            for (int i = 0; i < this._lstSub.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this._lstSub.get(i).getName());
            }
            sb.append("}");
        }
        sb.append(",Link[").append(this._lstLink.size()).append("]");
        sb.append(")");
        return sb.toString();
    }

    public boolean copyFrom(AltaEquipment source) {
        Object cpy;
        SelectCopyUtility util = new SelectCopyUtility();
        this._lstSub = new ArrayList(source.getSubs().size());
        for (AltaSub sub : source.getSubs()) {
            if (!util.selectForCopy(sub)) continue;
            cpy = sub.getCopy((CopyUtility)util);
            util.setRef(sub, cpy);
            this._lstSub.add((AltaSub)cpy);
        }
        this._lstLinkPossible = new ArrayList<AltaLink>(source.getLinks().size());
        for (AltaLink link : source.getLinks()) {
            if (!util.selectForCopy(link)) continue;
            cpy = link.getCopy((CopyUtility)util);
            util.setRef(link, cpy);
            this._lstLinkPossible.add((AltaLink)cpy);
        }
        this._lstLink = new ArrayList<AltaLink>(this._lstLinkPossible.size());
        this._content = source.getContent().getCopy((CopyUtility)util);
        this._mapTranslate.put(source.getDBFolder(), 1);
        return !this.isEmpty();
    }

    public boolean isEmpty() {
        if (!this._lstSub.isEmpty()) {
            return false;
        }
        if (!this._lstLink.isEmpty()) {
            return false;
        }
        for (AlgaSheet sheet : this._content.getSheets()) {
            if (sheet.getGraphs().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public int getTranslate(AltaEquipment node) {
        Integer nbr = this._mapTranslate.get(node.getDBFolder());
        if (nbr == null || nbr < 0) {
            this._mapTranslate.put(node.getDBFolder(), 1);
            return 0;
        }
        this._mapTranslate.put(node.getDBFolder(), nbr + 1);
        return DELTA_TRANSLATE * nbr;
    }

    private class SelectCopyUtility
    extends CopyUtility.Default {
        private SelectCopyUtility() {
        }

        public boolean selectForCopy(Object src) {
            if (src instanceof AltaSub) {
                if (((AltaSub)src).getGraphic() == null) {
                    _LOG.warning("Presence d'un sub sans lien graphique : " + ((AltaSub)src).getName());
                    return false;
                }
                return ((AltaSub)src).getGraphic().isSelected();
            }
            if (src instanceof AltaLink) {
                AltaLink link = (AltaLink)src;
                if (link.getFromSub() == null) {
                    return false;
                }
                if (!link.getFromSub().getGraphic().isSelected()) {
                    return false;
                }
                if (link.getToSub() == null) {
                    return false;
                }
                return link.getToSub().getGraphic().isSelected();
            }
            if (src instanceof AlgaSheet) {
                return ((AlgaSheet)src).isVisible();
            }
            if (src instanceof AlgaPort) {
                return false;
            }
            if (src instanceof AlgaLink) {
                AlgaLink link = (AlgaLink)src;
                if (!link.isSelected()) {
                    return false;
                }
                Object cpy = this.getRef(link.getLogical());
                if (cpy == null) {
                    return false;
                }
                if (!(cpy instanceof AltaLink)) {
                    _LOG.warning("InternalCopyError : Ref of link isn't a link " + link.getLogical() + " <> " + cpy);
                    return false;
                }
                AltaClipboard.this._lstLink.add((AltaLink)cpy);
                return true;
            }
            if (src instanceof AlgaGraph) {
                AlgaGraph grf = (AlgaGraph)src;
                if (grf.isSelected()) {
                    return true;
                }
                return grf.getParent() instanceof AlgaGroup;
            }
            return false;
        }
    }
}

