/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.graph;

import com.dassault.cecilia.dbobj.mbsa.component.gui.NamePosition;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContext;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaDraw;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.Pt;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditView;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentView;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.mouse.DelegateMouseLinkCreate;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.lib.util.CopyUtility;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;

public abstract class AlgaWithPorts
extends AlgaDraw {
    NamePosition _namePosition = NamePosition.TOP;
    Rectangle _textBounds = null;

    public NamePosition getNamePosition() {
        return this._namePosition;
    }

    public AlgaWithPorts setNamePosition(NamePosition namePosition) {
        this._namePosition = namePosition;
        return this;
    }

    @Override
    protected void copy(AlgaGraph grfsrc, boolean withDepth, CopyUtility util) {
        super.copy(grfsrc, withDepth, util);
        if (grfsrc instanceof AlgaWithPorts) {
            AlgaWithPorts src = (AlgaWithPorts)grfsrc;
            this._namePosition = src._namePosition;
        }
    }

    public abstract Pt getPoint(AltaFlow var1);

    public abstract AltaFlow getFlowAt(int var1, int var2);

    public Font getFont(AlgaContext context) {
        return context.getFont(null, 0, -1);
    }

    protected abstract String getLabel();

    protected abstract Color getColor(AlgaContext var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintLabel(Graphics g, AlgaContext context) {
        Font font = this.getFont(context);
        String name = this.getLabel();
        this.prepareTextBounds(g, font, name);
        Font oldFont = g.getFont();
        Color oldColor = g.getColor();
        try {
            g.setColor(this.getColor(context));
            g.setFont(font);
            g.drawString(name, this._textBounds.x, this._textBounds.y);
        }
        finally {
            g.setColor(oldColor);
            g.setFont(oldFont);
        }
    }

    private void prepareTextBounds(Graphics g, Font f, String name) {
        int y;
        int x;
        int h;
        int w;
        FontMetrics fmetrics = g.getFontMetrics(f);
        if (this.getTransform().isRotate()) {
            w = this.getH();
            h = this.getW();
        } else {
            w = this.getW();
            h = this.getH();
        }
        int wtext = fmetrics.stringWidth(name);
        int htext = fmetrics.getHeight();
        switch (this.getNamePosition()) {
            default: {
                x = this.getX() + w / 2 - wtext / 2;
                y = this.getY() - 5;
                break;
            }
            case BOTTOM: {
                x = this.getX() + w / 2 - wtext / 2;
                y = this.getY() + h + htext - fmetrics.getAscent() + 8;
                break;
            }
            case CENTER: {
                x = this.getX() + w / 2 - wtext / 2;
                y = this.getY() + (h + htext) / 2;
                break;
            }
            case RIGHT: {
                x = this.getX() + w + 5;
                y = this.getY() + (h + htext) / 2;
                break;
            }
            case LEFT: {
                x = this.getX() - wtext - 5;
                y = this.getY() + (h + htext) / 2;
            }
        }
        this._textBounds = new Rectangle(x, y, wtext, htext);
    }

    private Rectangle getTextBound() {
        return new Rectangle(this._textBounds.x, this._textBounds.y - this._textBounds.height, this._textBounds.width, this._textBounds.height);
    }

    public Rectangle getTextBounds(Graphics g) {
        Font f = new Font("Courier", 0, 12);
        String name = this.getLabel();
        this.prepareTextBounds(g, f, name);
        return this.getTextBound();
    }

    @Override
    public Rectangle getBounds(Graphics g) {
        Rectangle superBounds = super.getBounds(g);
        if (g != null) {
            Font f = new Font("Courier", 0, 12);
            String name = this.getLabel();
            this.prepareTextBounds(g, f, name);
            return superBounds.union(this.getTextBound());
        }
        return superBounds;
    }

    @Override
    public boolean contains(int x, int y) {
        Rectangle possible = new Rectangle(this.getSelectBounds());
        possible.grow(4, 4);
        return possible.contains(x, y);
    }

    @Override
    public AltaContentView.DelegateMouse getCtrlMouse(int x, int y, AltaContentView view) {
        AltaFlow flow = this.getFlowAt(x, y);
        if (flow != null && view instanceof AltaContentEditView) {
            return new DelegateMouseLinkCreate(this, flow, this.getPoint(flow));
        }
        return super.getCtrlMouse(x, y, view);
    }
}

