/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.table.TablePanel;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AlgaSheetTableModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

class AlgaSheetTablePanel
extends TablePanel {
    protected CeciliaAction _ctrlUp;
    protected CeciliaAction _ctrlDown;
    JButton _allVisibleButton;
    JButton _allInvisibleButton;

    public AlgaSheetTablePanel(Window window, AlgaSheetTableModel model) {
        super(window, model, true, true);
    }

    public JTable getTable() {
        return this._ctrlTable;
    }

    @Override
    protected AlgaSheetTableModel getTableModel() {
        return (AlgaSheetTableModel)super.getTableModel();
    }

    @Override
    protected void createActions() {
        super.createActions();
        this._ctrlUp = new CeciliaAction(ResIcoCore.getImageIcon("BUT_UP"), ResMsgVoc.getString("VOC_UP"), ResMsgCore.getString("ACTION_UP_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AlgaSheetTablePanel.this.getSelectedRowCount() > 0) {
                    AlgaSheetTablePanel.this.doUp();
                }
            }
        };
        this._ctrlDown = new CeciliaAction(ResIcoCore.getImageIcon("BUT_DOWN"), ResMsgVoc.getString("VOC_DOWN"), ResMsgCore.getString("ACTION_DOWN_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AlgaSheetTablePanel.this.getSelectedRowCount() > 0) {
                    AlgaSheetTablePanel.this.doDown();
                }
            }
        };
    }

    @Override
    protected JPopupMenu createMenuActions(JPopupMenu popupList) {
        super.createMenuActions(popupList);
        popupList.addSeparator();
        popupList.add(this._ctrlUp);
        popupList.add(this._ctrlDown);
        return popupList;
    }

    @Override
    protected void createToolBarActions(Container aPanel) {
        super.createToolBarActions(aPanel);
        aPanel.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        aPanel.add(this._ctrlUp.createButton(CeciliaAction.BorderStyle.LIGHT));
        aPanel.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        aPanel.add(this._ctrlDown.createButton(CeciliaAction.BorderStyle.LIGHT));
    }

    @Override
    protected JTable createCtrlCollection() {
        JTable table = super.createCtrlCollection();
        TableColumn column = null;
        block6: for (int i = 0; i < this.getTableModel().getColumnCount(); ++i) {
            column = table.getColumnModel().getColumn(i);
            switch (i) {
                case 0: {
                    column.setPreferredWidth(50);
                    continue block6;
                }
                case 1: {
                    column.setPreferredWidth(150);
                    continue block6;
                }
                case 2: {
                    column.setPreferredWidth(50);
                    continue block6;
                }
                case 3: {
                    column.setPreferredWidth(50);
                }
            }
        }
        table.setRowHeight(20);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable rendererTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(rendererTable, value, isSelected, hasFocus, row, column);
                if (value instanceof Integer) {
                    int i = (Integer)value;
                    if (i > 9) {
                        StringBuilder sb = new StringBuilder(32);
                        sb.append(i).append(" (").append((char)(65 + i - 10)).append(")");
                        this.setText(sb.toString());
                    } else {
                        this.setText(value.toString());
                    }
                }
                return this;
            }
        };
        renderer.setHorizontalAlignment(0);
        table.setDefaultRenderer(Integer.class, renderer);
        table.getSelectionModel().setSelectionMode(2);
        return table;
    }

    void setVisibleButtons(JButton allVisibleButton, JButton allInvisibleButton) {
        this._allVisibleButton = allVisibleButton;
        this._allInvisibleButton = allInvisibleButton;
    }

    @Override
    protected void refreshCtrl() {
        if (!this.isEnabled()) {
            this._ctrlAdd.setEnabled(false);
            this._ctrlDel.setEnabled(false);
            this._ctrlUp.setEnabled(false);
            this._ctrlDown.setEnabled(false);
            this._allInvisibleButton.setEnabled(false);
            this._allVisibleButton.setEnabled(false);
        } else {
            AlgaSheetTableModel model = this.getTableModel();
            this._ctrlAdd.setEnabled(!model.isReadOnly());
            int nbrSelect = this.getSelectedRowCount();
            boolean canDelete = false;
            boolean canUp = false;
            boolean canDown = false;
            if (nbrSelect > 0) {
                canDown = true;
                canUp = true;
                canDelete = true;
                int[] viewRows = this.getSelectedRows();
                for (int i = 0; i < nbrSelect; ++i) {
                    int modelRow = viewRows[i];
                    AlgaSheet sheet = (AlgaSheet)model.getItemAt(modelRow);
                    if (sheet.getGraphs().size() > 0 || sheet.isSelected()) {
                        canDelete = false;
                    }
                    if (modelRow == 0) {
                        canUp = false;
                    }
                    if (modelRow != model.getRowCount() - 1) continue;
                    canDown = false;
                }
            }
            this._ctrlDel.setEnabled(canDelete && !model.isReadOnly());
            this._ctrlUp.setEnabled(canUp);
            this._ctrlDown.setEnabled(canDown);
            if (this._allInvisibleButton != null) {
                int nbrVisible = 0;
                int nbrInvisible = 0;
                for (int i = model.getRowCount() - 1; i >= 0; --i) {
                    AlgaSheet sheet = (AlgaSheet)model.getItemAt(i);
                    if (sheet.isVisible()) {
                        ++nbrVisible;
                        continue;
                    }
                    ++nbrInvisible;
                }
                this._allInvisibleButton.setEnabled(nbrVisible > 1);
                this._allVisibleButton.setEnabled(nbrInvisible > 0);
            }
        }
    }

    @Override
    protected void addData(int idx) {
        int i;
        AlgaSheetTableModel model = this.getTableModel();
        if (model.getRowCount() >= 30) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.getString("ERR_SHEET_MAX"), ResMsgVoc.getString("VOC_LAYERS"), 0);
            return;
        }
        int number = 0;
        int flag = 0;
        for (i = model.getRowCount() - 1; i >= 0; --i) {
            flag |= 1 << ((AlgaSheet)model.getItemAt(i)).getNumber();
        }
        for (i = 1; i <= 30 && number == 0; ++i) {
            if ((flag & 1 << i) != 0) continue;
            number = i;
        }
        String name = ResMsgVoc.getString("VOC_LAYER") + " " + number;
        AlgaSheet sheet = new AlgaSheet(number, name, -1, false, true);
        model.addData(sheet);
    }

    @Override
    protected void delData(int[] viewRows) {
        int i;
        AlgaSheetTableModel model = this.getTableModel();
        ArrayList<AlgaSheet> delSheets = new ArrayList<AlgaSheet>(viewRows.length);
        for (i = 0; i < viewRows.length; ++i) {
            int modelRow = viewRows[i];
            AlgaSheet sheet = (AlgaSheet)model.getItemAt(modelRow);
            if (sheet.getGraphs().size() != 0) continue;
            delSheets.add(sheet);
        }
        for (i = delSheets.size() - 1; i >= 0; --i) {
            model.removeData(delSheets.get(i));
        }
    }

    protected void doUp() {
        int[] indices = this.getSelectedRows();
        if (indices.length == 0) {
            return;
        }
        this.getTableModel().up(indices);
        this._ctrlTable.clearSelection();
        for (int i = 0; i < indices.length; ++i) {
            this._ctrlTable.addRowSelectionInterval(indices[i], indices[i]);
        }
        this.refreshCtrl();
    }

    protected void doDown() {
        int[] indices = this.getSelectedRows();
        if (indices.length == 0) {
            return;
        }
        this.getTableModel().down(indices);
        this._ctrlTable.clearSelection();
        for (int i = 0; i < indices.length; ++i) {
            this._ctrlTable.addRowSelectionInterval(indices[i], indices[i]);
        }
        this.refreshCtrl();
    }
}

