/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions;

import com.dassault.cecilia.dbobj.mbsa.component.gui.AltaFlowPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaPort;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdDelete;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class OCmdDeletePorts
extends OCmdDelete {
    List<AltaFlow> _logicals;
    List<Integer> _indexes;
    AltaFlowPanel _flowPanel;
    LinkedHashSet<AlgaPort> _graphics;

    public OCmdDeletePorts(CeciliaAppl appl, AltaContentEditPanel contentPanel, AltaFlowPanel flowPanel, List<AltaFlow> ports) {
        super(appl, contentPanel);
        this.setSource(flowPanel);
        this._flowPanel = flowPanel;
        this._logicals = ports;
        this._graphics = new LinkedHashSet();
        for (int i = 0; i < this._logicals.size(); ++i) {
            AlgaPort port = this.getNode().getGraphic(this._logicals.get(i));
            if (port == null) continue;
            this._graphics.add(port);
        }
    }

    @Override
    protected boolean prepareDo() {
        if (!super.prepareDo() && !this.containsLocalPort()) {
            return false;
        }
        for (AlgaPort graph : this._graphics) {
            if ((graph.getFlag() & 4) == 0) continue;
            this._logicals.remove(graph.getFlow());
        }
        return this._logicals.size() > 0;
    }

    @Override
    protected void firstDo() {
        if (this._sheetsTransfom.size() > 0 || this._logicals.size() > 0) {
            this.redo();
            this.getPanel().addHisto(this);
        }
    }

    @Override
    protected void preparePort(AlgaPort graph) {
        if (!this._graphics.contains(graph)) {
            graph.setFlag(4);
        }
    }

    @Override
    protected boolean isSelectedGraph(AlgaGraph graph) {
        return this._graphics.contains(graph);
    }

    @Override
    protected boolean isLockedGraph(AlgaGraph graph) {
        if (this._graphics.contains(graph)) {
            return false;
        }
        return super.isLockedGraph(graph);
    }

    @Override
    public void redo() {
        super.redo();
        List<AltaFlow> flows = this.getNode().getFlows();
        this._indexes = new ArrayList<Integer>(this._logicals.size());
        for (int i = 0; i < this._logicals.size(); ++i) {
            int idx = flows.indexOf(this._logicals.get(i));
            flows.remove(idx);
            this._indexes.add(idx);
        }
        this._flowPanel.refreshTable();
    }

    @Override
    public void undo() {
        List<AltaFlow> flows = this.getNode().getFlows();
        for (int i = this._logicals.size() - 1; i >= 0; --i) {
            int idx = this._indexes.get(i);
            flows.add(idx, this._logicals.get(i));
        }
        super.undo();
        this._flowPanel.refreshTable();
    }

    private final boolean containsLocalPort() {
        boolean containsLocalPort = false;
        for (AltaFlow flow : this._logicals) {
            containsLocalPort |= flow.getOrientation() == AltaFlow.Orientation.LOCAL;
        }
        return containsLocalPort;
    }
}

