/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions;

import com.dassault.cecilia.dbobj.mbsa.equipment.AltaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCCmd;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OCmdLinkConvert
extends OCCmd {
    List<AlgaLink> _links = new ArrayList<AlgaLink>(16);
    List<AlgaSheet> _sheets = new ArrayList<AlgaSheet>(16);

    public OCmdLinkConvert(AltaContentEditPanel c) {
        super(c.getAppl(), c);
    }

    @Override
    protected boolean prepareDo() {
        List<AlgaSheet> sheets = this.getContent().getSheets();
        for (int i = sheets.size() - 1; i >= 0; --i) {
            AlgaSheet sheet = sheets.get(i);
            if (!sheet.isVisible()) continue;
            for (AlgaGraph graph : sheet.getGraphs()) {
                if (!graph.isSelected() || graph.isLocked() || !(graph instanceof AlgaLink)) continue;
                this._links.add((AlgaLink)graph);
                this._sheets.add(sheet);
            }
        }
        return this._links.size() > 0;
    }

    @Override
    protected void firstDo() {
        if (this._links.size() == 0) {
            return;
        }
        StringBuilder out = new StringBuilder(1024);
        out.append(this.getNode().getCode());
        if (out.length() == 0) {
            out.append(" assert\n");
        } else if (out.length() > 0 && out.charAt(out.length() - 1) != '\n') {
            out.append("\n");
        }
        for (int i = this._links.size() - 1; i >= 0; --i) {
            AlgaLink grf = this._links.get(i);
            AltaLink log = grf.getLogical();
            try {
                log.appendTo(out.append("  "));
                log.appendFrom(out.append(" = ")).append(" ;\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._sheets.get(i).remove(grf);
            this.getNode().delLink(log);
        }
        this.getNode().setCode(out.toString());
        ((AltaContentEditPanel)this.getPanel()).clearHisto();
        this.refreshAll();
    }

    @Override
    public void undo() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void redo() {
        throw new UnsupportedOperationException();
    }
}

