/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions;

import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSub;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaNode;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaWithPorts;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentView;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCCmd;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeEnum;
import com.dassault.cecilia.dbobj.mbsa.type.DBEnum;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecord;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecordField;
import com.dassault.cecilia.dbobj.mbsa.type.DBType;
import com.dassault.cecilia.lib.util.CopyUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;

public class OCmdLinkCreate
extends OCCmd {
    boolean _linkAtBackward;
    AlgaWithPorts _srcGrf;
    AlgaWithPorts _dstGrf;
    AltaFlow _srcFlow;
    AltaFlow _dstFlow;
    AltaLink _linkLog;
    AlgaLink _linkGrf;
    AlgaSheet _sheet;
    private static LinksDialog __DLG = null;

    public OCmdLinkCreate(AltaContentEditPanel c, boolean linkAtBackward) {
        super(c == null ? null : c.getAppl(), c);
        this._linkAtBackward = linkAtBackward;
    }

    public void setSource(AlgaWithPorts grf, AltaFlow flow) {
        this._srcGrf = grf;
        this._srcFlow = flow;
    }

    public void setDestination(AlgaWithPorts grf, AltaFlow flow) {
        this._dstGrf = grf;
        this._dstFlow = flow;
    }

    @Override
    protected boolean prepareDo() {
        boolean copie1924;
        AltaSub srcSub = null;
        if (this._srcGrf instanceof AlgaNode) {
            srcSub = ((AlgaNode)this._srcGrf).getLogical();
        }
        AltaSub dstSub = null;
        if (this._dstGrf instanceof AlgaNode) {
            dstSub = ((AlgaNode)this._dstGrf).getLogical();
        }
        boolean copie1892 = srcSub != null && srcSub.equals(dstSub) && !this._srcFlow.equals(this._dstFlow);
        boolean bl = copie1924 = srcSub != null && !srcSub.equals(dstSub);
        if ((copie1892 || copie1924) && this._srcFlow.getOrientation() == AltaFlow.Orientation.IN && this._dstFlow.getOrientation() == AltaFlow.Orientation.IN && this._srcFlow.getType().equals(this._dstFlow.getType()) && (!this._srcFlow.isRecord() || !((DBRecord)this._srcFlow.getType()).hasInverseField()) && this.prepareCopyLink(srcSub, this._srcFlow, dstSub, this._dstFlow, false)) {
            return true;
        }
        AltaLink link = OCmdLinkCreate.selectValidLink(this.getView(), this.getNode(), srcSub, this._srcFlow, dstSub, this._dstFlow);
        if (link == null) {
            return false;
        }
        this._linkLog = link;
        this._linkGrf = new AlgaLink().setLogical(this._linkLog);
        this._sheet = this.getNode().getContent().getCurrentSheet();
        return true;
    }

    private boolean prepareCopyLink(AltaSub srcSub, AltaFlow srcFlow, AltaSub dstSub, AltaFlow dstFlow, boolean reverse) {
        AltaLink srcLink = null;
        for (AltaLink altaLink : this.getNode().getLinks()) {
            if (!srcSub.equals(altaLink.getToSub()) || !srcFlow.equals(altaLink.getToFlow())) continue;
            if (srcLink == null) {
                srcLink = altaLink;
                continue;
            }
            srcLink = null;
            break;
        }
        if (srcLink == null) {
            if (!reverse) {
                return this.prepareCopyLink(dstSub, dstFlow, srcSub, srcFlow, true);
            }
        } else {
            AltaLink dstLink = null;
            for (AltaLink link : this.getNode().getLinks()) {
                if (!dstSub.equals(link.getToSub()) || !dstFlow.equals(link.getToFlow())) continue;
                dstLink = link;
                break;
            }
            if (dstLink == null) {
                this._linkLog = new AltaLink(srcLink.getFromSub(), srcLink.getFromFlow(), dstSub, dstFlow);
                this._linkLog.setFromField(srcLink.getFromField());
                this._linkLog.setToField(srcLink.getToField());
                this._linkGrf = null;
                List<AlgaSheet> list = this.getNode().getContent().getSheets();
                block2: for (int i = list.size() - 1; i >= 0 && this._linkGrf == null; --i) {
                    AlgaSheet sheet = list.get(i);
                    for (AlgaGraph graph : sheet.getGraphs()) {
                        AlgaLink algaLink;
                        if (!(graph instanceof AlgaLink) || (algaLink = (AlgaLink)graph).getLogical() != srcLink) continue;
                        this._linkGrf = algaLink.getCopy(true, (CopyUtility)new CopyUtility.ByPass());
                        this._linkGrf.setLogical(this._linkLog);
                        if (sheet.isVisible()) {
                            this._sheet = sheet;
                            continue block2;
                        }
                        this._sheet = this.getNode().getContent().getCurrentSheet();
                        continue block2;
                    }
                }
                if (this._linkGrf == null) {
                    this._linkGrf = new AlgaLink().setLogical(this._linkLog);
                    this._sheet = this.getNode().getContent().getCurrentSheet();
                }
                return true;
            }
        }
        return false;
    }

    private static boolean subEquals(AltaSub from, AltaSub to) {
        if (from == null) {
            return to == null;
        }
        return from.equals(to);
    }

    private static AltaFlow.Orientation getOrientation(AltaSub sub, AltaFlow flow) {
        if (sub == null) {
            switch (flow.getOrientation()) {
                case OUT: {
                    return AltaFlow.Orientation.IN;
                }
                case IN: {
                    return AltaFlow.Orientation.OUT;
                }
                case LOCAL: {
                    return AltaFlow.Orientation.LOCAL;
                }
            }
        }
        return flow.getOrientation();
    }

    public static AltaLink selectInitialValidLink(AltaContentView view, Set<FieldIdentifier> flowsOnUse, AltaSub fromSub, AltaFlow fromFlow, AltaSub toSub, AltaFlow toFlow, boolean withMsg) {
        AltaLink link = new AltaLink(fromSub, fromFlow, toSub, toFlow);
        if (OCmdLinkCreate.subEquals(fromSub, toSub) && fromFlow.equals(toFlow)) {
            return null;
        }
        if (!OCmdLinkCreate.canCreateALink(flowsOnUse, fromSub, toSub, fromFlow, toFlow)) {
            if (withMsg) {
                String flowName;
                String subName = null;
                if (OCmdLinkCreate.getOrientation(fromSub, fromFlow) == AltaFlow.Orientation.IN) {
                    flowName = fromFlow.getName();
                    if (fromSub != null) {
                        subName = fromSub.getName();
                    }
                } else {
                    flowName = toFlow.getName();
                    if (toSub != null) {
                        subName = toSub.getName();
                    }
                }
                String msg = "";
                msg = subName == null ? ResMsgOcas.msgFormat("MSG_XML_COMPONENT_LINK_FLOW_FULL_EQP", flowName, subName) : ResMsgOcas.msgFormat("MSG_XML_COMPONENT_LINK_FLOW_FULL", flowName, subName);
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(view), msg, JOptionCecilia.getTopTitleOf(view), 0);
            }
            return null;
        }
        return link;
    }

    protected static Map<DBRecordField, List<DBRecordField>> findCoherentLinks(Set<FieldIdentifier> flowsOnUse, AltaSub fromSub, AltaFlow fromFlow, AltaSub toSub, AltaFlow toFlow) {
        LinkedHashMap<DBRecordField, List<DBRecordField>> mapRecToSetRec = new LinkedHashMap<DBRecordField, List<DBRecordField>>();
        if (fromFlow.isRecord() && toFlow.isRecord()) {
            DBRecord record1 = (DBRecord)fromFlow.getType();
            DBRecord record2 = (DBRecord)toFlow.getType();
            AltaFlow.Orientation orienFlow1 = OCmdLinkCreate.getOrientation(fromSub, fromFlow);
            AltaFlow.Orientation orienFlow2 = OCmdLinkCreate.getOrientation(toSub, toFlow);
            LinkedHashSet<DBRecordField> setFieldIn1 = new LinkedHashSet<DBRecordField>();
            LinkedHashSet<DBRecordField> setFieldIn2 = new LinkedHashSet<DBRecordField>();
            LinkedHashSet<DBRecordField> setFieldOut1 = new LinkedHashSet<DBRecordField>();
            LinkedHashSet<DBRecordField> setFieldOut2 = new LinkedHashSet<DBRecordField>();
            OCmdLinkCreate.getFillSetInputsOutputs_utility(flowsOnUse, setFieldIn1, setFieldOut1, record1, orienFlow1, fromSub, fromFlow);
            OCmdLinkCreate.getFillSetInputsOutputs_utility(flowsOnUse, setFieldIn2, setFieldOut2, record2, orienFlow2, toSub, toFlow);
            OCmdLinkCreate.fillMap_utility(mapRecToSetRec, setFieldIn1, setFieldOut2);
            OCmdLinkCreate.fillMap_utility(mapRecToSetRec, setFieldOut1, setFieldIn2);
        } else if (!fromFlow.isRecord()) {
            if (!toFlow.isRecord()) {
                return null;
            }
            OCmdLinkCreate.fillMap_utility(flowsOnUse, mapRecToSetRec, toFlow, fromFlow, toSub, fromSub, true);
            if (mapRecToSetRec.isEmpty()) {
                return null;
            }
        } else if (!toFlow.isRecord()) {
            if (!fromFlow.isRecord()) {
                return null;
            }
            OCmdLinkCreate.fillMap_utility(flowsOnUse, mapRecToSetRec, fromFlow, toFlow, fromSub, toSub, false);
            if (mapRecToSetRec.isEmpty()) {
                return null;
            }
        }
        return mapRecToSetRec;
    }

    private static synchronized LinksDialog createAndConfigDialog(Component component, LinksTableModel model) {
        if (__DLG == null) {
            __DLG = new LinksDialog(JOptionCecilia.getWindowOf(component));
            __DLG.setModelLink(model);
            __DLG.pack();
            __DLG.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(component));
            return __DLG;
        }
        __DLG.setModelLink(model);
        return __DLG;
    }

    public static AltaLink selectValidLink(AltaContentView view, AltaEquipment eqp, AltaSub fromSub, AltaFlow fromFlow, AltaSub toSub, AltaFlow toFlow) {
        Set<FieldIdentifier> flowsOnUse = OCmdLinkCreate.getFlowsOnUse(eqp, fromSub, toSub, fromFlow, toFlow);
        AltaLink link = OCmdLinkCreate.selectInitialValidLink(view, flowsOnUse, fromSub, fromFlow, toSub, toFlow, true);
        if (link == null) {
            return null;
        }
        if (link.verify() && OCmdLinkCreate.sameTypeButFieldsUsed(flowsOnUse, fromSub, fromFlow, toSub, toFlow)) {
            return link;
        }
        Map<DBRecordField, List<DBRecordField>> coherentFields = OCmdLinkCreate.findCoherentLinks(flowsOnUse, fromSub, fromFlow, toSub, toFlow);
        if (coherentFields != null && !coherentFields.isEmpty()) {
            LinksTableModel tm = new LinksTableModel(fromSub == null ? fromFlow.getName() : fromSub.getName() + (fromFlow.isRecord() ? "." + fromFlow.getName() : ""), toSub == null ? toFlow.getName() : toSub.getName() + (toFlow.isRecord() ? "." + toFlow.getName() : ""));
            tm.addValues(coherentFields);
            LinksDialog dlg = OCmdLinkCreate.createAndConfigDialog(view, tm);
            dlg.openWindow(view);
            if (!dlg.getResult()) {
                return null;
            }
            DBRecordField[] select = dlg.getSelect();
            if (select == null) {
                return null;
            }
            link = new AltaLink(fromSub, fromFlow, toSub, toFlow);
            if (fromFlow.isRecord()) {
                if (toFlow.isRecord()) {
                    link.setFromField(select[0]);
                    link.setToField(select[1]);
                } else {
                    link.setFromField(select[0]);
                }
            } else if (toFlow.isRecord()) {
                link.setToField(select[1]);
            }
            if (link.verify()) {
                return link;
            }
        }
        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(view), ResMsgOcas.msgFormat("MSG_XML_COMPONENT_LINK_INVALID", link), UIManager.getString("OptionPane.messageDialogTitle"), 0);
        return null;
    }

    @Override
    protected void firstDo() {
        this.redo();
        this.getPanel().addHisto(this);
    }

    @Override
    public void redo() {
        this.getNode().addLink(this._linkLog);
        this._linkGrf.computeControlPoints();
        if (this._linkAtBackward) {
            this._sheet.add(this._linkGrf, -1);
        } else {
            this._sheet.add(this._linkGrf, Integer.MAX_VALUE);
        }
        this.getContent().changeSelectGraphs(null, false);
        this._linkGrf.setSelected(true);
        this.refreshAll();
    }

    @Override
    public void undo() {
        this._sheet.remove(this._linkGrf);
        this.getNode().delLink(this._linkLog);
        this.refreshAll();
    }

    private static boolean canCreateALink(Set<FieldIdentifier> flowsOnUse, AltaSub sub1, AltaSub sub2, AltaFlow flow1, AltaFlow flow2) {
        AltaFlow.Orientation orienFlow1 = OCmdLinkCreate.getOrientation(sub1, flow1);
        AltaFlow.Orientation orienFlow2 = OCmdLinkCreate.getOrientation(sub2, flow2);
        if (!flow1.isRecord() && !flow2.isRecord()) {
            if (orienFlow1 == orienFlow2) {
                return true;
            }
            if (!flow1.getType().equivalents(flow2.getType())) {
                return true;
            }
            if (orienFlow1 == AltaFlow.Orientation.IN) {
                return !flowsOnUse.contains(new FieldIdentifier(sub1, flow1));
            }
            return !flowsOnUse.contains(new FieldIdentifier(sub2, flow2));
        }
        if (!flow1.isRecord() || !flow2.isRecord()) {
            AltaFlow.Orientation orientSimple;
            AltaFlow flowSimple;
            AltaFlow flowRecord;
            AltaSub sub;
            if (flow1.isRecord()) {
                sub = sub1;
                flowRecord = flow1;
                flowSimple = flow2;
                orientSimple = OCmdLinkCreate.getOrientation(sub2, flow2);
            } else {
                sub = sub2;
                flowRecord = flow2;
                flowSimple = flow1;
                orientSimple = OCmdLinkCreate.getOrientation(sub1, flow1);
            }
            AltaType typeSimple = flowSimple.getType();
            AltaFlow.Orientation orientRecord = OCmdLinkCreate.getOrientation(sub, flowRecord);
            DBRecord typeRecord = (DBRecord)flowRecord.getType();
            if (orientSimple == AltaFlow.Orientation.IN) {
                if (flowsOnUse.contains(new FieldIdentifier(sub, flowSimple))) {
                    return false;
                }
                for (int i = 0; i < typeRecord.getValueCount(); ++i) {
                    DBRecordField field = typeRecord.getFieldAt(i);
                    if (OCmdLinkCreate.isAnInput(field, orientRecord) || !field.getType().equivalents(typeSimple)) continue;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < typeRecord.getValueCount(); ++i) {
                DBRecordField field = typeRecord.getFieldAt(i);
                if (!OCmdLinkCreate.isAnInput(field, orientRecord) || flowsOnUse.contains(new FieldIdentifier(sub, flowRecord, field)) || !field.getType().equivalents(typeSimple)) continue;
                return true;
            }
            return false;
        }
        DBRecord record1 = (DBRecord)flow1.getType();
        DBRecord record2 = (DBRecord)flow2.getType();
        AltaSub sub = orienFlow1 == AltaFlow.Orientation.IN ? sub1 : sub2;
        AltaFlow flow = orienFlow1 == AltaFlow.Orientation.IN ? flow1 : flow2;
        DBRecord record = orienFlow1 == AltaFlow.Orientation.IN ? record1 : record2;
        boolean isAnInputWithInversedFields = false;
        for (int i = 0; i < record.getValueCount(); ++i) {
            DBRecordField field = record.getFieldAt(i);
            if (field.getDirection() != DBRecordField.Direction.INVERSE) continue;
            isAnInputWithInversedFields = true;
            break;
        }
        if (flowsOnUse.contains(new FieldIdentifier(sub, flow)) && !isAnInputWithInversedFields) {
            return false;
        }
        Map<AltaType, SetOutputToInput> mapFields1 = OCmdLinkCreate.createMapTypeToOutputsInputs_utility(flowsOnUse, sub1, flow1, record1, orienFlow1);
        Map<AltaType, SetOutputToInput> mapFields2 = OCmdLinkCreate.createMapTypeToOutputsInputs_utility(flowsOnUse, sub2, flow2, record2, orienFlow2);
        LinkedHashSet<AltaType> typeAlreadyEncountered = new LinkedHashSet<AltaType>();
        LinkedHashSet<AltaType> allTypes = new LinkedHashSet<AltaType>();
        allTypes.addAll(mapFields1.keySet());
        allTypes.addAll(mapFields2.keySet());
        for (AltaType type : allTypes) {
            if (typeAlreadyEncountered.contains(type)) continue;
            SetOutputToInput list1 = mapFields1.get(type);
            SetOutputToInput list2 = mapFields2.get(type);
            if (type instanceof DBEnum || type instanceof AltaTypeEnum) {
                for (AltaType typeToAdd : allTypes) {
                    if (!typeToAdd.equivalents(type) || typeToAdd == type) continue;
                    SetOutputToInput listToAdd1 = mapFields1.get(typeToAdd);
                    SetOutputToInput listToAdd2 = mapFields2.get(typeToAdd);
                    if (list1 != null) {
                        list1.addAll(listToAdd1);
                    } else {
                        list1 = listToAdd1;
                    }
                    if (list2 != null) {
                        list2.addAll(listToAdd2);
                    } else {
                        list2 = listToAdd2;
                    }
                    typeAlreadyEncountered.add(typeToAdd);
                }
            }
            if (list1 == null || list2 == null || (list1.getInputs().isEmpty() || list2.getOutputs().isEmpty()) && (list1.getOutputs().isEmpty() || list2.getInputs().isEmpty())) continue;
            return true;
        }
        return false;
    }

    protected static final boolean sameTypeButFieldsUsed(Set<FieldIdentifier> flowsOnUse, AltaSub fromSub, AltaFlow fromFlow, AltaSub toSub, AltaFlow toFlow) {
        if (!fromFlow.getType().equals(toFlow.getType()) || !(fromFlow.getType() instanceof DBType)) {
            return true;
        }
        AltaFlow.Orientation ori1 = OCmdLinkCreate.getOrientation(fromSub, fromFlow);
        AltaFlow.Orientation ori2 = OCmdLinkCreate.getOrientation(toSub, toFlow);
        if (fromFlow.getType() instanceof DBRecord) {
            DBRecord record1 = (DBRecord)fromFlow.getType();
            DBRecord record2 = (DBRecord)toFlow.getType();
            for (int i = 0; i < record1.getValueCount(); ++i) {
                DBRecordField field1 = record1.getFieldAt(i);
                DBRecordField field2 = record2.getFieldAt(i);
                if (!OCmdLinkCreate.isAnInputNotUsed(flowsOnUse, fromSub, fromFlow, field1, ori1) && !OCmdLinkCreate.isAnInputNotUsed(flowsOnUse, toSub, toFlow, field2, ori2)) continue;
                return false;
            }
        } else {
            for (FieldIdentifier obj : flowsOnUse) {
                AltaFlow flow;
                if (!(obj instanceof AltaFlow) || (flow = (AltaFlow)((Object)obj)) != fromFlow && flow != toFlow) continue;
                return false;
            }
        }
        return true;
    }

    public static final Set<FieldIdentifier> getFlowsOnUse(AltaEquipment eqp, AltaSub sub1, AltaSub sub2, AltaFlow flow1, AltaFlow flow2) {
        ArrayList<AltaLink> links = new ArrayList<AltaLink>();
        for (AltaLink link : eqp.getLinks()) {
            AltaSub toSub = link.getToSub();
            AltaSub fromSub = link.getFromSub();
            AltaFlow toFlow = link.getToFlow();
            AltaFlow fromFlow = link.getFromFlow();
            if (!(sub1 == toSub && flow1.equals(toFlow) || sub1 == fromSub && flow1.equals(fromFlow) || sub2 == toSub && flow2.equals(toFlow)) && (sub2 != fromSub || !flow2.equals(fromFlow))) continue;
            links.add(link);
        }
        return OCmdLinkCreate.getFlowsOnUse(eqp, links);
    }

    private static final Set<FieldIdentifier> getFlowsOnUse(AltaEquipment eqp, List<AltaLink> links) {
        LinkedHashSet<FieldIdentifier> flowOnUse = new LinkedHashSet<FieldIdentifier>();
        for (AltaLink link : eqp.getLinks()) {
            AltaSub toSub = link.getToSub();
            AltaSub fromSub = link.getFromSub();
            AltaFlow toFlow = link.getToFlow();
            AltaFlow fromFlow = link.getFromFlow();
            DBRecordField toField = link.getToField();
            DBRecordField fromField = link.getFromField();
            if (toField != null && OCmdLinkCreate.isAnInput(toField, OCmdLinkCreate.getOrientation(toSub, toFlow))) {
                flowOnUse.add(new FieldIdentifier(toSub, toFlow, toField));
                continue;
            }
            if (fromField != null && OCmdLinkCreate.isAnInput(fromField, OCmdLinkCreate.getOrientation(fromSub, fromFlow))) {
                flowOnUse.add(new FieldIdentifier(fromSub, fromFlow, fromField));
                continue;
            }
            if (OCmdLinkCreate.getOrientation(toSub, toFlow) == AltaFlow.Orientation.IN) {
                OCmdLinkCreate.getFlowsOnUse_utility(flowOnUse, fromSub, fromFlow, fromField, toSub, toFlow, toField);
                continue;
            }
            OCmdLinkCreate.getFlowsOnUse_utility(flowOnUse, toSub, toFlow, toField, fromSub, fromFlow, fromField);
        }
        return flowOnUse;
    }

    private static void getFlowsOnUse_utility(Set<FieldIdentifier> flowOnUse, AltaSub fromSub, AltaFlow fromFlow, DBRecordField fromField, AltaSub toSub, AltaFlow toFlow, DBRecordField toField) {
        if (toFlow.isRecord() && toField == null) {
            DBRecordField current;
            int i;
            flowOnUse.add(new FieldIdentifier(toSub, toFlow, toField));
            DBRecord type = (DBRecord)toFlow.getType();
            for (i = 0; i < type.getValueCount(); ++i) {
                current = type.getFieldAt(i);
                if (current.getDirection() != DBRecordField.Direction.NORMAL) continue;
                flowOnUse.add(new FieldIdentifier(toSub, toFlow, current));
            }
            if (fromFlow.isRecord()) {
                type = (DBRecord)fromFlow.getType();
                for (i = 0; i < type.getValueCount(); ++i) {
                    current = type.getFieldAt(i);
                    if (current.getDirection() != DBRecordField.Direction.INVERSE) continue;
                    flowOnUse.add(new FieldIdentifier(fromSub, fromFlow, current));
                }
            }
        } else {
            flowOnUse.add(new FieldIdentifier(toSub, toFlow, toField));
        }
    }

    private static final void getFillSetInputsOutputs_utility(Set<FieldIdentifier> flowsOnUse, Set<DBRecordField> setIn, Set<DBRecordField> setOut, DBRecord record, AltaFlow.Orientation orientation, AltaSub sub, AltaFlow flow) {
        for (int i = 0; i < record.getValueCount(); ++i) {
            DBRecordField field = record.getFieldAt(i);
            if (OCmdLinkCreate.isAnInput(field, orientation)) {
                if (flowsOnUse.contains(new FieldIdentifier(sub, flow, field)) || flowsOnUse.contains(new FieldIdentifier(sub, flow))) continue;
                setIn.add(field);
                continue;
            }
            setOut.add(field);
        }
    }

    private static final void fillMap_utility(Set<FieldIdentifier> flowsOnUse, Map<DBRecordField, List<DBRecordField>> mapToFill, AltaFlow flow1, AltaFlow flow2, AltaSub sub1, AltaSub sub2, boolean isSub1) {
        LinkedHashSet<FieldIdentifier> goodFields = new LinkedHashSet<FieldIdentifier>();
        DBRecord toRecord = (DBRecord)flow1.getType();
        for (int i = 0; i < toRecord.getValueCount(); ++i) {
            boolean goodOrientation;
            DBRecordField toField = toRecord.getFieldAt(i);
            if (!flow2.getType().equivalents(toField.getType())) continue;
            boolean bl = goodOrientation = !OCmdLinkCreate.getOrientation(sub2, flow2).equals((Object)OCmdLinkCreate.getOrientation(sub1, flow1));
            if (toField.getDirection() == DBRecordField.Direction.INVERSE) {
                boolean bl2 = goodOrientation = !goodOrientation;
            }
            if (!goodOrientation) continue;
            goodFields.add(new FieldIdentifier(sub1, flow1, toField));
        }
        goodFields.removeAll(flowsOnUse);
        if (goodFields.isEmpty()) {
            return;
        }
        if (isSub1) {
            ArrayList<DBRecordField> fields = new ArrayList<DBRecordField>();
            for (FieldIdentifier subField : goodFields) {
                fields.add(subField.getField());
            }
            mapToFill.put(new DBRecordField(flow2.getName(), flow2.getType()), fields);
        } else {
            List<DBRecordField> toFields = Collections.singletonList(new DBRecordField(flow2.getName(), flow2.getType()));
            for (FieldIdentifier fromField : goodFields) {
                mapToFill.put(fromField.getField(), toFields);
            }
        }
    }

    private static final void fillMap_utility(Map<DBRecordField, List<DBRecordField>> mapToFill, Set<DBRecordField> set1, Set<DBRecordField> set2) {
        for (DBRecordField field : set1) {
            ArrayList<DBRecordField> fields = new ArrayList<DBRecordField>();
            for (DBRecordField tmpField : set2) {
                if (!tmpField.getType().equivalents(field.getType())) continue;
                fields.add(tmpField);
            }
            if (fields.isEmpty()) continue;
            mapToFill.put(field, fields);
        }
    }

    private static final Map<AltaType, SetOutputToInput> createMapTypeToOutputsInputs_utility(Set<FieldIdentifier> flowsOnUse, AltaSub sub, AltaFlow flow, DBRecord record, AltaFlow.Orientation orient) {
        LinkedHashMap<AltaType, SetOutputToInput> mapToFill = new LinkedHashMap<AltaType, SetOutputToInput>();
        for (int i = 0; i < record.getValueCount(); ++i) {
            DBRecordField field = record.getFieldAt(i);
            AltaType type = field.getType();
            if (mapToFill.get(type) == null) {
                mapToFill.put(type, new SetOutputToInput());
            }
            SetOutputToInput lists = (SetOutputToInput)mapToFill.get(type);
            if (OCmdLinkCreate.isAnInput(field, orient)) {
                if (flowsOnUse.contains(new FieldIdentifier(sub, flow, field)) || flowsOnUse.contains(new FieldIdentifier(sub, flow))) continue;
                lists.addInput(field);
                continue;
            }
            lists.addOutput(field);
        }
        return mapToFill;
    }

    private static final boolean isAnInput(DBRecordField field, AltaFlow.Orientation orient) {
        return orient == AltaFlow.Orientation.IN && field.getDirection() == DBRecordField.Direction.NORMAL || orient == AltaFlow.Orientation.OUT && field.getDirection() == DBRecordField.Direction.INVERSE;
    }

    private static final boolean isAnInputNotUsed(Set<FieldIdentifier> flowsOnUse, AltaSub sub, AltaFlow flow, DBRecordField field, AltaFlow.Orientation orient) {
        return OCmdLinkCreate.isAnInput(field, orient) && (flowsOnUse.contains(new FieldIdentifier(sub, flow, field)) || flowsOnUse.contains(new FieldIdentifier(sub, flow)));
    }

    private static class LinksTableModel
    extends DefaultTableModel {
        private final String _title1;
        private final String _title2;

        public LinksTableModel(String title1, String title2) {
            this._title1 = title1;
            this._title2 = title2;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return this._title1;
                }
                case 1: {
                    return this._title2;
                }
            }
            assert (false);
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return Object.class;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public void addValues(Map<DBRecordField, List<DBRecordField>> mapRecordsAssociated) {
            for (Map.Entry<DBRecordField, List<DBRecordField>> entry : mapRecordsAssociated.entrySet()) {
                DBRecordField record = entry.getKey();
                List<DBRecordField> listRecords = entry.getValue();
                for (DBRecordField recordAssociated : listRecords) {
                    this.addRow(new DBRecordField[]{record, recordAssociated});
                }
            }
        }
    }

    private static class LinksDialog
    extends JDialogCecilia {
        private final JTable _table = new JTable();

        public LinksDialog(Window window) {
            super(window, true);
            this._table.setRowSelectionAllowed(true);
            this._table.setSelectionMode(0);
            this._table.setPreferredScrollableViewportSize(new Dimension(300, 100));
            this._table.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() != 2) {
                        return;
                    }
                    if (!SwingUtilities.isLeftMouseButton(e)) {
                        return;
                    }
                    this.validDialog();
                }
            });
            JPanel panel = new JPanel(new GridBagLayout());
            JLabel label = new JLabel(ResMsgOcas.getString("MSG_XML_COMPONENT_LINK_SELECT_LINK"));
            panel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 100.0, 0.0, 11, 2, new Insets(5, 5, 0, 0), 0, 0));
            JScrollPane pane = new JScrollPane(this._table);
            panel.add((Component)pane, new GridBagConstraints(0, 1, 1, 1, 100.0, 100.0, 15, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)panel, "Center");
            this.getContentPane().add((Component)this.createButPanel(false), "South");
            this.init();
        }

        public void setModelLink(LinksTableModel model) {
            this._table.setModel(model);
        }

        @Override
        protected boolean verifyParameters() {
            int rowSelected = this._table.getSelectedRow();
            return rowSelected != -1;
        }

        @Override
        public String getTitle() {
            return ResMsgOcas.getString("TITLE_ALTA_CREATE_TYPE");
        }

        public void openWindow(Component component) {
            if (this._table.getRowCount() == 1) {
                this._table.selectAll();
                this._ctrlOK.requestFocus();
            }
            this.setVisible(true);
        }

        public DBRecordField[] getSelect() {
            DBRecordField[] fields = new DBRecordField[2];
            int rowSelected = this._table.getSelectedRow();
            if (rowSelected == -1) {
                return null;
            }
            fields[0] = (DBRecordField)this._table.getValueAt(rowSelected, 0);
            fields[1] = (DBRecordField)this._table.getValueAt(rowSelected, 1);
            return fields;
        }
    }

    public static class FieldIdentifier {
        private final AltaSub _sub;
        private final AltaFlow _flow;
        private DBRecordField _field;

        public FieldIdentifier(AltaSub sub, AltaFlow flow, DBRecordField field) {
            this(sub, flow);
            this._field = field;
        }

        public FieldIdentifier(AltaSub sub, AltaFlow flow) {
            this._sub = sub;
            this._flow = flow;
        }

        public final AltaSub getSub() {
            return this._sub;
        }

        public final AltaFlow getFlow() {
            return this._flow;
        }

        public final DBRecordField getField() {
            return this._field;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof FieldIdentifier)) {
                return false;
            }
            FieldIdentifier other = (FieldIdentifier)obj;
            if (!OCmdLinkCreate.subEquals(this.getSub(), other.getSub())) {
                return false;
            }
            if (!this.getFlow().equals(other.getFlow())) {
                return false;
            }
            if (this.getField() == null) {
                return other.getField() == null;
            }
            return this.getField().equals(other.getField());
        }

        public int hashCode() {
            int hash = this._flow.hashCode();
            if (this._sub != null) {
                hash = hash * 3 + this._sub.hashCode();
            }
            if (this._field != null) {
                hash = hash * 5 + this._field.hashCode();
            }
            return hash;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Sub : ").append(this._sub == null ? "<null>" : this._sub.getName());
            sb.append("  Flow : ").append(this._flow.getName());
            if (this._field != null) {
                sb.append("  Field : ").append(this._field.getName());
            }
            return sb.toString();
        }
    }

    private static class SetOutputToInput {
        private final Set<DBRecordField> _setInputs = new LinkedHashSet<DBRecordField>();
        private final Set<DBRecordField> _setOutputs = new LinkedHashSet<DBRecordField>();

        public final void addInput(DBRecordField input) {
            this._setInputs.add(input);
        }

        public final void addOutput(DBRecordField output) {
            this._setOutputs.add(output);
        }

        public final Set<DBRecordField> getInputs() {
            return this._setInputs;
        }

        public final Set<DBRecordField> getOutputs() {
            return this._setOutputs;
        }

        public final void addAll(SetOutputToInput list) {
            if (list == null) {
                return;
            }
            this._setInputs.addAll(list.getInputs());
            this._setOutputs.addAll(list.getOutputs());
        }

        public String toString() {
            return "SetInputs : " + this._setInputs.toString() + "  SetOutputs : " + this._setOutputs.toString();
        }
    }
}

