/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.node;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.dbobj.mbsa.node.AltaVar;
import com.dassault.cecilia.dbobj.mbsa.node.io.DBAltaTypeHandlerXml;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecord;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareUtils;
import java.awt.Component;
import java.awt.Point;
import java.io.IOException;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class AltaFlow
extends AltaVar {
    Orientation _orientation = Orientation.IN;
    int _x = 0;
    int _y = 0;
    boolean _bSelected = false;

    public AltaFlow(String name, AltaType type) {
        super(name, type);
    }

    protected void copy(AltaFlow src) {
        super.copy(src);
        this.setX(src.getX());
        this.setY(src.getY());
        this.setOrientation(src.getOrientation());
    }

    @Override
    public AltaFlow getCopy() {
        AltaFlow dest = new AltaFlow(this._name, this._type.getCopy());
        dest.copy(this);
        return dest;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof AltaFlow)) {
            return false;
        }
        AltaFlow other = (AltaFlow)obj;
        if (this.getOrientation() != other.getOrientation()) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        return this.getY() == other.getY();
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = hash * 3 + this._x;
        hash = hash * 5 + this._y;
        hash = hash * 7 + this._orientation.hashCode();
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append(":").append(this._type.toString());
        sb.append(":").append(this._orientation.toAltarica());
        sb.append("[").append(this._x).append(",").append(this._y).append("]");
        return sb.toString();
    }

    public int getX() {
        return this._x;
    }

    public int getY() {
        return this._y;
    }

    public Orientation getOrientation() {
        return this._orientation;
    }

    public AltaFlow setX(int x) {
        this._x = x;
        return this;
    }

    public AltaFlow setY(int y) {
        this._y = y;
        return this;
    }

    public AltaFlow setOrientation(Orientation orientation) {
        this._orientation = orientation;
        return this;
    }

    public AltaFlow setLocation(Point p) {
        this._x = p.x;
        this._y = p.y;
        return this;
    }

    public void toXML(Appendable out, boolean allAttributes, String indent0) throws IOException {
        out.append(indent0).append("<").append("alta.flow");
        DBObjectXmlUtility.appendXML(out.append(" ").append("name").append("='"), this._name).append("'");
        DBAltaTypeHandlerXml.writeType(this._type, out);
        if (allAttributes || this._orientation != Orientation.IN) {
            out.append(" ").append("orientation").append("='").append(this._orientation.toAltarica()).append("'");
        }
        if (allAttributes || this._x != 0) {
            out.append(" ").append("x").append("='").append(Integer.toString(this._x)).append("'");
        }
        if (allAttributes || this._y != 0) {
            out.append(" ").append("y").append("='").append(Integer.toString(this._y)).append("'");
        }
        if (allAttributes || this.getID() >= 0L) {
            out.append(" ").append("id").append("='").append(Long.toString(this.getID())).append("'");
        }
        out.append("/>\n");
    }

    public void setSelected(boolean value) {
        this._bSelected = value;
    }

    public boolean isSelected() {
        return this._bSelected;
    }

    public boolean isRecord() {
        return this._type instanceof DBRecord;
    }

    @Override
    public String getAbstract() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getAbstract());
        sb.append(CompareUtils.getTextForCompare(ResMsgVoc.getString("VOC_SENS"), this._orientation.getLabel()));
        sb.append("[X,Y] : [").append(this._x).append(',').append(this._y).append(']');
        return sb.toString();
    }

    public static enum Orientation {
        IN,
        OUT,
        LOCAL;

        String _altarica = this.name().toLowerCase();

        public CharSequence toAltarica() {
            return this._altarica;
        }

        public String getLabel() {
            return this._altarica;
        }

        public static class SpecificTableCellRenderer
        extends DefaultTableCellRenderer {
            public SpecificTableCellRenderer() {
                this.setOpaque(true);
                this.setHorizontalAlignment(0);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value instanceof Orientation) {
                    this.setText(((Orientation)((Object)value)).getLabel());
                }
                return this;
            }
        }
    }
}

