/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.node.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjProperty;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class AltaPropertiesPanel
extends JPanel {
    private DBFolder _dbFolder;
    private JLabel _creationLabel = new JLabel(ResMsgOcas.getString("MODEL_EDIT_LBL_CREATE") + " : ");
    private JLabel _creationValue = new JLabel("");
    private JLabel _modificationLabel = new JLabel(ResMsgOcas.getString("MODEL_EDIT_LBL_MODIFY") + " : ");
    private JLabel _modificationValue = new JLabel("");
    private JLabel _versionLabel = new JLabel(ResMsgVoc.getString("VOC_VERSION") + " : ");
    private JLabel _versionValue = new JLabel("");
    private JLabel _commentLabel = new JLabel(ResMsgVoc.getString("VOC_COMMENT") + " : ");
    private JTextArea _commentValue = new JTextArea("");
    private boolean _isModified = false;
    private DateFormat _dateFormat = SimpleDateFormat.getDateTimeInstance();

    public AltaPropertiesPanel(DBFolder dbFolder) {
        this.setDBFolder(dbFolder);
    }

    public AltaPropertiesPanel() {
    }

    public void setDBFolder(DBFolder dbFolder) {
        this._dbFolder = dbFolder;
        this.makePanel();
    }

    private void makePanel() {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.add((Component)this._creationLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 2), 0, 0));
        this.add((Component)this._creationValue, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 5), 0, 0));
        this.add((Component)this._modificationLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 2), 0, 0));
        this.add((Component)this._modificationValue, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 5), 0, 0));
        this.add((Component)this._versionLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 2), 0, 0));
        this.add((Component)this._versionValue, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 5), 0, 0));
        this.add((Component)new JSeparator(), new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this._commentLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 5, 2, 2), 0, 0));
        this.add((Component)new JScrollPane(this._commentValue), new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 2, 2, 5), 0, 0));
        this._creationLabel.setOpaque(false);
        this._creationLabel.setForeground(Color.black);
        this._creationValue.setOpaque(false);
        this._creationValue.setForeground(Color.black);
        this._modificationLabel.setOpaque(false);
        this._modificationLabel.setForeground(Color.black);
        this._modificationValue.setOpaque(false);
        this._modificationValue.setForeground(Color.black);
        this._versionLabel.setOpaque(false);
        this._versionLabel.setForeground(Color.black);
        this._versionValue.setOpaque(false);
        this._versionValue.setForeground(Color.black);
        this._commentLabel.setOpaque(false);
        this._commentLabel.setForeground(Color.black);
        this._commentValue.setBackground(Color.white);
        this.updateDBFolder(this._dbFolder);
        this._commentValue.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                AltaPropertiesPanel.this._isModified = true;
            }
        });
        this._isModified = false;
    }

    public void setEditable(boolean editable) {
        this._commentValue.setEditable(editable);
    }

    public void setDateFormat(DateFormat result) {
        this._dateFormat = result;
        this.updateCreateAndModify();
    }

    protected void updateCreateAndModify() {
        if (this._dbFolder != null) {
            DBObjProperty dbObjProp;
            StringBuilder sb = new StringBuilder(this._dateFormat.format(this._dbFolder.getDateCreate()));
            if (this._dbFolder.getObject() != null && (dbObjProp = this._dbFolder.getObject().getProperty("object.creator")) != null) {
                sb.append(" (").append(dbObjProp.getValue()).append(")");
            }
            this._creationValue.setText(sb.toString());
            sb = new StringBuilder(this._dateFormat.format(this._dbFolder.getDateModify()));
            sb.append(" (").append(this._dbFolder.getUserModify().getLogin()).append(")");
            this._modificationValue.setText(sb.toString());
        }
    }

    public boolean isModified() {
        return this._isModified;
    }

    public void setModified(boolean modified) {
        this._isModified = modified;
    }

    public String getComment() {
        return this._commentValue.getText();
    }

    public void updateDBFolder(DBFolder dbFolder) {
        DBObjProperty prop;
        this._dbFolder = dbFolder;
        this.updateCreateAndModify();
        String release = "1";
        if (this._dbFolder.getObject() != null && (prop = this._dbFolder.getObject().getProperty("object.release")) != null) {
            release = prop.getValue();
        }
        this._versionValue.setText(release);
        this._commentValue.setText(this._dbFolder.getDescription());
        this.setModified(false);
    }

    public void updateLangage() {
        this._creationLabel.setText(ResMsgOcas.getString("MODEL_EDIT_LBL_CREATE") + " : ");
        this._modificationLabel.setText(ResMsgOcas.getString("MODEL_EDIT_LBL_MODIFY") + " : ");
        this._commentLabel.setText(ResMsgVoc.getString("VOC_COMMENT") + " : ");
        this._versionLabel.setText(ResMsgVoc.getString("VOC_VERSION") + " : ");
    }
}

