/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.operator.gui;

import com.dassault.cecilia.core.ConfigManager;
import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.table.CeciliaTable;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.dbobj.demo.DemoLimits;
import com.dassault.cecilia.dbobj.folder.DBFolderTreeActivable;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.UtilOcas;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.mbsa.node.gui.AltaReservedWord;
import com.dassault.cecilia.dbobj.mbsa.operator.AltaOperator;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeBool;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeBound;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeEnum;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeFloat;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeInt;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeParser;
import com.dassault.cecilia.dbobj.mbsa.type.DBType;
import com.dassault.cecilia.dbobj.mbsa.type.gui.TypeDlgChooser;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class AltaOperandePanel
extends JPanel {
    private CeciliaAppl _appl;
    private AltaOperator _currentOperator = null;
    private boolean _isModified = false;
    OperTable _operTable;
    JLabel _operNameLabel = new JLabel(ResMsgVoc.getString("VOC_NAME"));
    JTextField _operName = new JTextField("");
    JLabel _operTypeLabel = new JLabel(ResMsgVoc.getString("VOC_TYPE"));
    JComboBox _operTypeSelector = new JComboBox();
    CeciliaAction _ctrlAdd;
    CeciliaAction _ctrlDel;
    CeciliaAction _ctrlEdit;
    CeciliaAction _ctrlUp;
    CeciliaAction _ctrlDown;
    JButton _allocateOperTypeButton = new JButton(ResMsgVoc.getString("VOC_AFFECT"));
    JPopupMenu _popupMenu = new JPopupMenu();
    JPanel _emptyPanel = new JPanel();
    JTextField _valueEnumTypeOper = new JTextField("");
    JPanel _predefinePanel = new JPanel();
    JTextField _predefineType = new JTextField("");
    private static TypeDlgChooser _typeChooser = null;
    private static Object _LockerDlgChooser = new Object();
    JButton _selectPredefineType = new JButton("...");
    JPanel _intervalPanel = new JPanel();
    JLabel _minLabel = new JLabel("Min");
    JLabel _maxLabel = new JLabel("Max");
    JTextField _minValue = new JTextField("");
    JTextField _maxValue = new JTextField("");
    JComboBox _listValueCombo = new JComboBox();
    OperTableEditor _operNameEditor = new OperTableEditor();
    ItemListener _listValueListener;
    JTextField _lastFocusField = this._operName;
    boolean _forReadOnly = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TypeDlgChooser getDlgChooser(Window win, CeciliaAppl appl) {
        if (_typeChooser == null) {
            TypeDlgChooser dlg = null;
            Object object = _LockerDlgChooser;
            synchronized (object) {
                if (_typeChooser == null) {
                    dlg = new TypeDlgChooser(win, appl);
                }
                if (_typeChooser == null) {
                    _typeChooser = dlg;
                }
            }
        }
        return _typeChooser;
    }

    public void forReadOnly(boolean readOnly) {
        this._forReadOnly = readOnly;
    }

    public AltaOperandePanel(AltaOperator dbOperator, CeciliaAppl appl) {
        super(new GridBagLayout());
        this._currentOperator = dbOperator;
        this._appl = appl;
        this.createActions();
        this._operTable = new OperTable();
        JToolBar panelOperButton = new JToolBar();
        JPanel panelOperType = new JPanel();
        JScrollPane scrollTable = new JScrollPane(this._operTable);
        this.add((Component)scrollTable, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 2, 5), 0, 0));
        this.add((Component)panelOperButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)panelOperType, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 5, 5), 0, 0));
        panelOperButton.add(Box.createHorizontalGlue());
        panelOperButton.add(this._ctrlAdd.createButton(CeciliaAction.BorderStyle.LIGHT));
        panelOperButton.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        panelOperButton.add(this._ctrlDel.createButton(CeciliaAction.BorderStyle.LIGHT));
        panelOperButton.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        panelOperButton.add(this._ctrlEdit.createButton(CeciliaAction.BorderStyle.LIGHT));
        panelOperButton.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        panelOperButton.add(this._ctrlUp.createButton(CeciliaAction.BorderStyle.LIGHT));
        panelOperButton.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        panelOperButton.add(this._ctrlDown.createButton(CeciliaAction.BorderStyle.LIGHT));
        panelOperButton.add(Box.createHorizontalGlue());
        panelOperButton.setFloatable(false);
        panelOperType.setLayout(new GridBagLayout());
        panelOperType.setBorder(BorderFactory.createEtchedBorder());
        panelOperType.add((Component)this._operNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panelOperType.add((Component)this._operName, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        panelOperType.add((Component)this._operTypeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panelOperType.add((Component)this._operTypeSelector, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panelOperType.add((Component)this._valueEnumTypeOper, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        panelOperType.add((Component)this._predefinePanel, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        panelOperType.add((Component)this._intervalPanel, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        panelOperType.add((Component)this._emptyPanel, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        panelOperType.add((Component)this._allocateOperTypeButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._predefinePanel.setLayout(new GridBagLayout());
        this._predefinePanel.add((Component)this._predefineType, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 2), 0, 0));
        this._predefinePanel.add((Component)this._selectPredefineType, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 5), 0, 0));
        this._intervalPanel.setLayout(new GridBagLayout());
        this._intervalPanel.add((Component)this._minLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this._intervalPanel.add((Component)this._minValue, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        this._intervalPanel.add((Component)this._maxLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this._intervalPanel.add((Component)this._maxValue, new GridBagConstraints(3, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        this._operNameLabel.setForeground(Color.black);
        this._operTypeLabel.setForeground(Color.black);
        this._minLabel.setForeground(Color.black);
        this._maxLabel.setForeground(Color.black);
        this._operTypeSelector.addItem("bool");
        this._operTypeSelector.addItem("enum");
        this._operTypeSelector.addItem(ResMsgVoc.getString("VOC_INTERVAL"));
        this._operTypeSelector.addItem(ResMsgOcas.getString("OCAS_PREDEFINE"));
        this._operTypeSelector.addItem("int");
        this._operTypeSelector.addItem("float");
        this._valueEnumTypeOper.setVisible(false);
        this._predefinePanel.setVisible(false);
        this._intervalPanel.setVisible(false);
        this._operTable.setModel(new OperTableModel(this._operTable));
        this._operTable.doLayout();
        this._operTable.setSelectionMode(0);
        this._operTable.setRowHeight(20);
        TableColumnModel tableColumnModel = this._operTable.getColumnModel();
        TableColumn valueColumn = tableColumnModel.getColumn(0);
        valueColumn.setCellEditor(new OperTableCellEditor());
        valueColumn.setCellRenderer(new OperTableCellRenderer());
        valueColumn = tableColumnModel.getColumn(1);
        valueColumn.setCellEditor(new OperTableCellEditor());
        valueColumn.setCellRenderer(new OperTableCellRenderer());
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setOpaque(true);
        this._operTable.getTableHeader().getColumnModel().getColumn(1).setCellRenderer(renderer);
        this._popupMenu.add(this._ctrlEdit);
        this._popupMenu.addSeparator();
        this._popupMenu.add(this._ctrlDel);
        this._popupMenu.add(this._ctrlUp);
        this._popupMenu.add(this._ctrlDown);
        this._popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                AltaOperandePanel.this.selectOperande();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        scrollTable.setComponentPopupMenu(this._popupMenu);
        this.defineActions();
    }

    public void refreshTable() {
        ((OperTableModel)this._operTable.getModel()).refresh(false);
    }

    public void refresh() {
        ((OperTableModel)this._operTable.getModel()).refresh(false);
        this.selectOperande();
    }

    private void createActions() {
        this._ctrlAdd = new CeciliaAction(ResIcoCore.getImageIcon("BUT_ADD"), ResMsgVoc.getString("VOC_ADD")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaOperandePanel.this.addOperande();
            }
        }.setDesc(ResMsgOcas.getString("OPERATOR_EDIT_ADD_OPERANDE"));
        this._ctrlDel = new CeciliaAction(ResIcoCore.getImageIcon("BUT_DEL"), ResMsgVoc.getString("VOC_DELETE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index;
                if (AltaOperandePanel.this._currentOperator != null && (index = AltaOperandePanel.this._operTable.getSelectedRow()) > 0) {
                    if (AltaOperandePanel.this._operTable.isEditing()) {
                        AltaOperandePanel.this._operTable.removeEditor();
                    }
                    AltaOperandePanel.this._currentOperator.getFlows().remove(index - 1);
                    ((OperTableModel)AltaOperandePanel.this._operTable.getModel()).refresh(false);
                    AltaOperandePanel.this._isModified = true;
                }
            }
        }.setDesc(ResMsgOcas.getString("OPERATOR_EDIT_DEL_OPERANDE"));
        this._ctrlEdit = new CeciliaAction(ResIcoCore.getImageIcon("BUT_EDIT"), ResMsgVoc.getString("VOC_EDIT")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaOperandePanel.this.doEditType();
            }
        }.setDesc(ResMsgOcas.getString("CMD_TYPE_EDIT"));
        this._ctrlUp = new CeciliaAction(ResIcoCore.getImageIcon("BUT_UP"), ResMsgVoc.getString("CMD_MOVE_UP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index;
                if (AltaOperandePanel.this._currentOperator != null && (index = AltaOperandePanel.this._operTable.getSelectedRow()) > 1) {
                    if (AltaOperandePanel.this._operTable.isEditing()) {
                        AltaOperandePanel.this._operTable.removeEditor();
                    }
                    AltaFlow operande = AltaOperandePanel.this._currentOperator.getFlows().remove(index - 1);
                    AltaOperandePanel.this._currentOperator.getFlows().add(index - 2, operande);
                    AltaOperandePanel.this._operTable.setRowSelectionInterval(index - 1, index - 1);
                    ((OperTableModel)AltaOperandePanel.this._operTable.getModel()).refresh(false);
                    AltaOperandePanel.this.selectOperande();
                    AltaOperandePanel.this._isModified = true;
                }
            }
        }.setDesc(ResMsgVoc.getString("CMD_MOVE_UP"));
        this._ctrlDown = new CeciliaAction(ResIcoCore.getImageIcon("BUT_DOWN"), ResMsgVoc.getString("CMD_MOVE_DOWN")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index;
                if (AltaOperandePanel.this._currentOperator != null && (index = AltaOperandePanel.this._operTable.getSelectedRow()) > 0) {
                    if (AltaOperandePanel.this._operTable.isEditing()) {
                        AltaOperandePanel.this._operTable.removeEditor();
                    }
                    AltaFlow operande = AltaOperandePanel.this._currentOperator.getFlows().remove(index - 1);
                    AltaOperandePanel.this._currentOperator.getFlows().add(index, operande);
                    AltaOperandePanel.this._operTable.setRowSelectionInterval(index + 1, index + 1);
                    ((OperTableModel)AltaOperandePanel.this._operTable.getModel()).refresh(false);
                    AltaOperandePanel.this.selectOperande();
                    AltaOperandePanel.this._isModified = true;
                }
            }
        }.setDesc(ResMsgVoc.getString("CMD_MOVE_DOWN"));
    }

    private void defineActions() {
        this._selectPredefineType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TypeDlgChooser dlg = AltaOperandePanel.getDlgChooser(SwingUtilities.getWindowAncestor(AltaOperandePanel.this._selectPredefineType), AltaOperandePanel.this._appl);
                DAOFolder daoFolder = AltaOperandePanel.this._appl.getDAOFactory().createFolderDAO();
                DBFolder dbFolder = daoFolder.findFolder("TYPE_FAMILIES", AltaOperandePanel.this._predefineType.getText());
                if (dbFolder != null) {
                    dlg.setSelectFolder(dbFolder);
                }
                dlg.setVisible(true);
                if (dlg.getResult() && (dbFolder = dlg.getSelectFolder()) != null) {
                    AltaOperandePanel.this._predefineType.setText(dbFolder.getRefPath());
                }
            }
        });
        this._operTypeSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (AltaOperandePanel.this._operTypeSelector.getSelectedIndex()) {
                    case 0: 
                    case 4: 
                    case 5: {
                        AltaOperandePanel.this._emptyPanel.setVisible(true);
                        AltaOperandePanel.this._valueEnumTypeOper.setVisible(false);
                        AltaOperandePanel.this._intervalPanel.setVisible(false);
                        AltaOperandePanel.this._predefinePanel.setVisible(false);
                        break;
                    }
                    case 1: {
                        AltaOperandePanel.this._emptyPanel.setVisible(false);
                        AltaOperandePanel.this._valueEnumTypeOper.setVisible(true);
                        AltaOperandePanel.this._intervalPanel.setVisible(false);
                        AltaOperandePanel.this._predefinePanel.setVisible(false);
                        break;
                    }
                    case 2: {
                        AltaOperandePanel.this._emptyPanel.setVisible(false);
                        AltaOperandePanel.this._valueEnumTypeOper.setVisible(false);
                        AltaOperandePanel.this._intervalPanel.setVisible(true);
                        AltaOperandePanel.this._predefinePanel.setVisible(false);
                        break;
                    }
                    case 3: {
                        AltaOperandePanel.this._emptyPanel.setVisible(false);
                        AltaOperandePanel.this._valueEnumTypeOper.setVisible(false);
                        AltaOperandePanel.this._intervalPanel.setVisible(false);
                        AltaOperandePanel.this._predefinePanel.setVisible(true);
                    }
                }
            }
        });
        this._allocateOperTypeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AltaOperandePanel.this._currentOperator == null) {
                    return;
                }
                int index = AltaOperandePanel.this._operTable.getSelectedRow();
                if (index == -1) {
                    return;
                }
                AltaType newType = AltaOperandePanel.this.getCurrentType();
                if (newType == null) {
                    return;
                }
                if (index == 0) {
                    AltaOperandePanel.this._currentOperator.setType(newType);
                } else {
                    AltaFlow oldOperande = AltaOperandePanel.this._currentOperator.getFlows().get(index - 1);
                    oldOperande.setType(newType);
                }
                ((OperTableModel)AltaOperandePanel.this._operTable.getModel()).refresh(false);
                AltaOperandePanel.this._isModified = true;
            }
        });
        this._operTable.getActionMap().put("DELETE", this._ctrlDel);
        this._operTable.getInputMap(0).put(KeyStroke.getKeyStroke("DELETE"), "DELETE");
        this._operName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    AltaOperandePanel.this.addOperande();
                    AltaOperandePanel.this._operName.setText("");
                    AltaOperandePanel.this._operName.requestFocus();
                }
            }
        });
        FocusAdapter focusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AltaOperandePanel.this.setLastFocusField((JTextField)e.getSource());
            }
        };
        this._operName.addFocusListener(focusListener);
    }

    protected void doEditType() {
        if (this._operTable.getSelectedRow() == -1) {
            return;
        }
        if (this._currentOperator == null) {
            return;
        }
        int index = this._operTable.getSelectedRow();
        AltaType type = this._currentOperator.getType();
        if (index > 0) {
            AltaFlow operande = this._currentOperator.getFlows().get(index - 1);
            type = operande.getType();
        }
        if (!(type instanceof DBType)) {
            return;
        }
        if (((DBType)type).getDBFolder() == null) {
            return;
        }
        DBFolderTreeActivable tree = this._appl.getTopWindow().getFolders().getTree(DBFolder.Family.TYPE);
        if (tree != null) {
            tree.edit(((DBType)type).getDBFolder(), false);
        }
    }

    protected AltaType getCurrentType() {
        switch (this._operTypeSelector.getSelectedIndex()) {
            case 0: {
                return AltaTypeBool.getInstance();
            }
            case 1: {
                if (this._valueEnumTypeOper.getText().equals("")) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.getString("MODEL_EDIT_ERROR_NO_ENUM"), ResMsgVoc.getString("VOC_ERROR"), 0);
                    break;
                }
                if (this._valueEnumTypeOper.getText().indexOf(" ") != -1) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.getString("MODEL_EDIT_ERROR_SPACE"), ResMsgVoc.getString("VOC_ERROR"), 0);
                    break;
                }
                String convertEnumType = AltaTypeEnum.convertInEnumType(this._valueEnumTypeOper.getText());
                if (convertEnumType != null) {
                    return new AltaTypeEnum("{" + convertEnumType + "}");
                }
                AltaType defaultType = AltaTypeParser.getType(this._valueEnumTypeOper.getText(), this._appl.getDAOFactory());
                if (defaultType != null) {
                    return defaultType;
                }
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.getString("TYPE_SPECIFY_DOES_NOT_EXIST"), ResMsgVoc.getString("VOC_ERROR"), 0);
                break;
            }
            case 2: {
                int minValue = Integer.MIN_VALUE;
                int maxValue = Integer.MIN_VALUE;
                try {
                    minValue = Integer.parseInt(this._minValue.getText());
                    maxValue = Integer.parseInt(this._maxValue.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (minValue < 0) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.getString("MODEL_EDIT_ERROR_MIN"), ResMsgVoc.getString("VOC_ERROR"), 0);
                    break;
                }
                if (maxValue < 0) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.getString("MODEL_EDIT_ERROR_MAX"), ResMsgVoc.getString("VOC_ERROR"), 0);
                    break;
                }
                if (minValue >= maxValue) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.getString("MODEL_EDIT_ERROR_MAXMIN_2"), ResMsgVoc.getString("VOC_ERROR"), 0);
                    break;
                }
                return new AltaTypeBound(minValue, maxValue);
            }
            case 3: {
                AltaType defaultType = AltaTypeParser.getType(this._predefineType.getText(), this._appl.getDAOFactory());
                if (defaultType == null) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.getString("TYPE_SPECIFY_DOES_NOT_EXIST"), ResMsgVoc.getString("VOC_ERROR"), 0);
                    break;
                }
                return defaultType;
            }
            case 4: {
                return AltaTypeInt.getInstance();
            }
            case 5: {
                return AltaTypeFloat.getInstance();
            }
        }
        return null;
    }

    protected String validateName(String name) {
        String character = "";
        if (this.isReservedWord(name)) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.msgFormat("MODEL_EDIT_RESERVED_WORD", name), ResMsgVoc.getString("VOC_ERROR"), 0);
        } else {
            character = UtilOcas.controlName(name);
            if (character != null) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.msgFormat("INFO_INVALID_CHARACTERE", character), ResMsgVoc.getString("VOC_ERROR"), 0);
            } else if (this.operandeExist(name)) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.getString("OPERATOR_EDIT_OPERANDE_EXIST"), ResMsgVoc.getString("VOC_ERROR"), 0);
            } else {
                return name;
            }
        }
        return null;
    }

    protected String getCurrentName() {
        String name = this._operName.getText();
        if (name.isEmpty()) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.getString("OPERATOR_EDIT_NAME_OPERANDE_EMTPY"), ResMsgVoc.getString("VOC_ERROR"), 0);
            return null;
        }
        return this.validateName(name);
    }

    public void addOperande() {
        String name;
        if (this._currentOperator == null) {
            return;
        }
        if (ConfigManager.getVersion() == ConfigManager.TypeVersion.DEMO && this._currentOperator.getFlows().size() >= DemoLimits.Limit.OPERATOR_FLOWS.getLimit()) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._operTable), ResMsgOcas.getString("DEMO_OPERATOR_FLOWS"), JOptionCecilia.getTopTitleOf(this._operTable), 0);
            return;
        }
        if (this._operTable.isEditing()) {
            this._operTable.removeEditor();
        }
        if ((name = this.getCurrentName()) == null) {
            return;
        }
        AltaType newType = this.getCurrentType();
        if (newType == null) {
            return;
        }
        AltaFlow newOperande = new AltaFlow(name, newType);
        int index = this._operTable.getSelectedRow();
        if (index != -1) {
            if (index == 0) {
                if (this._operTable.getRowCount() > 1) {
                    this._currentOperator.getFlows().add(index, newOperande);
                    this._operTable.setRowSelectionInterval(index + 1, index + 1);
                } else {
                    this._operTable.removeRowSelectionInterval(0, 0);
                    this._currentOperator.getFlows().add(newOperande);
                }
            } else {
                this._currentOperator.getFlows().add(index - 1, newOperande);
                this._operTable.setRowSelectionInterval(index, index);
            }
        } else {
            this._currentOperator.getFlows().add(newOperande);
        }
        ((OperTableModel)this._operTable.getModel()).refresh(false);
        this._isModified = true;
    }

    public void selectOperande() {
        if (this._currentOperator != null) {
            int index = this._operTable.getSelectedRow();
            if (index != -1) {
                if (index == 0) {
                    this._ctrlDel.setEnabled(false);
                    this._ctrlUp.setEnabled(false);
                    this._ctrlDown.setEnabled(false);
                } else {
                    this._ctrlUp.setEnabled(index != 1);
                    this._ctrlDown.setEnabled(index != this._operTable.getRowCount() - 1);
                    this._ctrlDel.setEnabled(true);
                }
                this._ctrlEdit.setEnabled(false);
                AltaType oldType = this._currentOperator.getType();
                if (index > 0) {
                    AltaFlow oldOperande = this._currentOperator.getFlows().get(index - 1);
                    oldType = oldOperande.getType();
                    this._operName.setText(oldOperande.getName());
                } else {
                    this._operName.setText(this._currentOperator.getName());
                }
                if (oldType instanceof AltaTypeBool) {
                    this._operTypeSelector.setSelectedIndex(0);
                } else if (oldType instanceof AltaTypeEnum) {
                    this._operTypeSelector.setSelectedIndex(1);
                    String enumeration = oldType.getValue();
                    if (enumeration.indexOf("{") != -1) {
                        enumeration = enumeration.substring(1, enumeration.length() - 1);
                    }
                    this._valueEnumTypeOper.setText(enumeration);
                } else if (oldType instanceof AltaTypeBound) {
                    this._operTypeSelector.setSelectedIndex(2);
                    this._minValue.setText(Integer.toString(((AltaTypeBound)oldType).getMin()));
                    this._maxValue.setText(Integer.toString(((AltaTypeBound)oldType).getMax()));
                } else if (oldType instanceof DBType) {
                    this._operTypeSelector.setSelectedIndex(3);
                    this._ctrlEdit.setEnabled(true);
                    this._predefineType.setText(((DBType)oldType).getDBFolder().getRefPath());
                } else if (oldType instanceof AltaTypeInt) {
                    this._operTypeSelector.setSelectedIndex(4);
                } else if (oldType instanceof AltaTypeFloat) {
                    this._operTypeSelector.setSelectedIndex(5);
                }
            } else {
                this._operName.setText("");
                this._operTypeSelector.setSelectedIndex(0);
                this._ctrlDel.setEnabled(false);
                this._ctrlUp.setEnabled(false);
                this._ctrlDown.setEnabled(false);
                this._ctrlEdit.setEnabled(false);
            }
        } else {
            this._ctrlDel.setEnabled(false);
            this._ctrlUp.setEnabled(false);
            this._ctrlDown.setEnabled(false);
            this._ctrlEdit.setEnabled(false);
        }
    }

    public boolean isReservedWord(String word) {
        return AltaReservedWord.isReservedWord(word);
    }

    public void setCurrentOperator(AltaOperator currentOperator) {
        this._currentOperator = currentOperator;
    }

    public boolean isModified() {
        return this._isModified;
    }

    public void setModified(boolean modified) {
        this._isModified = modified;
    }

    public void setLastFocusField(JTextField field) {
        this._lastFocusField = field;
    }

    public JTextField getLastFocusField() {
        return this._lastFocusField;
    }

    public void updateLangage() {
        this._allocateOperTypeButton.setText(ResMsgVoc.getString("VOC_AFFECT"));
        this._operNameLabel.setText(ResMsgVoc.getString("VOC_NAME"));
        this._operTypeLabel.setText(ResMsgVoc.getString("VOC_TYPE"));
        ((OperTableModel)this._operTable.getModel()).refresh(false);
        this._ctrlAdd.setName(ResMsgVoc.getString("VOC_ADD"));
        this._ctrlEdit.setName(ResMsgOcas.getString("CMD_TYPE_EDIT"));
        this._ctrlDel.setName(ResMsgVoc.getString("VOC_DELETE"));
        this._ctrlUp.setName(ResMsgVoc.getString("CMD_MOVE_UP"));
        this._ctrlDown.setName(ResMsgVoc.getString("CMD_MOVE_DOWN"));
        this._ctrlAdd.setDesc(ResMsgOcas.getString("OPERATOR_EDIT_ADD_OPERANDE"));
        this._ctrlDel.setDesc(ResMsgOcas.getString("OPERATOR_EDIT_DEL_OPERANDE"));
        this._ctrlEdit.setDesc(ResMsgOcas.getString("CMD_TYPE_EDIT"));
        this._ctrlUp.setDesc(ResMsgVoc.getString("CMD_MOVE_UP"));
        this._ctrlDown.setDesc(ResMsgVoc.getString("CMD_MOVE_DOWN"));
        int type = this._operTypeSelector.getSelectedIndex();
        this._operTypeSelector.removeAllItems();
        this._operTypeSelector.addItem("bool");
        this._operTypeSelector.addItem("enum");
        this._operTypeSelector.addItem(ResMsgVoc.getString("VOC_INTERVAL"));
        this._operTypeSelector.addItem(ResMsgOcas.getString("OCAS_PREDEFINE"));
        this._operTypeSelector.addItem("int");
        this._operTypeSelector.addItem("float");
        this._operTypeSelector.setSelectedIndex(type);
        this._selectPredefineType.setText("...");
    }

    private boolean operandeExist(String name) {
        if (this._currentOperator.getName().equals(name)) {
            return true;
        }
        List<AltaFlow> operandes = this._currentOperator.getFlows();
        for (int i = 0; i < operandes.size(); ++i) {
            if (!operandes.get(i).getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public class OperTableModel
    extends AbstractTableModel {
        private JTable _table;

        OperTableModel(JTable table) {
            this._table = table;
        }

        public void refresh(boolean columnChanged) {
            int c;
            int nbColumn = 0;
            ArrayList<Integer> tabColumnWidth = new ArrayList<Integer>();
            TableColumnModel headerColumnModel = this._table.getTableHeader().getColumnModel();
            int[] selectedRows = this._table.getSelectedRows();
            if (!columnChanged) {
                nbColumn = this.getColumnCount();
                for (c = 0; c < nbColumn; ++c) {
                    tabColumnWidth.add(headerColumnModel.getColumn(c).getWidth());
                }
            }
            this.fireTableChanged(null);
            if (columnChanged) {
                int tableWidth = this._table.getSize().width;
                nbColumn = this.getColumnCount() - 1;
                int columnWidth = tableWidth / nbColumn;
                for (int c2 = 1; c2 < nbColumn; ++c2) {
                    headerColumnModel.getColumn(c2).setWidth(columnWidth);
                }
                columnWidth = tableWidth - columnWidth * (nbColumn - 1) - (nbColumn + 1);
                headerColumnModel.getColumn(nbColumn).setWidth(columnWidth);
            } else {
                for (c = 0; c < nbColumn; ++c) {
                    headerColumnModel.getColumn(c).setPreferredWidth((Integer)tabColumnWidth.get(c));
                }
            }
            this._table.setRowHeight(20);
            TableColumnModel tableColumnModel = AltaOperandePanel.this._operTable.getColumnModel();
            TableColumn valueColumn = tableColumnModel.getColumn(0);
            valueColumn.setCellEditor(new OperTableCellEditor());
            valueColumn.setCellRenderer(new OperTableCellRenderer());
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setOpaque(true);
            headerColumnModel.getColumn(1).setCellRenderer(renderer);
            if (selectedRows.length != 0 && selectedRows[selectedRows.length - 1] < this._table.getRowCount()) {
                for (int i = 0; i < selectedRows.length; ++i) {
                    this._table.addRowSelectionInterval(selectedRows[i], selectedRows[i]);
                }
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            if (AltaOperandePanel.this._currentOperator == null) {
                return 0;
            }
            return AltaOperandePanel.this._currentOperator.getFlows().size() + 1;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (AltaOperandePanel.this._currentOperator != null) {
                if (row == 0) {
                    if (col == 0) {
                        return AltaOperandePanel.this._currentOperator.getName();
                    }
                    AltaType type = AltaOperandePanel.this._currentOperator.getType();
                    if (!(type instanceof DBType) || ((DBType)type).getDBFolder() == null) {
                        return type.getValue();
                    }
                    return ((DBType)type).getDBFolder().getRefPath();
                }
                if (col == 0) {
                    return AltaOperandePanel.this._currentOperator.getFlows().get(row - 1).getName();
                }
                AltaType type = AltaOperandePanel.this._currentOperator.getFlows().get(row - 1).getType();
                if (!(type instanceof DBType) || ((DBType)type).getDBFolder() == null) {
                    return type.getValue();
                }
                return ((DBType)type).getDBFolder().getRefPath();
            }
            return "";
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return ResMsgVoc.getString("VOC_NAME");
                }
                case 1: {
                    return ResMsgVoc.getString("VOC_TYPE");
                }
            }
            return "";
        }

        public Class getColumnClass(int c) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (!AltaOperandePanel.this._operTable.isEditable()) {
                return false;
            }
            return col == 0 && row != 0;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
        }
    }

    public class OperTableCellEditor
    extends DefaultCellEditor {
        OperTableCellEditor() {
            super(new JComboBox());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (row > 0 && column == 0) {
                AltaFlow operande = AltaOperandePanel.this._currentOperator.getFlows().get(row - 1);
                AltaOperandePanel.this._operNameEditor.setText(operande.getName());
                return AltaOperandePanel.this._operNameEditor;
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    public class OperTableCellRenderer
    extends DefaultTableCellRenderer {
        public OperTableCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            component.setForeground(row == 0 ? Color.red : Color.black);
            return component;
        }
    }

    public class OperTableEditor
    extends JTextField
    implements KeyListener {
        boolean enterHasBeenPressed;
        int _indexWhenFocusGained;

        OperTableEditor() {
            super("");
            this.enterHasBeenPressed = false;
            this.addKeyListener(this);
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void processFocusEvent(FocusEvent e) {
            super.processFocusEvent(e);
            if (e.getID() == 1005) {
                if (!this.enterHasBeenPressed) {
                    this.validText();
                }
            } else if (e.getID() == 1004) {
                this.enterHasBeenPressed = false;
                this._indexWhenFocusGained = AltaOperandePanel.this._operTable.getSelectedRow();
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                this.enterHasBeenPressed = true;
                this.validText();
            }
        }

        public void validText() {
            int index = this._indexWhenFocusGained;
            if (index <= 0) {
                return;
            }
            AltaFlow operande = AltaOperandePanel.this._currentOperator.getFlows().get(index - 1);
            if (!operande.getName().equals(this.getText())) {
                String name = AltaOperandePanel.this.validateName(this.getText());
                if (name != null) {
                    operande.setName(this.getText());
                    AltaOperandePanel.this._operName.setText(this.getText());
                    ((OperTableModel)AltaOperandePanel.this._operTable.getModel()).refresh(false);
                    AltaOperandePanel.this._isModified = true;
                }
            } else {
                ((OperTableModel)AltaOperandePanel.this._operTable.getModel()).refresh(false);
            }
            if (AltaOperandePanel.this._operTable.getCellEditor() != null) {
                AltaOperandePanel.this._operTable.getCellEditor().stopCellEditing();
            }
            AltaOperandePanel.this._operTable.setEditable(false);
        }
    }

    public class OperTable
    extends CeciliaTable {
        public boolean _isEditable = false;

        public OperTable() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    OperTable.this._isEditable = false;
                }
            });
        }

        @Override
        protected void doubleClickLeft(MouseEvent e) {
            this._isEditable = true;
            int row = this.rowAtPoint(e.getPoint());
            int column = this.columnAtPoint(e.getPoint());
            if (((OperTableModel)this.getModel()).isCellEditable(row, column)) {
                this.editCellAt(row, column);
                this.getEditorComponent().requestFocus();
            } else {
                this._isEditable = false;
                AltaOperandePanel.this.doEditType();
            }
        }

        @Override
        public void editingCanceled(ChangeEvent e) {
            this._isEditable = false;
            super.editingCanceled(e);
        }

        @Override
        public void editingStopped(ChangeEvent e) {
            this._isEditable = false;
            super.editingStopped(e);
        }

        public boolean isEditable() {
            return this._isEditable;
        }

        public void setEditable(boolean editable) {
            this._isEditable = editable;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
            try {
                AltaOperandePanel.this.selectOperande();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }
}

