/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.simul;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.cecilia.stepper.ViewData;
import com.dassault.cecilia.core.cecilia.stepper.ViewFolder;
import com.dassault.cecilia.core.cecilia.stepper.ViewListener;
import com.dassault.cecilia.core.cecilia.stepper.ViewNode;
import com.dassault.cecilia.core.cecilia.stepper.ViewState;
import com.dassault.cecilia.core.cecilia.stepper.ViewStepper;
import com.dassault.cecilia.core.cecilia.stepper.ViewTransition;
import com.dassault.cecilia.core.cecilia.stepper.ViewVariable;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PluginMStepper;
import com.dassault.cecilia.core.plugin.UtilityPlugable;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.FileFilterExtention;
import com.dassault.cecilia.dbobj.mbsa.simul.AltaSimStepper;
import com.dassault.cecilia.dbobj.mbsa.simul.AltaSimulFrame;
import com.dassault.cecilia.dbobj.mbsa.simul.ResIcoSimul;
import com.dassault.cecilia.dbobj.mbsa.simul.ResMsgSimul;
import com.dassault.cecilia.dbobj.mbsa.simul.SimulationAction;
import com.dassault.cecilia.dbobj.mbsa.simul.SimulationActionSaveInitStates;
import com.dassault.cecilia.dbobj.mbsa.simul.SimulationActionStartWithChoice;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.AltaDebugFrame;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.AltaEventSelect;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.AltaStateChange;
import com.dassault.cecilia.dbobj.mbsa.system.AltaSystem;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.CeciliaGUI;
import com.dassault.cecilia.main.cecilia.OpenFolder;
import com.dassault.cecilia.main.cecilia.OpenFolderList;
import com.dassault.cecilia.main.cecilia.actions.DeclareActions;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;

public class CentralizedStepper
implements ViewListener {
    private static Logger _LOG = Logger.getLogger(CentralizedStepper.class.getPackage().getName());
    private CeciliaAppl _appl;
    private CeciliaGUI _gui;
    protected PluginMStepper _currentPlugin = null;
    private static final String OPT_STEPPER = CentralizedStepper.class.getName() + "#DefaultStepper";
    private static final String OPT_INSTANTANEOUS_AUTO = Stepper.OPTION_INSTANTANEOUS_AUTO;
    private static final String OPT_INSTANTANEOUS_LOOP = Stepper.OPTION_INSTANTANEOUS_LOOP;
    private AltaSystem _currentModel = null;
    private AltaSimStepper _currentStepper = null;
    private EventListenerList _listeners = new EventListenerList();
    public static final int ACTION_GO_START = 0;
    public static final int ACTION_GO_INIT = 1;
    public static final int ACTION_GO_BACK = 2;
    public static final int ACTION_GO_FORW = 3;
    public static final int ACTION_GO_NEXT = 4;
    public static final int ACTION_GO_STOP = 5;
    public static final int ACTION_GO_SAVE = 13;
    public static final int ACTION_GO_EVENT = 11;
    public static final int ACTION_GO_STATE = 12;
    public static final int ACTION_GO_INFO = 21;
    public static final int ACTION_GO_DEBUG = 22;
    public static final int ACTION_GO_CHOICE = 100;
    CeciliaAction _goStart;
    CeciliaAction _goStartChoice;
    CeciliaAction _goInit;
    CeciliaAction _goBack;
    CeciliaAction _goForw;
    CeciliaAction _goNext;
    CeciliaAction _goStop;
    CeciliaAction _goSave;
    CeciliaAction _goEvent;
    CeciliaAction _goState;
    CeciliaAction _goInfo;
    CeciliaAction _goDebug;
    AltaEventSelect _dlgEvtSelect = null;
    AltaStateChange _dlgStateChange = null;
    AltaDebugFrame _debugFrame = null;
    JMenu _menuSimulation = null;

    CeciliaGUI getUI() {
        return this._gui;
    }

    public CentralizedStepper(CeciliaAppl appl, CeciliaGUI gui) {
        this._appl = appl;
        this._gui = gui;
    }

    public void connectComponents() {
        this._appl.getOpenFolders().addOpenFoldersListener(new OpenFolderList.OpenFoldersListener(){

            @Override
            public void listChanged(OpenFolderList.OpenFoldersEvent event) {
                switch (event.getAction()) {
                    case REMOVE: 
                    case REFRESH: {
                        return;
                    }
                }
                DBWrap dbWrap = null;
                OpenFolder oFolder = event.getFolder();
                if (oFolder != null) {
                    dbWrap = oFolder.getAccess().getDBWrap();
                }
                if (dbWrap instanceof AltaSystem) {
                    CentralizedStepper.this.setModel((AltaSystem)dbWrap);
                }
            }
        });
    }

    protected Plugable getPlugable() {
        return this._appl.getPlugable();
    }

    protected void setPluginStepper(PluginMStepper plugin) {
        if (this._currentPlugin == plugin) {
            return;
        }
        this._currentPlugin = plugin;
        this.getPlugable().setOption(OPT_STEPPER, plugin.getInfo("plugin.key"));
    }

    protected PluginMStepper getPluginStepper() {
        if (this._currentPlugin == null) {
            String currentKey = this.getPlugable().getOption(OPT_STEPPER);
            if (currentKey != null && currentKey.length() > 0) {
                this._currentPlugin = (PluginMStepper)this.getPlugable().getPlugin(currentKey);
                if (this._currentPlugin == null) {
                    _LOG.warning("Default current stepper not found : " + currentKey);
                }
            }
            if (this._currentPlugin == null && (currentKey = this.getPlugable().getInfo("pluginmanager.stepper.default")) != null && currentKey.length() > 0) {
                this._currentPlugin = (PluginMStepper)this.getPlugable().getPlugin(currentKey);
                if (this._currentPlugin == null) {
                    _LOG.warning("Default current stepper not found : " + currentKey);
                }
            }
            List plugins = this.getPlugable().getPlugins("PluginStepper");
            if (this._currentPlugin == null) {
                for (String stepperKey : plugins) {
                    PluginMStepper stepperPlug = (PluginMStepper)this.getPlugable().getPlugin(stepperKey);
                    String def = stepperPlug.getInfo("plugin.default");
                    if (!"true".equals(def)) continue;
                    this._currentPlugin = stepperPlug;
                }
            }
            if (this._currentPlugin == null) {
                if (plugins.size() == 0) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this.getPlugable().getWindow()), ResMsgSimul.getString("ERR_NO_STEPPER"), ResMsgSimul.getString("MSG_TITLE"), 0);
                    return null;
                }
                this._currentPlugin = (PluginMStepper)this.getPlugable().getPlugin((String)plugins.get(0));
            }
        }
        return this._currentPlugin;
    }

    public Stepper createStepper() {
        PluginMStepper pluginStepper = this.getPluginStepper();
        if (pluginStepper != null) {
            return pluginStepper.createStepper(this.getPlugable(), null);
        }
        return null;
    }

    public void setModel(AltaSystem model) {
        if (this._currentModel == model) {
            return;
        }
        this._currentModel = model;
        if (this._currentModel != null) {
            this.setSimStepper(this._currentModel.getStepper());
        } else {
            this.setSimStepper(null);
        }
    }

    public AltaSystem getModel() {
        return this._currentModel;
    }

    public void setSelectObject(AltaSystem model) {
        if (this._currentModel != model) {
            return;
        }
        if (this._currentStepper == null) {
            return;
        }
        this.fireAltaOtherUpdate(5, this.getSelectedComponent());
    }

    protected String getSelectedComponent() {
        if (this._currentModel == null) {
            return "";
        }
        OpenFolder openFolder = this._appl.getOpenFolders().getOpenFolder(this._currentModel.getDBFolder());
        AltaSimulFrame topSimulFrame = null;
        for (JInternalFrame frame : openFolder.getFrames()) {
            if (!frame.isVisible() || !(frame instanceof AltaSimulFrame)) continue;
            if (topSimulFrame == null) {
                topSimulFrame = (AltaSimulFrame)frame;
                continue;
            }
            int posTop = this._gui.getDesktop().getDesktop().getIndexOf(topSimulFrame);
            int posFrame = this._gui.getDesktop().getDesktop().getIndexOf(frame);
            if (posFrame >= posTop) continue;
            topSimulFrame = (AltaSimulFrame)frame;
        }
        if (topSimulFrame != null) {
            return topSimulFrame.getSelectedComponentPath();
        }
        return "";
    }

    public List<String> getSimulOptions() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(new StringBuilder(256).append("instantaneous.auto=\"").append(Boolean.toString(UtilityPlugable.getBooleanOption(this.getPlugable(), OPT_INSTANTANEOUS_AUTO, true))).append("\"").toString());
        args.add(new StringBuilder(256).append("instantaneous.loop=\"").append(Long.toString(UtilityPlugable.getLongOption(this.getPlugable(), OPT_INSTANTANEOUS_LOOP, 100L))).append("\"").toString());
        return args;
    }

    public void setSimStepper(AltaSimStepper stepper) {
        if (this._currentStepper != null) {
            this._currentStepper.removeAltaListener(this);
        }
        this._currentStepper = stepper;
        if (this._currentStepper != null) {
            this._currentStepper.addAltaListener(this);
        }
        this.fireAltaModelChanged();
    }

    public AltaSimStepper getSimStepper() {
        return this._currentStepper;
    }

    public void startSimulation() {
        if (this._currentModel == null) {
            return;
        }
        if (this._currentModel.getStepper() != null) {
            return;
        }
        AltaSimStepper stepper = new AltaSimStepper(this._appl, this, this._currentModel);
        if (stepper != null) {
            stepper.startSimulation();
            if (stepper.isConnected()) {
                this._currentModel.setStepper(stepper);
                this.setSimStepper(stepper);
            }
        }
    }

    public void stopSimulation() {
        if (this._currentModel == null) {
            return;
        }
        if (this._currentModel.getStepper() != null || this._currentStepper != null) {
            this._currentStepper.close();
            this.setSimStepper(null);
            this._currentModel.setStepper(null);
        }
        if (this._debugFrame != null && this._debugFrame.isVisible()) {
            boolean bOpenFolderInSimulation = false;
            for (OpenFolder openFolder : this._appl.getOpenFolders().getOpenFolders()) {
                if (!(openFolder.getMasterFrame() instanceof AltaSimulFrame)) continue;
                bOpenFolderInSimulation = true;
                break;
            }
            if (!bOpenFolderInSimulation) {
                this._debugFrame.doDefaultCloseAction();
            }
        }
    }

    public void addAltaListener(ViewListener l) {
        this._listeners.add(ViewListener.class, l);
    }

    public void removeAltaListener(ViewListener l) {
        this._listeners.remove(ViewListener.class, l);
    }

    protected void fireAltaModelChanged() {
        Object[] alllistener = this._listeners.getListenerList();
        for (int i = alllistener.length - 2; i >= 0; i -= 2) {
            ((ViewListener)alllistener[i + 1]).altaModelChanged(this.getSimStepper());
        }
    }

    protected void fireAltaTransitionUpdate(ViewTransition tr) {
        Object[] alllistener = this._listeners.getListenerList();
        for (int i = alllistener.length - 2; i >= 0; i -= 2) {
            ((ViewListener)alllistener[i + 1]).altaTransitionUpdate(tr);
        }
    }

    protected void fireAltaStateUpdate(ViewVariable state) {
        Object[] alllistener = this._listeners.getListenerList();
        for (int i = alllistener.length - 2; i >= 0; i -= 2) {
            ((ViewListener)alllistener[i + 1]).altaStateUpdate(state);
        }
    }

    protected void fireAltaFlowUpdate(ViewVariable flow) {
        Object[] alllistener = this._listeners.getListenerList();
        for (int i = alllistener.length - 2; i >= 0; i -= 2) {
            ((ViewListener)alllistener[i + 1]).altaFlowUpdate(flow);
        }
    }

    protected void fireAltaOtherUpdate(int type, Object data) {
        Object[] alllistener = this._listeners.getListenerList();
        for (int i = alllistener.length - 2; i >= 0; i -= 2) {
            ((ViewListener)alllistener[i + 1]).altaOtherUpdate(type, data);
        }
    }

    @Override
    public void altaFlowUpdate(ViewVariable flow) {
        this.fireAltaFlowUpdate(flow);
    }

    @Override
    public void altaModelChanged(ViewStepper acastep) {
        if (acastep != this.getSimStepper()) {
            return;
        }
        this.fireAltaModelChanged();
    }

    @Override
    public void altaOtherUpdate(int type, Object data) {
        this.fireAltaOtherUpdate(type, data);
    }

    @Override
    public void altaStateUpdate(ViewVariable state) {
        this.fireAltaStateUpdate(state);
    }

    @Override
    public void altaTransitionUpdate(ViewTransition tr) {
        this.fireAltaTransitionUpdate(tr);
    }

    protected AltaEventSelect getDlgEvtSelect() {
        if (this._dlgEvtSelect == null) {
            this._dlgEvtSelect = new AltaEventSelect(this.getPlugable().getWindow());
        }
        return this._dlgEvtSelect;
    }

    protected AltaStateChange getDlgStateChange() {
        if (this._dlgStateChange == null) {
            this._dlgStateChange = new AltaStateChange(this.getPlugable().getWindow());
        }
        return this._dlgStateChange;
    }

    protected AltaDebugFrame getDebugFrame() {
        if (this._debugFrame == null) {
            this._debugFrame = new AltaDebugFrame(this._appl, this);
        }
        return this._debugFrame;
    }

    public void make(DeclareActions actions) {
        actions.putAction("SIMUL_GO_START", this.createAction(0));
        actions.putAction("SIMUL_GO_CHOICE", this.createAction(100));
        actions.putAction("SIMUL_GO_INIT", this.createAction(1));
        actions.putAction("SIMUL_GO_BACK", this.createAction(2));
        actions.putAction("SIMUL_GO_FORW", this.createAction(3));
        actions.putAction("SIMUL_GO_NEXT", this.createAction(4));
        actions.putAction("SIMUL_GO_STOP", this.createAction(5));
        actions.putAction("SIMUL_GO_SAVE", this.createAction(13));
        actions.putAction("SIMUL_GO_EVENT", this.createAction(11));
        actions.putAction("SIMUL_GO_STATE", this.createAction(12));
        actions.putAction("SIMUL_GO_INFO", this.createAction(21));
        actions.putAction("SIMUL_GO_DEBUG", this.createAction(22));
        this.addAltaListener(new ViewListener(){

            @Override
            public void altaTransitionUpdate(ViewTransition tr) {
            }

            @Override
            public void altaStateUpdate(ViewVariable state) {
            }

            @Override
            public void altaFlowUpdate(ViewVariable flow) {
            }

            @Override
            public void altaOtherUpdate(int type, Object data) {
            }

            @Override
            public void altaModelChanged(ViewStepper acastep) {
                if (CentralizedStepper.this._menuSimulation == null) {
                    CentralizedStepper.this._menuSimulation = CentralizedStepper.this._gui.getMenuAction("Simulation");
                }
                if (CentralizedStepper.this._menuSimulation == null) {
                    return;
                }
                CentralizedStepper.this._menuSimulation.setEnabled(CentralizedStepper.this._currentModel != null);
            }
        });
    }

    public CeciliaAction createAction(int act) {
        switch (act) {
            case 0: {
                if (this._goStart == null) {
                    this._goStart = new SimulationAction(ResMsgSimul.getString("PAN_STEP_START")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            CentralizedStepper.this.startSimulation();
                        }

                        @Override
                        public void altaModelChanged(ViewStepper acastep) {
                            this.setEnabled(CentralizedStepper.this.getSimStepper() == null && CentralizedStepper.this._currentModel != null);
                        }
                    }.setIcon(ResIcoSimul.getImageIcon("GO_START")).setDesc(ResMsgSimul.getString("PAN_STEP_START_TTP"));
                    this.addAltaListener((SimulationAction)this._goStart);
                    this._goStart.setEnabled(false);
                }
                return this._goStart;
            }
            case 100: {
                if (this._goStartChoice == null) {
                    this._goStartChoice = new SimulationActionStartWithChoice(this);
                    this.addAltaListener((SimulationAction)this._goStartChoice);
                    this._goStartChoice.setEnabled(false);
                }
                return this._goStartChoice;
            }
            case 1: {
                if (this._goInit == null) {
                    this._goInit = new SimulationAction(ResMsgSimul.getString("PAN_STEP_RESET")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (CentralizedStepper.this.getSimStepper() != null) {
                                CentralizedStepper.this.getSimStepper().goInitialState();
                            }
                        }

                        @Override
                        public void altaModelChanged(ViewStepper acastep) {
                            this.refreshEnable();
                        }

                        @Override
                        public void altaOtherUpdate(int type, Object data) {
                            if (type == 4) {
                                this.refreshEnable();
                            }
                        }

                        protected void refreshEnable() {
                            this.setEnabled(CentralizedStepper.this.getSimStepper() != null && CentralizedStepper.this.getSimStepper().getNbrStep() > 0);
                        }
                    }.setIcon(ResIcoSimul.getImageIcon("GO_INIT")).setDesc(ResMsgSimul.getString("PAN_STEP_RESET"));
                    this.addAltaListener((SimulationAction)this._goInit);
                    this._goInit.setEnabled(false);
                }
                return this._goInit;
            }
            case 2: {
                if (this._goBack == null) {
                    this._goBack = new SimulationAction(ResMsgSimul.getString("PAN_STEP_BACKWARD")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (CentralizedStepper.this.getSimStepper() != null && CentralizedStepper.this.getSimStepper().getNbrStep() > 0) {
                                CentralizedStepper.this.getSimStepper().goBackward(1);
                            }
                        }

                        @Override
                        public void altaModelChanged(ViewStepper acastep) {
                            this.refreshEnable();
                        }

                        @Override
                        public void altaOtherUpdate(int type, Object data) {
                            if (type == 4) {
                                this.refreshEnable();
                            }
                        }

                        protected void refreshEnable() {
                            this.setEnabled(CentralizedStepper.this.getSimStepper() != null && CentralizedStepper.this.getSimStepper().getNbrStep() > 0);
                        }
                    }.setIcon(ResIcoSimul.getImageIcon("GO_BACK")).setDesc(ResMsgSimul.getString("PAN_STEP_BACKWARD"));
                    this.addAltaListener((SimulationAction)this._goBack);
                    this._goBack.setEnabled(false);
                }
                return this._goBack;
            }
            case 3: {
                if (this._goForw == null) {
                    this._goForw = new SimulationAction(ResMsgSimul.getString("PAN_STEP_FORWARD")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (CentralizedStepper.this.getSimStepper() == null) {
                                return;
                            }
                            if (CentralizedStepper.this.getSimStepper().getNbrStep() < CentralizedStepper.this.getSimStepper().getViewHisto().size()) {
                                CentralizedStepper.this.getSimStepper().goForward(null);
                            }
                        }

                        @Override
                        public void altaModelChanged(ViewStepper acastep) {
                            this.refreshEnable();
                        }

                        @Override
                        public void altaOtherUpdate(int type, Object data) {
                            if (type == 4) {
                                this.refreshEnable();
                            }
                        }

                        protected void refreshEnable() {
                            if (CentralizedStepper.this.getSimStepper() == null) {
                                this.setEnabled(false);
                            } else if (CentralizedStepper.this.getSimStepper().getNbrStep() < CentralizedStepper.this.getSimStepper().getViewHisto().size()) {
                                this.setEnabled(true);
                            } else {
                                this.setEnabled(false);
                            }
                        }
                    }.setIcon(ResIcoSimul.getImageIcon("GO_FORW")).setDesc(ResMsgSimul.getString("PAN_STEP_FORWARD"));
                    this.addAltaListener((SimulationAction)this._goForw);
                    this._goForw.setEnabled(false);
                }
                return this._goForw;
            }
            case 4: {
                if (this._goNext == null) {
                    this._goNext = new SimulationAction(ResMsgSimul.getString("PAN_STEP_NEXT")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (CentralizedStepper.this.getSimStepper() == null) {
                                return;
                            }
                            ViewTransition tr = CentralizedStepper.this.getSimStepper().getNextTransition();
                            if (tr == null) {
                                return;
                            }
                            CentralizedStepper.this.getSimStepper().goForward(tr);
                        }

                        @Override
                        public void altaModelChanged(ViewStepper acastep) {
                            this.refreshEnable();
                        }

                        @Override
                        public void altaOtherUpdate(int type, Object data) {
                            if (type == 4) {
                                this.refreshEnable();
                            }
                        }

                        protected void refreshEnable() {
                            this.setEnabled(CentralizedStepper.this.getSimStepper() != null && CentralizedStepper.this.getSimStepper().getNextTransition() != null);
                        }
                    }.setIcon(ResIcoSimul.getImageIcon("GO_NEXT")).setDesc(ResMsgSimul.getString("PAN_STEP_NEXT"));
                    this.addAltaListener((SimulationAction)this._goNext);
                    this._goNext.setEnabled(false);
                }
                return this._goNext;
            }
            case 5: {
                if (this._goStop == null) {
                    this._goStop = new SimulationAction(ResMsgSimul.getString("PAN_STEP_STOP")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (CentralizedStepper.this.getSimStepper() == null) {
                                return;
                            }
                            CentralizedStepper.this.getSimStepper().stopSimulation();
                        }

                        @Override
                        public void altaModelChanged(ViewStepper acastep) {
                            if (CentralizedStepper.this._currentModel == null) {
                                this.setEnabled(false);
                            } else {
                                this.setEnabled(CentralizedStepper.this._currentStepper != null);
                            }
                        }
                    }.setIcon(ResIcoSimul.getImageIcon("GO_STOP")).setDesc(ResMsgSimul.getString("PAN_STEP_STOP_TTP"));
                    this.addAltaListener((SimulationAction)this._goStop);
                    this._goStop.setEnabled(false);
                }
                return this._goStop;
            }
            case 13: {
                if (this._goSave == null) {
                    this._goSave = new SimulationActionSaveInitStates(this);
                    this.addAltaListener((SimulationAction)this._goSave);
                    this._goSave.setEnabled(false);
                }
                return this._goSave;
            }
            case 11: {
                if (this._goEvent == null) {
                    this._goEvent = new SimulationAction(ResMsgSimul.getString("PAN_STEP_EVENT")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (CentralizedStepper.this.getSimStepper() == null) {
                                return;
                            }
                            AltaEventSelect dlg = CentralizedStepper.this.getDlgEvtSelect();
                            String filter = CentralizedStepper.this.getSelectedComponent();
                            dlg.display(CentralizedStepper.this.getSimStepper(), filter);
                            ViewTransition select = dlg.getSelectTransition();
                            if (select != null && select.isValid()) {
                                CentralizedStepper.this.getSimStepper().goForward(select);
                            }
                        }

                        @Override
                        public void altaModelChanged(ViewStepper acastep) {
                            this.refreshEnable();
                        }

                        @Override
                        public void altaOtherUpdate(int type, Object data) {
                            if (type == 5 || type == 4) {
                                this.refreshEnable();
                            }
                        }

                        protected void refreshEnable() {
                            if (CentralizedStepper.this.getSimStepper() == null || CentralizedStepper.this._currentModel == null) {
                                this.setEnabled(false);
                            } else {
                                String filter = CentralizedStepper.this.getSelectedComponent();
                                ViewData data = CentralizedStepper.this.getSimStepper().findViewData(filter);
                                if (data == null) {
                                    this.setEnabled(false);
                                } else {
                                    this.setEnabled(data.getNbrValid() > 0);
                                }
                            }
                        }
                    }.setIcon(ResIcoSimul.getImageIcon("GO_EVENT")).setDesc(ResMsgSimul.getString("PAN_STEP_EVENT_TTP"));
                    this.addAltaListener((SimulationAction)this._goEvent);
                    this._goEvent.setEnabled(false);
                }
                return this._goEvent;
            }
            case 12: {
                if (this._goState == null) {
                    this._goState = new SimulationAction(ResMsgSimul.getString("PAN_STEP_STATE")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (CentralizedStepper.this.getSimStepper() == null) {
                                return;
                            }
                            AltaStateChange dlg = CentralizedStepper.this.getDlgStateChange();
                            String filter = CentralizedStepper.this.getSelectedComponent();
                            if (dlg.display(CentralizedStepper.this.getSimStepper(), filter)) {
                                ViewVariable select = dlg.getSelectVariable();
                                String value = dlg.getSelectValue();
                                if (select != null && value != null) {
                                    CentralizedStepper.this.getSimStepper().setValueOfState(select, value);
                                }
                            }
                        }

                        @Override
                        public void altaModelChanged(ViewStepper acastep) {
                            this.refreshEnable();
                        }

                        @Override
                        public void altaOtherUpdate(int type, Object data) {
                            if (type == 5 || type == 4) {
                                this.refreshEnable();
                            }
                        }

                        protected void refreshEnable() {
                            if (CentralizedStepper.this.getSimStepper() == null || CentralizedStepper.this._currentModel == null) {
                                this.setEnabled(false);
                            } else {
                                String filter = CentralizedStepper.this.getSelectedComponent();
                                ViewData data = CentralizedStepper.this.getSimStepper().findViewData(filter);
                                if (data == null) {
                                    this.setEnabled(false);
                                } else if (!(data instanceof ViewFolder)) {
                                    this.setEnabled(false);
                                } else {
                                    ViewFolder folder = (ViewFolder)data;
                                    for (int i = 0; i < folder.getChildCount(); ++i) {
                                        ViewNode child = folder.getChildAt(i);
                                        if (child instanceof ViewState) {
                                            this.setEnabled(true);
                                            return;
                                        }
                                        if (child instanceof ViewFolder) break;
                                    }
                                    this.setEnabled(false);
                                }
                            }
                        }
                    }.setIcon(ResIcoSimul.getImageIcon("GO_STATE")).setDesc(ResMsgSimul.getString("PAN_STEP_STATE_TTP"));
                    this.addAltaListener((SimulationAction)this._goState);
                    this._goState.setEnabled(false);
                }
                return this._goState;
            }
            case 21: {
                if (this._goInfo == null) {
                    this._goInfo = new SimulationAction(ResMsgSimul.getString("PAN_STEP_INFO")){
                        JFileChooser _dlg;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (CentralizedStepper.this._currentStepper == null) {
                                return;
                            }
                            if (this._dlg == null) {
                                this._dlg = new JFileChooser();
                                FileFilterExtention txtFilter = new FileFilterExtention("Text file (*.txt)", ".txt").verifyWrite(true);
                                this._dlg.addChoosableFileFilter(txtFilter);
                                this._dlg.setFileFilter(txtFilter);
                                this._dlg.setCurrentDirectory(new File(CentralizedStepper.this.getPlugable().getOption("plugable.option.path")));
                            }
                            if (this._dlg.showSaveDialog(CentralizedStepper.this.getPlugable().getWindow()) != 0) {
                                return;
                            }
                            File file = this._dlg.getSelectedFile();
                            if (file == null) {
                                return;
                            }
                            FileWriter outStream = null;
                            try {
                                outStream = new FileWriter(file);
                                CentralizedStepper.this._currentStepper.saveAllState(outStream);
                            }
                            catch (IOException exc) {
                                exc.printStackTrace();
                            }
                            finally {
                                if (outStream != null) {
                                    try {
                                        ((Writer)outStream).close();
                                    }
                                    catch (IOException iOException) {}
                                }
                            }
                        }

                        @Override
                        public void altaModelChanged(ViewStepper acastep) {
                            if (CentralizedStepper.this._currentModel == null) {
                                this.setEnabled(false);
                            } else {
                                this.setEnabled(CentralizedStepper.this._currentStepper != null);
                            }
                        }
                    }.setIcon(ResIcoCore.getImageIcon("MSG_INFO")).setDesc(ResMsgSimul.getString("PAN_STEP_INFO_TTP"));
                    this.addAltaListener((SimulationAction)this._goInfo);
                    this._goInfo.setEnabled(false);
                }
                return this._goInfo;
            }
            case 22: {
                if (this._goDebug == null) {
                    this._goDebug = new SimulationAction(ResMsgSimul.getString("PAN_STEP_DEBUG")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (CentralizedStepper.this._currentModel == null) {
                                return;
                            }
                            AltaDebugFrame frame = CentralizedStepper.this.getDebugFrame();
                            frame.showView(CentralizedStepper.this._appl.getTopWindow().getDesktop());
                        }

                        @Override
                        public void altaModelChanged(ViewStepper acastep) {
                            if (CentralizedStepper.this._currentModel == null) {
                                this.setEnabled(false);
                            }
                            this.setEnabled(CentralizedStepper.this.getSimStepper() != null);
                        }
                    }.setIcon(ResIcoSimul.getImageIcon("GO_DEBUG")).setDesc(ResMsgSimul.getString("PAN_STEP_DEBUG_TTP"));
                    this.addAltaListener((SimulationAction)this._goDebug);
                    this._goDebug.setEnabled(false);
                }
                return this._goDebug;
            }
        }
        throw new IllegalArgumentException();
    }
}

